/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi;

import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.CmdLineException;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.CmdLineParser;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.OptionDef;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.Messages;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.OptionHandler;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.Parameters;
import com.google.javascript.jscomp.jarjar.org.kohsuke.args4j.spi.Setter;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    private final Class<T> enumType;

    public EnumOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter, Class<T> enumType) {
        super(parser, option, setter);
        this.enumType = enumType;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String s = params.getParameter(0).replaceAll("-", "_");
        Enum value = null;
        for (Enum o : (Enum[])this.enumType.getEnumConstants()) {
            if (!o.name().equalsIgnoreCase(s)) continue;
            value = o;
            break;
        }
        if (value == null) {
            if (this.option.isArgument()) {
                throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, this.option.toString(), s);
            }
            throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, params.getParameter(-1), s);
        }
        this.setter.addValue(value);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer rv = new StringBuffer();
        rv.append("[");
        for (Enum t : (Enum[])this.enumType.getEnumConstants()) {
            rv.append(t).append(" | ");
        }
        rv.delete(rv.length() - 3, rv.length());
        rv.append("]");
        return rv.toString();
    }

    @Override
    public String getMetaVariable(ResourceBundle rb) {
        return this.getDefaultMetaVariable();
    }
}

