/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public final class CheckDefaultExportOfGoogModule
implements NodeTraversal.Callback,
CompilerPass {
    private static final String WARNING_PREFIX = "Default exports of goog.modules do not translate easily to ES module semantics.";
    public static final DiagnosticType DEFAULT_EXPORT_IN_GOOG_MODULE = DiagnosticType.disabled("JSC_DEFAULT_EXPORT_IN_GOOG_MODULE", "Default exports of goog.modules do not translate easily to ES module semantics. Please use named exports instead (`exports = '{'{0}'}';`) and change the import sites to use destructuring (`const '{'{0}'}' = goog.require(''...'');`).");
    public static final DiagnosticType MAYBE_ACCIDENTAL_DEFAULT_EXPORT_IN_GOOG_MODULE = DiagnosticType.disabled("JSC_MAYBE_ACCIDENTAL_DEFAULT_EXPORT_IN_GOOG_MODULE", "Default exports of goog.modules do not translate easily to ES module semantics. The exports pattern \n{0} is a special case of default exports in JSCompiler as one of its keys is not initialized with a local name, and therefore it can not be destructured at the import site. Please use named exports instead.");
    private final AbstractCompiler compiler;

    public CheckDefaultExportOfGoogModule(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            return n.getBooleanProp(Node.GOOG_MODULE);
        }
        return true;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (CheckDefaultExportOfGoogModule.isGoogModuleDefaultExportsAssignment(n)) {
            Node rhs = n.getFirstChild().getSecondChild();
            if (rhs.isName()) {
                String exportedName = rhs.getString();
                t.report(n, DEFAULT_EXPORT_IN_GOOG_MODULE, exportedName);
            } else if (rhs.isObjectLit()) {
                int maxLength = 40;
                String codeSnippet = new CodePrinter.Builder(n).setPrettyPrint(true).build();
                if (codeSnippet.length() > maxLength) {
                    codeSnippet = codeSnippet.substring(0, maxLength) + "...};\n";
                }
                t.report(n, MAYBE_ACCIDENTAL_DEFAULT_EXPORT_IN_GOOG_MODULE, codeSnippet);
            } else {
                t.report(n, DEFAULT_EXPORT_IN_GOOG_MODULE, "MyVariable");
            }
        }
    }

    private static boolean isGoogModuleDefaultExportsAssignment(Node statement) {
        if (!statement.isExprResult()) {
            return false;
        }
        if (!statement.getFirstChild().isAssign()) {
            return false;
        }
        if (!statement.getFirstFirstChild().isName()) {
            return false;
        }
        if (NodeUtil.isNamedExportsLiteral(statement.getFirstChild().getSecondChild())) {
            return false;
        }
        return statement.getFirstFirstChild().getString().equals("exports");
    }
}

