/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CheckUnusedPrivateProperties
implements CompilerPass,
NodeTraversal.Callback {
    public static final DiagnosticType UNUSED_PRIVATE_PROPERTY = DiagnosticType.disabled("JSC_UNUSED_PRIVATE_PROPERTY", "Private property {0} is never read");
    private final AbstractCompiler compiler;
    private final Set<String> used = new HashSet<String>();
    private final List<Node> candidates = new ArrayList<Node>();
    private final HashSet<String> constructorsAndInterfaces = new HashSet();

    public CheckUnusedPrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private void reportUnused(NodeTraversal t) {
        for (Node n : this.candidates) {
            String propName = this.getPropName(n);
            if (this.used.contains(propName)) continue;
            t.report(n, UNUSED_PRIVATE_PROPERTY, propName);
        }
    }

    private String getPropName(Node n) {
        switch (n.getToken()) {
            case GETPROP: 
            case MEMBER_FUNCTION_DEF: {
                return n.getString();
            }
        }
        throw new RuntimeException("Unexpected node type: " + n);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.used.clear();
            this.used.add("constructor");
            this.candidates.clear();
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.reportUnused(t);
                break;
            }
            case GETPROP: {
                String propName = n.getString();
                if (this.compiler.getCodingConvention().isExported(propName) || CheckUnusedPrivateProperties.isPinningPropertyUse(n) || !this.isCandidatePropertyDefinition(n)) {
                    this.used.add(propName);
                    break;
                }
                if (!this.isCheckablePrivatePropDecl(n)) break;
                this.candidates.add(n);
                break;
            }
            case MEMBER_FUNCTION_DEF: {
                if (!this.isCheckablePrivatePropDecl(n)) break;
                this.candidates.add(n);
                break;
            }
            case OBJECTLIT: {
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (!c.isStringKey() && !c.isGetterDef() && !c.isSetterDef() && !c.isMemberFunctionDef()) continue;
                    this.used.add(c.getString());
                }
                break;
            }
            case CALL: {
                Node propName;
                Node target = n.getFirstChild();
                if (!n.hasMoreThanOneChild() || !this.compiler.getCodingConvention().isPropertyRenameFunction(target) || !(propName = target.getNext()).isStringLit()) break;
                this.used.add(propName.getString());
                break;
            }
            case FUNCTION: {
                JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
                if (info == null || !info.isConstructor() && !info.isInterface()) break;
                this.recordConstructorOrInterface(n);
                break;
            }
            case CLASS: {
                this.recordConstructorOrInterface(n);
                break;
            }
        }
    }

    private void recordConstructorOrInterface(Node n) {
        String className = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
        if (className != null) {
            this.constructorsAndInterfaces.add(className);
        }
    }

    private boolean isPrivatePropDecl(Node n) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.getVisibility() == JSDocInfo.Visibility.PRIVATE;
    }

    private boolean isCheckablePrivatePropDecl(Node n) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return this.isPrivatePropDecl(n) && !info.hasTypedefType() && !info.isInterface();
    }

    private boolean isCandidatePropertyDefinition(Node n) {
        Preconditions.checkState(n.isGetProp(), n);
        Node target = n.getFirstChild();
        return target.isThis() || this.constructorsAndInterfaces.contains(target.getQualifiedName()) || target.isGetProp() && target.getString().equals("prototype");
    }

    private static boolean isPinningPropertyUse(Node n) {
        Node parent = n.getParent();
        if (n == parent.getFirstChild()) {
            if (parent.isExprResult()) {
                return false;
            }
            if (parent.isAssign()) {
                return false;
            }
            if (NodeUtil.isAssignmentOp(parent) || parent.isInc() || parent.isDec()) {
                return NodeUtil.isExpressionResultUsed(parent);
            }
        }
        return true;
    }
}

