/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Strings;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ArrayListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.ExportTrace;
import com.google.javascript.jscomp.modules.GoogEsImports;
import com.google.javascript.jscomp.modules.Import;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMapCreator;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.modules.ModuleRequestResolver;
import com.google.javascript.jscomp.modules.ResolveExportResult;
import com.google.javascript.jscomp.modules.UnresolvedModule;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class EsModuleProcessor
implements NodeTraversal.Callback,
ModuleMapCreator.ModuleProcessor {
    public static final DiagnosticType AMBIGUOUS_EXPORT_DEFINITION = DiagnosticType.warning("JSC_AMBIGUOUS_EXPORT_DEFINITION", "The export \"{0}\" is ambiguous.");
    public static final DiagnosticType CYCLIC_EXPORT_DEFINITION = DiagnosticType.error("JSC_CYCLIC_EXPORT_DEFINITION", "Cyclic export detected while resolving name \"{0}\".");
    public static final DiagnosticType DUPLICATE_EXPORT = DiagnosticType.error("JSC_DUPLICATE_EXPORT", "Duplicate export of \"{0}\".");
    public static final DiagnosticType IMPORTED_AMBIGUOUS_EXPORT = DiagnosticType.error("JSC_IMPORTED_AMBIGUOUS_EXPORT", "The requested name \"{0}\" is ambiguous.");
    public static final DiagnosticType NAMESPACE_IMPORT_CANNOT_USE_STAR = DiagnosticType.error("JSC_NAMESPACE_IMPORT_CANNOT_USE_STAR", "Namespace imports ('goog:some.Namespace') cannot use import * as. Did you mean to import {0} from ''{1}'';?");
    public static final DiagnosticType CANNOT_PATH_IMPORT_CLOSURE_FILE = DiagnosticType.error("JSC_CANNOT_PATH_IMPORT_CLOSURE_FILE", "Cannot import Closure files by path. Use either import 'goog:namespace' or goog.require('namespace')");
    private final AbstractCompiler compiler;
    private UnresolvedModuleBuilder currentModuleBuilder;
    private ModuleMetadataMap.ModuleMetadata metadata;

    EsModuleProcessor(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public UnresolvedModule process(ModuleMetadataMap.ModuleMetadata metadata, ModuleLoader.ModulePath path, Node script) {
        this.metadata = metadata;
        this.currentModuleBuilder = new UnresolvedModuleBuilder(path, script);
        NodeTraversal.traverse(this.compiler, script, this);
        UnresolvedModule m = this.currentModuleBuilder.build();
        this.metadata = null;
        this.currentModuleBuilder = null;
        return m;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case ROOT: 
            case SCRIPT: 
            case MODULE_BODY: 
            case EXPORT: 
            case IMPORT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case EXPORT: {
                this.visitExport(t, n);
                break;
            }
            case IMPORT: {
                this.visitImport(t, n);
                break;
            }
        }
    }

    private void visitExportAllFrom(NodeTraversal t, Node export) {
        this.currentModuleBuilder.add(Export.builder().exportName(null).moduleRequest(export.getSecondChild().getString()).importName("*").localName(null).modulePath(t.getInput().getPath()).exportNode(export).moduleMetadata(this.metadata).build());
    }

    private void visitExportDefault(NodeTraversal t, Node export) {
        String maybeName;
        Node child = export.getFirstChild();
        String name = "*default*";
        if ((child.isFunction() || child.isClass()) && !Strings.isNullOrEmpty(maybeName = NodeUtil.getName(child))) {
            name = maybeName;
        }
        if (!this.currentModuleBuilder.add(Export.builder().exportName("default").moduleRequest(null).importName(null).localName(name).modulePath(t.getInput().getPath()).exportNode(export).moduleMetadata(this.metadata).build())) {
            t.report(export, DUPLICATE_EXPORT, "default");
        }
    }

    private void visitExportFrom(NodeTraversal t, Node export) {
        for (Node child = export.getFirstFirstChild(); child != null; child = child.getNext()) {
            String importName = child.getFirstChild().getString();
            String exportedName = child.getLastChild().getString();
            if (this.currentModuleBuilder.add(Export.builder().exportName(exportedName).moduleRequest(export.getSecondChild().getString()).importName(importName).localName(null).modulePath(t.getInput().getPath()).exportNode(export).nameNode(child.getFirstChild()).moduleMetadata(this.metadata).build())) continue;
            t.report(export, DUPLICATE_EXPORT, exportedName);
        }
    }

    private void visitExportSpecs(NodeTraversal t, Node export) {
        for (Node child = export.getFirstFirstChild(); child != null; child = child.getNext()) {
            String localName = child.getFirstChild().getString();
            String exportedName = child.getLastChild().getString();
            if (this.currentModuleBuilder.add(Export.builder().exportName(exportedName).moduleRequest(null).importName(null).localName(localName).modulePath(t.getInput().getPath()).exportNode(export).nameNode(child.getFirstChild()).moduleMetadata(this.metadata).build())) continue;
            t.report(export, DUPLICATE_EXPORT, exportedName);
        }
    }

    private void visitExportNameDeclaration(NodeTraversal t, Node export, Node declaration) {
        List<Node> lhsNodes = NodeUtil.findLhsNodesInNode(declaration);
        for (Node lhs : lhsNodes) {
            Preconditions.checkState(lhs.isName());
            String name = lhs.getString();
            if (this.currentModuleBuilder.add(Export.builder().exportName(name).moduleRequest(null).importName(null).localName(name).modulePath(t.getInput().getPath()).exportNode(export).nameNode(lhs).moduleMetadata(this.metadata).build())) continue;
            t.report(export, DUPLICATE_EXPORT, name);
        }
    }

    private void visitExportFunctionOrClass(NodeTraversal t, Node export, Node declaration) {
        Preconditions.checkState(declaration.isFunction() || declaration.isClass());
        Node nameNode = declaration.getFirstChild();
        String name = nameNode.getString();
        if (!this.currentModuleBuilder.add(Export.builder().exportName(name).moduleRequest(null).importName(null).localName(name).modulePath(t.getInput().getPath()).exportNode(export).nameNode(nameNode).moduleMetadata(this.metadata).build())) {
            t.report(export, DUPLICATE_EXPORT, name);
        }
    }

    private void visitExport(NodeTraversal t, Node export) {
        if (export.getBooleanProp(Node.EXPORT_ALL_FROM)) {
            this.visitExportAllFrom(t, export);
        } else if (export.getBooleanProp(Node.EXPORT_DEFAULT)) {
            this.visitExportDefault(t, export);
        } else if (export.hasTwoChildren()) {
            this.visitExportFrom(t, export);
        } else if (export.getFirstChild().getToken() == Token.EXPORT_SPECS) {
            this.visitExportSpecs(t, export);
        } else {
            Node declaration = export.getFirstChild();
            if (NodeUtil.isNameDeclaration(declaration)) {
                this.visitExportNameDeclaration(t, export, declaration);
            } else {
                this.visitExportFunctionOrClass(t, export, declaration);
            }
        }
    }

    private void visitImportDefault(NodeTraversal t, Node importNode, String moduleRequest) {
        this.currentModuleBuilder.add(Import.builder().moduleRequest(moduleRequest).importName("default").localName(importNode.getFirstChild().getString()).modulePath(t.getInput().getPath()).importNode(importNode).nameNode(importNode.getFirstChild()).build());
    }

    private void visitImportSpecs(NodeTraversal t, Node importNode, String moduleRequest) {
        for (Node child = importNode.getSecondChild().getFirstChild(); child != null; child = child.getNext()) {
            String importName = child.getFirstChild().getString();
            String localName = child.getLastChild().getString();
            this.currentModuleBuilder.add(Import.builder().moduleRequest(moduleRequest).importName(importName).localName(localName).modulePath(t.getInput().getPath()).importNode(importNode).nameNode(child.getSecondChild()).build());
        }
    }

    private void visitImportStar(NodeTraversal t, Node importNode, String moduleRequest) {
        this.currentModuleBuilder.add(Import.builder().moduleRequest(moduleRequest).importName("*").localName(importNode.getSecondChild().getString()).importNode(importNode).modulePath(t.getInput().getPath()).nameNode(importNode.getSecondChild()).build());
    }

    private void visitImport(NodeTraversal t, Node importNode) {
        String moduleRequest = importNode.getLastChild().getString();
        if (importNode.getFirstChild().isName()) {
            this.visitImportDefault(t, importNode, moduleRequest);
        }
        if (importNode.getSecondChild().isImportSpecs()) {
            this.visitImportSpecs(t, importNode, moduleRequest);
        } else if (importNode.getSecondChild().isImportStar()) {
            this.visitImportStar(t, importNode, moduleRequest);
        }
    }

    private final class UnresolvedEsModule
    extends UnresolvedModule {
        private final ModuleMetadataMap.ModuleMetadata metadata;
        private final ModuleLoader.ModulePath path;
        private final ImmutableMap<String, Import> importsByLocalName;
        private final ImmutableList<Export> localExports;
        private final ImmutableList<Export> indirectExports;
        private final ImmutableList<Export> starExports;
        private ImmutableSet<String> exportedNames;
        private final Map<String, ResolveExportResult> resolvedImports;
        private final Map<String, ResolveExportResult> resolvedExports;
        private Module resolved;

        private UnresolvedEsModule(ModuleMetadataMap.ModuleMetadata metadata, ModuleLoader.ModulePath path, ImmutableMap<String, Import> importsByLocalName, ImmutableList<Export> localExports, ImmutableList<Export> indirectExports, ImmutableList<Export> starExports) {
            this.metadata = metadata;
            this.path = path;
            this.importsByLocalName = importsByLocalName;
            this.localExports = localExports;
            this.indirectExports = indirectExports;
            this.starExports = starExports;
            this.exportedNames = null;
            this.resolvedImports = new HashMap<String, ResolveExportResult>();
            this.resolvedExports = new HashMap<String, ResolveExportResult>();
            this.resolved = null;
        }

        @Override
        void reset() {
            this.resolved = null;
            this.exportedNames = null;
            this.resolvedImports.clear();
            this.resolvedExports.clear();
        }

        @Override
        public Module resolve(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier) {
            if (this.resolved == null) {
                LinkedHashMap<String, Binding> boundNames = new LinkedHashMap<String, Binding>(this.getAllResolvedImports(moduleRequestResolver));
                HashMap<String, Export> localNameToLocalExport = new HashMap<String, Export>();
                for (Export e : this.localExports) {
                    localNameToLocalExport.put(e.localName(), e);
                    if ("*default*".equals(e.localName())) continue;
                    ResolveExportResult b = this.resolveExport(moduleRequestResolver, e.exportName());
                    Preconditions.checkState(b.resolved(), "Cannot have invalid missing own export!");
                    if (b.isAmbiguous()) continue;
                    boundNames.put(e.localName(), b.getBinding());
                }
                this.resolved = Module.builder().boundNames(ImmutableMap.copyOf(boundNames)).namespace(ImmutableMap.copyOf(this.getAllResolvedExports(moduleRequestResolver))).metadata(this.metadata).path(this.path).localNameToLocalExport(ImmutableMap.copyOf(localNameToLocalExport)).build();
            }
            return this.resolved;
        }

        @Override
        ModuleMetadataMap.ModuleMetadata metadata() {
            return this.metadata;
        }

        Map<String, Binding> getAllResolvedImports(ModuleRequestResolver moduleRequestResolver) {
            HashMap<String, Binding> imports = new HashMap<String, Binding>();
            for (String name : this.importsByLocalName.keySet()) {
                ResolveExportResult b = this.resolveImport(moduleRequestResolver, name);
                if (!b.resolved()) continue;
                imports.put(name, b.getBinding());
            }
            return imports;
        }

        public ResolveExportResult resolveImport(ModuleRequestResolver moduleRequestResolver, String name, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
            if (this.resolvedImports.containsKey(name)) {
                return this.resolvedImports.get(name);
            }
            ResolveExportResult b = this.resolveImportImpl(moduleRequestResolver, name, resolveSet, exportStarSet);
            this.resolvedImports.put(name, b);
            return b;
        }

        public ResolveExportResult resolveImport(ModuleRequestResolver moduleRequestResolver, String name) {
            return this.resolveImport(moduleRequestResolver, name, new HashSet<ExportTrace>(), new HashSet<UnresolvedModule>());
        }

        private ResolveExportResult resolveImportImpl(ModuleRequestResolver moduleRequestResolver, String name, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
            Import i = this.importsByLocalName.get(name);
            UnresolvedModule requested = moduleRequestResolver.resolve(i);
            if (requested == null) {
                return ResolveExportResult.ERROR;
            }
            boolean importStar = i.importName().equals("*");
            if (importStar || i.importName().equals("default") && (requested.metadata().isGoogProvide() || requested.metadata().isGoogModule())) {
                if (!GoogEsImports.isGoogImportSpecifier(i.moduleRequest()) && (requested.metadata().isGoogModule() || requested.metadata().isGoogProvide())) {
                    EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), i.importNode().getLineno(), i.importNode().getCharno(), CANNOT_PATH_IMPORT_CLOSURE_FILE, i.localName(), i.moduleRequest()));
                    return ResolveExportResult.ERROR;
                }
                if (importStar && GoogEsImports.isGoogImportSpecifier(i.moduleRequest())) {
                    EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), i.importNode().getLineno(), i.importNode().getCharno(), NAMESPACE_IMPORT_CANNOT_USE_STAR, i.localName(), i.moduleRequest()));
                    return ResolveExportResult.ERROR;
                }
                String closureNamespace = GoogEsImports.isGoogImportSpecifier(i.moduleRequest()) ? GoogEsImports.getClosureIdFromGoogImportSpecifier(i.moduleRequest()) : null;
                return ResolveExportResult.of(Binding.from(requested.metadata(), closureNamespace, i.nameNode()));
            }
            ResolveExportResult result = requested.resolveExport(moduleRequestResolver, i.moduleRequest(), i.importName(), resolveSet, exportStarSet);
            if (!result.found() && !result.hadError()) {
                EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), i.importNode().getLineno(), i.importNode().getCharno(), ModuleMapCreator.DOES_NOT_HAVE_EXPORT, i.importName()));
                return ResolveExportResult.ERROR;
            }
            if (result.isAmbiguous()) {
                EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), i.importNode().getLineno(), i.importNode().getCharno(), IMPORTED_AMBIGUOUS_EXPORT, i.importName()));
                return ResolveExportResult.ERROR;
            }
            Node forSourceInfo = i.nameNode() == null ? i.importNode() : i.nameNode();
            return result.copy(forSourceInfo, Binding.CreatedBy.IMPORT);
        }

        @Override
        public ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver) {
            if (this.exportedNames == null) {
                this.exportedNames = this.getExportedNames(moduleRequestResolver, new HashSet<UnresolvedModule>());
            }
            return this.exportedNames;
        }

        @Override
        public ImmutableSet<String> getExportedNames(ModuleRequestResolver moduleRequestResolver, Set<UnresolvedModule> visited) {
            if (visited.contains(this)) {
                return ImmutableSet.of();
            }
            visited.add(this);
            TreeSet<String> exportedNames = new TreeSet<String>();
            for (Export e : this.localExports) {
                exportedNames.add(e.exportName());
            }
            for (Export e : this.indirectExports) {
                exportedNames.add(e.exportName());
            }
            for (Export e : this.starExports) {
                UnresolvedModule requested = moduleRequestResolver.resolve(e);
                if (requested == null) continue;
                if (requested.metadata().isEs6Module()) {
                    for (String n : requested.getExportedNames(moduleRequestResolver, visited)) {
                        if ("default".equals(n) || exportedNames.contains(n)) continue;
                        exportedNames.add(n);
                    }
                    continue;
                }
                EsModuleProcessor.this.compiler.report(JSError.make(e.exportNode(), Es6ToEs3Util.CANNOT_CONVERT_YET, "Wildcard export for non-ES module"));
            }
            return ImmutableSet.copyOf(exportedNames);
        }

        Map<String, Binding> getAllResolvedExports(ModuleRequestResolver moduleRequestResolver) {
            LinkedHashMap<String, Binding> exports = new LinkedHashMap<String, Binding>();
            for (String name : this.getExportedNames(moduleRequestResolver)) {
                ResolveExportResult b = this.resolveExport(moduleRequestResolver, name);
                Preconditions.checkState(b.found(), "Cannot have invalid own export.");
                if (b.resolved()) {
                    exports.put(name, b.getBinding());
                    continue;
                }
                if (!b.isAmbiguous()) continue;
                EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), -1, -1, AMBIGUOUS_EXPORT_DEFINITION, name));
            }
            return exports;
        }

        private ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, String exportName, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
            if (!this.getExportedNames(moduleRequestResolver).contains(exportName)) {
                return ResolveExportResult.NOT_FOUND;
            }
            if (!resolveSet.add(ExportTrace.create(this, exportName))) {
                EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), 0, 0, CYCLIC_EXPORT_DEFINITION, exportName));
                return ResolveExportResult.ERROR;
            }
            for (Export e : this.localExports) {
                if (!exportName.equals(e.exportName())) continue;
                Node forSourceInfo = e.nameNode() != null ? e.nameNode() : e.exportNode();
                return ResolveExportResult.of(Binding.from(e, forSourceInfo));
            }
            for (Export e : this.indirectExports) {
                if (!exportName.equals(e.exportName())) continue;
                if (this.importsByLocalName.containsKey(e.localName())) {
                    return this.resolveImport(moduleRequestResolver, e.localName(), resolveSet, exportStarSet).copy(e.nameNode(), Binding.CreatedBy.EXPORT);
                }
                UnresolvedModule requested = moduleRequestResolver.resolve(e);
                if (requested == null) {
                    return ResolveExportResult.ERROR;
                }
                ResolveExportResult result = requested.resolveExport(moduleRequestResolver, e.moduleRequest(), e.importName(), resolveSet, exportStarSet);
                if (!result.found() && !result.hadError()) {
                    EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), e.exportNode().getLineno(), e.exportNode().getCharno(), ModuleMapCreator.DOES_NOT_HAVE_EXPORT, e.importName()));
                    return ResolveExportResult.ERROR;
                }
                if (result.isAmbiguous()) {
                    EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), e.exportNode().getLineno(), e.exportNode().getCharno(), IMPORTED_AMBIGUOUS_EXPORT, e.importName()));
                }
                return result.copy(e.nameNode(), Binding.CreatedBy.EXPORT);
            }
            Preconditions.checkState(!"default".equals(exportName), "Default export cannot come from export *.");
            if (exportStarSet.contains(this)) {
                EsModuleProcessor.this.compiler.report(JSError.make(this.path.toString(), -1, -1, CYCLIC_EXPORT_DEFINITION, exportName));
                return ResolveExportResult.ERROR;
            }
            exportStarSet.add(this);
            ResolveExportResult starResolution = null;
            for (Export e : this.starExports) {
                UnresolvedModule requested = moduleRequestResolver.resolve(e);
                if (requested == null) {
                    return ResolveExportResult.ERROR;
                }
                if (!requested.getExportedNames(moduleRequestResolver).contains(exportName)) continue;
                ResolveExportResult resolution = requested.resolveExport(moduleRequestResolver, e.moduleRequest(), exportName, resolveSet, exportStarSet);
                if (resolution.hadError()) {
                    return resolution;
                }
                if (resolution.isAmbiguous()) {
                    return resolution;
                }
                if (starResolution == null) {
                    starResolution = resolution.copy(e.exportNode(), Binding.CreatedBy.EXPORT);
                    continue;
                }
                if (starResolution == resolution) continue;
                return ResolveExportResult.AMBIGUOUS;
            }
            if (starResolution == null) {
                return ResolveExportResult.ERROR;
            }
            return starResolution;
        }

        @Override
        public ResolveExportResult resolveExport(ModuleRequestResolver moduleRequestResolver, @Nullable String moduleSpecifier, String exportName, Set<ExportTrace> resolveSet, Set<UnresolvedModule> exportStarSet) {
            if (this.resolvedExports.containsKey(exportName)) {
                return this.resolvedExports.get(exportName);
            }
            ResolveExportResult b = this.resolveExport(moduleRequestResolver, exportName, resolveSet, exportStarSet);
            this.resolvedExports.put(exportName, b);
            return b;
        }
    }

    private final class UnresolvedModuleBuilder {
        private final ModuleLoader.ModulePath path;
        private final Node root;
        private final Map<String, Import> importsByLocalName;
        private final List<Export> exports;
        private final Set<String> exportedNames;

        UnresolvedModuleBuilder(ModuleLoader.ModulePath path, Node root) {
            this.path = path;
            this.root = root;
            this.importsByLocalName = new HashMap<String, Import>();
            this.exports = new ArrayList<Export>();
            this.exportedNames = new HashSet<String>();
        }

        void add(Import i) {
            this.importsByLocalName.put(i.localName(), i);
        }

        boolean add(Export e) {
            if (e.exportName() == null) {
                this.exports.add(e);
                return true;
            }
            if (this.exportedNames.contains(e.exportName())) {
                return false;
            }
            this.exports.add(e);
            this.exportedNames.add(e.exportName());
            return true;
        }

        UnresolvedModule build() {
            ArrayList<Export> localExports = new ArrayList<Export>();
            ImmutableList.Builder indirectExportsBuilder = new ImmutableList.Builder();
            ImmutableList.Builder starExportsBuilder = new ImmutableList.Builder();
            for (Export ee : this.exports) {
                if (ee.moduleRequest() == null) {
                    if (this.importsByLocalName.containsKey(ee.localName())) {
                        indirectExportsBuilder.add(ee);
                        continue;
                    }
                    localExports.add(ee);
                    continue;
                }
                if ("*".equals(ee.importName())) {
                    starExportsBuilder.add(ee);
                    continue;
                }
                indirectExportsBuilder.add(ee);
            }
            NodeTraversal.traverse(EsModuleProcessor.this.compiler, this.root, new FindMutableExports(localExports));
            return new UnresolvedEsModule(EsModuleProcessor.this.metadata, this.path, ImmutableMap.copyOf(this.importsByLocalName), ImmutableList.copyOf(localExports), (ImmutableList)indirectExportsBuilder.build(), (ImmutableList)starExportsBuilder.build());
        }
    }

    private static final class FindMutableExports
    extends NodeTraversal.AbstractPostOrderCallback {
        final List<Export> exports;
        final ListMultimap<String, Export> exportsByLocalName;

        FindMutableExports(List<Export> exports) {
            this.exports = exports;
            this.exportsByLocalName = ArrayListMultimap.create();
            for (Export e : exports) {
                this.exportsByLocalName.put(e.localName(), e);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isName()) {
                return;
            }
            Scope scope = t.getScope();
            if (!NodeUtil.isLValue(n) || ((Scope)scope.getClosestHoistScope()).isModuleScope()) {
                return;
            }
            Collection exports = this.exportsByLocalName.get((Object)n.getString());
            if (exports.isEmpty()) {
                return;
            }
            Var var = (Var)scope.getVar(n.getString());
            if (var == null || !((Scope)var.getScope()).isModuleScope()) {
                return;
            }
            for (Export e : new ArrayList(exports)) {
                int i = this.exports.indexOf(e);
                Export mutated = e.mutatedCopy();
                this.exports.set(i, mutated);
                this.exportsByLocalName.remove(e.localName(), e);
                this.exportsByLocalName.put(e.localName(), mutated);
            }
        }
    }
}

