/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.AutoValue_Config;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class Config {
    public abstract LanguageMode languageMode();

    public abstract StrictMode strictMode();

    public abstract JsDocParsing jsDocParsingMode();

    public abstract RunMode runMode();

    public abstract ImmutableMap<String, Annotation> annotations();

    public abstract ImmutableSet<String> suppressionNames();

    abstract ImmutableSet<String> closurePrimitiveNames();

    public abstract boolean parseInlineSourceMaps();

    final ImmutableSet<String> annotationNames() {
        return this.annotations().keySet();
    }

    public static Builder builder() {
        return new AutoValue_Config.Builder().setLanguageMode(LanguageMode.UNSUPPORTED).setStrictMode(StrictMode.STRICT).setJsDocParsingMode(JsDocParsing.TYPES_ONLY).setRunMode(RunMode.STOP_AFTER_ERROR).setExtraAnnotationNames(ImmutableSet.of()).setSuppressionNames(ImmutableSet.of()).setClosurePrimitiveNames(ImmutableSet.of()).setParseInlineSourceMaps(false);
    }

    private static ImmutableMap<String, Annotation> buildAnnotations(Iterable<String> allowlist) {
        ImmutableMap.Builder<String, Annotation> annotationsBuilder = ImmutableMap.builder();
        annotationsBuilder.putAll(Annotation.recognizedAnnotations);
        for (String unrecognizedAnnotation : allowlist) {
            if (unrecognizedAnnotation.isEmpty() || Annotation.recognizedAnnotations.containsKey(unrecognizedAnnotation)) continue;
            annotationsBuilder.put(unrecognizedAnnotation, Annotation.NOT_IMPLEMENTED);
        }
        return annotationsBuilder.buildOrThrow();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setLanguageMode(LanguageMode var1);

        public abstract Builder setStrictMode(StrictMode var1);

        public abstract Builder setJsDocParsingMode(JsDocParsing var1);

        public abstract Builder setRunMode(RunMode var1);

        public abstract Builder setParseInlineSourceMaps(boolean var1);

        public abstract Builder setSuppressionNames(Iterable<String> var1);

        abstract Builder setClosurePrimitiveNames(Iterable<String> var1);

        final Builder setExtraAnnotationNames(Iterable<String> names) {
            return this.setAnnotations(Config.buildAnnotations(names));
        }

        public abstract Config build();

        public abstract Builder setAnnotations(ImmutableMap<String, Annotation> var1);
    }

    public static enum RunMode {
        STOP_AFTER_ERROR,
        KEEP_GOING;

    }

    public static enum JsDocParsing {
        TYPES_ONLY,
        INCLUDE_DESCRIPTIONS_NO_WHITESPACE,
        INCLUDE_DESCRIPTIONS_WITH_WHITESPACE,
        INCLUDE_ALL_COMMENTS;


        boolean shouldParseDescriptions() {
            return this != TYPES_ONLY;
        }

        boolean shouldPreserveWhitespace() {
            return this == INCLUDE_DESCRIPTIONS_WITH_WHITESPACE || this == INCLUDE_ALL_COMMENTS;
        }
    }

    public static enum LanguageMode {
        ECMASCRIPT3(FeatureSet.ES3),
        ECMASCRIPT5(FeatureSet.ES5),
        ECMASCRIPT_2015(FeatureSet.ES2015_MODULES),
        ECMASCRIPT_2016(FeatureSet.ES2016_MODULES),
        ECMASCRIPT_2017(FeatureSet.ES2017_MODULES),
        ECMASCRIPT_2018(FeatureSet.ES2018_MODULES),
        ECMASCRIPT_2019(FeatureSet.ES2019_MODULES),
        ECMASCRIPT_2020(FeatureSet.ES2020_MODULES),
        ECMASCRIPT_2021(FeatureSet.ES2021_MODULES),
        ES_NEXT(FeatureSet.ES_NEXT),
        ES_NEXT_IN(FeatureSet.ES_NEXT_IN),
        UNSUPPORTED(FeatureSet.ES_UNSUPPORTED);

        public final FeatureSet featureSet;

        private LanguageMode(FeatureSet featureSet) {
            this.featureSet = featureSet;
        }

        public static LanguageMode minimumRequiredFor(FeatureSet.Feature feature) {
            for (LanguageMode mode : LanguageMode.values()) {
                if (!mode.featureSet.has(feature)) continue;
                return mode;
            }
            throw new IllegalStateException("No input language mode supports feature: " + (Object)((Object)feature));
        }

        public static LanguageMode minimumRequiredForSet(FeatureSet featureSet) {
            for (LanguageMode mode : LanguageMode.values()) {
                if (!mode.featureSet.contains(featureSet)) continue;
                return mode;
            }
            throw new IllegalStateException("No input language mode supports feature set: " + featureSet);
        }

        public static LanguageMode latestEcmaScript() {
            return ECMASCRIPT_2020;
        }
    }

    public static enum StrictMode {
        STRICT,
        SLOPPY;


        public boolean isStrict() {
            return this == STRICT;
        }
    }
}

