/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.trees;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;

public class FunctionDeclarationTree
extends ParseTree {
    @Nullable
    public final IdentifierToken name;
    public final FormalParameterListTree formalParameterList;
    public final ParseTree functionBody;
    public final boolean isStatic;
    public final boolean isGenerator;
    public final boolean isOptional;
    public final boolean isAsync;
    public final Kind kind;

    public static Builder builder(Kind kind) {
        return new Builder(kind);
    }

    private FunctionDeclarationTree(Builder builder) {
        super(ParseTreeType.FUNCTION_DECLARATION, builder.location);
        this.name = builder.name;
        this.isStatic = builder.isStatic;
        this.isGenerator = builder.isGenerator;
        this.isOptional = builder.isOptional;
        this.kind = Preconditions.checkNotNull(builder.kind);
        this.formalParameterList = Preconditions.checkNotNull(builder.formalParameterList);
        this.functionBody = Preconditions.checkNotNull(builder.functionBody);
        this.isAsync = builder.isAsync;
    }

    public static class Builder {
        private final Kind kind;
        @Nullable
        private IdentifierToken name = null;
        @Nullable
        private FormalParameterListTree formalParameterList = null;
        @Nullable
        private ParseTree functionBody = null;
        private boolean isStatic = false;
        private boolean isGenerator = false;
        private boolean isOptional = false;
        private boolean isAsync = false;
        private SourceRange location;

        Builder(Kind kind) {
            this.kind = kind;
        }

        public Builder setName(IdentifierToken name) {
            this.name = name;
            return this;
        }

        public Builder setFormalParameterList(FormalParameterListTree formalParameterList) {
            this.formalParameterList = formalParameterList;
            return this;
        }

        public Builder setFunctionBody(ParseTree functionBody) {
            this.functionBody = functionBody;
            return this;
        }

        public Builder setStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return this;
        }

        public Builder setGenerator(boolean isGenerator) {
            this.isGenerator = isGenerator;
            return this;
        }

        public Builder setOptional(boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public Builder setAsync(boolean isAsync) {
            this.isAsync = isAsync;
            return this;
        }

        public FunctionDeclarationTree build(SourceRange location) {
            this.location = location;
            return new FunctionDeclarationTree(this);
        }
    }

    public static enum Kind {
        DECLARATION,
        EXPRESSION,
        MEMBER,
        ARROW;

    }
}

