/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.base.IdentityRef;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.base.Tri;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.colors.DebugInfo;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashBasedTable;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.serialization.MalformedTypedAstException;
import com.google.javascript.jscomp.serialization.ObjectTypeProto;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.SubtypingEdge;
import com.google.javascript.jscomp.serialization.TypePointers;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypeProto;
import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;

public final class ColorPool {
    private final ImmutableMap<ColorId, Color> idToColor;
    private final ImmutableList<ShardView> shardViews;
    private final ColorRegistry colorRegistry;
    private static final Color PENDING_COLOR = Color.singleBuilder().setId(ColorId.fromUnsigned(-559038737)).build();

    private ColorPool(Builder builder) {
        this.idToColor = ImmutableMap.copyOf(builder.idToColor);
        this.shardViews = ImmutableList.copyOf(builder.protoToShard.values());
        this.colorRegistry = builder.registry.build();
    }

    public Color getColor(ColorId id) {
        return this.idToColor.get(id);
    }

    public ColorRegistry getRegistry() {
        return this.colorRegistry;
    }

    public ShardView getOnlyShard() {
        return Iterables.getOnlyElement(this.shardViews);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ColorPool fromOnlyShard(TypePool typePool, StringPool stringPool) {
        return ColorPool.builder().addShardAnd(typePool, stringPool).build();
    }

    private static ImmutableList<ColorId> createTrimmedOffsetToId(TypePool typePool) {
        TypeProto proto;
        int i;
        ColorId[] ids = new ColorId[typePool.getTypeCount()];
        block8: for (i = 0; i < ids.length; ++i) {
            proto = typePool.getType(i);
            switch (proto.getKindCase()) {
                case OBJECT: {
                    ids[i] = ColorId.fromBytes(proto.getObject().getUuid());
                    continue block8;
                }
                case UNION: {
                    continue block8;
                }
                default: {
                    throw new MalformedTypedAstException(proto);
                }
            }
        }
        block9: for (i = 0; i < ids.length; ++i) {
            proto = typePool.getType(i);
            switch (proto.getKindCase()) {
                case OBJECT: {
                    continue block9;
                }
                case UNION: {
                    MalformedTypedAstException.checkWellFormed(proto.getUnion().getUnionMemberCount() > 1, "Union has too few members", proto);
                    LinkedHashSet<ColorId> members = new LinkedHashSet<ColorId>();
                    for (Integer memberPointer : proto.getUnion().getUnionMemberList()) {
                        ColorId memberId = TypePointers.isAxiomatic(memberPointer) ? ((Color)TypePointers.OFFSET_TO_AXIOMATIC_COLOR.get(memberPointer)).getId() : ids[TypePointers.trimOffset(memberPointer)];
                        MalformedTypedAstException.checkWellFormed(memberId != null, "Union member not found", proto);
                        members.add(memberId);
                    }
                    ids[i] = ColorId.union(members);
                    continue block9;
                }
                default: {
                    throw new AssertionError(proto);
                }
            }
        }
        LinkedHashSet<ColorId> seenIds = new LinkedHashSet<ColorId>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            TypeProto proto2 = typePool.getType(i2);
            MalformedTypedAstException.checkWellFormed(seenIds.add(ids[i2]), "Duplicate ID in single shard", proto2);
        }
        return ImmutableList.copyOf(ids);
    }

    private static int validatePointer(int offset, ShardView shard) {
        MalformedTypedAstException.checkWellFormed(0 <= offset && offset < TypePointers.untrimOffset(shard.trimmedOffsetToId.size()), "Pointer offset outside of shard", offset);
        return offset;
    }

    public static final class Builder {
        private final LinkedHashMap<IdentityRef<TypePool>, ShardView> protoToShard = new LinkedHashMap();
        private final LinkedHashMap<ColorId, Color> idToColor = new LinkedHashMap();
        private final ColorRegistry.Builder registry = ColorRegistry.builder();
        private final HashBasedTable<ColorId, ShardView, TypeProto> idToProto = HashBasedTable.create();
        private final ArrayDeque<ColorId> reconcilationDebugStack = new ArrayDeque();

        private Builder() {
            this.idToColor.putAll(StandardColors.AXIOMATIC_COLORS);
        }

        public Builder addShardAnd(TypePool typePool, StringPool stringPool) {
            this.addShard(typePool, stringPool);
            return this;
        }

        public ShardView addShard(TypePool typePool, StringPool stringPool) {
            Preconditions.checkState(this.idToProto.isEmpty(), "build has already been called");
            IdentityRef<TypePool> typePoolRef = IdentityRef.of(typePool);
            ShardView existing = this.protoToShard.get(typePoolRef);
            if (existing != null) {
                Preconditions.checkState(JSCompObjects.identical(typePool, TypePool.getDefaultInstance()), typePool);
                return existing;
            }
            ImmutableList trimmedOffsetToId = ColorPool.createTrimmedOffsetToId(typePool);
            ShardView shard = new ShardView(typePool, stringPool, trimmedOffsetToId);
            this.protoToShard.put(typePoolRef, shard);
            if (typePool.hasDebugInfo()) {
                for (TypePool.DebugInfo.Mismatch m : typePool.getDebugInfo().getMismatchList()) {
                    for (Integer pointer : m.getInvolvedColorList()) {
                        this.registry.addMismatchLocation(shard.getId(pointer), m.getSourceRef());
                    }
                }
            }
            return shard;
        }

        public ColorPool build() {
            Preconditions.checkState(this.idToProto.isEmpty(), "build has already been called");
            for (ShardView shard : this.protoToShard.values()) {
                for (int i = 0; i < shard.typePool.getTypeCount(); ++i) {
                    ColorId id = (ColorId)shard.trimmedOffsetToId.get(i);
                    this.idToProto.put((Object)id, (Object)shard, (Object)shard.typePool.getType(i));
                }
            }
            for (ColorId id : StandardColors.AXIOMATIC_COLORS.keySet()) {
                MalformedTypedAstException.checkWellFormed(!this.idToProto.containsRow(id), "Found serialized definiton for axiomatic color", id);
            }
            for (ColorId id : this.idToProto.rowKeySet()) {
                this.lookupOrReconcileColor(id);
            }
            for (ColorId colorId : ColorRegistry.REQUIRED_IDS) {
                this.registry.setNativeColor(this.idToColor.computeIfAbsent(colorId, unused -> Color.singleBuilder().setId(colorId).build()));
            }
            for (ShardView shard : this.protoToShard.values()) {
                for (SubtypingEdge edge : shard.typePool.getDisambiguationEdgesList()) {
                    this.registry.addDisambiguationEdge(this.idToColor.get(shard.getId(ColorPool.validatePointer(edge.getSubtype(), shard))), this.idToColor.get(shard.getId(ColorPool.validatePointer(edge.getSupertype(), shard))));
                }
            }
            ColorPool colorPool = new ColorPool(this);
            for (ShardView shard : this.protoToShard.values()) {
                shard.colorPool = colorPool;
            }
            return colorPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Color lookupOrReconcileColor(ColorId id) {
            this.reconcilationDebugStack.addLast(id);
            try {
                Color result;
                Color existing = this.idToColor.putIfAbsent(id, PENDING_COLOR);
                if (existing != null) {
                    if (JSCompObjects.identical(existing, PENDING_COLOR)) {
                        throw new MalformedTypedAstException((Object)("Cyclic Color structure detected: " + this.reconcilationDebugStack.stream().map(x$0 -> this.idToProto.row(x$0)).map(ImmutableMap::copyOf).collect(ImmutableList.toImmutableList())));
                    }
                    Color color = existing;
                    return color;
                }
                Map viewToProto = this.idToProto.row((Object)id);
                TypeProto sample = Iterables.getFirst(viewToProto.values(), null);
                Preconditions.checkNotNull(sample, id);
                switch (sample.getKindCase()) {
                    case OBJECT: {
                        result = this.reconcileObjectProtos(id, viewToProto);
                        break;
                    }
                    case UNION: {
                        result = this.reconcileUnionProtos(id, viewToProto);
                        break;
                    }
                    default: {
                        throw new AssertionError(sample);
                    }
                }
                Preconditions.checkState(result != null, id);
                this.idToColor.put(id, result);
                Color color = result;
                return color;
            }
            finally {
                this.reconcilationDebugStack.removeLast();
            }
        }

        /*
         * WARNING - void declaration
         */
        private Color reconcileObjectProtos(ColorId id, Map<ShardView, TypeProto> viewToProto) {
            TreeSet<String> debugTypenames = new TreeSet<String>();
            ImmutableSet.Builder instanceColors = ImmutableSet.builder();
            ImmutableSet.Builder prototypes = ImmutableSet.builder();
            ImmutableSet.Builder ownProperties = ImmutableSet.builder();
            Tri isClosureAssert = Tri.UNKNOWN;
            boolean isConstructor = false;
            boolean isInvalidating = false;
            boolean propertiesKeepOriginalName = false;
            for (Map.Entry<ShardView, TypeProto> entry : viewToProto.entrySet()) {
                void var17_18;
                ShardView shard = entry.getKey();
                TypeProto proto = entry.getValue();
                Preconditions.checkState(proto.hasObject());
                ObjectTypeProto objProto = proto.getObject();
                if (objProto.hasDebugInfo()) {
                    debugTypenames.addAll(objProto.getDebugInfo().getTypenameList());
                }
                for (Integer n : objProto.getInstanceTypeList()) {
                    instanceColors.add(this.lookupOrReconcileColor(shard.getId(n)));
                }
                boolean isClosureAssertBool = objProto.getClosureAssert();
                MalformedTypedAstException.checkWellFormed(isClosureAssert.toBoolean(isClosureAssertBool) == isClosureAssertBool, "Inconsistent values for closure_assert", objProto);
                isClosureAssert = Tri.forBoolean(isClosureAssertBool);
                isConstructor |= objProto.getMarkedConstructor();
                isInvalidating |= objProto.getIsInvalidating();
                propertiesKeepOriginalName |= objProto.getPropertiesKeepOriginalName();
                for (Integer p3 : objProto.getPrototypeList()) {
                    prototypes.add(this.lookupOrReconcileColor(shard.getId(p3)));
                }
                boolean bl = false;
                while (var17_18 < objProto.getOwnPropertyCount()) {
                    ownProperties.add(shard.stringPool.get(objProto.getOwnProperty((int)var17_18)));
                    ++var17_18;
                }
            }
            DebugInfo debugInfo = DebugInfo.EMPTY;
            if (!debugTypenames.isEmpty()) {
                debugInfo = DebugInfo.builder().setCompositeTypename(String.join((CharSequence)"/", debugTypenames)).build();
            }
            return Color.singleBuilder().setId(id).setDebugInfo(debugInfo).setInstanceColors((ImmutableSet<Color>)instanceColors.build()).setPrototypes((ImmutableSet<Color>)prototypes.build()).setOwnProperties((ImmutableSet<String>)ownProperties.build()).setClosureAssert(isClosureAssert.toBoolean(false)).setConstructor(isConstructor).setInvalidating(isInvalidating).setPropertiesKeepOriginalName(propertiesKeepOriginalName).build();
        }

        private Color reconcileUnionProtos(ColorId id, Map<ShardView, TypeProto> viewToProto) {
            LinkedHashSet<Color> union = new LinkedHashSet<Color>();
            viewToProto.forEach((shard, proto) -> {
                Preconditions.checkState(proto.hasUnion(), proto);
                for (Integer memberPointer : proto.getUnion().getUnionMemberList()) {
                    ColorId memberId = ((ShardView)shard).getId(memberPointer);
                    Color member = this.lookupOrReconcileColor(memberId);
                    MalformedTypedAstException.checkWellFormed(!member.isUnion(), "Reconciling union with non-union", proto);
                    union.add(member);
                }
            });
            Color result = Color.createUnion(union);
            Preconditions.checkState(id.equals(result.getId()), "%s == %s", (Object)id, (Object)result);
            return result;
        }
    }

    public static final class ShardView {
        private final TypePool typePool;
        private final StringPool stringPool;
        private final ImmutableList<ColorId> trimmedOffsetToId;
        private ColorPool colorPool;

        private ShardView(TypePool typePool, StringPool stringPool, ImmutableList<ColorId> trimmedOffsetToId) {
            this.typePool = typePool;
            this.stringPool = stringPool;
            this.trimmedOffsetToId = trimmedOffsetToId;
        }

        public Color getColor(int pointer) {
            Preconditions.checkState(this.colorPool != null, this);
            return this.colorPool.getColor(this.getId(pointer));
        }

        private ColorId getId(int untrimmedOffset) {
            if (TypePointers.isAxiomatic(untrimmedOffset)) {
                return ((Color)TypePointers.OFFSET_TO_AXIOMATIC_COLOR.get(untrimmedOffset)).getId();
            }
            return (ColorId)this.trimmedOffsetToId.get(TypePointers.trimOffset(untrimmedOffset));
        }
    }
}

