/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.hash.HashFunction;
import com.google.javascript.jscomp.jarjar.com.google.common.hash.Hasher;
import com.google.javascript.jscomp.jarjar.com.google.common.hash.Hashing;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.nio.charset.StandardCharsets;
import java.util.Map;

final class JSTypeColorIdHasher {
    private final ImmutableMap<ObjectType, ColorId> standardColorObjectIds = NATIVE_TYPE_TO_ID.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> registry.getNativeObjectType((JSTypeNative)((Object)((Object)e.getKey()))), Map.Entry::getValue));
    private static final HashFunction FARM_64 = Hashing.farmHashFingerprint64();
    static final ImmutableMap<JSTypeNative, ColorId> NATIVE_TYPE_TO_ID = ImmutableMap.builder().put(JSTypeNative.ARGUMENTS_TYPE, StandardColors.ARGUMENTS_ID).put(JSTypeNative.ARRAY_TYPE, StandardColors.ARRAY_ID).put(JSTypeNative.ASYNC_ITERATOR_ITERABLE_TYPE, StandardColors.ASYNC_ITERATOR_ITERABLE_ID).put(JSTypeNative.GENERATOR_TYPE, StandardColors.GENERATOR_ID).put(JSTypeNative.I_TEMPLATE_ARRAY_TYPE, StandardColors.I_TEMPLATE_ARRAY_ID).put(JSTypeNative.ITERATOR_TYPE, StandardColors.ITERATOR_ID).put(JSTypeNative.PROMISE_TYPE, StandardColors.PROMISE_ID).put(JSTypeNative.BIGINT_OBJECT_TYPE, StandardColors.BIGINT_OBJECT_ID).put(JSTypeNative.BOOLEAN_OBJECT_TYPE, StandardColors.BOOLEAN_OBJECT_ID).put(JSTypeNative.NUMBER_OBJECT_TYPE, StandardColors.NUMBER_OBJECT_ID).put(JSTypeNative.STRING_OBJECT_TYPE, StandardColors.STRING_OBJECT_ID).put(JSTypeNative.SYMBOL_OBJECT_TYPE, StandardColors.SYMBOL_OBJECT_ID).buildOrThrow();

    JSTypeColorIdHasher(JSTypeRegistry registry) {
    }

    ColorId hashObjectType(ObjectType type) {
        FunctionType fnType;
        Preconditions.checkState(type != null && !type.isEnumElementType() && !type.isNoResolvedType() && !type.isTemplatizedType() && !type.isUnknownType() && !type.isTemplateType(), type);
        ColorId boxId = this.standardColorObjectIds.get(type);
        if (boxId != null) {
            return boxId;
        }
        Hasher hasher = FARM_64.newHasher();
        if (type.isFunctionType() && (fnType = type.toMaybeFunctionType()).hasInstanceType()) {
            hasher.putInt(-1937018661);
        }
        if (type.hasReferenceName()) {
            this.putReferenceNameType(hasher, type);
        } else {
            for (String prop : type.getOwnPropertyNames()) {
                JSTypeColorIdHasher.putUtf8(hasher, prop);
            }
        }
        return ColorId.fromUnsigned(hasher.hash().asLong());
    }

    private void putReferenceNameType(Hasher hasher, ObjectType type) {
        JSTypeColorIdHasher.putUtf8(hasher, type.getReferenceName());
        JSType.WithSourceRef sourceRef = JSTypeColorIdHasher.sourceRefFor(type);
        if (sourceRef == null) {
            hasher.putInt(1712056194);
            return;
        }
        String moduleId = sourceRef.getGoogModuleId();
        if (moduleId == null) {
            hasher.putInt(630441471);
        } else {
            JSTypeColorIdHasher.putUtf8(hasher, moduleId);
        }
    }

    @Nullable
    private static JSType.WithSourceRef sourceRefFor(ObjectType type) {
        if (type.isEnumType()) {
            return type.toMaybeEnumType();
        }
        if (type.isEnumElementType()) {
            throw new AssertionError(type);
        }
        if (type.isFunctionType()) {
            return type.toMaybeFunctionType();
        }
        if (type.isFunctionPrototypeType()) {
            return type.getOwnerFunction();
        }
        if (type.getConstructor() != null) {
            return type.getConstructor();
        }
        return null;
    }

    private static void putUtf8(Hasher hasher, String s) {
        hasher.putString(s, StandardCharsets.UTF_8);
    }

    private static final class Marker {
        static final int HAS_INSTANCE_TYPE = -1937018661;
        static final int IS_PROTOTYPE_TYPE = 1284532309;
        static final int NO_GOOG_MODULE_ID = 630441471;
        static final int UNKNOWN_SOURCEREF = 1712056194;

        private Marker() {
        }
    }
}

