/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.ColorId;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.LinkedHashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.serialization.JSTypeColorIdHasher;
import com.google.javascript.jscomp.serialization.ObjectTypeProto;
import com.google.javascript.jscomp.serialization.SerializationOptions;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.SubtypingEdge;
import com.google.javascript.jscomp.serialization.TypePointers;
import com.google.javascript.jscomp.serialization.TypePool;
import com.google.javascript.jscomp.serialization.TypeProto;
import com.google.javascript.jscomp.serialization.UnionTypeProto;
import com.google.javascript.rhino.ClosurePrimitive;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

final class JSTypeReconserializer {
    private final JSTypeRegistry registry;
    private final SerializationOptions serializationMode;
    private final InvalidatingTypes invalidatingTypes;
    private final StringPool.Builder stringPoolBuilder;
    private final JSTypeColorIdHasher hasher;
    private final Predicate<String> shouldPropagatePropertyName;
    private final SeenTypeRecord unknownRecord;
    private final IdentityHashMap<JSType, SeenTypeRecord> typeToRecordCache = new IdentityHashMap();
    private final LinkedHashMap<ColorId, SeenTypeRecord> seenTypeRecords = new LinkedHashMap();
    private final SetMultimap<Integer, Integer> disambiguateEdges = LinkedHashMultimap.create();
    private State state = State.COLLECTING_TYPES;
    private static final ImmutableMap<JSTypeNative, Color> JSTYPE_NATIVE_TO_AXIOMATIC_COLOR_MAP = ImmutableMap.builder().put(JSTypeNative.ALL_TYPE, StandardColors.UNKNOWN).put(JSTypeNative.CHECKED_UNKNOWN_TYPE, StandardColors.UNKNOWN).put(JSTypeNative.NO_OBJECT_TYPE, StandardColors.UNKNOWN).put(JSTypeNative.NO_TYPE, StandardColors.UNKNOWN).put(JSTypeNative.UNKNOWN_TYPE, StandardColors.UNKNOWN).put(JSTypeNative.BIGINT_TYPE, StandardColors.BIGINT).put(JSTypeNative.BOOLEAN_TYPE, StandardColors.BOOLEAN).put(JSTypeNative.NULL_TYPE, StandardColors.NULL_OR_VOID).put(JSTypeNative.NUMBER_TYPE, StandardColors.NUMBER).put(JSTypeNative.STRING_TYPE, StandardColors.STRING).put(JSTypeNative.SYMBOL_TYPE, StandardColors.SYMBOL).put(JSTypeNative.VOID_TYPE, StandardColors.NULL_OR_VOID).put(JSTypeNative.FUNCTION_FUNCTION_TYPE, StandardColors.TOP_OBJECT).put(JSTypeNative.FUNCTION_PROTOTYPE, StandardColors.TOP_OBJECT).put(JSTypeNative.FUNCTION_TYPE, StandardColors.TOP_OBJECT).put(JSTypeNative.OBJECT_FUNCTION_TYPE, StandardColors.TOP_OBJECT).put(JSTypeNative.OBJECT_PROTOTYPE, StandardColors.TOP_OBJECT).put(JSTypeNative.OBJECT_TYPE, StandardColors.TOP_OBJECT).buildOrThrow();

    private JSTypeReconserializer(JSTypeRegistry registry, InvalidatingTypes invalidatingTypes, StringPool.Builder stringPoolBuilder, Predicate<String> shouldPropagatePropertyName, SerializationOptions serializationMode) {
        this.registry = registry;
        this.hasher = new JSTypeColorIdHasher(registry);
        this.invalidatingTypes = invalidatingTypes;
        this.stringPoolBuilder = stringPoolBuilder;
        this.shouldPropagatePropertyName = shouldPropagatePropertyName;
        this.serializationMode = serializationMode;
        this.seedCachesWithAxiomaticTypes();
        this.unknownRecord = this.seenTypeRecords.get(StandardColors.UNKNOWN.getId());
    }

    public static JSTypeReconserializer create(JSTypeRegistry registry, InvalidatingTypes invalidatingTypes, StringPool.Builder stringPoolBuilder, Predicate<String> shouldPropagatePropertyName, SerializationOptions serializationMode) {
        JSTypeReconserializer serializer = new JSTypeReconserializer(registry, invalidatingTypes, stringPoolBuilder, shouldPropagatePropertyName, serializationMode);
        serializer.checkValidLinearTime();
        return serializer;
    }

    int serializeType(JSType type) {
        SeenTypeRecord record = this.recordType(type);
        return record.pointer;
    }

    private SeenTypeRecord recordType(JSType type) {
        JSType forwardedType = type.isNamedType() ? type.toMaybeNamedType().getReferencedType() : (type.isEnumElementType() ? type.toMaybeEnumElementType().getPrimitiveType() : (type.isTemplatizedType() ? type.toMaybeTemplatizedType().getReferencedType() : (type.isFunctionType() && type.toMaybeFunctionType().getCanonicalRepresentation() != null ? type.toMaybeFunctionType().getCanonicalRepresentation() : null)));
        if (forwardedType != null) {
            return this.recordType(forwardedType);
        }
        if (type.isUnknownType() || type.isNoResolvedType() || type.isTemplateType()) {
            return this.unknownRecord;
        }
        SeenTypeRecord jstypeRecord = this.typeToRecordCache.get(type);
        if (jstypeRecord != null) {
            return jstypeRecord;
        }
        if (type.isUnionType()) {
            return this.recordUnionType(type.toMaybeUnionType());
        }
        if (type.isObjectType()) {
            return this.recordObjectType(type.toMaybeObjectType());
        }
        throw new AssertionError(type);
    }

    private SeenTypeRecord recordUnionType(UnionType type) {
        Preconditions.checkNotNull(type);
        LinkedHashSet<SeenTypeRecord> altRecords = new LinkedHashSet<SeenTypeRecord>();
        for (JSType jSType : type.getAlternates()) {
            SeenTypeRecord alt = this.recordType(jSType);
            if (alt.unionMembers == null) {
                altRecords.add(alt);
                continue;
            }
            altRecords.addAll(alt.unionMembers);
        }
        if (altRecords.size() == 1) {
            return (SeenTypeRecord)Iterables.getOnlyElement(altRecords);
        }
        ImmutableSet.Builder alternateIds = ImmutableSet.builder();
        for (SeenTypeRecord altRecord : altRecords) {
            alternateIds.add(altRecord.colorId);
        }
        ColorId colorId = ColorId.union((Set<ColorId>)((Object)alternateIds.build()));
        SeenTypeRecord record = this.getOrCreateRecord(colorId, type);
        if (record.unionMembers == null) {
            record.unionMembers = ImmutableSet.copyOf(altRecords);
        } else if (this.serializationMode.runValidation()) {
            Preconditions.checkState(altRecords.equals(record.unionMembers), "Unions with same ID must have same members: %s => %s == %s", (Object)colorId, altRecords.stream().map(r -> r.colorId).collect(ImmutableSet.toImmutableSet()), record.unionMembers.stream().map(r -> r.colorId).collect(ImmutableSet.toImmutableSet()));
        }
        return record;
    }

    private SeenTypeRecord recordObjectType(ObjectType type) {
        FunctionType fnType;
        Preconditions.checkNotNull(type);
        ColorId id = this.hasher.hashObjectType(type);
        SeenTypeRecord record = this.getOrCreateRecord(id, type);
        this.addSupertypeEdges(type, record.pointer);
        if (type.isFunctionType() && (fnType = type.toMaybeFunctionType()).hasInstanceType() && fnType.getInstanceType() != null) {
            this.serializeType(fnType.getInstanceType());
            this.serializeType(fnType.getPrototype());
        }
        return record;
    }

    private void addSupertypeEdges(ObjectType subtype, Integer serializedSubtype) {
        this.disambiguateEdges.putAll(serializedSubtype, this.ownAncestorInterfacesOf(subtype));
        if (subtype.getImplicitPrototype() != null) {
            Integer supertype = this.serializeType(subtype.getImplicitPrototype());
            this.disambiguateEdges.put(serializedSubtype, supertype);
        }
    }

    private SeenTypeRecord getOrCreateRecord(ColorId id, JSType jstype) {
        Preconditions.checkNotNull(jstype);
        Preconditions.checkState(State.COLLECTING_TYPES == this.state || State.GENERATING_POOL == this.state);
        SeenTypeRecord record = this.seenTypeRecords.computeIfAbsent(id, unused -> {
            int pointer = this.seenTypeRecords.size();
            return new SeenTypeRecord(id, pointer);
        });
        this.typeToRecordCache.put(jstype, record);
        record.jstypes.add(jstype);
        return record;
    }

    private TypeProto reconcileUnionTypes(SeenTypeRecord seen) {
        return TypeProto.newBuilder().setUnion(UnionTypeProto.newBuilder().addAllUnionMember(seen.unionMembers.stream().map(r -> r.pointer).sorted().collect(ImmutableList.toImmutableList())).build()).build();
    }

    private TypeProto reconcileObjectTypes(SeenTypeRecord seen) {
        TreeSet<String> debugTypenames = new TreeSet<String>();
        LinkedHashSet<Integer> instancePointers = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> prototypePointers = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> ownProperties = new LinkedHashSet<Integer>();
        boolean isClosureAssert = false;
        boolean isConstructor = false;
        boolean isInvalidating = false;
        boolean propertiesKeepOriginalName = false;
        for (JSType type : seen.jstypes) {
            ObjectType objType = Preconditions.checkNotNull(type.toMaybeObjectType(), type);
            if (this.serializationMode.includeDebugInfo()) {
                debugTypenames.add(JSTypeReconserializer.debugNameOf(type));
            }
            if (objType.isFunctionType()) {
                FunctionType fnType = objType.toMaybeFunctionType();
                if (fnType.hasInstanceType() && fnType.getInstanceType() != null) {
                    instancePointers.add(this.serializeType(fnType.getInstanceType()));
                    prototypePointers.add(this.serializeType(fnType.getPrototype()));
                    isConstructor |= fnType.isConstructor();
                }
                isClosureAssert |= JSTypeReconserializer.isClosureAssert(fnType.getClosurePrimitive());
            }
            for (String ownProperty : objType.getOwnPropertyNames()) {
                if (!this.shouldPropagatePropertyName.test(ownProperty)) continue;
                ownProperties.add(this.stringPoolBuilder.put(ownProperty));
            }
            isInvalidating |= this.invalidatingTypes.isInvalidating(objType);
            propertiesKeepOriginalName |= objType.isEnumType();
        }
        ObjectTypeProto.Builder objectProto = ObjectTypeProto.newBuilder().addAllInstanceType(instancePointers).addAllOwnProperty(ownProperties).addAllPrototype(prototypePointers).setClosureAssert(isClosureAssert).setIsInvalidating(isInvalidating).setMarkedConstructor(isConstructor).setPropertiesKeepOriginalName(propertiesKeepOriginalName).setUuid(seen.colorId.asByteString());
        if (!debugTypenames.isEmpty()) {
            objectProto.getDebugInfoBuilder().addAllTypename(debugTypenames);
        }
        return TypeProto.newBuilder().setObject(objectProto).build();
    }

    private ImmutableList<Integer> ownAncestorInterfacesOf(ObjectType type) {
        FunctionType ctorType = type.getConstructor();
        if (ctorType == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder ancestors = ImmutableList.builder();
        for (JSType jSType : Iterables.concat(ctorType.getExtendedInterfaces(), ctorType.getOwnImplementedInterfaces())) {
            ancestors.add((Object)this.serializeType(jSType));
        }
        return ancestors.build();
    }

    private void seedCachesWithAxiomaticTypes() {
        Preconditions.checkState(this.seenTypeRecords.isEmpty());
        for (Color axiomatic2 : TypePointers.OFFSET_TO_AXIOMATIC_COLOR) {
            int index = this.seenTypeRecords.size();
            SeenTypeRecord record = new SeenTypeRecord(axiomatic2.getId(), index);
            this.seenTypeRecords.put(axiomatic2.getId(), record);
        }
        JSTYPE_NATIVE_TO_AXIOMATIC_COLOR_MAP.forEach((jstypeNative, axiomatic) -> this.getOrCreateRecord(axiomatic.getId(), this.registry.getNativeType((JSTypeNative)((Object)jstypeNative))));
        Preconditions.checkState(this.seenTypeRecords.size() == TypePointers.OFFSET_TO_AXIOMATIC_COLOR.size());
    }

    private void checkValidLinearTime() {
        if (!this.serializationMode.runValidation()) {
            return;
        }
        int totalTypeCount = this.seenTypeRecords.size();
        for (SeenTypeRecord seen : this.seenTypeRecords.values()) {
            int offset = seen.pointer;
            Preconditions.checkState(offset >= 0);
            Preconditions.checkState(offset <= totalTypeCount, "Found invalid pointer %s, out of a total of %s user-defined types", offset, totalTypeCount);
        }
    }

    TypePool generateTypePool() {
        Preconditions.checkState(this.state == State.COLLECTING_TYPES);
        this.checkValidLinearTime();
        TypePool.Builder builder = TypePool.newBuilder();
        if (this.serializationMode.includeDebugInfo()) {
            TypePool.DebugInfo.Builder debugInfo = builder.getDebugInfoBuilder();
            this.invalidatingTypes.getMismatchLocations().inverse().asMap().forEach((location, types) -> debugInfo.addMismatchBuilder().setSourceRef(location.getLocation()).addAllInvolvedColor(types.stream().peek(t -> Preconditions.checkState(!t.isUnionType(), t)).map(this::serializeType).distinct().sorted().collect(ImmutableList.toImmutableList())));
        }
        this.state = State.GENERATING_POOL;
        for (SeenTypeRecord seen : this.seenTypeRecords.values()) {
            if (StandardColors.AXIOMATIC_COLORS.containsKey(seen.colorId)) {
                Preconditions.checkState(TypePointers.isAxiomatic(seen.pointer), "Missing .type for SeenTypeRecord %s", (Object)seen);
                continue;
            }
            builder.addType(seen.unionMembers != null ? this.reconcileUnionTypes(seen) : this.reconcileObjectTypes(seen));
        }
        for (Integer subtype : this.disambiguateEdges.keySet()) {
            for (Integer supertype : this.disambiguateEdges.get((Object)subtype)) {
                builder.addDisambiguationEdges(SubtypingEdge.newBuilder().setSubtype(subtype).setSupertype(supertype));
            }
        }
        this.state = State.FINISHED;
        this.checkValidLinearTime();
        return builder.build();
    }

    ImmutableMultimap<String, String> getColorIdToJSTypeMapForDebugging() {
        ImmutableMultimap.Builder colorIdToTypes = ImmutableMultimap.builder().orderKeysBy(Comparator.naturalOrder()).orderValuesBy(Comparator.naturalOrder());
        this.typeToRecordCache.forEach((jstype, record) -> colorIdToTypes.put(record.colorId.toString(), jstype.toString()));
        return colorIdToTypes.build();
    }

    private static boolean isClosureAssert(@Nullable ClosurePrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        switch (primitive) {
            case ASSERTS_TRUTHY: 
            case ASSERTS_MATCHES_RETURN: {
                return true;
            }
            case ASSERTS_FAIL: {
                return false;
            }
        }
        throw new AssertionError();
    }

    private static String debugNameOf(JSType type) {
        ObjectType oType = type.toMaybeObjectType();
        if (oType == null) {
            return type.toString();
        }
        String className = oType.getReferenceName();
        if (oType.isFunctionType()) {
            FunctionType fnType = oType.toMaybeFunctionType();
            Node source = fnType.getSource();
            if (fnType.hasInstanceType() && source != null) {
                className = "(typeof " + className + ")";
            }
        }
        return className == null ? type.toString() : className;
    }

    private static final class SeenTypeRecord {
        final ColorId colorId;
        final int pointer;
        final ArrayList<JSType> jstypes = new ArrayList();
        @Nullable
        ImmutableSet<SeenTypeRecord> unionMembers = null;

        SeenTypeRecord(ColorId colorId, int pointer) {
            this.colorId = colorId;
            this.pointer = pointer;
        }
    }

    private static enum State {
        COLLECTING_TYPES,
        GENERATING_POOL,
        FINISHED;

    }
}

