/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;

final class TypePointers {
    static final ImmutableList<Color> OFFSET_TO_AXIOMATIC_COLOR = ImmutableList.of(StandardColors.UNKNOWN, StandardColors.BOOLEAN, StandardColors.STRING, StandardColors.NUMBER, StandardColors.NULL_OR_VOID, StandardColors.SYMBOL, StandardColors.BIGINT, StandardColors.TOP_OBJECT);
    static final int AXIOMATIC_COLOR_COUNT = OFFSET_TO_AXIOMATIC_COLOR.size();

    static int trimOffset(int x) {
        Preconditions.checkState(x >= AXIOMATIC_COLOR_COUNT, x);
        return x - AXIOMATIC_COLOR_COUNT;
    }

    static int untrimOffset(int x) {
        Preconditions.checkState(x >= 0, x);
        return x + AXIOMATIC_COLOR_COUNT;
    }

    static boolean isAxiomatic(int x) {
        return x < AXIOMATIC_COLOR_COUNT;
    }

    private TypePointers() {
        throw new AssertionError();
    }
}

