/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Optional;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableCollection;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.protobuf.CodedInputStream;
import com.google.javascript.jscomp.jarjar.com.google.protobuf.ExtensionRegistry;
import com.google.javascript.jscomp.jarjar.com.google.protobuf.ExtensionRegistryLite;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.serialization.AutoValue_TypedAstDeserializer_DeserializedAst;
import com.google.javascript.jscomp.serialization.ColorPool;
import com.google.javascript.jscomp.serialization.LazyAst;
import com.google.javascript.jscomp.serialization.ScriptNodeDeserializer;
import com.google.javascript.jscomp.serialization.SourceFileProto;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.TypedAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

@GwtIncompatible(value="protobuf.lite")
public final class TypedAstDeserializer {
    private final Mode mode;
    private final SourceFile syntheticExterns;
    private final Optional<ColorPool.Builder> colorPoolBuilder;
    private final LinkedHashMap<String, SourceFile> filePoolBuilder = new LinkedHashMap();
    private final LinkedHashMap<SourceFile, Supplier<Node>> typedAstFilesystem = new LinkedHashMap();
    private final ImmutableSet.Builder<String> externProperties = ImmutableSet.builder();
    private final ArrayList<ScriptNodeDeserializer> syntheticExternsDeserializers = new ArrayList();

    private TypedAstDeserializer(SourceFile syntheticExterns, Optional<ColorPool.Builder> existingColorPool, Mode mode, boolean includeTypeInformation) {
        this.syntheticExterns = syntheticExterns;
        this.mode = mode;
        this.colorPoolBuilder = includeTypeInformation ? Optional.of(existingColorPool.or(ColorPool.builder())) : Optional.absent();
    }

    public static DeserializedAst deserializeFullAst(AbstractCompiler compiler, SourceFile syntheticExterns, ImmutableList<SourceFile> existingSourceFiles, InputStream typedAstsStream, boolean includeTypeInformation) {
        ImmutableMap<String, SourceFile> sourceFilesByName = existingSourceFiles.stream().collect(ImmutableMap.toImmutableMap(SourceFile::getName, Function.identity()));
        return TypedAstDeserializer.deserialize(compiler, syntheticExterns, sourceFilesByName, Optional.absent(), typedAstsStream, Mode.FULL_AST, includeTypeInformation);
    }

    public static DeserializedAst deserializeRuntimeLibraries(AbstractCompiler compiler, SourceFile syntheticExterns, Optional<ColorPool.Builder> colorPool, InputStream typedAstsStream) {
        return TypedAstDeserializer.deserialize(compiler, syntheticExterns, ImmutableMap.of(), colorPool, typedAstsStream, Mode.RUNTIME_LIBRARY_ONLY, colorPool.isPresent());
    }

    private static DeserializedAst deserialize(AbstractCompiler compiler, SourceFile syntheticExterns, ImmutableMap<String, SourceFile> scriptSourceFiles, Optional<ColorPool.Builder> colorPool, InputStream typedAstStream, Mode mode, boolean includeTypeInformation) {
        Preconditions.checkArgument(colorPool.isPresent() == (mode.equals((Object)Mode.RUNTIME_LIBRARY_ONLY) && includeTypeInformation), "ColorPool.Builder required iff deserializing runtime libraries & including types");
        List<TypedAst> typedAstProtos = TypedAstDeserializer.deserializeTypedAsts(typedAstStream);
        TypedAstDeserializer deserializer = new TypedAstDeserializer(syntheticExterns, colorPool, mode, includeTypeInformation);
        deserializer.filePoolBuilder.put(syntheticExterns.getName(), syntheticExterns);
        deserializer.filePoolBuilder.putAll(scriptSourceFiles);
        if (!mode.equals((Object)Mode.RUNTIME_LIBRARY_ONLY)) {
            compiler.initRuntimeLibraryTypedAsts(deserializer.colorPoolBuilder);
        }
        for (TypedAst typedAstProto : typedAstProtos) {
            deserializer.deserializeSingleTypedAst(typedAstProto);
        }
        deserializer.typedAstFilesystem.put(syntheticExterns, () -> {
            Node script = IR.script();
            script.setStaticSourceFile(syntheticExterns);
            for (ScriptNodeDeserializer d : deserializer.syntheticExternsDeserializers) {
                script.addChildrenToBack(d.deserializeNew().removeChildren());
            }
            return script;
        });
        return deserializer.toDeserializedAst();
    }

    private DeserializedAst toDeserializedAst() {
        Optional registry = this.mode.equals((Object)Mode.RUNTIME_LIBRARY_ONLY) || !this.colorPoolBuilder.isPresent() ? Optional.absent() : Optional.of(this.colorPoolBuilder.get().build().getRegistry());
        return DeserializedAst.create(ImmutableMap.copyOf(this.typedAstFilesystem), registry, (ImmutableSet)this.externProperties.build());
    }

    private void deserializeSingleTypedAst(TypedAst typedAstProto) {
        ImmutableList.Builder fileShardBuilder = ImmutableList.builder();
        StringPool stringShard = StringPool.fromProto(typedAstProto.getStringPool());
        Optional<ColorPool.ShardView> colorShard = this.colorPoolBuilder.transform(builder -> builder.addShard(typedAstProto.getTypePool(), stringShard));
        for (SourceFileProto p : typedAstProto.getSourceFilePool().getSourceFileList()) {
            fileShardBuilder.add(this.filePoolBuilder.computeIfAbsent(p.getFilename(), n -> SourceFile.fromProto(p)));
        }
        ImmutableCollection fileShard = fileShardBuilder.build();
        Iterator<Serializable> iterator = typedAstProto.getExternsSummary().getPropNamePtrList().iterator();
        while (iterator.hasNext()) {
            int x = iterator.next();
            this.externProperties.add((Object)stringShard.get(x));
        }
        for (LazyAst lazyAst : Iterables.concat(typedAstProto.getExternAstList(), typedAstProto.getCodeAstList())) {
            this.initLazyAstDeserializer(lazyAst, (ImmutableList<SourceFile>)fileShard, colorShard, stringShard);
        }
    }

    private void initLazyAstDeserializer(LazyAst lazyAst, ImmutableList<SourceFile> fileShard, Optional<ColorPool.ShardView> colorShard, StringPool stringShard) {
        SourceFile file = (SourceFile)fileShard.get(lazyAst.getSourceFile() - 1);
        ScriptNodeDeserializer deserializer = new ScriptNodeDeserializer(lazyAst, stringShard, colorShard, fileShard);
        if (JSCompObjects.identical(this.syntheticExterns, file)) {
            this.syntheticExternsDeserializers.add(deserializer);
        } else {
            this.typedAstFilesystem.computeIfAbsent(file, f -> deserializer::deserializeNew);
        }
    }

    @GwtIncompatible(value="ObjectInputStream")
    private static List<TypedAst> deserializeTypedAsts(InputStream typedAstsStream) {
        try {
            CodedInputStream codedInput = CodedInputStream.newInstance(typedAstsStream);
            return TypedAst.List.parseFrom(codedInput, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry()).getTypedAstsList();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot read from TypedAST input stream", ex);
        }
    }

    @AutoValue
    public static abstract class DeserializedAst {
        public abstract ImmutableMap<SourceFile, Supplier<Node>> getFilesystem();

        public abstract Optional<ColorRegistry> getColorRegistry();

        @Nullable
        public abstract ImmutableSet<String> getExternProperties();

        private static DeserializedAst create(ImmutableMap<SourceFile, Supplier<Node>> filesystem, Optional<ColorRegistry> colorRegistry, ImmutableSet<String> externProperties) {
            return new AutoValue_TypedAstDeserializer_DeserializedAst(filesystem, colorRegistry, externProperties);
        }
    }

    private static enum Mode {
        RUNTIME_LIBRARY_ONLY,
        FULL_AST;

    }
}

