/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.NoAllocation;
import com.google.javascript.jscomp.jarjar.com.google.protobuf.ByteString;

final class Wtf8 {
    private static final byte CONTINUATION_MASK = 63;

    private Wtf8() {
    }

    static ByteString encodeToWtf8(String s) {
        int length = s.length();
        ByteString.Output output = ByteString.newOutput(length);
        for (int i = 0; i < length; ++i) {
            int codepoint = s.codePointAt(i);
            if (codepoint < 128) {
                output.write(codepoint);
                continue;
            }
            if (codepoint < 2048) {
                output.write(0xC0 | 0x1F & codepoint >>> 6);
                output.write(0x80 | 0x3F & codepoint);
                continue;
            }
            if (codepoint < 65536) {
                output.write(0xE0 | 0xF & codepoint >>> 12);
                output.write(0x80 | 0x3F & codepoint >>> 6);
                output.write(0x80 | 0x3F & codepoint);
                continue;
            }
            ++i;
            output.write(0xF0 | 7 & codepoint >>> 18);
            output.write(0x80 | 0x3F & codepoint >>> 12);
            output.write(0x80 | 0x3F & codepoint >>> 6);
            output.write(0x80 | 0x3F & codepoint);
        }
        return output.toByteString();
    }

    static Decoder decoder(int maxLength) {
        return new Decoder(maxLength);
    }

    static class Decoder {
        private final int[] codepointBuffer;

        private Decoder(int maxLength) {
            this.codepointBuffer = new int[maxLength];
        }

        @NoAllocation
        String decode(ByteString encoded) {
            int encodedByteCount = encoded.size();
            int codepointCount = 0;
            for (int i = 0; i < encodedByteCount; ++i) {
                int thirdByte;
                int secondByte;
                int firstByte;
                int codepoint;
                int b = encoded.byteAt(i);
                if ((b & 0x80) == 0) {
                    codepoint = b;
                } else if ((b & 0xE0) == 192) {
                    firstByte = 0x1F & b;
                    secondByte = encoded.byteAt(++i) & 0x3F;
                    codepoint = firstByte << 6 | secondByte;
                } else if ((b & 0xF0) == 224) {
                    firstByte = 0xF & b;
                    secondByte = encoded.byteAt(++i) & 0x3F;
                    thirdByte = encoded.byteAt(++i) & 0x3F;
                    codepoint = firstByte << 12 | secondByte << 6 | thirdByte;
                } else if ((b & 0xF8) == 240) {
                    firstByte = 7 & b;
                    secondByte = encoded.byteAt(++i) & 0x3F;
                    thirdByte = encoded.byteAt(++i) & 0x3F;
                    int fourthByte = encoded.byteAt(++i) & 0x3F;
                    codepoint = firstByte << 18 | secondByte << 12 | thirdByte << 6 | fourthByte;
                } else {
                    throw new AssertionError();
                }
                this.codepointBuffer[codepointCount++] = codepoint;
            }
            return new String(this.codepointBuffer, 0, codepointCount);
        }
    }
}

