/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Joiner;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.HashMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Multimaps;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Streams;
import com.google.javascript.jscomp.jarjar.com.google.common.io.FileWriteMode;
import com.google.javascript.jscomp.jarjar.com.google.common.io.Files;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public final class ApplySuggestedFixes {
    private static final Joiner DOUBLE_LINE_JOINER = Joiner.on("\n\n");

    public static void applySuggestedFixesToFiles(Iterable<SuggestedFix> fixes) throws IOException {
        HashSet filenames = new HashSet();
        for (SuggestedFix suggestedFix : fixes) {
            filenames.addAll(suggestedFix.getReplacements().keySet());
        }
        HashMap<String, String> filenameToCodeMap = new HashMap<String, String>();
        for (String filename : filenames) {
            filenameToCodeMap.put(filename, Files.asCharSource(new File(filename), StandardCharsets.UTF_8).read());
        }
        ImmutableMap<String, String> immutableMap = ApplySuggestedFixes.applySuggestedFixesToCode(fixes, filenameToCodeMap);
        for (Map.Entry entry : immutableMap.entrySet()) {
            Files.asCharSink(new File((String)entry.getKey()), StandardCharsets.UTF_8, new FileWriteMode[0]).write((CharSequence)entry.getValue());
        }
    }

    public static ImmutableList<ImmutableMap<String, String>> applyAllSuggestedFixChoicesToCode(Iterable<SuggestedFix> fixChoices, Map<String, String> fileNameToCodeMap) {
        if (Iterables.isEmpty(fixChoices)) {
            return ImmutableList.of(ImmutableMap.of());
        }
        int alternativeCount = ((SuggestedFix)Iterables.getFirst(fixChoices, null)).getAlternatives().size();
        Preconditions.checkArgument(Streams.stream(fixChoices).map(f -> f.getAlternatives().size()).allMatch(Predicate.isEqual(alternativeCount)), "All SuggestedFixAlternatives must offer an equal number of choices for this utility to make sense");
        return IntStream.range(0, alternativeCount).mapToObj(i -> ApplySuggestedFixes.applySuggestedFixChoicesToCode(fixChoices, i, fileNameToCodeMap)).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableMap<String, String> applySuggestedFixChoicesToCode(Iterable<SuggestedFix> fixChoices, int choiceIndex, Map<String, String> fileNameToCodeMap) {
        ImmutableList<SuggestedFix> chosenFixes = Streams.stream(fixChoices).map(choices -> (SuggestedFix)choices.getAlternatives().get(choiceIndex)).collect(ImmutableList.toImmutableList());
        return ApplySuggestedFixes.applySuggestedFixesToCode(chosenFixes, fileNameToCodeMap);
    }

    public static ImmutableMap<String, String> applySuggestedFixesToCode(Iterable<SuggestedFix> fixes, Map<String, String> filenameToCodeMap) {
        ReplacementMap map = new ReplacementMap();
        for (SuggestedFix fix : fixes) {
            map.putIfNoOverlap(fix);
        }
        ImmutableMap.Builder<String, String> newCodeMap = ImmutableMap.builder();
        for (Map.Entry<String, Set<CodeReplacement>> entry : map.entrySet()) {
            String filename = entry.getKey();
            if (!filenameToCodeMap.containsKey(filename)) {
                throw new IllegalArgumentException("filenameToCodeMap missing code for file: " + filename);
            }
            Set<CodeReplacement> replacements = entry.getValue();
            String newCode = ApplySuggestedFixes.applyCodeReplacements(replacements, filenameToCodeMap.get(filename));
            newCodeMap.put(filename, newCode);
        }
        return newCodeMap.buildOrThrow();
    }

    public static String applyCodeReplacements(Collection<CodeReplacement> replacements, String code) {
        ImmutableSortedSet<CodeReplacement> sortedReplacements = ImmutableSortedSet.copyOf(replacements);
        Preconditions.checkArgument(!ApplySuggestedFixes.containsOverlaps(sortedReplacements), "Found overlap between code replacements:\n%s", (Object)DOUBLE_LINE_JOINER.join(sortedReplacements));
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        for (CodeReplacement replacement : sortedReplacements) {
            sb.append(code, lastIndex, replacement.getStartPosition());
            sb.append(replacement.getNewContent());
            lastIndex = replacement.getEndPosition();
        }
        if (lastIndex <= code.length()) {
            sb.append(code, lastIndex, code.length());
        }
        return sb.toString();
    }

    private static boolean containsOverlaps(ImmutableSortedSet<CodeReplacement> replacements) {
        int start = -1;
        for (CodeReplacement replacement : replacements) {
            if (replacement.getStartPosition() < start) {
                return true;
            }
            start = replacement.getEndPosition();
        }
        return false;
    }

    private ApplySuggestedFixes() {
    }

    private static class ReplacementMap {
        private final SetMultimap<String, CodeReplacement> map = HashMultimap.create();

        private ReplacementMap() {
        }

        void putIfNoOverlap(SuggestedFix fix) {
            if (this.canPut(fix)) {
                this.map.putAll(fix.getReplacements());
            }
        }

        private boolean canPut(SuggestedFix fix) {
            for (String filename : fix.getReplacements().keySet()) {
                ImmutableSet replacements = ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.naturalOrder().addAll((Iterable)this.map.get((Object)filename))).addAll((Iterable)fix.getReplacements().get((Object)filename))).build();
                if (!ApplySuggestedFixes.containsOverlaps((ImmutableSortedSet)replacements)) continue;
                return false;
            }
            return true;
        }

        Set<Map.Entry<String, Set<CodeReplacement>>> entrySet() {
            return Multimaps.asMap(this.map).entrySet();
        }
    }
}

