/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.jscomp.base.JSCompDoubles;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class IR {
    private IR() {
    }

    public static Node empty() {
        return new Node(Token.EMPTY);
    }

    public static Node export(Node declaration) {
        return new Node(Token.EXPORT, declaration);
    }

    public static Node importNode(Node name, Node importSpecs, Node moduleIdentifier) {
        Preconditions.checkState(name.isName() || name.isEmpty(), name);
        Preconditions.checkState(importSpecs.isImportSpec() || importSpecs.isImportStar() || importSpecs.isEmpty(), importSpecs);
        Preconditions.checkState(moduleIdentifier.isStringLit(), moduleIdentifier);
        return new Node(Token.IMPORT, name, importSpecs, moduleIdentifier);
    }

    public static Node importStar(String name) {
        return Node.newString(Token.IMPORT_STAR, name);
    }

    public static Node function(Node name, Node params, Node body) {
        Preconditions.checkState(name.isName());
        Preconditions.checkState(params.isParamList());
        Preconditions.checkState(body.isBlock());
        return new Node(Token.FUNCTION, name, params, body);
    }

    public static Node arrowFunction(Node name, Node params, Node body) {
        Preconditions.checkState(name.isName());
        Preconditions.checkState(params.isParamList());
        Preconditions.checkState(body.isBlock() || IR.mayBeExpression(body));
        Node func = new Node(Token.FUNCTION, name, params, body);
        func.setIsArrowFunction(true);
        return func;
    }

    public static Node paramList(Node ... params) {
        Node paramList = new Node(Token.PARAM_LIST);
        for (Node param : params) {
            Preconditions.checkState(param.isName() || param.isRest() || param.isDefaultValue());
            paramList.addChildToBack(param);
        }
        return paramList;
    }

    public static Node root(Node ... rootChildren) {
        Node root = new Node(Token.ROOT);
        for (Node child : rootChildren) {
            Preconditions.checkState(child.getToken() == Token.ROOT || child.getToken() == Token.SCRIPT);
            root.addChildToBack(child);
        }
        return root;
    }

    public static Node block() {
        Node block = new Node(Token.BLOCK);
        return block;
    }

    public static Node block(Node stmt) {
        Preconditions.checkState(IR.mayBeStatement(stmt), "Block node cannot contain %s", (Object)stmt.getToken());
        Node block = new Node(Token.BLOCK, stmt);
        return block;
    }

    public static Node block(Node ... stmts) {
        Node block = IR.block();
        for (Node stmt : stmts) {
            Preconditions.checkState(IR.mayBeStatement(stmt));
            block.addChildToBack(stmt);
        }
        return block;
    }

    public static Node block(List<Node> stmts) {
        Node paramList = IR.block();
        for (Node stmt : stmts) {
            Preconditions.checkState(IR.mayBeStatement(stmt));
            paramList.addChildToBack(stmt);
        }
        return paramList;
    }

    private static Node blockUnchecked(Node stmt) {
        return new Node(Token.BLOCK, stmt);
    }

    public static Node script() {
        Node block = new Node(Token.SCRIPT);
        return block;
    }

    public static Node script(Node ... stmts) {
        Node block = IR.script();
        for (Node stmt : stmts) {
            Preconditions.checkState(IR.mayBeStatementNoReturn(stmt));
            block.addChildToBack(stmt);
        }
        return block;
    }

    public static Node script(List<Node> stmts) {
        Node paramList = IR.script();
        for (Node stmt : stmts) {
            Preconditions.checkState(IR.mayBeStatementNoReturn(stmt));
            paramList.addChildToBack(stmt);
        }
        return paramList;
    }

    public static Node var(Node lhs, Node value) {
        return IR.declaration(lhs, value, Token.VAR);
    }

    public static Node var(Node lhs) {
        return IR.declaration(lhs, Token.VAR);
    }

    public static Node let(Node lhs, Node value) {
        return IR.declaration(lhs, value, Token.LET);
    }

    public static Node let(Node lhs) {
        return IR.declaration(lhs, Token.LET);
    }

    public static Node constNode(Node lhs, Node value) {
        return IR.declaration(lhs, value, Token.CONST);
    }

    public static Node declaration(Node lhs, Token type) {
        Preconditions.checkState(lhs.isName() || lhs.isDestructuringPattern() || lhs.isDestructuringLhs(), lhs);
        if (lhs.isDestructuringPattern()) {
            lhs = new Node(Token.DESTRUCTURING_LHS, lhs);
        }
        return new Node(type, lhs);
    }

    public static Node declaration(Node lhs, Node value, Token type) {
        if (lhs.isName()) {
            Preconditions.checkState(!lhs.hasChildren());
        } else {
            Preconditions.checkState(lhs.isArrayPattern() || lhs.isObjectPattern());
            lhs = new Node(Token.DESTRUCTURING_LHS, lhs);
        }
        Preconditions.checkState(IR.mayBeExpression(value), "%s can't be an expression", (Object)value);
        lhs.addChildToBack(value);
        return new Node(type, lhs);
    }

    public static Node returnNode() {
        return new Node(Token.RETURN);
    }

    public static Node returnNode(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(Token.RETURN, expr);
    }

    public static Node yield() {
        return new Node(Token.YIELD);
    }

    public static Node yield(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(Token.YIELD, expr);
    }

    public static Node await(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(Token.AWAIT, expr);
    }

    public static Node throwNode(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(Token.THROW, expr);
    }

    public static Node exprResult(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr), expr);
        return new Node(Token.EXPR_RESULT, expr);
    }

    public static Node ifNode(Node cond, Node then) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(then.isBlock());
        return new Node(Token.IF, cond, then);
    }

    public static Node ifNode(Node cond, Node then, Node elseNode) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(then.isBlock());
        Preconditions.checkState(elseNode.isBlock());
        return new Node(Token.IF, cond, then, elseNode);
    }

    public static Node doNode(Node body, Node cond) {
        Preconditions.checkState(body.isBlock());
        Preconditions.checkState(IR.mayBeExpression(cond));
        return new Node(Token.DO, body, cond);
    }

    public static Node whileNode(Node cond, Node body) {
        Preconditions.checkState(body.isBlock());
        Preconditions.checkState(IR.mayBeExpression(cond));
        return new Node(Token.WHILE, cond, body);
    }

    public static Node forIn(Node target, Node cond, Node body) {
        Preconditions.checkState(target.isVar() || IR.mayBeExpression(target));
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(body.isBlock());
        return new Node(Token.FOR_IN, target, cond, body);
    }

    public static Node forNode(Node init, Node cond, Node incr, Node body) {
        Preconditions.checkState(init.isVar() || init.isLet() || init.isConst() || IR.mayBeExpressionOrEmpty(init));
        Preconditions.checkState(IR.mayBeExpressionOrEmpty(cond));
        Preconditions.checkState(IR.mayBeExpressionOrEmpty(incr));
        Preconditions.checkState(body.isBlock());
        Node r = new Node(Token.FOR, init, cond, incr);
        r.addChildToBack(body);
        return r;
    }

    public static Node switchNode(Node cond, Node ... cases) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Node switchNode = new Node(Token.SWITCH, cond);
        for (Node caseNode : cases) {
            Preconditions.checkState(caseNode.isCase() || caseNode.isDefaultCase());
            switchNode.addChildToBack(caseNode);
        }
        return switchNode;
    }

    public static Node caseNode(Node expr, Node body) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        Preconditions.checkState(body.isBlock());
        body.setIsAddedBlock(true);
        return new Node(Token.CASE, expr, body);
    }

    public static Node defaultCase(Node body) {
        Preconditions.checkState(body.isBlock());
        body.setIsAddedBlock(true);
        return new Node(Token.DEFAULT_CASE, body);
    }

    public static Node label(Node name, Node stmt) {
        Preconditions.checkState(name.isLabelName());
        Preconditions.checkState(IR.mayBeStatement(stmt));
        Node block = new Node(Token.LABEL, name, stmt);
        return block;
    }

    public static Node labelName(String name) {
        Preconditions.checkState(!name.isEmpty());
        return Node.newString(Token.LABEL_NAME, name);
    }

    public static Node tryFinally(Node tryBody, Node finallyBody) {
        Preconditions.checkState(tryBody.isBlock());
        Preconditions.checkState(finallyBody.isBlock());
        Node catchBody = IR.block().srcrefIfMissing(tryBody);
        return new Node(Token.TRY, tryBody, catchBody, finallyBody);
    }

    public static Node tryCatch(Node tryBody, Node catchNode) {
        Preconditions.checkState(tryBody.isBlock());
        Preconditions.checkState(catchNode.isCatch());
        Node catchBody = IR.blockUnchecked(catchNode).srcrefIfMissing(catchNode);
        return new Node(Token.TRY, tryBody, catchBody);
    }

    public static Node tryCatchFinally(Node tryBody, Node catchNode, Node finallyBody) {
        Preconditions.checkState(finallyBody.isBlock());
        Node tryNode = IR.tryCatch(tryBody, catchNode);
        tryNode.addChildToBack(finallyBody);
        return tryNode;
    }

    public static Node catchNode(Node expr, Node body) {
        Preconditions.checkState(expr.isName());
        Preconditions.checkState(body.isBlock());
        return new Node(Token.CATCH, expr, body);
    }

    public static Node breakNode() {
        return new Node(Token.BREAK);
    }

    public static Node breakNode(Node name) {
        Preconditions.checkState(name.isLabelName());
        return new Node(Token.BREAK, name);
    }

    public static Node continueNode() {
        return new Node(Token.CONTINUE);
    }

    public static Node continueNode(Node name) {
        Preconditions.checkState(name.isLabelName());
        return new Node(Token.CONTINUE, name);
    }

    public static Node call(Node target, Node ... args) {
        Node call = new Node(Token.CALL, target);
        for (Node arg : args) {
            Preconditions.checkState(IR.mayBeExpression(arg) || arg.isSpread(), arg);
            call.addChildToBack(arg);
        }
        return call;
    }

    public static Node startOptChainCall(Node target, Node ... args) {
        Node call = new Node(Token.OPTCHAIN_CALL, target);
        for (Node arg : args) {
            Preconditions.checkState(IR.mayBeExpression(arg) || arg.isSpread(), arg);
            call.addChildToBack(arg);
        }
        call.setIsOptionalChainStart(true);
        return call;
    }

    public static Node continueOptChainCall(Node target, Node ... args) {
        Node call = new Node(Token.OPTCHAIN_CALL, target);
        for (Node arg : args) {
            Preconditions.checkState(IR.mayBeExpression(arg) || arg.isSpread(), arg);
            call.addChildToBack(arg);
        }
        call.setIsOptionalChainStart(false);
        return call;
    }

    public static Node newNode(Node target, Node ... args) {
        Node newcall = new Node(Token.NEW, target);
        for (Node arg : args) {
            Preconditions.checkState(IR.mayBeExpression(arg) || arg.isSpread(), arg);
            newcall.addChildToBack(arg);
        }
        return newcall;
    }

    public static Node name(String name) {
        Preconditions.checkState(name.indexOf(46) == -1, "Invalid name '%s'. Did you mean to use NodeUtil.newQName?", (Object)name);
        return Node.newString(Token.NAME, name);
    }

    public static Node startOptChainGetprop(Node target, String prop) {
        Preconditions.checkState(IR.mayBeExpression(target), target);
        Node optChainGetProp = Node.newString(Token.OPTCHAIN_GETPROP, prop);
        optChainGetProp.addChildToBack(target);
        optChainGetProp.setIsOptionalChainStart(true);
        return optChainGetProp;
    }

    public static Node continueOptChainGetprop(Node target, String prop) {
        Preconditions.checkState(IR.mayBeExpression(target), target);
        Node optChainGetProp = Node.newString(Token.OPTCHAIN_GETPROP, prop);
        optChainGetProp.addChildToBack(target);
        optChainGetProp.setIsOptionalChainStart(false);
        return optChainGetProp;
    }

    public static Node getprop(Node target, String prop) {
        Preconditions.checkState(IR.mayBeExpression(target));
        Node getprop = Node.newString(Token.GETPROP, prop);
        getprop.addChildToBack(target);
        return getprop;
    }

    public static Node getprop(Node target, String prop, String ... moreProps) {
        Preconditions.checkState(IR.mayBeExpression(target));
        Node result = IR.getprop(target, prop);
        for (String moreProp : moreProps) {
            result = IR.getprop(result, moreProp);
        }
        return result;
    }

    public static Node startOptChainGetelem(Node target, Node elem) {
        Preconditions.checkState(IR.mayBeExpression(target), target);
        Preconditions.checkState(IR.mayBeExpression(elem), elem);
        Node optChainGetElem = new Node(Token.OPTCHAIN_GETELEM, target, elem);
        optChainGetElem.setIsOptionalChainStart(true);
        return optChainGetElem;
    }

    public static Node continueOptChainGetelem(Node target, Node elem) {
        Preconditions.checkState(IR.mayBeExpression(target), target);
        Preconditions.checkState(IR.mayBeExpression(elem), elem);
        Node optChainGetElem = new Node(Token.OPTCHAIN_GETELEM, target, elem);
        optChainGetElem.setIsOptionalChainStart(false);
        return optChainGetElem;
    }

    public static Node getelem(Node target, Node elem) {
        Preconditions.checkState(IR.mayBeExpression(target));
        Preconditions.checkState(IR.mayBeExpression(elem));
        return new Node(Token.GETELEM, target, elem);
    }

    public static Node delprop(Node target) {
        Preconditions.checkState(IR.mayBeExpression(target));
        return new Node(Token.DELPROP, target);
    }

    public static Node assign(Node target, Node expr) {
        Preconditions.checkState(target.isValidAssignmentTarget(), target);
        Preconditions.checkState(IR.mayBeExpression(expr), expr);
        return new Node(Token.ASSIGN, target, expr);
    }

    public static Node hook(Node cond, Node trueval, Node falseval) {
        Preconditions.checkState(IR.mayBeExpression(cond));
        Preconditions.checkState(IR.mayBeExpression(trueval));
        Preconditions.checkState(IR.mayBeExpression(falseval));
        return new Node(Token.HOOK, cond, trueval, falseval);
    }

    public static Node in(Node expr1, Node expr2) {
        return IR.binaryOp(Token.IN, expr1, expr2);
    }

    public static Node comma(Node expr1, Node expr2) {
        return IR.binaryOp(Token.COMMA, expr1, expr2);
    }

    public static Node and(Node expr1, Node expr2) {
        return IR.binaryOp(Token.AND, expr1, expr2);
    }

    public static Node or(Node expr1, Node expr2) {
        return IR.binaryOp(Token.OR, expr1, expr2);
    }

    public static Node coalesce(Node expr1, Node expr2) {
        return IR.binaryOp(Token.COALESCE, expr1, expr2);
    }

    public static Node not(Node expr1) {
        return IR.unaryOp(Token.NOT, expr1);
    }

    public static Node lt(Node expr1, Node expr2) {
        return IR.binaryOp(Token.LT, expr1, expr2);
    }

    public static Node ge(Node expr1, Node expr2) {
        return IR.binaryOp(Token.GE, expr1, expr2);
    }

    public static Node eq(Node expr1, Node expr2) {
        return IR.binaryOp(Token.EQ, expr1, expr2);
    }

    public static Node ne(Node expr1, Node expr2) {
        return IR.binaryOp(Token.NE, expr1, expr2);
    }

    public static Node sheq(Node expr1, Node expr2) {
        return IR.binaryOp(Token.SHEQ, expr1, expr2);
    }

    public static Node shne(Node expr1, Node expr2) {
        return IR.binaryOp(Token.SHNE, expr1, expr2);
    }

    public static Node voidNode(Node expr1) {
        return IR.unaryOp(Token.VOID, expr1);
    }

    public static Node neg(Node expr1) {
        return IR.unaryOp(Token.NEG, expr1);
    }

    public static Node pos(Node expr1) {
        return IR.unaryOp(Token.POS, expr1);
    }

    public static Node cast(Node expr1, JSDocInfo jsdoc) {
        Node op = IR.unaryOp(Token.CAST, expr1);
        op.setJSDocInfo(jsdoc);
        return op;
    }

    public static Node inc(Node exp, boolean isPost) {
        Node op = IR.unaryOp(Token.INC, exp);
        op.putBooleanProp(Node.INCRDECR_PROP, isPost);
        return op;
    }

    public static Node dec(Node exp, boolean isPost) {
        Node op = IR.unaryOp(Token.DEC, exp);
        op.putBooleanProp(Node.INCRDECR_PROP, isPost);
        return op;
    }

    public static Node add(Node expr1, Node expr2) {
        return IR.binaryOp(Token.ADD, expr1, expr2);
    }

    public static Node sub(Node expr1, Node expr2) {
        return IR.binaryOp(Token.SUB, expr1, expr2);
    }

    public static Node assignOr(Node expr1, Node expr2) {
        return IR.binaryOp(Token.ASSIGN_OR, expr1, expr2);
    }

    public static Node assignAnd(Node expr1, Node expr2) {
        return IR.binaryOp(Token.ASSIGN_AND, expr1, expr2);
    }

    public static Node assignCoalesce(Node expr1, Node expr2) {
        return IR.binaryOp(Token.ASSIGN_COALESCE, expr1, expr2);
    }

    public static Node objectlit(Node ... propdefs) {
        Node objectlit = new Node(Token.OBJECTLIT);
        for (Node propdef : propdefs) {
            switch (propdef.getToken()) {
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: 
                case GETTER_DEF: 
                case SETTER_DEF: 
                case OBJECT_SPREAD: 
                case COMPUTED_PROP: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected OBJECTLIT child: " + propdef);
                }
            }
            objectlit.addChildToBack(propdef);
        }
        return objectlit;
    }

    public static Node objectPattern(Node ... keys) {
        Node objectPattern = new Node(Token.OBJECT_PATTERN);
        for (Node key : keys) {
            Preconditions.checkState(key.isStringKey() || key.isComputedProp() || key.isRest());
            objectPattern.addChildToBack(key);
        }
        return objectPattern;
    }

    public static Node arrayPattern(Node ... keys) {
        Node arrayPattern = new Node(Token.ARRAY_PATTERN);
        for (Node key : keys) {
            Preconditions.checkState(key.isRest() || key.isValidAssignmentTarget());
            arrayPattern.addChildToBack(key);
        }
        return arrayPattern;
    }

    public static Node computedProp(Node key, Node value) {
        Preconditions.checkState(IR.mayBeExpression(key), key);
        Preconditions.checkState(IR.mayBeExpression(value), value);
        return new Node(Token.COMPUTED_PROP, key, value);
    }

    public static Node propdef(Node string, Node value) {
        Preconditions.checkState(string.isStringKey());
        Preconditions.checkState(!string.hasChildren());
        Preconditions.checkState(IR.mayBeExpression(value));
        string.addChildToFront(value);
        return string;
    }

    public static Node arraylit(Node ... exprs) {
        return IR.arraylit(Arrays.asList(exprs));
    }

    public static Node arraylit(Iterable<Node> exprs) {
        Node arraylit = new Node(Token.ARRAYLIT);
        for (Node expr : exprs) {
            Preconditions.checkState(IR.mayBeExpressionOrEmpty(expr) || expr.isSpread(), expr);
            arraylit.addChildToBack(expr);
        }
        return arraylit;
    }

    public static Node regexp(Node expr) {
        Preconditions.checkState(expr.isStringLit());
        return new Node(Token.REGEXP, expr);
    }

    public static Node regexp(Node expr, Node flags) {
        Preconditions.checkState(expr.isStringLit());
        Preconditions.checkState(flags.isStringLit());
        return new Node(Token.REGEXP, expr, flags);
    }

    public static Node string(String s) {
        return Node.newString(s);
    }

    public static Node stringKey(String s) {
        return Node.newString(Token.STRING_KEY, s);
    }

    public static Node stringKey(String s, Node value) {
        Preconditions.checkState(IR.mayBeExpression(value) || value.isDefaultValue());
        Node stringKey = IR.stringKey(s);
        stringKey.addChildToFront(value);
        return stringKey;
    }

    public static Node quotedStringKey(String s, Node value) {
        Node k = IR.stringKey(s, value);
        k.putBooleanProp(Node.QUOTED_PROP, true);
        return k;
    }

    public static Node iterRest(Node target) {
        Preconditions.checkState(target.isValidAssignmentTarget(), target);
        return new Node(Token.ITER_REST, target);
    }

    public static Node objectRest(Node target) {
        Preconditions.checkState(target.isValidAssignmentTarget(), target);
        return new Node(Token.OBJECT_REST, target);
    }

    public static Node iterSpread(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(Token.ITER_SPREAD, expr);
    }

    public static Node objectSpread(Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(Token.OBJECT_SPREAD, expr);
    }

    public static Node superNode() {
        return new Node(Token.SUPER);
    }

    public static Node getterDef(String name, Node value) {
        Preconditions.checkState(value.isFunction());
        Node member = Node.newString(Token.GETTER_DEF, name);
        member.addChildToFront(value);
        return member;
    }

    public static Node setterDef(String name, Node value) {
        Preconditions.checkState(value.isFunction());
        Node member = Node.newString(Token.SETTER_DEF, name);
        member.addChildToFront(value);
        return member;
    }

    public static Node memberFieldDef(String name, Node value) {
        Preconditions.checkState(IR.mayBeExpression(value));
        Node member = Node.newString(Token.MEMBER_FIELD_DEF, name);
        member.addChildToFront(value);
        return member;
    }

    public static Node memberFunctionDef(String name, Node function) {
        Preconditions.checkState(function.isFunction());
        Node member = Node.newString(Token.MEMBER_FUNCTION_DEF, name);
        member.addChildToBack(function);
        return member;
    }

    public static Node number(double d) {
        Preconditions.checkState(!Double.isNaN(d), d);
        Preconditions.checkState(JSCompDoubles.isPositive(d), d);
        return Node.newNumber(d);
    }

    public static Node bigint(BigInteger b) {
        Preconditions.checkNotNull(b);
        Preconditions.checkState(b.signum() >= 0, b);
        return Node.newBigInt(b);
    }

    public static Node thisNode() {
        return new Node(Token.THIS);
    }

    public static Node trueNode() {
        return new Node(Token.TRUE);
    }

    public static Node falseNode() {
        return new Node(Token.FALSE);
    }

    public static Node nullNode() {
        return new Node(Token.NULL);
    }

    public static Node typeof(Node expr) {
        return IR.unaryOp(Token.TYPEOF, expr);
    }

    public static Node importMeta() {
        return new Node(Token.IMPORT_META);
    }

    private static Node binaryOp(Token token, Node expr1, Node expr2) {
        Preconditions.checkState(IR.mayBeExpression(expr1), expr1);
        Preconditions.checkState(IR.mayBeExpression(expr2), expr2);
        return new Node(token, expr1, expr2);
    }

    private static Node unaryOp(Token token, Node expr) {
        Preconditions.checkState(IR.mayBeExpression(expr));
        return new Node(token, expr);
    }

    private static boolean mayBeExpressionOrEmpty(Node n) {
        return n.isEmpty() || IR.mayBeExpression(n);
    }

    private static boolean mayBeStatementNoReturn(Node n) {
        switch (n.getToken()) {
            case EMPTY: 
            case FUNCTION: {
                return true;
            }
            case BLOCK: 
            case BREAK: 
            case CLASS: 
            case CONST: 
            case CONTINUE: 
            case DEBUGGER: 
            case DO: 
            case EXPR_RESULT: 
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case IF: 
            case LABEL: 
            case LET: 
            case SWITCH: 
            case THROW: 
            case TRY: 
            case VAR: 
            case WHILE: 
            case WITH: {
                return true;
            }
        }
        return false;
    }

    public static boolean mayBeStatement(Node n) {
        if (!IR.mayBeStatementNoReturn(n)) {
            return n.isReturn();
        }
        return true;
    }

    public static boolean mayBeExpression(Node n) {
        switch (n.getToken()) {
            case FUNCTION: 
            case CLASS: {
                return true;
            }
            case ADD: 
            case AND: 
            case ARRAYLIT: 
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_OR: 
            case ASSIGN_AND: 
            case ASSIGN_COALESCE: 
            case AWAIT: 
            case BIGINT: 
            case BITAND: 
            case BITOR: 
            case BITNOT: 
            case BITXOR: 
            case CALL: 
            case CAST: 
            case COALESCE: 
            case COMMA: 
            case DEC: 
            case DELPROP: 
            case DIV: 
            case DYNAMIC_IMPORT: 
            case EQ: 
            case EXPONENT: 
            case FALSE: 
            case GE: 
            case GETPROP: 
            case GETELEM: 
            case GT: 
            case HOOK: 
            case IMPORT_META: 
            case IN: 
            case INC: 
            case INSTANCEOF: 
            case LE: 
            case LSH: 
            case LT: 
            case MOD: 
            case MUL: 
            case NAME: 
            case NE: 
            case NEG: 
            case NEW: 
            case NEW_TARGET: 
            case NOT: 
            case NUMBER: 
            case NULL: 
            case OBJECTLIT: 
            case OPTCHAIN_CALL: 
            case OPTCHAIN_GETELEM: 
            case OPTCHAIN_GETPROP: 
            case OR: 
            case POS: 
            case REGEXP: 
            case RSH: 
            case SHEQ: 
            case SHNE: 
            case STRINGLIT: 
            case SUB: 
            case SUPER: 
            case TEMPLATELIT: 
            case TAGGED_TEMPLATELIT: 
            case THIS: 
            case TYPEOF: 
            case TRUE: 
            case URSH: 
            case VOID: 
            case YIELD: {
                return true;
            }
        }
        return false;
    }
}

