/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.ErrorReporter;
import java.util.ArrayList;
import java.util.List;

public class SimpleErrorReporter
implements ErrorReporter {
    @Nullable
    private List<String> warnings = null;
    @Nullable
    private List<String> errors = null;

    @Override
    public void warning(String message, String sourceName, int line, int lineOffset) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(SimpleErrorReporter.formatDetailedMessage(message, sourceName, line));
    }

    @Override
    public void error(String message, String sourceName, int line, int lineOffset) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(SimpleErrorReporter.formatDetailedMessage(message, sourceName, line));
    }

    private static String formatDetailedMessage(String message, String sourceName, int lineNumber) {
        String details = message;
        if (sourceName == null || lineNumber <= 0) {
            return details;
        }
        StringBuilder buf = new StringBuilder(details);
        buf.append(" (");
        if (sourceName != null) {
            buf.append(sourceName);
        }
        if (lineNumber > 0) {
            buf.append('#');
            buf.append(lineNumber);
        }
        buf.append(')');
        return buf.toString();
    }
}

