/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Splitter;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeDeclarationsIR {
    public static Node stringType() {
        return new Node(Token.STRING_TYPE);
    }

    public static Node numberType() {
        return new Node(Token.NUMBER_TYPE);
    }

    public static Node booleanType() {
        return new Node(Token.BOOLEAN_TYPE);
    }

    public static Node anyType() {
        return new Node(Token.ANY_TYPE);
    }

    public static Node voidType() {
        return new Node(Token.VOID_TYPE);
    }

    public static Node undefinedType() {
        return new Node(Token.UNDEFINED_TYPE);
    }

    public static Node namedType(String typeName) {
        return TypeDeclarationsIR.namedType(Splitter.on('.').split(typeName));
    }

    public static Node namedType(Iterable<String> segments) {
        Iterator<String> segmentsIt = segments.iterator();
        Node node = IR.name(segmentsIt.next());
        while (segmentsIt.hasNext()) {
            node = IR.getprop(node, segmentsIt.next());
        }
        return new Node(Token.NAMED_TYPE, node);
    }

    public static Node recordType(LinkedHashMap<String, Node> properties) {
        Node node = new Node(Token.RECORD_TYPE);
        for (Map.Entry<String, Node> prop : properties.entrySet()) {
            Node stringKey = IR.stringKey(prop.getKey());
            node.addChildToBack(stringKey);
            if (prop.getValue() == null) continue;
            stringKey.addChildToFront(prop.getValue());
        }
        return node;
    }

    private static Node maybeAddType(Node node, Node type) {
        if (type != null) {
            node.setDeclaredTypeExpression(type);
        }
        return node;
    }

    public static Node functionType(Node returnType, LinkedHashMap<String, Node> requiredParams, LinkedHashMap<String, Node> optionalParams, String restName, Node restType) {
        Node name;
        Node node = new Node(Token.FUNCTION_TYPE, returnType);
        Preconditions.checkNotNull(requiredParams);
        Preconditions.checkNotNull(optionalParams);
        for (Map.Entry<String, Node> param : requiredParams.entrySet()) {
            name = IR.name(param.getKey());
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(name, param.getValue()));
        }
        for (Map.Entry<String, Node> param : optionalParams.entrySet()) {
            name = IR.name(param.getKey());
            name.putBooleanProp(Node.OPT_ES6_TYPED, true);
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(name, param.getValue()));
        }
        if (restName != null) {
            Node rest = new Node(Token.ITER_REST, IR.name(restName));
            node.addChildToBack(TypeDeclarationsIR.maybeAddType(rest, restType));
        }
        return node;
    }

    public static Node parameterizedType(Node baseType, Iterable<Node> typeParameters) {
        if (Iterables.isEmpty(typeParameters)) {
            return baseType;
        }
        Node node = new Node(Token.PARAMETERIZED_TYPE, baseType);
        for (Node typeParameter : typeParameters) {
            node.addChildToBack(typeParameter);
        }
        return node;
    }

    public static Node arrayType(Node elementType) {
        return new Node(Token.ARRAY_TYPE, elementType);
    }

    public static Node unionType(Iterable<Node> options) {
        Preconditions.checkArgument(!Iterables.isEmpty(options), "union must have at least one option");
        Node node = new Node(Token.UNION_TYPE);
        for (Node option : options) {
            node.addChildToBack(option);
        }
        return node;
    }

    public static Node unionType(Node ... options) {
        return TypeDeclarationsIR.unionType(Arrays.asList(options));
    }

    public static Node optionalParameter(Node parameterType) {
        return new Node(Token.OPTIONAL_PARAMETER, parameterType);
    }
}

