/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.errorprone.annotations.MustBeClosed;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeClass;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import java.util.ArrayDeque;

public final class JSTypeResolver {
    private final JSTypeRegistry registry;
    private final ArrayDeque<JSType> captureStack = new ArrayDeque();
    private final ArrayDeque<JSType> resolutionQueue = new ArrayDeque();
    private State state = State.CLOSED;

    static JSTypeResolver create(JSTypeRegistry registry) {
        if (registry.getResolver() != null) {
            return registry.getResolver();
        }
        return new JSTypeResolver(registry);
    }

    private JSTypeResolver(JSTypeRegistry registry) {
        this.registry = registry;
    }

    void addUnresolved(JSType captured) {
        Preconditions.checkState(!captured.isResolved());
        this.captureStack.addLast(captured);
    }

    void resolveIfClosed(JSType captured, JSTypeClass caller) {
        if (!caller.isTypeOf(captured)) {
            return;
        }
        JSType expected = this.captureStack.removeLast();
        Preconditions.checkState(JSCompObjects.identical(captured, expected), "Captured %s; Expected %s", (Object)captured, (Object)expected);
        switch (this.state) {
            case CLOSED: 
            case CLOSING: {
                this.doResolve(captured);
                break;
            }
            case OPEN: {
                this.resolutionQueue.addLast(captured);
            }
        }
    }

    @MustBeClosed
    public Closer openForDefinition() {
        Preconditions.checkState(this.state.equals((Object)State.CLOSED));
        Preconditions.checkState(this.captureStack.isEmpty());
        this.state = State.OPEN;
        return new Closer();
    }

    private void resolveAll() {
        Preconditions.checkState(this.state.equals((Object)State.OPEN));
        Preconditions.checkState(this.captureStack.isEmpty());
        this.state = State.CLOSING;
        while (!this.resolutionQueue.isEmpty()) {
            this.doResolve(this.resolutionQueue.removeFirst());
        }
        this.state = State.CLOSED;
        PrototypeObjectType globalThis = (PrototypeObjectType)this.registry.getNativeType(JSTypeNative.GLOBAL_THIS);
        JSType windowType = this.registry.getGlobalType("Window");
        if (globalThis.isUnknownType()) {
            ObjectType windowObjType = ObjectType.cast(windowType);
            if (windowObjType != null) {
                globalThis.setImplicitPrototype(windowObjType);
            } else {
                globalThis.setImplicitPrototype(this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
            }
        }
    }

    private void doResolve(JSType type) {
        type.resolve(this.registry.getErrorReporter());
    }

    void assertLegalToResolveTypes() {
        Preconditions.checkState(!this.state.equals((Object)State.OPEN), "Types cannot be resolved while the registry is open");
    }

    private static enum State {
        CLOSED,
        OPEN,
        CLOSING;

    }

    public final class Closer
    implements AutoCloseable {
        private boolean hasRun = false;

        @Override
        public void close() {
            Preconditions.checkState(!this.hasRun);
            this.hasRun = true;
            JSTypeResolver.this.resolveAll();
        }
    }
}

