/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSortedSet;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Sets;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

final class PropertyMap {
    private static final PropertyMap EMPTY_MAP = new PropertyMap(ImmutableMap.of());
    private ObjectType parentSource = null;
    private final Map<String, Property> properties;
    @Nullable
    private ImmutableSortedSet<String> cachedKeySet = null;
    private int cachedKeySetCounter = 0;

    PropertyMap() {
        this(new TreeMap<String, Property>());
    }

    private PropertyMap(Map<String, Property> underlyingMap) {
        this.properties = underlyingMap;
    }

    static PropertyMap immutableEmptyMap() {
        return EMPTY_MAP;
    }

    void setParentSource(ObjectType ownerType) {
        if (this == EMPTY_MAP) {
            return;
        }
        this.parentSource = ownerType;
        this.incrementCachedKeySetCounter();
    }

    PropertyMap getPrimaryParent() {
        if (this.parentSource == null) {
            return null;
        }
        ObjectType iProto = this.parentSource.getImplicitPrototype();
        return iProto == null ? null : iProto.getPropertyMap();
    }

    private Iterable<ObjectType> getSecondaryParentObjects() {
        if (this.parentSource == null) {
            return ImmutableList.of();
        }
        if (this.parentSource.getConstructor() != null && this.parentSource.getConstructor().isAbstract()) {
            return this.parentSource.getConstructor().getOwnImplementedInterfaces();
        }
        return this.parentSource.getCtorExtendedInterfaces();
    }

    Property.OwnedProperty findTopMost(String name) {
        PropertyMap map;
        Property.OwnedProperty found = null;
        for (map = this; map != null; map = map.getPrimaryParent()) {
            Property prop = map.properties.get(name);
            if (prop == null) continue;
            found = new Property.OwnedProperty(map.parentSource, prop);
        }
        if (found != null) {
            return found;
        }
        for (map = this; map != null; map = map.getPrimaryParent()) {
            for (ObjectType o : map.getSecondaryParentObjects()) {
                Property.OwnedProperty e;
                PropertyMap parent = o.getPropertyMap();
                if (parent == null || (e = parent.findTopMost(name)) == null) continue;
                return e;
            }
        }
        return null;
    }

    Property.OwnedProperty findClosest(String name) {
        PropertyMap map;
        for (map = this; map != null; map = map.getPrimaryParent()) {
            Property prop = map.properties.get(name);
            if (prop == null) continue;
            return new Property.OwnedProperty(map.parentSource, prop);
        }
        for (map = this; map != null; map = map.getPrimaryParent()) {
            for (ObjectType o : map.getSecondaryParentObjects()) {
                Property.OwnedProperty e;
                PropertyMap parent = o.getPropertyMap();
                if (parent == null || (e = parent.findClosest(name)) == null) continue;
                return e;
            }
        }
        return null;
    }

    Property getOwnProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    int getPropertiesCount() {
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent == null) {
            return this.properties.size();
        }
        return this.keySet().size();
    }

    Set<String> getOwnPropertyNames() {
        return this.properties.keySet();
    }

    ImmutableSortedSet<String> keySet() {
        Set<PropertyMap> ancestors = Sets.newIdentityHashSet();
        this.collectAllAncestors(ancestors);
        int maxAncestorCounter = 0;
        for (PropertyMap ancestor : ancestors) {
            if (ancestor.cachedKeySetCounter <= maxAncestorCounter) continue;
            maxAncestorCounter = ancestor.cachedKeySetCounter;
        }
        if (maxAncestorCounter != this.cachedKeySetCounter || this.cachedKeySet == null) {
            TreeSet<String> keys = new TreeSet<String>();
            for (PropertyMap ancestor : ancestors) {
                ancestor.cachedKeySetCounter = maxAncestorCounter;
                ancestor.cachedKeySet = null;
                keys.addAll(ancestor.getOwnPropertyNames());
            }
            this.cachedKeySet = ImmutableSortedSet.copyOfSorted(keys);
        }
        return this.cachedKeySet;
    }

    private void collectAllAncestors(Set<PropertyMap> ancestors) {
        if (!ancestors.add(this)) {
            return;
        }
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent != null) {
            primaryParent.collectAllAncestors(ancestors);
        }
        for (ObjectType parentType : this.getSecondaryParentObjects()) {
            PropertyMap parentMap = parentType.getPropertyMap();
            if (parentMap == null) continue;
            parentMap.collectAllAncestors(ancestors);
        }
    }

    boolean removeProperty(String name) {
        if (this.properties.remove(name) == null) {
            return false;
        }
        this.incrementCachedKeySetCounter();
        return true;
    }

    void putProperty(String name, Property newProp) {
        Property oldProp = this.properties.get(name);
        if (oldProp == null) {
            this.incrementCachedKeySetCounter();
        } else {
            newProp.setJSDocInfo(oldProp.getJSDocInfo());
        }
        this.properties.put(name, newProp);
    }

    Iterable<Property> values() {
        return this.properties.values();
    }

    public int hashCode() {
        return Objects.hashCode(this.properties.keySet());
    }

    private void incrementCachedKeySetCounter() {
        ++this.cachedKeySetCounter;
        this.cachedKeySet = null;
        Preconditions.checkState(this.cachedKeySetCounter >= 0);
    }
}

