/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.ContainsUpperBoundSuperTypeVisitor;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeIterations;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;

final class SubtypeChecker {
    private static final ImmutableSet<String> BIVARIANT_TYPES = ImmutableSet.of("Object", "IArrayLike", "Array");
    private static final int POTENTIALLY_CYCLIC_RECURSION_DEPTH = 20;
    private JSType initialSupertype;
    private JSType initialSubtype;
    private final JSTypeRegistry registry;
    private Boolean isUsingStructuralTyping;
    private JSType.SubtypingMode subtypingMode;
    private HashMap<CacheKey, JSType.MatchStatus> subtypeCache;
    private boolean hasRun = false;
    private int recursionDepth = 0;

    SubtypeChecker setSupertype(JSType value) {
        this.checkHasNotRun();
        Preconditions.checkState(this.initialSupertype == null);
        this.initialSupertype = Preconditions.checkNotNull(value);
        return this;
    }

    SubtypeChecker setSubtype(JSType value) {
        this.checkHasNotRun();
        Preconditions.checkState(this.initialSubtype == null);
        this.initialSubtype = Preconditions.checkNotNull(value);
        return this;
    }

    SubtypeChecker setUsingStructuralSubtyping(boolean value) {
        this.checkHasNotRun();
        Preconditions.checkState(this.isUsingStructuralTyping == null);
        this.isUsingStructuralTyping = value;
        return this;
    }

    SubtypeChecker setSubtypingMode(JSType.SubtypingMode value) {
        this.checkHasNotRun();
        Preconditions.checkState(this.subtypingMode == null);
        this.subtypingMode = Preconditions.checkNotNull(value);
        return this;
    }

    private void checkHasNotRun() {
        Preconditions.checkState(!this.hasRun);
    }

    SubtypeChecker(JSTypeRegistry registry) {
        this.registry = registry;
    }

    boolean check() {
        this.checkHasNotRun();
        this.hasRun = true;
        return this.isSubtypeCaching(this.initialSubtype, this.initialSupertype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSubtypeCaching(JSType subtype, JSType supertype) {
        Preconditions.checkNotNull(subtype);
        Preconditions.checkNotNull(supertype);
        if (this.recursionDepth > 20 && this.subtypeCache == null) {
            this.subtypeCache = new HashMap();
        }
        if (this.subtypeCache == null) {
            try {
                ++this.recursionDepth;
                boolean bl = this.isSubtypeDispatching(subtype, supertype);
                return bl;
            }
            finally {
                --this.recursionDepth;
            }
        }
        CacheKey key = new CacheKey(subtype, supertype);
        JSType.MatchStatus cached = this.subtypeCache.putIfAbsent(key, JSType.MatchStatus.PROCESSING);
        if (cached == null) {
            boolean result = this.isSubtypeDispatching(subtype, supertype);
            this.subtypeCache.put(key, JSType.MatchStatus.valueOf(result));
            return result;
        }
        if (cached == JSType.MatchStatus.PROCESSING) {
            this.subtypeCache.put(key, JSType.MatchStatus.MATCH);
            return true;
        }
        return cached.subtypeValue();
    }

    private boolean isSubtypeDispatching(JSType subtype, JSType supertype) {
        switch (subtype.getTypeClass()) {
            case ARROW: {
                return this.isArrowTypeSubtype((ArrowType)subtype, supertype);
            }
            case ENUM_ELEMENT: {
                return this.isEnumElementSubtype((EnumElementType)subtype, supertype);
            }
            case ENUM: {
                return this.isEnumSubtype((EnumType)subtype, supertype);
            }
            case NO_OBJECT: 
            case NO: 
            case NO_RESOLVED: {
                return this.isVariousBottomsSubtype(subtype, supertype);
            }
            case FUNCTION: {
                return this.isFunctionSubtype((FunctionType)subtype, supertype);
            }
            case TEMPLATE: {
                return this.isTemplateSubtype((TemplateType)subtype, supertype);
            }
            case PROXY_OBJECT: {
                return this.isProxyObjectSubtype((ProxyObjectType)subtype, supertype);
            }
        }
        return this.isSubtypeHelper(subtype, supertype);
    }

    private boolean isSubtypeHelper(JSType subtype, JSType supertype) {
        if (JSCompObjects.identical(subtype, supertype) || supertype.isUnknownType() || supertype.isAllType() || subtype.isUnknownType() || subtype.isNoType()) {
            return true;
        }
        if (this.subtypingMode == JSType.SubtypingMode.IGNORE_NULL_UNDEFINED && (subtype.isNullType() || subtype.isVoidType())) {
            return true;
        }
        if (Objects.equals(subtype, supertype)) {
            return true;
        }
        if (subtype.isNamedType()) {
            return this.isSubtypeDispatching(subtype.toMaybeNamedType().getReferencedType(), supertype);
        }
        if (supertype.isNamedType()) {
            return this.isSubtypeDispatching(subtype, supertype.toMaybeNamedType().getReferencedType());
        }
        if (subtype.isUnionType()) {
            return JSTypeIterations.allTypesMatch(sub -> this.isSubtypeCaching((JSType)sub, supertype), subtype.toMaybeUnionType());
        }
        if (supertype.isUnionType()) {
            return JSTypeIterations.anyTypeMatches(sup -> this.isSubtypeCaching(subtype, (JSType)sup), supertype.toMaybeUnionType());
        }
        if (!subtype.isObjectType() || !supertype.isObjectType()) {
            return false;
        }
        return this.isObjectSubtypeHelper(subtype.assertObjectType(), supertype.assertObjectType());
    }

    private boolean isObjectSubtypeHelper(ObjectType subtype, ObjectType supertype) {
        block8: {
            FunctionType supertypeCtor;
            block7: {
                TemplateType covariantKey;
                JSType thatElement;
                JSType thisElement;
                TemplateTypeMap subtypeParams = subtype.getTemplateTypeMap();
                TemplateTypeMap supertypeParams = supertype.getTemplateTypeMap();
                boolean bivarantMatch = false;
                if (SubtypeChecker.isBivariantType(supertype)) {
                    TemplateType key = subtype.registry.getObjectElementKey();
                    thisElement = subtypeParams.getResolvedTemplateType(key);
                    if (!this.meetVarianceConstraint(Variance.BIVARIANT, thisElement, thatElement = supertypeParams.getResolvedTemplateType(key))) {
                        return false;
                    }
                    bivarantMatch = true;
                }
                if (this.isUsingStructuralTyping.booleanValue() && supertype.isStructuralType()) {
                    return this.isStructuralSubtypeHelper(subtype, supertype, PropertyOptionality.VOIDABLE_PROPS_ARE_OPTIONAL);
                }
                if (supertype.isRecordType()) {
                    return this.isStructuralSubtypeHelper(subtype, supertype, PropertyOptionality.ALL_PROPS_ARE_REQUIRED);
                }
                if (!bivarantMatch && ((covariantKey = SubtypeChecker.getTemplateKeyIfCovariantType(supertype)) != null ? !this.meetVarianceConstraint(Variance.COVARIANT, thisElement = subtypeParams.getResolvedTemplateType(covariantKey), thatElement = supertypeParams.getResolvedTemplateType(covariantKey)) : !this.isTypeMapSubmap(subtype, supertype))) {
                    return false;
                }
                FunctionType subtypeCtor = subtype.getConstructor();
                supertypeCtor = supertype.getConstructor();
                if (subtypeCtor == null || !subtypeCtor.isInterface()) break block7;
                for (ObjectType subtypeInterface : subtype.getCtorExtendedInterfaces()) {
                    if (!this.isSubtypeCaching(subtypeInterface, supertype)) continue;
                    return true;
                }
                break block8;
            }
            if (supertypeCtor == null || !supertypeCtor.isInterface()) break block8;
            for (ObjectType subtypeInterface : subtype.getCtorImplementedInterfaces()) {
                if (!this.isSubtypeCaching(subtypeInterface, supertype)) continue;
                return true;
            }
        }
        return supertype.isImplicitPrototypeOf(subtype);
    }

    private boolean isStructuralSubtypeHelper(ObjectType subtype, ObjectType supertype, PropertyOptionality optionality) {
        Set<String> props = supertype.isRecordType() ? supertype.getOwnPropertyNames() : supertype.getPropertyNames();
        for (String property : props) {
            JSType subtypeProp;
            JSType supertypeProp = supertype.getPropertyType(property);
            if (!(subtype.hasProperty(property) ? !this.isSubtypeCaching(subtypeProp = subtype.getPropertyType(property), supertypeProp) : !optionality.isOptional(supertypeProp))) continue;
            return false;
        }
        return true;
    }

    private boolean isFunctionSubtype(FunctionType subtype, JSType nonFunctionSupertype) {
        if (this.isSubtypeHelper(subtype, nonFunctionSupertype)) {
            return true;
        }
        if (nonFunctionSupertype.isFunctionType()) {
            FunctionType supertype = nonFunctionSupertype.toMaybeFunctionType();
            if (supertype.isInterface()) {
                return true;
            }
            if (subtype.isInterface()) {
                return false;
            }
            return this.shouldTreatThisTypesAsCovariant(subtype, supertype) && this.isSubtypeCaching(subtype.getInternalArrowType(), supertype.getInternalArrowType());
        }
        return this.isSubtypeCaching(this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), nonFunctionSupertype);
    }

    private boolean isVariousBottomsSubtype(JSType subtype, JSType supertype) {
        if (this.isSubtypeHelper(subtype, supertype)) {
            return true;
        }
        if (subtype instanceof NoResolvedType) {
            return !supertype.isNoType();
        }
        return supertype.isObject() && !supertype.isNoType() && !supertype.isNoResolvedType();
    }

    private boolean isArrowTypeSubtype(ArrowType subtype, JSType nonArrowSupertype) {
        FunctionType.Parameter supertypeParam;
        if (!(nonArrowSupertype instanceof ArrowType)) {
            return false;
        }
        ArrowType supertype = (ArrowType)nonArrowSupertype;
        if (!this.isSubtypeCaching(subtype.getReturnType(), supertype.getReturnType())) {
            return false;
        }
        Iterator subtypeParameters = subtype.getParameterList().iterator();
        Iterator supertypeParameters = supertype.getParameterList().iterator();
        FunctionType.Parameter subtypeParam = subtypeParameters.hasNext() ? (FunctionType.Parameter)subtypeParameters.next() : null;
        FunctionType.Parameter parameter = supertypeParam = supertypeParameters.hasNext() ? (FunctionType.Parameter)supertypeParameters.next() : null;
        while (subtypeParam != null && supertypeParam != null) {
            boolean thatIsOptional;
            JSType subtypeParamType = subtypeParam.getJSType();
            JSType supertypeParamType = supertypeParam.getJSType();
            if (!(subtypeParamType == null || supertypeParamType != null && this.isSubtypeCaching(supertypeParamType, subtypeParamType))) {
                return false;
            }
            boolean thisIsVarArgs = subtypeParam.isVariadic();
            boolean thatIsVarArgs = supertypeParam.isVariadic();
            boolean thisIsOptional = thisIsVarArgs || subtypeParam.isOptional();
            boolean bl = thatIsOptional = thatIsVarArgs || supertypeParam.isOptional();
            if (!thisIsOptional && thatIsOptional) {
                boolean isTopFunction;
                boolean bl2 = isTopFunction = thatIsVarArgs && (supertypeParamType == null || supertypeParamType.isUnknownType() || supertypeParamType.isNoType());
                if (!isTopFunction) {
                    return false;
                }
            }
            if (!thisIsVarArgs) {
                FunctionType.Parameter parameter2 = subtypeParam = subtypeParameters.hasNext() ? (FunctionType.Parameter)subtypeParameters.next() : null;
            }
            if (!thatIsVarArgs) {
                FunctionType.Parameter parameter3 = supertypeParam = supertypeParameters.hasNext() ? (FunctionType.Parameter)supertypeParameters.next() : null;
            }
            if (!thisIsVarArgs || !thatIsVarArgs) continue;
            break;
        }
        return subtypeParam == null || subtypeParam.isOptional() || subtypeParam.isVariadic() || supertypeParam != null;
    }

    private boolean isEnumSubtype(EnumType subtype, JSType supertype) {
        return supertype.equals(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE)) || subtype.equals(this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE)) || this.isSubtypeHelper(subtype, supertype);
    }

    private boolean isEnumElementSubtype(EnumElementType subtype, JSType supertype) {
        if (supertype.isEnumElementType() && JSCompObjects.identical(subtype.getEnumType(), supertype.toMaybeEnumElementType().getEnumType())) {
            return this.isSubtypeCaching(subtype.getPrimitiveType(), supertype.toMaybeEnumElementType().getPrimitiveType());
        }
        if (this.isSubtypeHelper(subtype, supertype)) {
            return true;
        }
        return this.isSubtypeCaching(subtype.getPrimitiveType(), supertype);
    }

    private boolean isProxyObjectSubtype(ProxyObjectType subtype, JSType supertype) {
        return this.isSubtypeDispatching(subtype.getReferencedTypeInternal(), supertype);
    }

    private boolean isTemplateSubtype(TemplateType subtype, JSType supertype) {
        if (!subtype.getBound().isUnknownType() && supertype.isTemplateType() && !supertype.toMaybeTemplateType().getBound().isUnknownType()) {
            return subtype.visit(new ContainsUpperBoundSuperTypeVisitor(supertype)) == ContainsUpperBoundSuperTypeVisitor.Result.PRESENT;
        }
        return this.isProxyObjectSubtype(subtype, supertype);
    }

    private boolean isTypeMapSubmap(ObjectType subtype, ObjectType supertype) {
        if (subtype.isFunctionPrototypeType()) {
            return true;
        }
        TemplateTypeMap submap = subtype.getTemplateTypeMap();
        TemplateTypeMap supermap = supertype.getTemplateTypeMap();
        for (TemplateType key : supermap.getTemplateKeys()) {
            JSType supervalue;
            JSType subvalue;
            int keyCount = submap.getTemplateKeyCountThisShouldAlwaysBeOneOrZeroButIsnt(key);
            if (keyCount == 0) {
                if (subtype.loosenTypecheckingDueToForwardReferencedSupertype()) continue;
                return false;
            }
            if (keyCount > 1 || this.meetVarianceConstraint(Variance.INVARIANT, subvalue = submap.getResolvedTemplateType(key), supervalue = supermap.getResolvedTemplateType(key))) continue;
            return false;
        }
        return true;
    }

    private boolean meetVarianceConstraint(Variance variance, JSType override, JSType reference) {
        switch (variance) {
            case COVARIANT: {
                return this.isSubtypeCaching(override, reference);
            }
            case CONTRAVARIANT: {
                return this.isSubtypeCaching(reference, override);
            }
            case BIVARIANT: {
                return this.meetVarianceConstraint(Variance.COVARIANT, reference, override) || this.meetVarianceConstraint(Variance.CONTRAVARIANT, reference, override);
            }
            case INVARIANT: {
                return this.meetVarianceConstraint(Variance.COVARIANT, reference, override) && this.meetVarianceConstraint(Variance.CONTRAVARIANT, reference, override);
            }
        }
        throw new AssertionError();
    }

    private static boolean isBivariantType(JSType type) {
        ObjectType unwrapped = SubtypeChecker.getObjectTypeIfNative(type);
        return unwrapped != null && BIVARIANT_TYPES.contains(unwrapped.getReferenceName());
    }

    @Nullable
    static TemplateType getTemplateKeyIfCovariantType(JSType type) {
        String unwrappedTypeName;
        TemplatizedType ttype;
        if (type.isTemplatizedType() && (ttype = type.toMaybeTemplatizedType()).getTemplateTypeMap().hasTemplateKey(ttype.registry.getIThenableTemplate())) {
            return ttype.registry.getIThenableTemplate();
        }
        ObjectType unwrapped = SubtypeChecker.getObjectTypeIfNative(type);
        String string = unwrappedTypeName = unwrapped == null ? null : unwrapped.getReferenceName();
        if (unwrappedTypeName == null) {
            return null;
        }
        switch (unwrappedTypeName) {
            case "Iterator": {
                return unwrapped.registry.getIteratorValueTemplate();
            }
            case "Generator": {
                return unwrapped.registry.getGeneratorValueTemplate();
            }
            case "AsyncIterator": {
                return unwrapped.registry.getAsyncIteratorValueTemplate();
            }
            case "Iterable": {
                return unwrapped.registry.getIterableTemplate();
            }
            case "AsyncIterable": {
                return unwrapped.registry.getAsyncIterableTemplate();
            }
        }
        return null;
    }

    private boolean shouldTreatThisTypesAsCovariant(FunctionType subtype, FunctionType supertype) {
        if (supertype.getTypeOfThis().toObjectType() != null && supertype.getTypeOfThis().toObjectType().getConstructor() != null && supertype.getTypeOfThis().toObjectType().getConstructor().isInterface()) {
            return true;
        }
        return this.hackTemporarilyChangeSubtypingMode(JSType.SubtypingMode.NORMAL, () -> this.isSubtypeCaching(supertype.getTypeOfThis(), subtype.getTypeOfThis()) || this.isSubtypeCaching(subtype.getTypeOfThis(), supertype.getTypeOfThis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hackTemporarilyChangeSubtypingMode(JSType.SubtypingMode tempMode, BooleanSupplier callback) {
        JSType.SubtypingMode originalMode = this.subtypingMode;
        try {
            this.subtypingMode = tempMode;
            boolean bl = callback.getAsBoolean();
            return bl;
        }
        finally {
            this.subtypingMode = originalMode;
        }
    }

    @Nullable
    private static ObjectType getObjectTypeIfNative(JSType type) {
        ObjectType objType = type.toObjectType();
        ObjectType unwrapped = ObjectType.deeplyUnwrap(objType);
        return unwrapped != null && unwrapped.isNativeObjectType() ? unwrapped : null;
    }

    private static final class CacheKey {
        final JSType left;
        final JSType right;
        final int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            CacheKey that = (CacheKey)other;
            if (JSCompObjects.identical(this.left, that.left) && JSCompObjects.identical(this.right, that.right)) {
                return true;
            }
            return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
        }

        CacheKey(JSType left, JSType right) {
            this.left = left;
            this.right = right;
            this.hashCode = 31 * left.hashCode() + right.hashCode();
        }
    }

    private static enum Variance {
        COVARIANT,
        CONTRAVARIANT,
        BIVARIANT,
        INVARIANT;

    }

    private static enum PropertyOptionality {
        VOIDABLE_PROPS_ARE_OPTIONAL,
        ALL_PROPS_ARE_REQUIRED;


        boolean isOptional(JSType propType) {
            return this == VOIDABLE_PROPS_ARE_OPTIONAL && propType.isExplicitlyVoidable();
        }
    }
}

