/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1UTF8String
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new /* Unavailable Anonymous Inner Class!! */;
    final byte[] contents;

    public static ASN1UTF8String getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1UTF8String) {
            return (ASN1UTF8String)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1UTF8String) {
            return (ASN1UTF8String)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1UTF8String)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1UTF8String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1UTF8String)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    ASN1UTF8String(String string) {
        this(Strings.toUTF8ByteArray((String)string), false);
    }

    ASN1UTF8String(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone((byte[])byArray) : byArray;
    }

    public final String getString() {
        return Strings.fromUTF8ByteArray((byte[])this.contents);
    }

    public String toString() {
        return this.getString();
    }

    public final int hashCode() {
        return Arrays.hashCode((byte[])this.contents);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UTF8String)) {
            return false;
        }
        ASN1UTF8String aSN1UTF8String = (ASN1UTF8String)aSN1Primitive;
        return Arrays.areEqual((byte[])this.contents, (byte[])aSN1UTF8String.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL((boolean)bl, (int)this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 12, this.contents);
    }

    static ASN1UTF8String createPrimitive(byte[] byArray) {
        return new DERUTF8String(byArray, false);
    }
}

