/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Field;
import org.bouncycastle.math.raw.Nat256;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SecP256R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict((String)"FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"));
    protected int[] x;

    public SecP256R1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP256R1FieldElement");
        }
        this.x = SecP256R1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP256R1FieldElement() {
        this.x = Nat256.create();
    }

    protected SecP256R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    public boolean isZero() {
        return Nat256.isZero((int[])this.x);
    }

    public boolean isOne() {
        return Nat256.isOne((int[])this.x);
    }

    public boolean testBitZero() {
        return Nat256.getBit((int[])this.x, (int)0) == 1;
    }

    public BigInteger toBigInteger() {
        return Nat256.toBigInteger((int[])this.x);
    }

    public String getFieldName() {
        return "SecP256R1Field";
    }

    public int getFieldSize() {
        return Q.bitLength();
    }

    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256R1Field.add((int[])this.x, (int[])((SecP256R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement addOne() {
        int[] nArray = Nat256.create();
        SecP256R1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256R1Field.subtract((int[])this.x, (int[])((SecP256R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256R1Field.multiply((int[])this.x, (int[])((SecP256R1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256R1Field.inv((int[])((SecP256R1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP256R1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement negate() {
        int[] nArray = Nat256.create();
        SecP256R1Field.negate((int[])this.x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement square() {
        int[] nArray = Nat256.create();
        SecP256R1Field.square((int[])this.x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement invert() {
        int[] nArray = Nat256.create();
        SecP256R1Field.inv((int[])this.x, (int[])nArray);
        return new SecP256R1FieldElement(nArray);
    }

    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat256.isZero((int[])nArray) || Nat256.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat256.create();
        int[] nArray3 = Nat256.create();
        SecP256R1Field.square((int[])nArray, (int[])nArray2);
        SecP256R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        SecP256R1Field.squareN((int[])nArray2, (int)2, (int[])nArray3);
        SecP256R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        SecP256R1Field.squareN((int[])nArray3, (int)4, (int[])nArray2);
        SecP256R1Field.multiply((int[])nArray2, (int[])nArray3, (int[])nArray2);
        SecP256R1Field.squareN((int[])nArray2, (int)8, (int[])nArray3);
        SecP256R1Field.multiply((int[])nArray3, (int[])nArray2, (int[])nArray3);
        SecP256R1Field.squareN((int[])nArray3, (int)16, (int[])nArray2);
        SecP256R1Field.multiply((int[])nArray2, (int[])nArray3, (int[])nArray2);
        SecP256R1Field.squareN((int[])nArray2, (int)32, (int[])nArray2);
        SecP256R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        SecP256R1Field.squareN((int[])nArray2, (int)96, (int[])nArray2);
        SecP256R1Field.multiply((int[])nArray2, (int[])nArray, (int[])nArray2);
        SecP256R1Field.squareN((int[])nArray2, (int)94, (int[])nArray2);
        SecP256R1Field.square((int[])nArray2, (int[])nArray3);
        return Nat256.eq((int[])nArray, (int[])nArray3) ? new SecP256R1FieldElement(nArray2) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP256R1FieldElement)) {
            return false;
        }
        SecP256R1FieldElement secP256R1FieldElement = (SecP256R1FieldElement)object;
        return Nat256.eq((int[])this.x, (int[])secP256R1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode((int[])this.x, (int)0, (int)8);
    }
}

