/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class XMSSMTPublicKey
extends ASN1Object {
    private final byte[] publicSeed;
    private final byte[] root;

    public XMSSMTPublicKey(byte[] byArray, byte[] byArray2) {
        this.publicSeed = Arrays.clone((byte[])byArray);
        this.root = Arrays.clone((byte[])byArray2);
    }

    private XMSSMTPublicKey(ASN1Sequence aSN1Sequence) {
        if (!ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).hasValue(0)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.publicSeed = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets());
        this.root = Arrays.clone((byte[])DEROctetString.getInstance((Object)aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public static XMSSMTPublicKey getInstance(Object object) {
        if (object instanceof XMSSMTPublicKey) {
            return (XMSSMTPublicKey)object;
        }
        if (object != null) {
            return new XMSSMTPublicKey(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public byte[] getPublicSeed() {
        return Arrays.clone((byte[])this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone((byte[])this.root);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(0L));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.publicSeed));
        aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.root));
        return new DERSequence(aSN1EncodableVector);
    }
}

