/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.pbs;

import gridscale.cluster.BatchScheduler;
import gridscale.cluster.HeadNode;
import gridscale.effectaside.package;
import gridscale.pbs.package;
import gridscale.pbs.package$;
import java.io.Serializable;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.plugin.environment.pbs.PBSEnvironment;
import org.openmole.plugin.environment.pbs.PBSEnvironment$;
import org.openmole.plugin.environment.ssh.SharedStorage;
import org.openmole.plugin.environment.ssh.SharedStorage$;
import org.openmole.plugin.environment.ssh.package;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class PBSJobService<S, H> {
    private final S s;
    private final package.RuntimeInstallation<?> installation;
    private final PBSEnvironment.Parameters parameters;
    private final H h;
    private final AccessControl accessControl;
    private final StorageInterface<S> storageInterface;
    private final HierarchicalStorageInterface<S> hierarchicalStorageInterface;
    private final HeadNode<H> headNode;
    private final BatchEnvironment.Services services;
    private final package.Effect<package.System> systemInterpreter;

    public PBSJobService(S s, String tmpDirectory, package.RuntimeInstallation<?> installation, PBSEnvironment.Parameters parameters, H h, AccessControl accessControl, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, HeadNode<H> headNode, BatchEnvironment.Services services, package.Effect<package.System> systemInterpreter) {
        this.s = s;
        this.installation = installation;
        this.parameters = parameters;
        this.h = h;
        this.accessControl = accessControl;
        this.storageInterface = storageInterface;
        this.hierarchicalStorageInterface = hierarchicalStorageInterface;
        this.headNode = headNode;
        this.services = services;
        this.systemInterpreter = systemInterpreter;
    }

    public AccessControl accessControl() {
        return this.accessControl;
    }

    public BatchScheduler.BatchJob submit(SerializedJob serializedJob, String outputPath, String jobDirectory) {
        String workDirectory = (String)this.parameters.workDirectory().getOrElse(PBSJobService::$anonfun$1);
        SharedStorage.JobScript remoteScript = this.buildScript$1(jobDirectory, workDirectory, serializedJob, outputPath);
        package.PBSJobDescription description = package.PBSJobDescription$.MODULE$.apply("/bin/bash " + remoteScript.content(), jobDirectory, this.parameters.queue(), this.parameters.wallTime(), this.parameters.memory(), this.parameters.nodes(), this.parameters.coreByNode().orElse(this::$anonfun$2), this.parameters.flavour());
        PBSEnvironment$.MODULE$.Log().log(PBSEnvironment$.MODULE$.Log().FINE(), () -> PBSJobService.submit$$anonfun$1(remoteScript, description));
        BatchScheduler.BatchJob id = (BatchScheduler.BatchJob)this.accessControl().apply(() -> this.$anonfun$3(description));
        PBSEnvironment$.MODULE$.Log().log(PBSEnvironment$.MODULE$.Log().FINE(), () -> PBSJobService.submit$$anonfun$2(id));
        return id;
    }

    public byte state(BatchScheduler.BatchJob id) {
        return BoxesRunTime.unboxToByte((Object)this.accessControl().apply(() -> this.state$$anonfun$1(id)));
    }

    public void delete(BatchScheduler.BatchJob id) {
        this.accessControl().apply((Function0 & Serializable)() -> {
            this.delete$$anonfun$1(id);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<String, String> stdOutErr(BatchScheduler.BatchJob id) {
        return (Tuple2)this.accessControl().apply(() -> this.stdOutErr$$anonfun$1(id));
    }

    private static final String $anonfun$1() {
        return "/tmp";
    }

    private final SharedStorage.JobScript buildScript$1(String jobDirectory$1, String workDirectory$1, SerializedJob serializedJob, String outputPath) {
        return SharedStorage$.MODULE$.buildScript((Function1 & Serializable)runtime -> this.installation.apply(runtime), jobDirectory$1, workDirectory$1, this.parameters.openMOLEMemory(), this.parameters.threads(), serializedJob, outputPath, this.s, this.parameters.modules(), SharedStorage$.MODULE$.buildScript$default$10(), this.services.newFile(), this.services.preference(), this.storageInterface, this.hierarchicalStorageInterface);
    }

    private final Option $anonfun$2() {
        return this.parameters.threads();
    }

    private static final String submit$$anonfun$1(SharedStorage.JobScript remoteScript$1, package.PBSJobDescription description$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Submitting PBS job, PBS script:\n                 |" + package.impl$.MODULE$.toScript(description$1, "uniqId") + "\n                 |bash script:\n                 |" + remoteScript$1));
    }

    private final BatchScheduler.BatchJob $anonfun$3(package.PBSJobDescription description$2) {
        return package$.MODULE$.submit(this.h, description$2, this.headNode, this.systemInterpreter);
    }

    private static final String submit$$anonfun$2(BatchScheduler.BatchJob id$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Submitted PBS job with PBS script:\n                 |uniqId: " + id$1.uniqId() + "\n                 |job id: " + id$1.jobId()));
    }

    private final byte state$$anonfun$1(BatchScheduler.BatchJob id$2) {
        return GridScaleJobService$.MODULE$.translateStatus(package$.MODULE$.state(this.h, id$2, this.headNode));
    }

    private final void delete$$anonfun$1(BatchScheduler.BatchJob id$3) {
        package$.MODULE$.clean(this.h, id$3, this.headNode);
    }

    private final Tuple2 stdOutErr$$anonfun$1(BatchScheduler.BatchJob id$4) {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.stdOut(this.h, id$4, this.headNode), (Object)package$.MODULE$.stdErr(this.h, id$4, this.headNode));
    }
}

