/*
 * Decompiled with CFR 0.152.
 */
package container;

import container.ImageBuilder$;
import container.ProcessUtil$;
import container.Proot$Script$;
import container.package;
import container.package$FlatImage$;
import container.tool.package$;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Proot$
implements Serializable {
    private static final String scriptName;
    private static final String standardVarsFuncName;
    private static final String envFuncName;
    private static final String printCommandsFuncName;
    private static final String infoVolumesFuncName;
    private static final String infoPortsFuncName;
    private static final String runPRootFuncName;
    private static final String bashVarPrefix;
    private static final String workdirBashVAR;
    private static final String entryPointBashVar;
    private static final String cmdBashVar;
    private static final String launchScriptName;
    public static final Proot$Script$ Script;
    public static final Proot$ MODULE$;

    private Proot$() {
    }

    static {
        MODULE$ = new Proot$();
        scriptName = "launcher.sh";
        standardVarsFuncName = "prepareStandardVars";
        envFuncName = "prepareEnv";
        printCommandsFuncName = "printCommands";
        infoVolumesFuncName = "infoVolumes";
        infoPortsFuncName = "infoPorts";
        runPRootFuncName = "runPRoot";
        bashVarPrefix = "LOADER_";
        workdirBashVAR = MODULE$.bashVarPrefix() + "WORKDIR";
        entryPointBashVar = MODULE$.bashVarPrefix() + "ENTRYPOINT";
        cmdBashVar = MODULE$.bashVarPrefix() + "CMD";
        launchScriptName = "launch.sh";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Proot$.class);
    }

    public String scriptName() {
        return scriptName;
    }

    public String standardVarsFuncName() {
        return standardVarsFuncName;
    }

    public String envFuncName() {
        return envFuncName;
    }

    public String printCommandsFuncName() {
        return printCommandsFuncName;
    }

    public String infoVolumesFuncName() {
        return infoVolumesFuncName;
    }

    public String infoPortsFuncName() {
        return infoPortsFuncName;
    }

    public String runPRootFuncName() {
        return runPRootFuncName;
    }

    public String bashVarPrefix() {
        return bashVarPrefix;
    }

    public String workdirBashVAR() {
        return workdirBashVAR;
    }

    public String entryPointBashVar() {
        return entryPointBashVar;
    }

    public String cmdBashVar() {
        return cmdBashVar;
    }

    public String launchScriptName() {
        return launchScriptName;
    }

    public boolean generatePRootScript(File scriptFile, String proot, String rootFS, Option<String> workDirectory, Seq<Tuple2<String, String>> bind, Option<Seq<String>> containerEnvironmentVariables, Seq<Tuple2<String, String>> environmentVariables, Seq<String> commandLines, boolean noSeccomp, Option<String> kernel) {
        scriptFile.getParentFile().mkdirs();
        try (OutputStreamWriter script = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(scriptFile)));){
            Seq seq;
            this.writeln$1(script, "#!/usr/bin/env bash\n");
            Proot$Script$.MODULE$.prepareEnvVariables(containerEnvironmentVariables, this.envFuncName(), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)s -> this.writeln$1(script, (String)s));
            if (noSeccomp) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"PROOT_NO_SECCOMP");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"1");
                seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            } else {
                seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
            }
            Seq noSeccompVariable = seq;
            this.preparePRootCommand((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)s -> this.writeln$1(script, (String)s), proot, rootFS, workDirectory, bind, (Seq<Tuple2<String, String>>)((Seq)environmentVariables.$plus$plus((IterableOnce)noSeccompVariable)), commandLines, kernel);
            this.prepareCLI((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)s -> this.writeln$1(script, (String)s));
            script.flush();
        }
        return scriptFile.setExecutable(true);
    }

    public void prepareCLI(Function1<String, BoxedUnit> write) {
        write.apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(this.runPRootFuncName() + " $1 \"$2\" ${@:3}")));
    }

    public void preparePRootCommand(Function1<String, BoxedUnit> write, String proot, String rootFS, Option<String> workDirectory, Seq<Tuple2<String, String>> bind, Seq<Tuple2<String, String>> environmentVariables, Seq<String> commandLines, Option<String> kernel) {
        String workDirectoryArgs = Option$.MODULE$.option2Iterable(workDirectory.filterNot((Function1 & Serializable)_$1 -> _$1.trim().isEmpty()).map((Function1 & Serializable)w -> "-w " + w)).mkString(" ");
        String bindArgs = ((IterableOnceOps)bind.map((Function1 & Serializable)b -> "-b '" + b._1() + ":" + b._2() + "'")).mkString(" ");
        String kernelArg = (String)kernel.map((Function1 & Serializable)k -> "-k " + k).getOrElse(this::$anonfun$5);
        write.apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("function " + this.runPRootFuncName() + " {\n         |  PROOT=`which " + proot + "`\n         |  for i in $(env | cut -d'=' -f1) ; do unset \"$i\"; done\n         |  " + ((IterableOnceOps)environmentVariables.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String n = (String)tuple2._1();
                String v = (String)tuple2._2();
                return "export " + n + "=" + v;
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n") + "\n         |  " + this.envFuncName() + "\n         |  " + ((IterableOnceOps)commandLines.map((Function1 & Serializable)commandLine -> Proot$Script$.MODULE$.assembleCommandParts((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"$PROOT", "--kill-on-exit", "--netcoop", kernelArg, "-r " + rootFS, workDirectoryArgs, bindArgs, commandLine})))).mkString("\n") + "\n         |}\n         |")));
    }

    public int execute(package.FlatImage image, File tmpDirectory, Seq<String> commands, String proot, Seq<Tuple2<String, String>> bind, Option<String> workDirectory, Seq<Tuple2<String, String>> environmentVariables, PrintStream output, PrintStream error, boolean noSeccomp, Option<String> kernel) {
        int n;
        Seq seq;
        ImageBuilder$.MODULE$.checkImageFile(image.file());
        String path = image.file().getAbsolutePath() + "/";
        String rootFSPath = path + package$FlatImage$.MODULE$.rootfsName();
        Seq commandLines = commands.isEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Option$.MODULE$.option2Iterable(image.command()).mkString(" ")})) : commands;
        File script = better.files.package$.MODULE$.FileExtensions(tmpDirectory).toScala().$div(this.launchScriptName()).toJava();
        Option workDirectoryValue = workDirectory.orElse(() -> this.$anonfun$6(image));
        if (!environmentVariables.exists((Function1 & Serializable)_$2 -> {
            Object object = _$2._1();
            String string = "HOME";
            return !(object != null ? !object.equals(string) : string != null);
        })) {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"HOME");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"/root");
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            seq = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        Seq additionalVariables = seq;
        this.generatePRootScript(script, proot, rootFSPath, (Option<String>)workDirectoryValue, bind, image.env(), (Seq<Tuple2<String, String>>)((Seq)environmentVariables.$plus$plus((IterableOnce)additionalVariables)), (Seq<String>)commandLines, noSeccomp, kernel);
        try {
            n = ProcessUtil$.MODULE$.execute((Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{script.getCanonicalPath()}))), output, error, ProcessUtil$.MODULE$.execute$default$4());
        }
        finally {
            script.delete();
        }
        return n;
    }

    public Seq<String> execute$default$3() {
        return scala.package$.MODULE$.Vector().empty();
    }

    public String execute$default$4() {
        return "proot";
    }

    public Seq<Tuple2<String, String>> execute$default$5() {
        return scala.package$.MODULE$.Vector().empty();
    }

    public Option<String> execute$default$6() {
        return None$.MODULE$;
    }

    public Seq<Tuple2<String, String>> execute$default$7() {
        return scala.package$.MODULE$.Vector().empty();
    }

    public PrintStream execute$default$8() {
        return package$.MODULE$.outputLogger();
    }

    public PrintStream execute$default$9() {
        return package$.MODULE$.outputLogger();
    }

    public boolean execute$default$10() {
        return false;
    }

    public Option<String> execute$default$11() {
        return None$.MODULE$;
    }

    private final void writeln$1(OutputStreamWriter script$1, String s) {
        script$1.write(s + "\n");
    }

    private final String $anonfun$5() {
        return "";
    }

    private final Option $anonfun$6(package.FlatImage image$1) {
        return image$1.workDirectory();
    }
}

