/*
 * Decompiled with CFR 0.152.
 */
package container;

import better.files.File;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import container.DockerMetadata;
import container.DockerMetadata$;
import container.DockerMetadata$Digest$;
import container.DockerMetadata$ImageManifestV2Schema1$;
import container.DockerMetadata$JOSE$;
import container.DockerMetadata$JWK$;
import container.DockerMetadata$Signature$;
import container.DockerMetadata$TopLevelImageManifest$;
import container.DockerMetadata$V1History$;
import container.Registry;
import container.Registry$;
import container.Registry$Config$;
import container.Registry$HTTP$;
import container.Registry$Layer$;
import container.Registry$LayerConfig$;
import container.Registry$Manifest$;
import container.Registry$Token$;
import container.RegistryImage;
import container.Stream$;
import container.UserBadDataError;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure$;
import io.circe.DerivedDecoder;
import io.circe.HCursor;
import io.circe.export.Exported$;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import squants.time.Time;

public final class Registry$
implements Serializable {
    public static final Registry$HTTP$ HTTP;
    public static final Registry$Layer$ Layer;
    public static final Registry$LayerConfig$ LayerConfig;
    public static final Registry$Manifest$ Manifest;
    public static final Registry$Token$ Token;
    public static final Registry$Config$ Config;
    public static final Registry$ MODULE$;

    private Registry$() {
    }

    static {
        MODULE$ = new Registry$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Registry$.class);
    }

    public String content(HttpResponse response) {
        return Source$.MODULE$.fromInputStream(response.getEntity().getContent(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String baseURL(RegistryImage image) {
        Object path = image.name().contains("/") ? image.name() : "library/" + image.name();
        return image.registry() + "/v2/" + (String)path;
    }

    public String downloadManifest(RegistryImage image, Time timeout, Option<HttpHost> proxy) {
        String url = this.baseURL(image) + "/manifests/" + image.tag();
        CloseableHttpResponse httpResponse = Registry$HTTP$.MODULE$.client(proxy, true).execute(Registry$Token$.MODULE$.withToken(url, timeout, proxy));
        if (httpResponse.getStatusLine().getStatusCode() >= 300) {
            throw new UserBadDataError("Docker registry responded with " + httpResponse + " to query of image " + image);
        }
        return this.content(httpResponse);
    }

    public Try<DockerMetadata.ImageJSON> decodeConfig(String configContent) {
        return io.circe.jawn.package$.MODULE$.decode(configContent, DockerMetadata$.MODULE$.imageJSONDecoder()).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Try<DockerMetadata.TopLevelImageManifest> decodeTopLevelManifest(String manifestContent) {
        return io.circe.jawn.package$.MODULE$.decode(manifestContent, Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.TopLevelImageManifest>(){
            public static final long OFFSET$0;
            private final String[] elemLabels;
            public long 0bitmap$1;
            public Decoder[] elemDecoders$lzy1;
            {
                String string = "Config";
                String string2 = "Layers";
                String string3 = "RepoTags";
                String string4 = "Parent";
                this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.3.class.getDeclaredField("0bitmap$1"));
            }

            public final String name() {
                return "TopLevelImageManifest";
            }

            public final String[] elemLabels() {
                return this.elemLabels;
            }

            public Decoder[] elemDecoders() {
                long l;
                long l2;
                while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                    if (l2 == 0L) {
                        if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                        try {
                            Decoder decodeA;
                            Decoder decodeA2;
                            Decoder decodeA3;
                            Decoder decodeA4;
                            Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
                            Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeVector(Decoder$.MODULE$.decodeString());
                            Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeVector(Decoder$.MODULE$.decodeString());
                            Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                            Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                            this.elemDecoders$lzy1 = decoderArray;
                            LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                            return decoderArray;
                        }
                        catch (Throwable throwable) {
                            LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                            throw throwable;
                        }
                    }
                    LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                }
                return this.elemDecoders$lzy1;
            }

            public final Either apply(HCursor c) {
                DockerMetadata$TopLevelImageManifest$ dockerMetadata$TopLevelImageManifest$;
                DockerMetadata$TopLevelImageManifest$ m = dockerMetadata$TopLevelImageManifest$ = DockerMetadata$TopLevelImageManifest$.MODULE$;
                if (c.value().isObject()) {
                    Iterator iter = this.resultIterator(c);
                    Object[] res = new Object[this.elemCount()];
                    Left failed = null;
                    int i = 0;
                    while (iter.hasNext() && failed == null) {
                        Either either = (Either)iter.next();
                        if (either instanceof Right) {
                            Object value;
                            res[i] = value = ((Right)either).value();
                        } else if (either instanceof Left) {
                            Left l;
                            failed = l = (Left)either;
                        } else {
                            throw new MatchError((Object)either);
                        }
                        ++i;
                    }
                    if (failed == null) {
                        return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                    }
                    return (Either)failed;
                }
                return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$3$$_$apply$$anonfun$1(c)));
            }

            public final Validated decodeAccumulating(HCursor c) {
                DockerMetadata$TopLevelImageManifest$ dockerMetadata$TopLevelImageManifest$;
                DockerMetadata$TopLevelImageManifest$ m = dockerMetadata$TopLevelImageManifest$ = DockerMetadata$TopLevelImageManifest$.MODULE$;
                if (c.value().isObject()) {
                    Iterator iter = this.resultAccumulatingIterator(c);
                    Object[] res = new Object[this.elemCount()];
                    Builder failed = package$.MODULE$.List().newBuilder();
                    int i = 0;
                    while (iter.hasNext()) {
                        BoxedUnit boxedUnit;
                        Validated validated = (Validated)iter.next();
                        if (validated instanceof Validated.Valid) {
                            Object object;
                            Object value;
                            Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                            res[i] = value = (object = valid._1());
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (validated instanceof Validated.Invalid) {
                            NonEmptyList nonEmptyList;
                            Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                            NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                            boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                        } else {
                            throw new MatchError((Object)validated);
                        }
                        ++i;
                    }
                    List failures = (List)failed.result();
                    if (failures.isEmpty()) {
                        return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                    }
                    return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                }
                return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$3$$_$decodeAccumulating$$anonfun$1(c)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$3$$_$apply$$anonfun$1(io.circe.HCursor ), container$Registry$$anon$3$$_$decodeAccumulating$$anonfun$1(io.circe.HCursor )}, serializedLambda);
            }
        })))).map((Function1 & Serializable)_$4 -> (DockerMetadata.TopLevelImageManifest)_$4.head()).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Try<DockerMetadata.ImageManifestV2Schema1> decodeManifest(String manifestContent) {
        return io.circe.jawn.package$.MODULE$.decode(manifestContent, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.ImageManifestV2Schema1>(){
            public static final long OFFSET$0;
            private final String[] elemLabels;
            public long 0bitmap$7;
            public Decoder[] elemDecoders$lzy7;
            {
                String string = "name";
                String string2 = "tag";
                String string3 = "architecture";
                String string4 = "fsLayers";
                String string5 = "history";
                String string6 = "schemaVersion";
                String string7 = "signatures";
                this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.4.class.getDeclaredField("0bitmap$7"));
            }

            public final String name() {
                return "ImageManifestV2Schema1";
            }

            public final String[] elemLabels() {
                return this.elemLabels;
            }

            public Decoder[] elemDecoders() {
                long l;
                long l2;
                while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                    if (l2 == 0L) {
                        if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                        try {
                            Decoder decodeA;
                            Decoder decodeA2;
                            Decoder decodeA3;
                            Decoder decodeA4;
                            Decoder decodeA5;
                            Decoder decodeA6;
                            Decoder decodeA7;
                            Decoder decoder = decodeA7 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                            Decoder decoder2 = decodeA6 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                            Decoder decoder3 = decodeA5 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                            Decoder decoder4 = decodeA4 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.Digest>(){
                                public static final long OFFSET$0;
                                private final String[] elemLabels;
                                public long 0bitmap$2;
                                public Decoder[] elemDecoders$lzy2;
                                {
                                    String string = "blobSum";
                                    this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
                                }

                                static {
                                    OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.5.class.getDeclaredField("0bitmap$2"));
                                }

                                public final String name() {
                                    return "Digest";
                                }

                                public final String[] elemLabels() {
                                    return this.elemLabels;
                                }

                                public Decoder[] elemDecoders() {
                                    long l;
                                    long l2;
                                    while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                                        if (l2 == 0L) {
                                            if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                                            try {
                                                Decoder decodeA;
                                                Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
                                                Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                                                this.elemDecoders$lzy2 = decoderArray;
                                                LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                                                return decoderArray;
                                            }
                                            catch (Throwable throwable) {
                                                LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                                                throw throwable;
                                            }
                                        }
                                        LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                                    }
                                    return this.elemDecoders$lzy2;
                                }

                                public final Either apply(HCursor c) {
                                    DockerMetadata$Digest$ dockerMetadata$Digest$;
                                    DockerMetadata$Digest$ m = dockerMetadata$Digest$ = DockerMetadata$Digest$.MODULE$;
                                    if (c.value().isObject()) {
                                        Iterator iter = this.resultIterator(c);
                                        Object[] res = new Object[this.elemCount()];
                                        Left failed = null;
                                        int i = 0;
                                        while (iter.hasNext() && failed == null) {
                                            Either either = (Either)iter.next();
                                            if (either instanceof Right) {
                                                Object value;
                                                res[i] = value = ((Right)either).value();
                                            } else if (either instanceof Left) {
                                                Left l;
                                                failed = l = (Left)either;
                                            } else {
                                                throw new MatchError((Object)either);
                                            }
                                            ++i;
                                        }
                                        if (failed == null) {
                                            return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                        }
                                        return (Either)failed;
                                    }
                                    return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$5$$_$apply$$anonfun$2(c)));
                                }

                                public final Validated decodeAccumulating(HCursor c) {
                                    DockerMetadata$Digest$ dockerMetadata$Digest$;
                                    DockerMetadata$Digest$ m = dockerMetadata$Digest$ = DockerMetadata$Digest$.MODULE$;
                                    if (c.value().isObject()) {
                                        Iterator iter = this.resultAccumulatingIterator(c);
                                        Object[] res = new Object[this.elemCount()];
                                        Builder failed = package$.MODULE$.List().newBuilder();
                                        int i = 0;
                                        while (iter.hasNext()) {
                                            BoxedUnit boxedUnit;
                                            Validated validated = (Validated)iter.next();
                                            if (validated instanceof Validated.Valid) {
                                                Object object;
                                                Object value;
                                                Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                                                res[i] = value = (object = valid._1());
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else if (validated instanceof Validated.Invalid) {
                                                NonEmptyList nonEmptyList;
                                                Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                                                NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                                                boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                                            } else {
                                                throw new MatchError((Object)validated);
                                            }
                                            ++i;
                                        }
                                        List failures = (List)failed.result();
                                        if (failures.isEmpty()) {
                                            return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                        }
                                        return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                                    }
                                    return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$5$$_$decodeAccumulating$$anonfun$2(c)));
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$5$$_$apply$$anonfun$2(io.circe.HCursor ), container$Registry$$anon$5$$_$decodeAccumulating$$anonfun$2(io.circe.HCursor )}, serializedLambda);
                                }
                            }))));
                            Decoder decoder5 = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.V1History>(){
                                public static final long OFFSET$0;
                                private final String[] elemLabels;
                                public long 0bitmap$3;
                                public Decoder[] elemDecoders$lzy3;
                                {
                                    String string = "v1Compatibility";
                                    this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
                                }

                                static {
                                    OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.6.class.getDeclaredField("0bitmap$3"));
                                }

                                public final String name() {
                                    return "V1History";
                                }

                                public final String[] elemLabels() {
                                    return this.elemLabels;
                                }

                                public Decoder[] elemDecoders() {
                                    long l;
                                    long l2;
                                    while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                                        if (l2 == 0L) {
                                            if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                                            try {
                                                Decoder decodeA;
                                                Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
                                                Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                                                this.elemDecoders$lzy3 = decoderArray;
                                                LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                                                return decoderArray;
                                            }
                                            catch (Throwable throwable) {
                                                LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                                                throw throwable;
                                            }
                                        }
                                        LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                                    }
                                    return this.elemDecoders$lzy3;
                                }

                                public final Either apply(HCursor c) {
                                    DockerMetadata$V1History$ dockerMetadata$V1History$;
                                    DockerMetadata$V1History$ m = dockerMetadata$V1History$ = DockerMetadata$V1History$.MODULE$;
                                    if (c.value().isObject()) {
                                        Iterator iter = this.resultIterator(c);
                                        Object[] res = new Object[this.elemCount()];
                                        Left failed = null;
                                        int i = 0;
                                        while (iter.hasNext() && failed == null) {
                                            Either either = (Either)iter.next();
                                            if (either instanceof Right) {
                                                Object value;
                                                res[i] = value = ((Right)either).value();
                                            } else if (either instanceof Left) {
                                                Left l;
                                                failed = l = (Left)either;
                                            } else {
                                                throw new MatchError((Object)either);
                                            }
                                            ++i;
                                        }
                                        if (failed == null) {
                                            return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                        }
                                        return (Either)failed;
                                    }
                                    return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$6$$_$apply$$anonfun$3(c)));
                                }

                                public final Validated decodeAccumulating(HCursor c) {
                                    DockerMetadata$V1History$ dockerMetadata$V1History$;
                                    DockerMetadata$V1History$ m = dockerMetadata$V1History$ = DockerMetadata$V1History$.MODULE$;
                                    if (c.value().isObject()) {
                                        Iterator iter = this.resultAccumulatingIterator(c);
                                        Object[] res = new Object[this.elemCount()];
                                        Builder failed = package$.MODULE$.List().newBuilder();
                                        int i = 0;
                                        while (iter.hasNext()) {
                                            BoxedUnit boxedUnit;
                                            Validated validated = (Validated)iter.next();
                                            if (validated instanceof Validated.Valid) {
                                                Object object;
                                                Object value;
                                                Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                                                res[i] = value = (object = valid._1());
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else if (validated instanceof Validated.Invalid) {
                                                NonEmptyList nonEmptyList;
                                                Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                                                NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                                                boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                                            } else {
                                                throw new MatchError((Object)validated);
                                            }
                                            ++i;
                                        }
                                        List failures = (List)failed.result();
                                        if (failures.isEmpty()) {
                                            return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                        }
                                        return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                                    }
                                    return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$6$$_$decodeAccumulating$$anonfun$3(c)));
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$6$$_$apply$$anonfun$3(io.circe.HCursor ), container$Registry$$anon$6$$_$decodeAccumulating$$anonfun$3(io.circe.HCursor )}, serializedLambda);
                                }
                            }))));
                            Decoder decoder6 = decodeA2 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeInt());
                            Decoder decoder7 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.Signature>(){
                                public static final long OFFSET$0;
                                private final String[] elemLabels;
                                public long 0bitmap$6;
                                public Decoder[] elemDecoders$lzy6;
                                {
                                    String string = "header";
                                    String string2 = "signature";
                                    String string3 = "protected";
                                    this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
                                }

                                static {
                                    OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.7.class.getDeclaredField("0bitmap$6"));
                                }

                                public final String name() {
                                    return "Signature";
                                }

                                public final String[] elemLabels() {
                                    return this.elemLabels;
                                }

                                public Decoder[] elemDecoders() {
                                    long l;
                                    long l2;
                                    while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                                        if (l2 == 0L) {
                                            if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                                            try {
                                                Decoder decodeA;
                                                Decoder decodeA2;
                                                Decoder decodeA3;
                                                Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.JOSE>(){
                                                    public static final long OFFSET$0;
                                                    private final String[] elemLabels;
                                                    public long 0bitmap$5;
                                                    public Decoder[] elemDecoders$lzy5;
                                                    {
                                                        String string = "jwk";
                                                        String string2 = "alg";
                                                        this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
                                                    }

                                                    static {
                                                        OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.8.class.getDeclaredField("0bitmap$5"));
                                                    }

                                                    public final String name() {
                                                        return "JOSE";
                                                    }

                                                    public final String[] elemLabels() {
                                                        return this.elemLabels;
                                                    }

                                                    public Decoder[] elemDecoders() {
                                                        long l;
                                                        long l2;
                                                        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                                                            if (l2 == 0L) {
                                                                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                                                                try {
                                                                    Decoder decodeA;
                                                                    Decoder decodeA2;
                                                                    Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)new DerivedDecoder<DockerMetadata.JWK>(){
                                                                        public static final long OFFSET$0;
                                                                        private final String[] elemLabels;
                                                                        public long 0bitmap$4;
                                                                        public Decoder[] elemDecoders$lzy4;
                                                                        {
                                                                            String string = "crv";
                                                                            String string2 = "kid";
                                                                            String string3 = "kty";
                                                                            String string4 = "x";
                                                                            String string5 = "y";
                                                                            this.elemLabels = (String[])package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
                                                                        }

                                                                        static {
                                                                            OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(anon.9.class.getDeclaredField("0bitmap$4"));
                                                                        }

                                                                        public final String name() {
                                                                            return "JWK";
                                                                        }

                                                                        public final String[] elemLabels() {
                                                                            return this.elemLabels;
                                                                        }

                                                                        public Decoder[] elemDecoders() {
                                                                            long l;
                                                                            long l2;
                                                                            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                                                                                if (l2 == 0L) {
                                                                                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                                                                                    try {
                                                                                        Decoder decodeA;
                                                                                        Decoder decodeA2;
                                                                                        Decoder decodeA3;
                                                                                        Decoder decodeA4;
                                                                                        Decoder decodeA5;
                                                                                        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                                                        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                                                        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                                                        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                                                        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                                                        Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                                                                                        this.elemDecoders$lzy4 = decoderArray;
                                                                                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                                                                                        return decoderArray;
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                                                                                        throw throwable;
                                                                                    }
                                                                                }
                                                                                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                                                                            }
                                                                            return this.elemDecoders$lzy4;
                                                                        }

                                                                        public final Either apply(HCursor c) {
                                                                            DockerMetadata$JWK$ dockerMetadata$JWK$;
                                                                            DockerMetadata$JWK$ m = dockerMetadata$JWK$ = DockerMetadata$JWK$.MODULE$;
                                                                            if (c.value().isObject()) {
                                                                                Iterator iter = this.resultIterator(c);
                                                                                Object[] res = new Object[this.elemCount()];
                                                                                Left failed = null;
                                                                                int i = 0;
                                                                                while (iter.hasNext() && failed == null) {
                                                                                    Either either = (Either)iter.next();
                                                                                    if (either instanceof Right) {
                                                                                        Object value;
                                                                                        res[i] = value = ((Right)either).value();
                                                                                    } else if (either instanceof Left) {
                                                                                        Left l;
                                                                                        failed = l = (Left)either;
                                                                                    } else {
                                                                                        throw new MatchError((Object)either);
                                                                                    }
                                                                                    ++i;
                                                                                }
                                                                                if (failed == null) {
                                                                                    return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                                                                }
                                                                                return (Either)failed;
                                                                            }
                                                                            return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$9$$_$apply$$anonfun$4(c)));
                                                                        }

                                                                        public final Validated decodeAccumulating(HCursor c) {
                                                                            DockerMetadata$JWK$ dockerMetadata$JWK$;
                                                                            DockerMetadata$JWK$ m = dockerMetadata$JWK$ = DockerMetadata$JWK$.MODULE$;
                                                                            if (c.value().isObject()) {
                                                                                Iterator iter = this.resultAccumulatingIterator(c);
                                                                                Object[] res = new Object[this.elemCount()];
                                                                                Builder failed = package$.MODULE$.List().newBuilder();
                                                                                int i = 0;
                                                                                while (iter.hasNext()) {
                                                                                    BoxedUnit boxedUnit;
                                                                                    Validated validated = (Validated)iter.next();
                                                                                    if (validated instanceof Validated.Valid) {
                                                                                        Object object;
                                                                                        Object value;
                                                                                        Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                                                                                        res[i] = value = (object = valid._1());
                                                                                        boxedUnit = BoxedUnit.UNIT;
                                                                                    } else if (validated instanceof Validated.Invalid) {
                                                                                        NonEmptyList nonEmptyList;
                                                                                        Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                                                                                        NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                                                                                        boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                                                                                    } else {
                                                                                        throw new MatchError((Object)validated);
                                                                                    }
                                                                                    ++i;
                                                                                }
                                                                                List failures = (List)failed.result();
                                                                                if (failures.isEmpty()) {
                                                                                    return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                                                                }
                                                                                return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                                                                            }
                                                                            return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$9$$_$decodeAccumulating$$anonfun$4(c)));
                                                                        }

                                                                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                                                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$9$$_$apply$$anonfun$4(io.circe.HCursor ), container$Registry$$anon$9$$_$decodeAccumulating$$anonfun$4(io.circe.HCursor )}, serializedLambda);
                                                                        }
                                                                    })));
                                                                    Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                                    Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                                                                    this.elemDecoders$lzy5 = decoderArray;
                                                                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                                                                    return decoderArray;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                                                                    throw throwable;
                                                                }
                                                            }
                                                            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                                                        }
                                                        return this.elemDecoders$lzy5;
                                                    }

                                                    public final Either apply(HCursor c) {
                                                        DockerMetadata$JOSE$ dockerMetadata$JOSE$;
                                                        DockerMetadata$JOSE$ m = dockerMetadata$JOSE$ = DockerMetadata$JOSE$.MODULE$;
                                                        if (c.value().isObject()) {
                                                            Iterator iter = this.resultIterator(c);
                                                            Object[] res = new Object[this.elemCount()];
                                                            Left failed = null;
                                                            int i = 0;
                                                            while (iter.hasNext() && failed == null) {
                                                                Either either = (Either)iter.next();
                                                                if (either instanceof Right) {
                                                                    Object value;
                                                                    res[i] = value = ((Right)either).value();
                                                                } else if (either instanceof Left) {
                                                                    Left l;
                                                                    failed = l = (Left)either;
                                                                } else {
                                                                    throw new MatchError((Object)either);
                                                                }
                                                                ++i;
                                                            }
                                                            if (failed == null) {
                                                                return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                                            }
                                                            return (Either)failed;
                                                        }
                                                        return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$8$$_$apply$$anonfun$5(c)));
                                                    }

                                                    public final Validated decodeAccumulating(HCursor c) {
                                                        DockerMetadata$JOSE$ dockerMetadata$JOSE$;
                                                        DockerMetadata$JOSE$ m = dockerMetadata$JOSE$ = DockerMetadata$JOSE$.MODULE$;
                                                        if (c.value().isObject()) {
                                                            Iterator iter = this.resultAccumulatingIterator(c);
                                                            Object[] res = new Object[this.elemCount()];
                                                            Builder failed = package$.MODULE$.List().newBuilder();
                                                            int i = 0;
                                                            while (iter.hasNext()) {
                                                                BoxedUnit boxedUnit;
                                                                Validated validated = (Validated)iter.next();
                                                                if (validated instanceof Validated.Valid) {
                                                                    Object object;
                                                                    Object value;
                                                                    Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                                                                    res[i] = value = (object = valid._1());
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                } else if (validated instanceof Validated.Invalid) {
                                                                    NonEmptyList nonEmptyList;
                                                                    Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                                                                    NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                                                                    boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                                                                } else {
                                                                    throw new MatchError((Object)validated);
                                                                }
                                                                ++i;
                                                            }
                                                            List failures = (List)failed.result();
                                                            if (failures.isEmpty()) {
                                                                return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                                            }
                                                            return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                                                        }
                                                        return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$8$$_$decodeAccumulating$$anonfun$5(c)));
                                                    }

                                                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$8$$_$apply$$anonfun$5(io.circe.HCursor ), container$Registry$$anon$8$$_$decodeAccumulating$$anonfun$5(io.circe.HCursor )}, serializedLambda);
                                                    }
                                                })));
                                                Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeString());
                                                Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                                                this.elemDecoders$lzy6 = decoderArray;
                                                LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                                                return decoderArray;
                                            }
                                            catch (Throwable throwable) {
                                                LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                                                throw throwable;
                                            }
                                        }
                                        LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                                    }
                                    return this.elemDecoders$lzy6;
                                }

                                public final Either apply(HCursor c) {
                                    DockerMetadata$Signature$ dockerMetadata$Signature$;
                                    DockerMetadata$Signature$ m = dockerMetadata$Signature$ = DockerMetadata$Signature$.MODULE$;
                                    if (c.value().isObject()) {
                                        Iterator iter = this.resultIterator(c);
                                        Object[] res = new Object[this.elemCount()];
                                        Left failed = null;
                                        int i = 0;
                                        while (iter.hasNext() && failed == null) {
                                            Either either = (Either)iter.next();
                                            if (either instanceof Right) {
                                                Object value;
                                                res[i] = value = ((Right)either).value();
                                            } else if (either instanceof Left) {
                                                Left l;
                                                failed = l = (Left)either;
                                            } else {
                                                throw new MatchError((Object)either);
                                            }
                                            ++i;
                                        }
                                        if (failed == null) {
                                            return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                        }
                                        return (Either)failed;
                                    }
                                    return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$7$$_$apply$$anonfun$6(c)));
                                }

                                public final Validated decodeAccumulating(HCursor c) {
                                    DockerMetadata$Signature$ dockerMetadata$Signature$;
                                    DockerMetadata$Signature$ m = dockerMetadata$Signature$ = DockerMetadata$Signature$.MODULE$;
                                    if (c.value().isObject()) {
                                        Iterator iter = this.resultAccumulatingIterator(c);
                                        Object[] res = new Object[this.elemCount()];
                                        Builder failed = package$.MODULE$.List().newBuilder();
                                        int i = 0;
                                        while (iter.hasNext()) {
                                            BoxedUnit boxedUnit;
                                            Validated validated = (Validated)iter.next();
                                            if (validated instanceof Validated.Valid) {
                                                Object object;
                                                Object value;
                                                Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                                                res[i] = value = (object = valid._1());
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else if (validated instanceof Validated.Invalid) {
                                                NonEmptyList nonEmptyList;
                                                Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                                                NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                                                boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                                            } else {
                                                throw new MatchError((Object)validated);
                                            }
                                            ++i;
                                        }
                                        List failures = (List)failed.result();
                                        if (failures.isEmpty()) {
                                            return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                                        }
                                        return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                                    }
                                    return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$7$$_$decodeAccumulating$$anonfun$6(c)));
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$7$$_$apply$$anonfun$6(io.circe.HCursor ), container$Registry$$anon$7$$_$decodeAccumulating$$anonfun$6(io.circe.HCursor )}, serializedLambda);
                                }
                            }))));
                            Decoder[] decoderArray = (Decoder[])package$.MODULE$.Nil().$colon$colon((Object)decoder7).$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).toArray(ClassTag$.MODULE$.apply(Decoder.class));
                            this.elemDecoders$lzy7 = decoderArray;
                            LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                            return decoderArray;
                        }
                        catch (Throwable throwable) {
                            LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                            throw throwable;
                        }
                    }
                    LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
                }
                return this.elemDecoders$lzy7;
            }

            public final Either apply(HCursor c) {
                DockerMetadata$ImageManifestV2Schema1$ dockerMetadata$ImageManifestV2Schema1$;
                DockerMetadata$ImageManifestV2Schema1$ m = dockerMetadata$ImageManifestV2Schema1$ = DockerMetadata$ImageManifestV2Schema1$.MODULE$;
                if (c.value().isObject()) {
                    Iterator iter = this.resultIterator(c);
                    Object[] res = new Object[this.elemCount()];
                    Left failed = null;
                    int i = 0;
                    while (iter.hasNext() && failed == null) {
                        Either either = (Either)iter.next();
                        if (either instanceof Right) {
                            Object value;
                            res[i] = value = ((Right)either).value();
                        } else if (either instanceof Left) {
                            Left l;
                            failed = l = (Left)either;
                        } else {
                            throw new MatchError((Object)either);
                        }
                        ++i;
                    }
                    if (failed == null) {
                        return package$.MODULE$.Right().apply(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                    }
                    return (Either)failed;
                }
                return package$.MODULE$.Left().apply((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$4$$_$apply$$anonfun$7(c)));
            }

            public final Validated decodeAccumulating(HCursor c) {
                DockerMetadata$ImageManifestV2Schema1$ dockerMetadata$ImageManifestV2Schema1$;
                DockerMetadata$ImageManifestV2Schema1$ m = dockerMetadata$ImageManifestV2Schema1$ = DockerMetadata$ImageManifestV2Schema1$.MODULE$;
                if (c.value().isObject()) {
                    Iterator iter = this.resultAccumulatingIterator(c);
                    Object[] res = new Object[this.elemCount()];
                    Builder failed = package$.MODULE$.List().newBuilder();
                    int i = 0;
                    while (iter.hasNext()) {
                        BoxedUnit boxedUnit;
                        Validated validated = (Validated)iter.next();
                        if (validated instanceof Validated.Valid) {
                            Object object;
                            Object value;
                            Validated.Valid valid = Validated.Valid$.MODULE$.unapply((Validated.Valid)validated);
                            res[i] = value = (object = valid._1());
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (validated instanceof Validated.Invalid) {
                            NonEmptyList nonEmptyList;
                            Validated.Invalid invalid = Validated.Invalid$.MODULE$.unapply((Validated.Invalid)validated);
                            NonEmptyList failures = nonEmptyList = (NonEmptyList)invalid._1();
                            boxedUnit = failed.$plus$plus$eq((IterableOnce)failures.toList());
                        } else {
                            throw new MatchError((Object)validated);
                        }
                        ++i;
                    }
                    List failures = (List)failed.result();
                    if (failures.isEmpty()) {
                        return Validated$.MODULE$.valid(m.fromProduct(Tuple$.MODULE$.fromArray((Object)res)));
                    }
                    return Validated$.MODULE$.invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(failures));
                }
                return Validated$.MODULE$.invalidNel((Object)DecodingFailure$.MODULE$.apply(this.name(), () -> Registry$.container$Registry$$anon$4$$_$decodeAccumulating$$anonfun$7(c)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{container$Registry$$anon$4$$_$apply$$anonfun$7(io.circe.HCursor ), container$Registry$$anon$4$$_$decodeAccumulating$$anonfun$7(io.circe.HCursor )}, serializedLambda);
            }
        }))).toTry((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<Registry.Layer> layers(DockerMetadata.ImageManifestV2Schema1 manifest) {
        return (Seq)Option$.MODULE$.option2Iterable(manifest.fsLayers()).toSeq().flatMap((Function1 & Serializable)fsLayers -> fsLayers.map((Function1 & Serializable)fsLayer -> Registry$Layer$.MODULE$.apply(fsLayer.blobSum())));
    }

    public void downloadBlob(RegistryImage image, Registry.Layer layer, File file, Time timeout, Option<HttpHost> proxy) {
        String url = this.baseURL(image) + "/blobs/" + layer.digest();
        HttpGet httpGet = Registry$Token$.MODULE$.withToken(url, timeout, proxy);
        boolean bl = Registry$HTTP$.MODULE$.execute$default$3();
        Registry$HTTP$.MODULE$.execute(httpGet, proxy, bl, true, (JProcedure1 & Serializable)response -> {
            try (OutputStream os = file.newOutputStream(file.newOutputStream$default$1());){
                Stream$.MODULE$.copy(new GZIPInputStream(response.getEntity().getContent()), os);
            }
        });
    }

    public static final List container$Registry$$anon$3$$_$apply$$anonfun$1(HCursor c$1) {
        return c$1.history();
    }

    public static final List container$Registry$$anon$3$$_$decodeAccumulating$$anonfun$1(HCursor c$2) {
        return c$2.history();
    }

    public static final List container$Registry$$anon$5$$_$apply$$anonfun$2(HCursor c$3) {
        return c$3.history();
    }

    public static final List container$Registry$$anon$5$$_$decodeAccumulating$$anonfun$2(HCursor c$4) {
        return c$4.history();
    }

    public static final List container$Registry$$anon$6$$_$apply$$anonfun$3(HCursor c$5) {
        return c$5.history();
    }

    public static final List container$Registry$$anon$6$$_$decodeAccumulating$$anonfun$3(HCursor c$6) {
        return c$6.history();
    }

    public static final List container$Registry$$anon$9$$_$apply$$anonfun$4(HCursor c$7) {
        return c$7.history();
    }

    public static final List container$Registry$$anon$9$$_$decodeAccumulating$$anonfun$4(HCursor c$8) {
        return c$8.history();
    }

    public static final List container$Registry$$anon$8$$_$apply$$anonfun$5(HCursor c$9) {
        return c$9.history();
    }

    public static final List container$Registry$$anon$8$$_$decodeAccumulating$$anonfun$5(HCursor c$10) {
        return c$10.history();
    }

    public static final List container$Registry$$anon$7$$_$apply$$anonfun$6(HCursor c$11) {
        return c$11.history();
    }

    public static final List container$Registry$$anon$7$$_$decodeAccumulating$$anonfun$6(HCursor c$12) {
        return c$12.history();
    }

    public static final List container$Registry$$anon$4$$_$apply$$anonfun$7(HCursor c$13) {
        return c$13.history();
    }

    public static final List container$Registry$$anon$4$$_$decodeAccumulating$$anonfun$7(HCursor c$14) {
        return c$14.history();
    }
}

