/*
 * Decompiled with CFR 0.152.
 */
package container.tool;

import container.tool.Tar$Mode$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Tar$
implements Serializable {
    private static final Tar$Mode$ Mode;
    public static final Tar$ MODULE$;

    private Tar$() {
    }

    static {
        MODULE$ = new Tar$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tar$.class);
    }

    public void archive(File directory, File archive, boolean includeDirectoryName) {
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream(new BufferedOutputStream(new FileOutputStream(archive)));){
            Tuple2 tuple2;
            if (!Files.isDirectory(directory.toPath(), new LinkOption[0])) {
                throw new IOException(directory.toString() + " is not a directory.");
            }
            Stack<Tuple2> toArchive = new Stack<Tuple2>();
            if (!includeDirectoryName) {
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)directory);
                tuple2 = toArchive.push(Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)file, (Object)""));
            } else {
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)directory);
                tuple2 = toArchive.push(Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)file, (Object)directory.getName()));
            }
            while (!toArchive.isEmpty()) {
                TarArchiveEntry tarArchiveEntry;
                Tuple2 tuple22 = (Tuple2)toArchive.pop();
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                File source = (File)tuple22._1();
                String entryName = (String)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)source, (Object)entryName);
                File source2 = (File)tuple23._1();
                String entryName2 = (String)tuple23._2();
                boolean isSymbolicLink = Files.isSymbolicLink(source2.toPath());
                boolean isDirectory = Files.isDirectory(source2.toPath(), new LinkOption[0]);
                if (isDirectory && !isSymbolicLink) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(source2.toPath());){
                        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(stream).asScala()).foreach((Function1 & Serializable)f -> {
                            Path newSource = source2.toPath().resolve(f.getFileName());
                            String newEntryName = entryName2 + '/' + f.getFileName();
                            return toArchive.push(Tuple2$.MODULE$.apply((Object)newSource.toFile(), (Object)newEntryName));
                        });
                    }
                    tarArchiveEntry = new TarArchiveEntry(entryName2 + '/');
                } else if (isSymbolicLink) {
                    TarArchiveEntry e = new TarArchiveEntry(entryName2, 50);
                    e.setLinkName(Files.readSymbolicLink(source2.toPath()).toString());
                    tarArchiveEntry = e;
                } else {
                    TarArchiveEntry e = new TarArchiveEntry(entryName2);
                    e.setSize(Files.size(source2.toPath()));
                    tarArchiveEntry = e;
                }
                TarArchiveEntry e = tarArchiveEntry;
                File file = source2;
                File file2 = directory;
                if (!(file == null ? file2 != null : !((Object)file).equals(file2))) continue;
                if (!isSymbolicLink) {
                    e.setMode(this.mode$1(source2.toPath()));
                }
                tos.putArchiveEntry(e);
                if (!Files.isRegularFile(source2.toPath(), LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    Files.copy(source2.toPath(), tos);
                }
                finally {
                    tos.closeArchiveEntry();
                }
            }
        }
    }

    public boolean archive$default$3() {
        return false;
    }

    public void extract(File archive, File directory, boolean overwrite, boolean compressed) {
        try (TarArchiveInputStream tis = !compressed ? new TarArchiveInputStream(new BufferedInputStream(new FileInputStream(archive))) : new TarArchiveInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(archive))));){
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!Files.isDirectory(directory.toPath(), new LinkOption[0])) {
                throw new IOException(directory.toString() + " is not a directory.");
            }
            ListBuffer directoryRights = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            package$.MODULE$.Iterator().continually(() -> this.extract$$anonfun$1(tis)).takeWhile((Function1 & Serializable)_$1 -> _$1 != null).foreach((Function1 & Serializable)e -> {
                Path dest = Paths.get(directory.toString(), e.getName());
                if (e.isDirectory()) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                    Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)dest);
                    return directoryRights.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, (Object)BoxesRunTime.boxToInteger((int)e.getMode())));
                }
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                if (!e.getLinkName().isEmpty()) {
                    Path path;
                    Path link = Paths.get(e.getLinkName(), new String[0]);
                    try {
                        path = Files.createSymbolicLink(dest, link, new FileAttribute[0]);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileAlreadyExistsException) {
                            FileAlreadyExistsException e2 = (FileAlreadyExistsException)throwable2;
                            if (overwrite) {
                                dest.toFile().delete();
                                path = Files.createSymbolicLink(dest, link, new FileAttribute[0]);
                            }
                        }
                        throw throwable;
                    }
                    return path;
                }
                Files.copy(tis, dest, (CopyOption[])((StandardCopyOption[])Arrays$.MODULE$.seqToArray((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING})).filter((Function1 & Serializable)_$2 -> overwrite), StandardCopyOption.class)));
                return BoxesRunTime.boxToBoolean((boolean)this.setMode$1(dest, e.getMode()));
            });
            directoryRights.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    int mode = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return true;
                }
                return false;
            }).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    int mode = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return this.setMode$1(path, mode);
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    public boolean extract$default$3() {
        return true;
    }

    public boolean extract$default$4() {
        return false;
    }

    private final int mode$1(Path source) {
        Path f = source.toRealPath(new LinkOption[0]);
        return (Files.isReadable(f) ? Tar$Mode$.MODULE$.READ_MODE() : 0) | (Files.isWritable(f) ? Tar$Mode$.MODULE$.WRITE_MODE() : 0) | (Files.isExecutable(f) ? Tar$Mode$.MODULE$.EXEC_MODE() : 0);
    }

    private final boolean setMode$1(Path file, int m) {
        File f = file.toRealPath(new LinkOption[0]).toFile();
        f.setReadable((m & Tar$Mode$.MODULE$.READ_MODE()) != 0);
        f.setWritable((m & Tar$Mode$.MODULE$.WRITE_MODE()) != 0);
        return f.setExecutable((m & Tar$Mode$.MODULE$.EXEC_MODE()) != 0);
    }

    private final TarArchiveEntry extract$$anonfun$1(TarArchiveInputStream tis$1) {
        return tis$1.getNextTarEntry();
    }
}

