/*
 * Decompiled with CFR 0.152.
 */
package org.typelevel.jawn;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.typelevel.jawn.AsyncParser;
import org.typelevel.jawn.FContext;
import org.typelevel.jawn.Facade;
import org.typelevel.jawn.IncompleteParseException$;
import org.typelevel.jawn.ParseException$;
import org.typelevel.jawn.Parser$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public abstract class Parser<J> {
    private final Charset utf8 = Charset.forName("UTF-8");

    public static int ARRBEG() {
        return Parser$.MODULE$.ARRBEG();
    }

    public static int ARREND() {
        return Parser$.MODULE$.ARREND();
    }

    public static int DATA() {
        return Parser$.MODULE$.DATA();
    }

    public static int ErrorContext() {
        return Parser$.MODULE$.ErrorContext();
    }

    public static int[] HexChars() {
        return Parser$.MODULE$.HexChars();
    }

    public static int KEY() {
        return Parser$.MODULE$.KEY();
    }

    public static int OBJBEG() {
        return Parser$.MODULE$.OBJBEG();
    }

    public static int OBJEND() {
        return Parser$.MODULE$.OBJEND();
    }

    public static int SEP() {
        return Parser$.MODULE$.SEP();
    }

    public static <J> AsyncParser<J> async(AsyncParser.Mode mode) {
        return Parser$.MODULE$.async(mode);
    }

    public static <J> Try<J> parseFromByteArray(byte[] byArray, Facade<J> facade) {
        return Parser$.MODULE$.parseFromByteArray(byArray, facade);
    }

    public static <J> Try<J> parseFromByteBuffer(ByteBuffer byteBuffer, Facade<J> facade) {
        return Parser$.MODULE$.parseFromByteBuffer(byteBuffer, facade);
    }

    public static <J> Try<J> parseFromChannel(ReadableByteChannel readableByteChannel, Facade<J> facade) {
        return Parser$.MODULE$.parseFromChannel(readableByteChannel, (Facade)facade);
    }

    public static <J> Try<J> parseFromCharSequence(CharSequence charSequence, Facade<J> facade) {
        return Parser$.MODULE$.parseFromCharSequence(charSequence, facade);
    }

    public static <J> Try<J> parseFromFile(File file, Facade<J> facade) {
        return Parser$.MODULE$.parseFromFile(file, (Facade)facade);
    }

    public static <J> Try<J> parseFromPath(String string, Facade<J> facade) {
        return Parser$.MODULE$.parseFromPath(string, (Facade)facade);
    }

    public static <J> Try<J> parseFromString(String string, Facade<J> facade) {
        return Parser$.MODULE$.parseFromString(string, facade);
    }

    public static <J> J parseUnsafe(String string, Facade<J> facade) {
        return Parser$.MODULE$.parseUnsafe(string, facade);
    }

    public final Charset utf8() {
        return this.utf8;
    }

    public abstract char at(int var1);

    public abstract CharSequence at(int var1, int var2);

    public abstract boolean atEof(int var1);

    public abstract int reset(int var1);

    public abstract void checkpoint(int var1, int var2, FContext<J> var3, List<FContext<J>> var4);

    public abstract void close();

    public abstract void newline(int var1);

    public abstract int line();

    public abstract int column(int var1);

    public Nothing$ die(int i, String msg) {
        return this.die(i, msg, 6);
    }

    private CharSequence safeAt(int i, int j) {
        CharSequence charSequence;
        Parser parser = this;
        int n = j;
        while (true) {
            if (n <= i) {
                charSequence = "";
                break;
            }
            try {
                charSequence = parser.at(i, n);
            }
            catch (Exception exception) {
                Parser parser2 = parser;
                int n2 = n - 1;
                parser = parser2;
                n = n2;
                continue;
            }
            break;
        }
        return charSequence;
    }

    public Nothing$ die(int i, String msg, int chars) {
        String string;
        int y = this.line() + 1;
        int x = this.column(i) + 1;
        if (this.atEof(i)) {
            string = "eof";
        } else {
            int offset;
            for (offset = 0; offset < chars && !this.atEof(i + offset); ++offset) {
            }
            CharSequence txt = this.safeAt(i, i + offset);
            string = this.atEof(i + offset) ? new StringBuilder(2).append("'").append(txt).append("'").toString() : new StringBuilder(5).append("'").append(txt).append("...'").toString();
        }
        String got = string;
        String s = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s got %s (line %d, column %d)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{msg, got, BoxesRunTime.boxToInteger((int)y), BoxesRunTime.boxToInteger((int)x)}));
        throw ParseException$.MODULE$.apply(s, i, y, x);
    }

    public Nothing$ error(String msg) {
        return scala.sys.package$.MODULE$.error(msg);
    }

    public final int parseNum(int i, FContext<J> ctxt, Facade<J> facade) {
        int j = i;
        char c = this.at(j);
        int decIndex = -1;
        int expIndex = -1;
        if (c == '-') {
            c = this.at(++j);
        }
        if (c == '0') {
            c = this.at(++j);
        } else if ('1' <= c && c <= '9') {
            while ('0' <= (c = this.at(++j)) && c <= '9') {
            }
        } else {
            throw this.die(i, "expected digit");
        }
        if (c == '.') {
            decIndex = j - i;
            if ('0' <= (c = this.at(++j)) && c <= '9') {
                while ('0' <= (c = this.at(++j)) && c <= '9') {
                }
            } else {
                throw this.die(i, "expected digit");
            }
        }
        if (c == 'e' || c == 'E') {
            expIndex = j - i;
            if ((c = this.at(++j)) == '+' || c == '-') {
                c = this.at(++j);
            }
            if ('0' <= c && c <= '9') {
                while ('0' <= (c = this.at(++j)) && c <= '9') {
                }
            } else {
                throw this.die(i, "expected digit");
            }
        }
        ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
        return j;
    }

    public final int parseNumSlow(int i, FContext<J> ctxt, Facade<J> facade) {
        int j = i;
        char c = this.at(j);
        int decIndex = -1;
        int expIndex = -1;
        if (c == '-') {
            c = this.at(++j);
        }
        if (c == '0') {
            if (this.atEof(++j)) {
                ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                return j;
            }
            c = this.at(j);
        } else if ('1' <= c && c <= '9') {
            while (true) {
                if (this.atEof(++j)) {
                    ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                    return j;
                }
                c = this.at(j);
                if ('0' <= c && c <= '9') {
                    continue;
                }
                break;
            }
        } else {
            throw this.die(i, "expected digit");
        }
        if (c == '.') {
            decIndex = j - i;
            if ('0' <= (c = this.at(++j)) && c <= '9') {
                while (true) {
                    if (this.atEof(++j)) {
                        ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                        return j;
                    }
                    c = this.at(j);
                    if ('0' <= c && c <= '9') {
                        continue;
                    }
                    break;
                }
            } else {
                throw this.die(i, "expected digit");
            }
        }
        if (c == 'e' || c == 'E') {
            expIndex = j - i;
            if ((c = this.at(++j)) == '+' || c == '-') {
                c = this.at(++j);
            }
            if ('0' <= c && c <= '9') {
                while (true) {
                    if (this.atEof(++j)) {
                        ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                        return j;
                    }
                    c = this.at(j);
                    if ('0' <= c && c <= '9') {
                        continue;
                    }
                    break;
                }
            } else {
                throw this.die(i, "expected digit");
            }
        }
        ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
        return j;
    }

    public final char descape(int pos, CharSequence s) {
        int[] hc = Parser$.MODULE$.HexChars();
        int x = 0;
        for (int i = 0; i < 4; ++i) {
            int n = hc[s.charAt(i)];
            if (n < 0) {
                throw this.die(pos, "expected valid unicode escape");
            }
            x = x << 4 | n;
        }
        return (char)x;
    }

    public abstract int parseString(int var1, FContext<J> var2);

    public final J parseTrue(int i, Facade<J> facade) {
        if (this.at(i + 1) != 'r' || this.at(i + 2) != 'u' || this.at(i + 3) != 'e') {
            throw this.die(i, "expected true");
        }
        return facade.jtrue(i);
    }

    public final J parseFalse(int i, Facade<J> facade) {
        if (this.at(i + 1) != 'a' || this.at(i + 2) != 'l' || this.at(i + 3) != 's' || this.at(i + 4) != 'e') {
            throw this.die(i, "expected false");
        }
        return facade.jfalse(i);
    }

    public final J parseNull(int i, Facade<J> facade) {
        if (this.at(i + 1) != 'u' || this.at(i + 2) != 'l' || this.at(i + 3) != 'l') {
            throw this.die(i, "expected null");
        }
        return facade.jnull(i);
    }

    public final Tuple2<J, Object> parse(int i, Facade<J> facade) {
        Tuple2<J, Object> tuple2;
        try {
            tuple2 = this.parseTop(i, facade);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw IncompleteParseException$.MODULE$.apply("exhausted input");
        }
        return tuple2;
    }

    public final Tuple2<J, Object> parseTop(int i, Facade<J> facade) {
        Tuple2 tuple2;
        Parser parser = this;
        int n = i;
        block13: while (true) {
            char c = parser.at(n);
            switch (c) {
                case ' ': {
                    Parser parser2 = parser;
                    int n2 = n + 1;
                    parser = parser2;
                    n = n2;
                    continue block13;
                }
                case '\t': {
                    Parser parser3 = parser;
                    int n3 = n + 1;
                    parser = parser3;
                    n = n3;
                    continue block13;
                }
                case '\r': {
                    Parser parser4 = parser;
                    int n4 = n + 1;
                    parser = parser4;
                    n = n4;
                    continue block13;
                }
                case '\n': {
                    parser.newline(n);
                    Parser parser5 = parser;
                    int n5 = n + 1;
                    parser = parser5;
                    n = n5;
                    continue block13;
                }
                case '[': {
                    tuple2 = parser.rparse(6, n + 1, facade.arrayContext(n), (List<FContext<J>>)package$.MODULE$.Nil(), facade);
                    break block13;
                }
                case '{': {
                    tuple2 = parser.rparse(7, n + 1, facade.objectContext(n), (List<FContext<J>>)package$.MODULE$.Nil(), facade);
                    break block13;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    FContext<J> ctxt = facade.singleContext(n);
                    int j = parser.parseNumSlow(n, ctxt, facade);
                    tuple2 = Tuple2$.MODULE$.apply(ctxt.finish(n), (Object)BoxesRunTime.boxToInteger((int)j));
                    break block13;
                }
                case '\"': {
                    FContext<J> ctxt = facade.singleContext(n);
                    int j = parser.parseString(n, ctxt);
                    tuple2 = Tuple2$.MODULE$.apply(ctxt.finish(n), (Object)BoxesRunTime.boxToInteger((int)j));
                    break block13;
                }
                case 't': {
                    tuple2 = Tuple2$.MODULE$.apply(parser.parseTrue(n, facade), (Object)BoxesRunTime.boxToInteger((int)(n + 4)));
                    break block13;
                }
                case 'f': {
                    tuple2 = Tuple2$.MODULE$.apply(parser.parseFalse(n, facade), (Object)BoxesRunTime.boxToInteger((int)(n + 5)));
                    break block13;
                }
                case 'n': {
                    tuple2 = Tuple2$.MODULE$.apply(parser.parseNull(n, facade), (Object)BoxesRunTime.boxToInteger((int)(n + 4)));
                    break block13;
                }
                default: {
                    throw parser.die(n, "expected json value");
                }
            }
            break;
        }
        return tuple2;
    }

    public final Tuple2<J, Object> rparse(int state, int j, FContext<J> context, List<FContext<J>> stack, Facade<J> facade) {
        int i;
        Parser parser = this;
        List list = stack;
        FContext fContext = context;
        int n = state;
        int n2 = j;
        while (true) {
            i = parser.reset(n2);
            parser.checkpoint(n, i, fContext, list);
            char c = parser.at(i);
            if (c == '\n') {
                parser.newline(i);
                Parser parser2 = parser;
                int n3 = i + 1;
                parser = parser2;
                n2 = n3;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r') {
                Parser parser3 = parser;
                int n4 = i + 1;
                parser = parser3;
                n2 = n4;
                continue;
            }
            if (n == 1) {
                if (c == '[') {
                    Parser parser4 = parser;
                    int n5 = 6;
                    int n6 = i + 1;
                    FContext<J> fContext2 = facade.arrayContext(i);
                    List list2 = list.$colon$colon(fContext);
                    parser = parser4;
                    n = n5;
                    n2 = n6;
                    fContext = fContext2;
                    list = list2;
                    continue;
                }
                if (c == '{') {
                    Parser parser5 = parser;
                    int n7 = 7;
                    int n8 = i + 1;
                    FContext<J> fContext3 = facade.objectContext(i);
                    List list3 = list.$colon$colon(fContext);
                    parser = parser5;
                    n = n7;
                    n2 = n8;
                    fContext = fContext3;
                    list = list3;
                    continue;
                }
                if (c >= '0' && c <= '9' || c == '-') {
                    int j2 = parser.parseNum(i, fContext, facade);
                    Parser parser6 = parser;
                    int n9 = fContext.isObj() ? 5 : 4;
                    int n10 = j2;
                    parser = parser6;
                    n = n9;
                    n2 = n10;
                    continue;
                }
                if (c == '\"') {
                    int j3 = parser.parseString(i, fContext);
                    Parser parser7 = parser;
                    int n11 = fContext.isObj() ? 5 : 4;
                    int n12 = j3;
                    parser = parser7;
                    n = n11;
                    n2 = n12;
                    continue;
                }
                if (c == 't') {
                    fContext.add(parser.parseTrue(i, facade), i);
                    Parser parser8 = parser;
                    int n13 = fContext.isObj() ? 5 : 4;
                    int n14 = i + 4;
                    parser = parser8;
                    n = n13;
                    n2 = n14;
                    continue;
                }
                if (c == 'f') {
                    fContext.add(parser.parseFalse(i, facade), i);
                    Parser parser9 = parser;
                    int n15 = fContext.isObj() ? 5 : 4;
                    int n16 = i + 5;
                    parser = parser9;
                    n = n15;
                    n2 = n16;
                    continue;
                }
                if (c == 'n') {
                    fContext.add(parser.parseNull(i, facade), i);
                    Parser parser10 = parser;
                    int n17 = fContext.isObj() ? 5 : 4;
                    int n18 = i + 4;
                    parser = parser10;
                    n = n17;
                    n2 = n18;
                    continue;
                }
                throw parser.die(i, "expected json value");
            }
            if (c == ']' && (n == 4 || n == 6) || c == '}' && (n == 5 || n == 7)) {
                if (list.isEmpty()) break;
                FContext ctxt2 = (FContext)list.head();
                ctxt2.add(fContext.finish(i), i);
                Parser parser11 = parser;
                int n19 = ctxt2.isObj() ? 5 : 4;
                int n20 = i + 1;
                FContext fContext4 = ctxt2;
                List list4 = (List)list.tail();
                parser = parser11;
                n = n19;
                n2 = n20;
                fContext = fContext4;
                list = list4;
                continue;
            }
            if (n == 2) {
                if (c == '\"') {
                    int j4 = parser.parseString(i, fContext);
                    Parser parser12 = parser;
                    int n21 = 3;
                    int n22 = j4;
                    parser = parser12;
                    n = n21;
                    n2 = n22;
                    continue;
                }
                throw parser.die(i, "expected \"");
            }
            if (n == 3) {
                if (c == ':') {
                    Parser parser13 = parser;
                    int n23 = 1;
                    int n24 = i + 1;
                    parser = parser13;
                    n = n23;
                    n2 = n24;
                    continue;
                }
                throw parser.die(i, "expected :");
            }
            if (n == 4) {
                if (c == ',') {
                    Parser parser14 = parser;
                    int n25 = 1;
                    int n26 = i + 1;
                    parser = parser14;
                    n = n25;
                    n2 = n26;
                    continue;
                }
                throw parser.die(i, "expected ] or ,");
            }
            if (n == 5) {
                if (c == ',') {
                    Parser parser15 = parser;
                    int n27 = 2;
                    int n28 = i + 1;
                    parser = parser15;
                    n = n27;
                    n2 = n28;
                    continue;
                }
                throw parser.die(i, "expected } or ,");
            }
            if (n == 6) {
                Parser parser16 = parser;
                int n29 = 1;
                int n30 = i;
                parser = parser16;
                n = n29;
                n2 = n30;
                continue;
            }
            Parser parser17 = parser;
            int n31 = 2;
            int n32 = i;
            parser = parser17;
            n = n31;
            n2 = n32;
        }
        return Tuple2$.MODULE$.apply(fContext.finish(i), (Object)BoxesRunTime.boxToInteger((int)(i + 1)));
    }
}

