/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.batch.refresh;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.openmole.core.dsl.extension.package$;
import org.openmole.core.event.Event;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.execution.ExceptionEvent;
import org.openmole.core.workflow.execution.ExecutionJob;
import org.openmole.core.workflow.execution.ExecutionState$;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workflow.mole.MoleExecution$;
import org.openmole.core.workflow.mole.MoleExecutionMessage;
import org.openmole.core.workflow.mole.MoleExecutionMessage$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.BatchExecutionJob;
import org.openmole.plugin.environment.batch.environment.BatchJobControl;
import org.openmole.plugin.environment.batch.environment.JobStore;
import org.openmole.plugin.environment.batch.environment.JobStore$;
import org.openmole.plugin.environment.batch.environment.UpdateInterval;
import org.openmole.plugin.environment.batch.refresh.Delay;
import org.openmole.plugin.environment.batch.refresh.Delay$;
import org.openmole.plugin.environment.batch.refresh.DispatchedMessage;
import org.openmole.plugin.environment.batch.refresh.Error;
import org.openmole.plugin.environment.batch.refresh.GetResult;
import org.openmole.plugin.environment.batch.refresh.JobManager$DispatcherActor$;
import org.openmole.plugin.environment.batch.refresh.JobMessage;
import org.openmole.plugin.environment.batch.refresh.Kill;
import org.openmole.plugin.environment.batch.refresh.Kill$;
import org.openmole.plugin.environment.batch.refresh.Manage;
import org.openmole.plugin.environment.batch.refresh.Manage$;
import org.openmole.plugin.environment.batch.refresh.MoleJobError;
import org.openmole.plugin.environment.batch.refresh.MoleJobError$;
import org.openmole.plugin.environment.batch.refresh.Refresh;
import org.openmole.plugin.environment.batch.refresh.Refresh$;
import org.openmole.plugin.environment.batch.refresh.RetryAction;
import org.openmole.plugin.environment.batch.refresh.Submit;
import org.openmole.plugin.environment.batch.refresh.Submit$;
import org.openmole.plugin.environment.batch.refresh.Submitted;
import org.openmole.plugin.environment.batch.refresh.Submitted$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;
import squants.time.Time;

public final class JobManager$
implements Serializable {
    public static final JobManager$DispatcherActor$ DispatcherActor;
    public static final JobManager$ MODULE$;

    private JobManager$() {
    }

    static {
        MODULE$ = new JobManager$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JobManager$.class);
    }

    public int killPriority() {
        return 10;
    }

    public int messagePriority(DispatchedMessage message) {
        DispatchedMessage dispatchedMessage = message;
        if (dispatchedMessage instanceof Refresh) {
            return 5;
        }
        if (dispatchedMessage instanceof Submit) {
            return 50;
        }
        if (dispatchedMessage instanceof GetResult) {
            return 50;
        }
        if (dispatchedMessage instanceof Kill) {
            return 10;
        }
        if (dispatchedMessage instanceof Error) {
            return 100;
        }
        return 1;
    }

    public void dispatch(DispatchedMessage msg, BatchEnvironment.Services services) {
        services.threadProvider().enqueue(this.messagePriority(msg), (Function0)(JFunction0.mcV.sp & Serializable)() -> JobManager$DispatcherActor$.MODULE$.receive(msg, services));
    }

    public void $bang(JobMessage msg, BatchEnvironment.Services services) {
        JobMessage jobMessage;
        while (true) {
            if ((jobMessage = msg) instanceof Submit) {
                Submit msg2 = (Submit)jobMessage;
                this.killOr(msg2.environment(), msg2.job().storedJob(), Kill$.MODULE$.apply(msg2.job(), msg2.environment(), (Option<BatchJobControl>)None$.MODULE$), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dispatch(msg2, services), services);
                return;
            }
            if (jobMessage instanceof Refresh) {
                Refresh msg3 = (Refresh)jobMessage;
                this.killOr(msg3.environment(), msg3.job().storedJob(), Kill$.MODULE$.apply(msg3.job(), msg3.environment(), (Option<BatchJobControl>)Some$.MODULE$.apply((Object)msg3.batchJob())), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dispatch(msg3, services), services);
                return;
            }
            if (jobMessage instanceof GetResult) {
                GetResult msg4 = (GetResult)jobMessage;
                this.killOr(msg4.environment(), msg4.job().storedJob(), Kill$.MODULE$.apply(msg4.job(), msg4.environment(), (Option<BatchJobControl>)Some$.MODULE$.apply((Object)msg4.batchJob())), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dispatch(msg4, services), services);
                return;
            }
            if (jobMessage instanceof RetryAction) {
                RetryAction msg5 = (RetryAction)jobMessage;
                this.dispatch(msg5, services);
                return;
            }
            if (jobMessage instanceof Error) {
                Error msg6 = (Error)jobMessage;
                this.dispatch(msg6, services);
                return;
            }
            if (jobMessage instanceof Kill) {
                Kill msg7 = (Kill)jobMessage;
                this.dispatch(msg7, services);
                return;
            }
            if (!(jobMessage instanceof Manage)) break;
            Manage manage = Manage$.MODULE$.unapply((Manage)jobMessage);
            BatchExecutionJob batchExecutionJob = manage._1();
            BatchEnvironment batchEnvironment = manage._2();
            BatchExecutionJob bej = batchExecutionJob;
            BatchEnvironment environment = batchEnvironment;
            services.eventDispatcher().trigger((Object)environment, (Event)Environment.JobSubmitted$.MODULE$.apply(bej.id(), (ExecutionJob)bej));
            msg = Submit$.MODULE$.apply(bej, environment);
        }
        if (jobMessage instanceof Delay) {
            Delay delay = Delay$.MODULE$.unapply((Delay)jobMessage);
            JobMessage jobMessage2 = delay._1();
            Time time = delay._2();
            JobMessage msg8 = jobMessage2;
            Time delay2 = time;
            services.threadProvider().scheduler().schedule(org.openmole.tool.thread.package$.MODULE$.function2Runable((Function0 & Serializable)() -> {
                this.$bang$$anonfun$4(services, msg8);
                return BoxedUnit.UNIT;
            }), delay2.millis(), TimeUnit.MILLISECONDS);
            return;
        }
        if (jobMessage instanceof Submitted) {
            Submitted submitted = Submitted$.MODULE$.unapply((Submitted)jobMessage);
            BatchExecutionJob batchExecutionJob = submitted._1();
            BatchEnvironment batchEnvironment = submitted._2();
            BatchJobControl batchJobControl = submitted._3();
            BatchExecutionJob job = batchExecutionJob;
            BatchEnvironment environment = batchEnvironment;
            BatchJobControl bj = batchJobControl;
            this.killOr(environment, job.storedJob(), Kill$.MODULE$.apply(job, environment, (Option<BatchJobControl>)Some$.MODULE$.apply((Object)bj)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.$bang(Delay$.MODULE$.apply(Refresh$.MODULE$.apply(job, environment, bj, ((UpdateInterval)bj.updateInterval().apply()).minUpdateInterval(), Refresh$.MODULE$.$lessinit$greater$default$5()), ((UpdateInterval)bj.updateInterval().apply()).minUpdateInterval()), services), services);
            return;
        }
        if (jobMessage instanceof MoleJobError) {
            MoleJobError moleJobError = MoleJobError$.MODULE$.unapply((MoleJobError)jobMessage);
            long l = moleJobError._1();
            BatchExecutionJob batchExecutionJob = moleJobError._2();
            BatchEnvironment batchEnvironment = moleJobError._3();
            Throwable throwable = moleJobError._4();
            Option<String> option = moleJobError._5();
            String string = moleJobError._6();
            long mj = l;
            BatchExecutionJob j = batchExecutionJob;
            BatchEnvironment environment = batchEnvironment;
            Throwable e = throwable;
            Option<String> output = option;
            String host = string;
            Environment.MoleJobExceptionRaised er = Environment.MoleJobExceptionRaised$.MODULE$.apply((ExecutionJob)j, e, Level.WARNING, mj, (Option)Some$.MODULE$.apply((Object)this.detail$1(output, host)));
            environment.error((ExceptionEvent)er);
            services.eventDispatcher().trigger((Object)environment, (Event)er);
            package$.MODULE$.Logger().fine(this::$bang$$anonfun$6, e, FullName$.MODULE$.apply("org.openmole.plugin.environment.batch.refresh.JobManager.!"), Line$.MODULE$.apply(94), services.loggerService(), services.outputRedirection());
            return;
        }
        throw new MatchError((Object)jobMessage);
    }

    public void sendToMoleExecution(JobStore.StoredJob job, Function1<MoleExecution, BoxedUnit> f) {
        MoleExecutionMessage$.MODULE$.send(job.moleExecution(), (MoleExecutionMessage)MoleExecutionMessage.WithMoleExecutionSate$.MODULE$.apply(f), MoleExecutionMessage$.MODULE$.send$default$3(job.moleExecution()));
    }

    public boolean canceled(JobStore.StoredJob storedJob) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])storedJob.storedMoleJobs());
        return ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)storedMoleJob -> JobStore$.MODULE$.subMoleCanceled((JobStore.StoredMoleJob)storedMoleJob));
    }

    public Object killOr(BatchExecutionJob batchJob, Kill kill, Function0<Object> op, BatchEnvironment.Services services) {
        if (batchJob.state() == ExecutionState$.MODULE$.KILLED()) {
            return BoxedUnit.UNIT;
        }
        if (this.canceled(batchJob.storedJob())) {
            this.$bang(kill, services);
            return BoxedUnit.UNIT;
        }
        return op.apply();
    }

    public void killOr(BatchEnvironment environment, JobStore.StoredJob storedJob, Kill kill, Function0<BoxedUnit> op, BatchEnvironment.Services services) {
        if (environment.stopped() || this.canceled(storedJob)) {
            this.$bang(kill, services);
            return;
        }
        this.sendToMoleExecution(storedJob, (Function1<MoleExecution, BoxedUnit>)(JProcedure1 & Serializable)state -> {
            if (!this.jobIsFinished((MoleExecution)state, storedJob)) {
                op.apply$mcV$sp();
                return;
            }
            this.$bang(kill, services);
        });
    }

    public boolean jobIsFinished(MoleExecution moleExecution, JobStore.StoredJob job) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])job.storedMoleJobs());
        Object object2 = Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.id(), ClassTag$.MODULE$.apply(Long.TYPE)));
        return ArrayOps$.MODULE$.forall$extension(object2, (Function1)(JFunction1.mcZJ.sp & Serializable)mj -> MoleExecution$.MODULE$.moleJobIsFinished(moleExecution, mj));
    }

    private final void $bang$$anonfun$4(BatchEnvironment.Services services$5, JobMessage msg$5) {
        this.$bang(msg$5, services$5);
    }

    private final String detail$1$$anonfun$2(String host$3) {
        return "OpenMOLE output on remote node " + host$3 + " was empty";
    }

    private final String detail$1(Option output$1, String host$1) {
        return (String)output$1.map((Function1 & Serializable)output -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("OpenMOLE output on remote node " + host$1 + " was:\n             |" + output))).getOrElse(() -> this.detail$1$$anonfun$2(host$1));
    }

    private final String $bang$$anonfun$6() {
        return "Error during job execution, it will be resubmitted.";
    }
}

