/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.batch.storage;

import gridscale.package;
import java.io.Serializable;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString$;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.Preference$;
import org.openmole.core.preference.PreferenceLocation$;
import org.openmole.core.replication.ReplicaCatalog$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.storage.EnvironmentStorage;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageService$;
import org.openmole.plugin.environment.batch.storage.StorageSpace;
import org.openmole.plugin.environment.batch.storage.StorageSpace$;
import org.openmole.tool.logger.JavaLogger;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import squants.time.Time;
import squants.time.TimeConversions$;

public final class HierarchicalStorageSpace$
implements JavaLogger,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HierarchicalStorageSpace$.class.getDeclaredField("Log$lzy1"));
    private volatile Object Log$lzy1;
    private static final ClearPreferenceLocation TmpDirRemoval;
    private static final ClearPreferenceLocation TmpDirCreation;
    public static final HierarchicalStorageSpace$ MODULE$;

    private HierarchicalStorageSpace$() {
    }

    static {
        MODULE$ = new HierarchicalStorageSpace$();
        TmpDirRemoval = PreferenceLocation$.MODULE$.apply("StorageService", "TmpDirRemoval", MODULE$::$init$$$anonfun$1);
        TmpDirCreation = PreferenceLocation$.MODULE$.apply("StorageService", "TmpDirCreation", MODULE$::$init$$$anonfun$2);
    }

    public final JavaLogger$Log$ Log() {
        Object object = this.Log$lzy1;
        if (object instanceof JavaLogger$Log$) {
            return (JavaLogger$Log$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JavaLogger$Log$)this.Log$lzyINIT1();
    }

    private Object Log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JavaLogger$Log$ javaLogger$Log$ = null;
                    try {
                        javaLogger$Log$ = new JavaLogger$Log$((JavaLogger)this);
                        object2 = javaLogger$Log$ == null ? LazyVals.NullValue$.MODULE$ : javaLogger$Log$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return javaLogger$Log$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HierarchicalStorageSpace$.class);
    }

    public ClearPreferenceLocation<Time> TmpDirRemoval() {
        return TmpDirRemoval;
    }

    public ClearPreferenceLocation<Time> TmpDirCreation() {
        return TmpDirCreation;
    }

    public <S> StorageSpace create(S s, String root, String storageId, Function1<Throwable, Object> isConnectionError, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, Preference preference) {
        String string;
        String persistent = "persistent/";
        String tmp = "tmp/";
        try {
            string = this.createBasePath(s, root, isConnectionError, storageInterface, hierarchicalStorageInterface, preference);
        }
        catch (Throwable e) {
            throw new InternalProcessingError("Error creating base directory " + root + " on storage " + s, e);
        }
        String baseDirectory = string;
        String replicaDirectory = hierarchicalStorageInterface.child(s, baseDirectory, persistent);
        try {
            if (!storageInterface.exists(s, replicaDirectory)) {
                hierarchicalStorageInterface.makeDir(s, replicaDirectory);
            }
        }
        catch (Throwable e) {
            throw new InternalProcessingError("Error creating replica directory " + replicaDirectory + " on storage " + s, e);
        }
        String tmpDirectory = hierarchicalStorageInterface.child(s, baseDirectory, tmp);
        try {
            if (!storageInterface.exists(s, tmpDirectory)) {
                hierarchicalStorageInterface.makeDir(s, tmpDirectory);
            }
        }
        catch (Throwable e) {
            throw new InternalProcessingError("Error creating tmp directory " + tmpDirectory + " on storage " + s, e);
        }
        return StorageSpace$.MODULE$.apply(baseDirectory, replicaDirectory, tmpDirectory);
    }

    public <S> void clean(S s, StorageSpace storageSpace, boolean background, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, EnvironmentStorage<S> environmentStorage, BatchEnvironment.Services services) {
        services.replicaCatalog().clean(environmentStorage.id(s), (Function1)(JProcedure1 & Serializable)_$1 -> StorageService$.MODULE$.rmFile(s, (String)_$1, storageInterface));
        this.cleanReplicaDirectory(s, storageSpace.replicaDirectory(), environmentStorage.id(s), background, services, storageInterface, hierarchicalStorageInterface);
        this.cleanTmpDirectory(s, storageSpace.tmpDirectory(), background, storageInterface, hierarchicalStorageInterface, services);
    }

    public Option<Object> extractTimeFromName(String name) {
        String time = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(name), (Function1 & Serializable)_$2 -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$2)));
        if (time.isEmpty()) {
            return None$.MODULE$;
        }
        return Try$.MODULE$.apply(() -> this.extractTimeFromName$$anonfun$1(time)).toOption();
    }

    public <T> void ignoreErrors(Function0<T> f) {
        Try$.MODULE$.apply(f);
    }

    public <S> void cleanTmpDirectory(S s, String tmpDirectory, boolean background, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, BatchEnvironment.Services services) {
        Seq<package.ListEntry> entries = hierarchicalStorageInterface.list(s, tmpDirectory);
        long removalDate = System.currentTimeMillis() - TimeConversions$.MODULE$.timeToScalaDuration((Time)services.preference().apply(this.TmpDirRemoval(), ConfigurationString$.MODULE$.given_ConfigurationString_Time())).toMillis();
        entries.withFilter((Function1 & Serializable)entry -> this.remove$1(removalDate, entry.name())).foreach((Function1)(JProcedure1 & Serializable)entry -> {
            String path = StorageService$.MODULE$.child(s, tmpDirectory, entry.name(), hierarchicalStorageInterface);
            package.FileType fileType = entry.type();
            package.FileType$.Directory$ directory$ = package.FileType$.Directory$.MODULE$;
            if (!(fileType != null ? !fileType.equals(directory$) : directory$ != null)) {
                this.ignoreErrors((Function0 & Serializable)() -> {
                    this.cleanTmpDirectory$$anonfun$2$$anonfun$1(s, background, hierarchicalStorageInterface, services, path);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            this.ignoreErrors((Function0 & Serializable)() -> {
                this.cleanTmpDirectory$$anonfun$2$$anonfun$2(s, background, storageInterface, services, path);
                return BoxedUnit.UNIT;
            });
        });
    }

    public <S> void cleanReplicaDirectory(S s, String persistentPath, String storageId, boolean background, BatchEnvironment.Services services, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface) {
        Seq<package.ListEntry> entries = hierarchicalStorageInterface.list(s, persistentPath);
        Set inReplica = ((IterableOnceOps)services.replicaCatalog().forPaths((Seq)entries.map((Function1 & Serializable)e -> StorageService$.MODULE$.child(s, persistentPath, e.name(), hierarchicalStorageInterface)), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{storageId}))).map((Function1 & Serializable)_$5 -> _$5.path())).toSet();
        entries.withFilter((Function1 & Serializable)e -> this.graceIsOver$1(services, e.name())).foreach((Function1)(JProcedure1 & Serializable)e -> {
            String path = StorageService$.MODULE$.child(s, persistentPath, e.name(), hierarchicalStorageInterface);
            if (!inReplica.contains((Object)path)) {
                package.FileType fileType = e.type();
                package.FileType$.Directory$ directory$ = package.FileType$.Directory$.MODULE$;
                if (!(fileType != null ? !fileType.equals(directory$) : directory$ != null)) {
                    this.ignoreErrors((Function0 & Serializable)() -> {
                        this.cleanReplicaDirectory$$anonfun$2$$anonfun$1(s, background, services, hierarchicalStorageInterface, path);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                this.ignoreErrors((Function0 & Serializable)() -> {
                    this.cleanReplicaDirectory$$anonfun$2$$anonfun$2(s, background, services, storageInterface, path);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public <S> String createBasePath(S s, String root, Function1<Throwable, Object> isConnectionError, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, Preference preference) {
        String rootPath = this.mkRootDir$1(s, root, isConnectionError, hierarchicalStorageInterface);
        String basePath = StorageService$.MODULE$.child(s, rootPath, this.baseDirName$1(preference), hierarchicalStorageInterface);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.createBasePath$$anonfun$1(s, hierarchicalStorageInterface, basePath);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            return basePath;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            if (BoxesRunTime.unboxToBoolean((Object)isConnectionError.apply((Object)e))) {
                throw e;
            }
            if (storageInterface.exists(s, basePath)) {
                return basePath;
            }
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public <S> String createJobDirectory(S s, StorageSpace storageSpace, HierarchicalStorageInterface<S> hierarchicalStorageInterface, Preference preference) {
        String intervalDirectory = hierarchicalStorageInterface.child(s, storageSpace.tmpDirectory(), StorageSpace$.MODULE$.lastBegining((Time)preference.apply(this.TmpDirCreation(), ConfigurationString$.MODULE$.given_ConfigurationString_Time())));
        this.ignoreErrors((Function0 & Serializable)() -> {
            this.createJobDirectory$$anonfun$1(s, hierarchicalStorageInterface, intervalDirectory);
            return BoxedUnit.UNIT;
        });
        String communicationPath = hierarchicalStorageInterface.child(s, intervalDirectory, StorageSpace$.MODULE$.timedUniqName());
        hierarchicalStorageInterface.makeDir(s, communicationPath);
        return communicationPath;
    }

    private final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)30), (Numeric)Numeric.IntIsIntegral$.MODULE$).days());
    }

    private final Option $init$$$anonfun$2() {
        return Some$.MODULE$.apply((Object)TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).hours());
    }

    private final /* synthetic */ boolean $anonfun$1(char _$2) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$2));
    }

    private final long extractTimeFromName$$anonfun$1(String time$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time$1));
    }

    private final boolean remove$1$$anonfun$2() {
        return true;
    }

    private final boolean remove$1(long removalDate$1, String name) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractTimeFromName(name).map((Function1)(JFunction1.mcZJ.sp & Serializable)_$3 -> _$3 < removalDate$1).getOrElse(this::remove$1$$anonfun$2));
    }

    private final void cleanTmpDirectory$$anonfun$2$$anonfun$1(Object s$3, boolean background$2, HierarchicalStorageInterface hierarchicalStorageInterface$2, BatchEnvironment.Services services$2, String path$1) {
        StorageService$.MODULE$.rmDirectory(s$3, path$1, background$2, services$2, hierarchicalStorageInterface$2);
    }

    private final void cleanTmpDirectory$$anonfun$2$$anonfun$2(Object s$4, boolean background$3, StorageInterface storageInterface$3, BatchEnvironment.Services services$3, String path$2) {
        StorageService$.MODULE$.rmFile(s$4, path$2, background$3, services$3, storageInterface$3);
    }

    private final boolean graceIsOver$1$$anonfun$2() {
        return true;
    }

    private final boolean graceIsOver$1(BatchEnvironment.Services services$4, String name) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractTimeFromName(name).map((Function1)(JFunction1.mcZJ.sp & Serializable)_$4 -> _$4 + TimeConversions$.MODULE$.timeToScalaDuration((Time)services$4.preference().apply(ReplicaCatalog$.MODULE$.ReplicaGraceTime(), ConfigurationString$.MODULE$.given_ConfigurationString_Time())).toMillis() < System.currentTimeMillis()).getOrElse(this::graceIsOver$1$$anonfun$2));
    }

    private final void cleanReplicaDirectory$$anonfun$2$$anonfun$1(Object s$7, boolean background$5, BatchEnvironment.Services services$7, HierarchicalStorageInterface hierarchicalStorageInterface$5, String path$3) {
        StorageService$.MODULE$.rmDirectory(s$7, path$3, background$5, services$7, hierarchicalStorageInterface$5);
    }

    private final void cleanReplicaDirectory$$anonfun$2$$anonfun$2(Object s$8, boolean background$6, BatchEnvironment.Services services$8, StorageInterface storageInterface$5, String path$4) {
        StorageService$.MODULE$.rmFile(s$8, path$4, background$6, services$8, storageInterface$5);
    }

    private final String baseDirName$1(Preference preference$1) {
        return "openmole-" + preference$1.apply(Preference$.MODULE$.uniqueID(), ConfigurationString$.MODULE$.given_ConfigurationString_String()) + '/';
    }

    private final String mkRootDir$1(Object s$9, String root$1, Function1 isConnectionError$1, HierarchicalStorageInterface hierarchicalStorageInterface$6) {
        String string;
        HierarchicalStorageSpace$ hierarchicalStorageSpace$ = this;
        synchronized (hierarchicalStorageSpace$) {
            Seq paths = (Seq)((IterableOps)package$.MODULE$.Iterator().iterate((Object)Some$.MODULE$.apply((Object)root$1), (Function1 & Serializable)p -> p.flatMap((Function1 & Serializable)_$6 -> hierarchicalStorageInterface$6.parent(s$9, (String)_$6))).takeWhile((Function1 & Serializable)_$7 -> _$7.isDefined()).toSeq().reverse()).flatten(Predef$.MODULE$.$conforms());
            string = (String)((IterableOnceOps)paths.tail()).foldLeft((Object)((String)paths.head()).toString(), (Function2 & Serializable)(path, file) -> {
                String childPath = StorageService$.MODULE$.child(s$9, (String)path, hierarchicalStorageInterface$6.name(s$9, (String)file), hierarchicalStorageInterface$6);
                try {
                    hierarchicalStorageInterface$6.makeDir(s$9, childPath);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        Throwable e = throwable3;
                        if (BoxesRunTime.unboxToBoolean((Object)isConnectionError$1.apply((Object)e))) {
                            throw e;
                        }
                        Throwable e2 = throwable3;
                        this.Log().logger().log(this.Log().FINE(), "Error creating base directory " + root$1, e2);
                    }
                    throw throwable;
                }
                return childPath;
            });
        }
        return string;
    }

    private final void createBasePath$$anonfun$1(Object s$13, HierarchicalStorageInterface hierarchicalStorageInterface$10, String basePath$1) {
        hierarchicalStorageInterface$10.makeDir(s$13, basePath$1);
    }

    private final void createJobDirectory$$anonfun$1(Object s$14, HierarchicalStorageInterface hierarchicalStorageInterface$11, String intervalDirectory$1) {
        hierarchicalStorageInterface$11.makeDir(s$14, intervalDirectory$1);
    }
}

