/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.batch.storage;

import java.io.File;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.openmole.core.communication.storage.RemoteStorage;
import org.openmole.core.communication.storage.package;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageService$;
import org.openmole.tool.file.FilePackage;
import org.openmole.tool.stream.GZipedInputStream;
import org.openmole.tool.stream.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class StorageInterface$
implements Serializable {
    public static final StorageInterface$ MODULE$ = new StorageInterface$();

    private StorageInterface$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StorageInterface$.class);
    }

    public <S> RemoteStorage remote(S s, String communicationDirectory, StorageInterface<S> evidence$1, HierarchicalStorageInterface<S> evidence$2) {
        return new RemoteStorage(s, communicationDirectory, evidence$1, evidence$2){
            private final Object s$1;
            private final String communicationDirectory$1;
            private final StorageInterface evidence$1$1;
            private final HierarchicalStorageInterface evidence$2$1;
            {
                this.s$1 = s$2;
                this.communicationDirectory$1 = communicationDirectory$2;
                this.evidence$1$1 = evidence$1$2;
                this.evidence$2$1 = evidence$2$2;
            }

            public String upload(File src, Option dest, package.TransferOptions options, TmpDirectory newFile) {
                return StorageService$.MODULE$.uploadInDirectory(this.s$1, src, this.communicationDirectory$1, options, this.evidence$1$1, this.evidence$2$1);
            }

            public void download(String src, File dest, package.TransferOptions options, TmpDirectory newFile) {
                StorageService$.MODULE$.download(this.s$1, src, dest, options, this.evidence$1$1);
            }
        };
    }

    public void upload(boolean compressed, Function2<Function0<InputStream>, String, BoxedUnit> uploadStream, File src, String dest, package.TransferOptions options) {
        if (compressed) {
            if (!options.raw()) {
                uploadStream.apply((Function0 & Serializable)() -> this.compressedFileStream$1(src), (Object)dest);
                return;
            }
            uploadStream.apply((Function0 & Serializable)() -> this.fileStream$1(src), (Object)dest);
            return;
        }
        uploadStream.apply((Function0 & Serializable)() -> this.fileStream$1(src), (Object)dest);
    }

    public package.TransferOptions upload$default$5(boolean compressed, Function2<Function0<InputStream>, String, BoxedUnit> uploadStream) {
        return package.TransferOptions$.MODULE$.default();
    }

    public void download(boolean compressed, Function2<String, Function1<InputStream, BoxedUnit>, BoxedUnit> downloadStream, String src, File dest, package.TransferOptions options) {
        if (compressed) {
            if (!options.raw()) {
                downloadStream.apply((Object)src, (JProcedure1 & Serializable)is -> this.uncompressed$1(dest, (InputStream)is));
                return;
            }
            downloadStream.apply((Object)src, (JProcedure1 & Serializable)is -> this.downloadFile$1(dest, (InputStream)is));
            return;
        }
        downloadStream.apply((Object)src, (JProcedure1 & Serializable)is -> this.downloadFile$1(dest, (InputStream)is));
    }

    public package.TransferOptions download$default$5(boolean compressed, Function2<String, Function1<InputStream, BoxedUnit>, BoxedUnit> downloadStream) {
        return package.TransferOptions$.MODULE$.default();
    }

    public boolean isDirectory(String name) {
        return name.endsWith("/");
    }

    private final FilterInputStream fileStream$1(File src$1) {
        FilePackage.FileDecorator fileDecorator = org.openmole.tool.file.package$.MODULE$.FileDecorator(src$1);
        return fileDecorator.bufferedInputStream(fileDecorator.bufferedInputStream$default$1());
    }

    private final GZipedInputStream compressedFileStream$1(File src$2) {
        FilePackage.FileDecorator fileDecorator = org.openmole.tool.file.package$.MODULE$.FileDecorator(src$2);
        return package$.MODULE$.InputStreamDecorator((InputStream)fileDecorator.bufferedInputStream(fileDecorator.bufferedInputStream$default$1())).toGZiped();
    }

    private final long downloadFile$1(File dest$1, InputStream is) {
        return Files.copy(is, dest$1.toPath(), new CopyOption[0]);
    }

    private final long uncompressed$1(File dest$2, InputStream is) {
        return this.downloadFile$1(dest$2, package$.MODULE$.InputStreamDecorator(is).toGZ());
    }
}

