/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Utils;

public class DefaultDecorator
implements Decorator {
    @Override
    public void openParagraph(StringBuilder stringBuilder) {
        stringBuilder.append("<p>");
    }

    @Override
    public void closeParagraph(StringBuilder stringBuilder) {
        stringBuilder.append("</p>\n");
    }

    @Override
    public void openBlockquote(StringBuilder stringBuilder) {
        stringBuilder.append("<blockquote>");
    }

    @Override
    public void closeBlockquote(StringBuilder stringBuilder) {
        stringBuilder.append("</blockquote>\n");
    }

    @Override
    public void openCodeBlock(StringBuilder stringBuilder) {
        stringBuilder.append("<pre><code>");
    }

    @Override
    public void closeCodeBlock(StringBuilder stringBuilder) {
        stringBuilder.append("</code></pre>\n");
    }

    @Override
    public void openCodeSpan(StringBuilder stringBuilder) {
        stringBuilder.append("<code>");
    }

    @Override
    public void appendCodeSpan(StringBuilder stringBuilder, String string, int n, int n2) {
        this.openCodeSpan(stringBuilder);
        Utils.appendCode(stringBuilder, string, n, n2);
        this.closeCodeSpan(stringBuilder);
    }

    @Override
    public void closeCodeSpan(StringBuilder stringBuilder) {
        stringBuilder.append("</code>");
    }

    @Override
    public void openHeadline(StringBuilder stringBuilder, int n) {
        stringBuilder.append("<h");
        stringBuilder.append(n);
    }

    @Override
    public void closeHeadline(StringBuilder stringBuilder, int n) {
        stringBuilder.append("</h");
        stringBuilder.append(n);
        stringBuilder.append(">\n");
    }

    @Override
    public void openStrong(StringBuilder stringBuilder) {
        stringBuilder.append("<strong>");
    }

    @Override
    public void closeStrong(StringBuilder stringBuilder) {
        stringBuilder.append("</strong>");
    }

    @Override
    public void openEmphasis(StringBuilder stringBuilder) {
        stringBuilder.append("<em>");
    }

    @Override
    public void closeEmphasis(StringBuilder stringBuilder) {
        stringBuilder.append("</em>");
    }

    @Override
    public void openStrikeout(StringBuilder stringBuilder) {
        stringBuilder.append("<del>");
    }

    @Override
    public void closeStrikeout(StringBuilder stringBuilder) {
        stringBuilder.append("</del>");
    }

    @Override
    public void openSuper(StringBuilder stringBuilder) {
        stringBuilder.append("<sup>");
    }

    @Override
    public void closeSuper(StringBuilder stringBuilder) {
        stringBuilder.append("</sup>");
    }

    @Override
    public void openOrderedList(StringBuilder stringBuilder) {
        stringBuilder.append("<ol>\n");
    }

    @Override
    public void closeOrderedList(StringBuilder stringBuilder) {
        stringBuilder.append("</ol>\n");
    }

    @Override
    public void openUnorderedList(StringBuilder stringBuilder) {
        stringBuilder.append("<ul>\n");
    }

    @Override
    public void closeUnorderedList(StringBuilder stringBuilder) {
        stringBuilder.append("</ul>\n");
    }

    @Override
    public void openListItem(StringBuilder stringBuilder) {
        stringBuilder.append("<li");
    }

    @Override
    public void closeListItem(StringBuilder stringBuilder) {
        stringBuilder.append("</li>\n");
    }

    @Override
    public void horizontalRuler(StringBuilder stringBuilder) {
        stringBuilder.append("<hr />\n");
    }

    @Override
    public void openLink(StringBuilder stringBuilder) {
        stringBuilder.append("<a");
    }

    @Override
    public void closeLink(StringBuilder stringBuilder) {
        stringBuilder.append("</a>");
    }

    @Override
    public void openImage(StringBuilder stringBuilder) {
        stringBuilder.append("<img");
    }

    @Override
    public void closeImage(StringBuilder stringBuilder) {
        stringBuilder.append(" />");
    }

    @Override
    public void openTable(StringBuilder stringBuilder) {
        stringBuilder.append("<table>\n");
    }

    @Override
    public void closeTable(StringBuilder stringBuilder) {
        stringBuilder.append("</table>\n");
    }

    @Override
    public void openTableHead(StringBuilder stringBuilder) {
        stringBuilder.append("<thead>\n");
    }

    @Override
    public void closeTableHead(StringBuilder stringBuilder) {
        stringBuilder.append("</thead>\n");
    }

    @Override
    public void openTableBody(StringBuilder stringBuilder) {
        stringBuilder.append("<tbody>\n");
    }

    @Override
    public void closeTableBody(StringBuilder stringBuilder) {
        stringBuilder.append("</tbody>\n");
    }

    @Override
    public void openTableRow(StringBuilder stringBuilder) {
        stringBuilder.append("<tr>\n");
    }

    @Override
    public void closeTableRow(StringBuilder stringBuilder) {
        stringBuilder.append("</tr>\n");
    }

    @Override
    public void openTableData(StringBuilder stringBuilder, String string) {
        if (string == null) {
            stringBuilder.append("<td>");
        } else {
            stringBuilder.append("<td style=\"text-align:").append(string).append(";\">");
        }
    }

    @Override
    public void closeTableData(StringBuilder stringBuilder) {
        stringBuilder.append("</td>");
    }

    @Override
    public void openTableHeader(StringBuilder stringBuilder, String string) {
        if (string == null) {
            stringBuilder.append("<th>");
        } else {
            stringBuilder.append("<th style=\"text-align:").append(string).append(";\">");
        }
    }

    @Override
    public void closeTableHeader(StringBuilder stringBuilder) {
        stringBuilder.append("</th>");
    }
}

