/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark.cmd;

import com.github.rjeschke.txtmark.cmd.CmdArgument;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

final class CmdLineParser {
    static final HashMap<Class<?>, Type> TYPE_MAP = new HashMap();
    static final Class<?>[] TYPE_CLASS_LIST = Colls.objArray(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, List.class, Boolean.class, Boolean.TYPE);
    static final Type[] TYPE_TYPE_LIST = Colls.objArray(Type.STRING, Type.BYTE, Type.BYTE, Type.SHORT, Type.SHORT, Type.INT, Type.INT, Type.LONG, Type.LONG, Type.FLOAT, Type.FLOAT, Type.DOUBLE, Type.DOUBLE, Type.LIST, Type.BOOL, Type.BOOL);
    static final HashSet<String> BOOL_TRUE = new HashSet<String>(Colls.list("on", "true", "yes"));
    static final HashSet<String> BOOL_FALSE = new HashSet<String>(Colls.list("off", "false", "no"));

    private CmdLineParser() {
    }

    static Type getTypeFor(Class<?> clazz) {
        Type type = TYPE_MAP.get(clazz);
        if (type != null) {
            return type;
        }
        if (Classes.implementsInterface(clazz, List.class)) {
            return Type.LIST;
        }
        return Type.UNSUPPORTED;
    }

    static String defaultToString(Object object, Type type, Arg arg) {
        if (object == null || arg.isSwitch || arg.catchAll || !arg.printDefault) {
            return null;
        }
        if (type == Type.LIST) {
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Once<String> once = Once.of("", Character.toString(arg.itemSep));
            for (Object e : list) {
                stringBuilder.append(once.get());
                stringBuilder.append(e.toString());
            }
            return stringBuilder.toString();
        }
        return object.toString();
    }

    private static void parseArgs(Object[] objectArray, List<Arg> list, HashMap<String, Arg> hashMap, HashMap<String, Arg> hashMap2) throws IOException {
        for (Object object : objectArray) {
            Field[] fieldArray;
            Class<?> clazz = object.getClass();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(CmdArgument.class)) continue;
                Arg arg = new Arg(field.getAnnotation(CmdArgument.class), object, field);
                if (arg.type == Type.UNSUPPORTED) {
                    throw new IOException("Unsupported parameter type: " + field.getType().getCanonicalName() + " for: " + arg);
                }
                if (arg.listType == Type.UNSUPPORTED || arg.listType == Type.LIST) {
                    throw new IOException("Unsupported list type: " + field.getType().getCanonicalName() + " for: " + arg);
                }
                if (Strings.isEmpty(arg.s) && Strings.isEmpty(arg.l)) {
                    throw new IOException("Missing parameter name");
                }
                if (!Strings.isEmpty(arg.s)) {
                    if (hashMap.containsKey(arg.s)) {
                        throw new IOException("Duplicate short argument: -" + arg.s);
                    }
                    hashMap.put(arg.s, arg);
                }
                if (!Strings.isEmpty(arg.l)) {
                    if (hashMap2.containsKey(arg.l)) {
                        throw new IOException("Duplicate long argument: --" + arg.l);
                    }
                    hashMap2.put(arg.l, arg);
                }
                if (arg.isCatchAll() && arg.type != Type.LIST) {
                    throw new IOException("Parameter '" + arg + "' requires a List field.");
                }
                if (arg.isSwitch && arg.type != Type.BOOL) {
                    throw new IOException("Parameter '" + arg + "' requires a Boolean/boolean field.");
                }
                list.add(arg);
            }
        }
    }

    public static String generateHelp(int n, boolean bl, Object ... objectArray) throws IOException {
        List<Arg> list = Colls.list(new Arg[0]);
        HashMap<String, Arg> hashMap = new HashMap<String, Arg>();
        HashMap<String, Arg> hashMap2 = new HashMap<String, Arg>();
        CmdLineParser.parseArgs(objectArray, list, hashMap, hashMap2);
        int n2 = 0;
        for (Arg object : list) {
            int n3 = object.toString().length();
            if (!object.isSwitch) {
                ++n3;
                n3 += object.getResolvedType().toString().length();
                if (object.isCatchAll()) {
                    ++n3;
                } else if (object.isList()) {
                    n3 += 6;
                }
            }
            n2 = Math.max(n2, n3);
        }
        n2 += 2;
        if (bl) {
            Collections.sort(list);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Arg arg : list) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(' ');
            stringBuilder2.append(arg);
            if (!arg.isSwitch) {
                stringBuilder2.append(' ');
                stringBuilder2.append(arg.getResolvedType().toString().toLowerCase());
                if (arg.isCatchAll()) {
                    stringBuilder2.append('s');
                } else if (arg.isList()) {
                    stringBuilder2.append('[');
                    stringBuilder2.append(arg.itemSep);
                    stringBuilder2.append("...]");
                }
            }
            while (stringBuilder2.length() < n2) {
                stringBuilder2.append(' ');
            }
            stringBuilder2.append(':');
            StringBuilder stringBuilder3 = new StringBuilder(arg.desc.trim());
            String string = CmdLineParser.defaultToString(arg.safeFieldGet(), arg.type, arg);
            if (string != null) {
                stringBuilder3.append(" Default is: '");
                stringBuilder3.append(string);
                stringBuilder3.append("'.");
            }
            List<String> list2 = Strings.split(stringBuilder3.toString(), ' ');
            for (String string2 : list2) {
                if (stringBuilder2.length() + string2.length() + 1 > n) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append('\n');
                    stringBuilder2.setLength(0);
                    while (stringBuilder2.length() <= n2) {
                        stringBuilder2.append(' ');
                    }
                    stringBuilder2.append(' ');
                }
                stringBuilder2.append(' ');
                stringBuilder2.append(string2);
            }
            if (stringBuilder2.length() <= n2) continue;
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static List<String> parse(String[] stringArray, Object ... objectArray) throws IOException {
        List<String> list = Colls.list(new String[0]);
        List<Arg> list2 = Colls.list(new Arg[0]);
        HashMap<String, Arg> hashMap = new HashMap<String, Arg>();
        HashMap<String, Arg> hashMap2 = new HashMap<String, Arg>();
        CmdLineParser.parseArgs(objectArray, list2, hashMap, hashMap2);
        for (int i = 0; i < stringArray.length; ++i) {
            Arg arg;
            String object = stringArray[i];
            if (object.startsWith("--")) {
                arg = hashMap2.get(object.substring(2));
                if (arg == null) {
                    throw new IOException("Unknown switch: " + object);
                }
            } else if (object.startsWith("-")) {
                arg = hashMap.get(object.substring(1));
                if (arg == null) {
                    throw new IOException("Unknown switch: " + object);
                }
            } else {
                arg = null;
                list.add(object);
            }
            if (arg == null) continue;
            if (arg.isSwitch) {
                arg.setField("true");
            } else {
                if (i + 1 >= stringArray.length) {
                    System.out.println("Missing parameter for: " + object);
                }
                if (arg.isCatchAll()) {
                    List<String> list3 = Colls.list(new String[0]);
                    ++i;
                    while (i < stringArray.length) {
                        list3.add(stringArray[i]);
                        ++i;
                    }
                    arg.setCatchAll(list3);
                } else {
                    arg.setField(stringArray[++i]);
                }
            }
            arg.setPresent();
        }
        for (Arg arg : list2) {
            if (arg.isOk()) continue;
            throw new IOException("Missing mandatory argument: " + arg);
        }
        return list;
    }

    static {
        for (int i = 0; i < TYPE_CLASS_LIST.length; ++i) {
            TYPE_MAP.put(TYPE_CLASS_LIST[i], TYPE_TYPE_LIST[i]);
        }
    }

    static enum Type {
        UNSUPPORTED,
        STRING,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        LIST,
        BOOL;

    }

    private static final class Classes {
        private Classes() {
        }

        static final boolean implementsInterface(Class<?> clazz, Class<?> clazz2) {
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                if (!clazz3.equals(clazz2)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Arg
    implements Comparable<Arg> {
        final String s;
        final String l;
        final String id;
        final String desc;
        final char itemSep;
        final boolean isSwitch;
        final boolean required;
        final boolean catchAll;
        final boolean printDefault;
        final Type type;
        final Type listType;
        boolean present = false;
        final Object object;
        final Field field;

        public Arg(CmdArgument cmdArgument, Object object, Field field) {
            this.s = cmdArgument.s() == '\u0000' ? "" : Character.toString(cmdArgument.s());
            this.l = cmdArgument.l();
            this.desc = cmdArgument.desc();
            this.isSwitch = cmdArgument.isSwitch();
            this.required = cmdArgument.required();
            this.catchAll = cmdArgument.catchAll();
            this.itemSep = cmdArgument.listSep();
            this.printDefault = cmdArgument.printDefault();
            this.id = this.s + "/" + this.l;
            this.object = object;
            this.field = field;
            this.type = CmdLineParser.getTypeFor(this.field.getType());
            this.listType = CmdLineParser.getTypeFor(cmdArgument.listType());
        }

        public Type getResolvedType() {
            return this.isList() ? this.listType : this.type;
        }

        public boolean isCatchAll() {
            return this.catchAll;
        }

        public boolean isList() {
            return this.type == Type.LIST;
        }

        public void setCatchAll(List<String> list) throws IOException {
            this.setListField(list);
        }

        public void setListField(List<String> list) throws IOException {
            try {
                if (this.listType == Type.STRING) {
                    this.field.set(this.object, list);
                } else {
                    List<Object> list2 = Colls.list(new Object[0]);
                    for (String string : list) {
                        list2.add(this.toObject(string, this.listType));
                    }
                    this.field.set(this.object, list2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Failed to write value", illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Failed to write value", illegalAccessException);
            }
        }

        Object safeFieldGet() {
            try {
                return this.field.get(this.object);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Object toObject(String string, Type type) throws IOException {
            try {
                switch (type) {
                    case STRING: {
                        return string;
                    }
                    case BYTE: {
                        return Byte.parseByte(string);
                    }
                    case SHORT: {
                        return Short.parseShort(string);
                    }
                    case INT: {
                        return Integer.parseInt(string);
                    }
                    case LONG: {
                        return Long.parseLong(string);
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.parseFloat(string));
                    }
                    case DOUBLE: {
                        return Double.parseDouble(string);
                    }
                    case BOOL: {
                        if (BOOL_TRUE.contains(string.toLowerCase())) {
                            return true;
                        }
                        if (BOOL_FALSE.contains(string.toLowerCase())) {
                            return false;
                        }
                        throw new IOException("Illegal bool value for:" + this.toString());
                    }
                }
                throw new IOException("Illegal type: " + type.toString().toLowerCase());
            }
            catch (Throwable throwable) {
                throw new IOException("Parsing error for: " + this.toString() + "; '" + string + "'", throwable);
            }
        }

        public void setField(String string) throws IOException {
            try {
                if (this.isList()) {
                    this.setListField(Strings.split(string, this.itemSep));
                } else {
                    this.field.set(this.object, this.toObject(string, this.type));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Failed to write field: " + this.field.getName(), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Failed to write field: " + this.field.getName(), illegalAccessException);
            }
        }

        public void setPresent() {
            this.present = true;
        }

        public boolean isOk() {
            return !this.required || this.present;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Arg) {
                return this.id.equals(((Arg)object).id);
            }
            return false;
        }

        public String toString() {
            if (Strings.isEmpty(this.s)) {
                return "    --" + this.l;
            }
            if (Strings.isEmpty(this.l)) {
                return "-" + this.s;
            }
            return "-" + this.s + ", --" + this.l;
        }

        @Override
        public int compareTo(Arg arg) {
            String string = Strings.isEmpty(this.s) ? this.l : this.s;
            String string2 = Strings.isEmpty(arg.s) ? arg.l : arg.s;
            return string.compareTo(string2);
        }
    }

    private static class Once<T> {
        private final T first;
        private final T next;
        private boolean isFirst = true;

        public Once(T t, T t2) {
            this.first = t;
            this.next = t2;
        }

        public static <T> Once<T> of(T t, T t2) {
            return new Once<T>(t, t2);
        }

        public T get() {
            if (this.isFirst) {
                this.isFirst = false;
                return this.first;
            }
            return this.next;
        }
    }

    private static final class Strings {
        private Strings() {
        }

        public static final boolean isEmpty(String string) {
            return string == null || string.isEmpty();
        }

        public static final List<String> split(String string, char c) {
            List<String> list = Colls.list(new String[0]);
            if (string != null) {
                int n;
                int n2 = 0;
                for (n = 0; n < string.length(); ++n) {
                    if (string.charAt(n) != c) continue;
                    list.add(string.substring(n2, n));
                    n2 = n + 1;
                }
                list.add(string.substring(n2, n));
            }
            return list;
        }
    }

    private static final class Colls {
        private Colls() {
        }

        static final <T> T[] objArray(T ... TArray) {
            return TArray;
        }

        static final <A> List<A> list(A ... AArray) {
            ArrayList<A> arrayList = new ArrayList<A>(AArray.length);
            for (int i = 0; i < AArray.length; ++i) {
                arrayList.add(AArray[i]);
            }
            return arrayList;
        }
    }
}

