/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark.cmd;

import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import com.github.rjeschke.txtmark.cmd.CmdLineParser;
import com.github.rjeschke.txtmark.cmd.CodeBlockEmitter;
import com.github.rjeschke.txtmark.cmd.TxtmarkArguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class Run {
    private static final void printUsage() {
        try {
            System.out.println("Usage: txtmark [options] [input-file]");
            System.out.println("Options:");
            System.out.println(CmdLineParser.generateHelp(80, false, new TxtmarkArguments()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        TxtmarkArguments txtmarkArguments = new TxtmarkArguments();
        List<Object> list = new ArrayList();
        boolean bl = false;
        try {
            list = CmdLineParser.parse(stringArray, txtmarkArguments);
        }
        catch (IOException iOException) {
            System.out.println("Error: " + iOException.getMessage());
            System.out.println("---");
            bl = true;
        }
        if (txtmarkArguments.printHelp || bl) {
            Run.printUsage();
            System.exit(bl ? 1 : 0);
        }
        Configuration.Builder builder = Configuration.builder();
        builder.setEncoding(txtmarkArguments.encoding).setEnablePanicMode(txtmarkArguments.panicMode).setSafeMode(txtmarkArguments.safeMode).setAllowSpacesInFencedCodeBlockDelimiters(!txtmarkArguments.noFencedSpaced);
        if (txtmarkArguments.forceExtendedProfile) {
            builder.forceExtentedProfile();
        }
        if (txtmarkArguments.highlighter != null && !txtmarkArguments.highlighter.isEmpty()) {
            if (!new File(txtmarkArguments.highlighter).exists()) {
                System.err.println("Program '" + txtmarkArguments.highlighter + "' not found");
                System.exit(1);
            }
            builder.setCodeBlockEmitter(new CodeBlockEmitter(txtmarkArguments.encoding, txtmarkArguments.highlighter));
        }
        Configuration configuration = builder.build();
        boolean bl2 = true;
        InputStream inputStream = null;
        Writer writer = null;
        try {
            String string = list.isEmpty() ? "--" : (String)list.get(0);
            String string2 = txtmarkArguments.outFile;
            inputStream = string.equals("--") ? System.in : new FileInputStream(string);
            String string3 = Processor.process(inputStream, configuration);
            writer = string2 == null ? new OutputStreamWriter((OutputStream)System.out, txtmarkArguments.encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(string2), txtmarkArguments.encoding);
            writer.write(string3);
        }
        catch (IOException iOException) {
            bl2 = false;
            System.err.println("Exception: " + iOException.toString());
            iOException.printStackTrace(System.err);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.exit(bl2 ? 0 : 1);
    }
}

