/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.slurm;

import gridscale.cluster.BatchScheduler;
import gridscale.cluster.HeadNode;
import gridscale.effectaside.package;
import gridscale.slurm.package;
import gridscale.slurm.package$;
import java.io.Serializable;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.plugin.environment.slurm.SLURMEnvironment;
import org.openmole.plugin.environment.ssh.SharedStorage;
import org.openmole.plugin.environment.ssh.SharedStorage$;
import org.openmole.plugin.environment.ssh.package;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class SLURMJobService<S, H> {
    private final S s;
    private final package.RuntimeInstallation<?> installation;
    private final SLURMEnvironment.Parameters parameters;
    private final H h;
    private final AccessControl accessControl;
    private final StorageInterface<S> storageInterface;
    private final HierarchicalStorageInterface<S> hierarchicalStorageInterface;
    private final HeadNode<H> headNode;
    private final BatchEnvironment.Services services;
    private final package.Effect<package.System> systemInterpreter;

    public SLURMJobService(S s, String tmpDirectory, package.RuntimeInstallation<?> installation, SLURMEnvironment.Parameters parameters, H h, AccessControl accessControl, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, HeadNode<H> headNode, BatchEnvironment.Services services, package.Effect<package.System> systemInterpreter) {
        this.s = s;
        this.installation = installation;
        this.parameters = parameters;
        this.h = h;
        this.accessControl = accessControl;
        this.storageInterface = storageInterface;
        this.hierarchicalStorageInterface = hierarchicalStorageInterface;
        this.headNode = headNode;
        this.services = services;
        this.systemInterpreter = systemInterpreter;
    }

    public AccessControl accessControl() {
        return this.accessControl;
    }

    public BatchScheduler.BatchJob submit(SerializedJob serializedJob, String outputPath, String jobDirectory) {
        String workDirectory = (String)this.parameters.workDirectory().getOrElse(SLURMJobService::$anonfun$1);
        SharedStorage.JobScript remoteScript = this.buildScript$1(jobDirectory, workDirectory, serializedJob, outputPath);
        String string = "/bin/bash " + remoteScript.content();
        Option option = this.parameters.cpuPerTask().orElse(this::$anonfun$2);
        List list = this.parameters.gres().toList();
        List list2 = this.parameters.constraints().toList();
        package.SLURMJobDescription description = package.SLURMJobDescription$.MODULE$.apply(string, jobDirectory, this.parameters.partition(), this.parameters.time(), this.parameters.memory(), this.parameters.nodes(), this.parameters.nTasks(), option, this.parameters.qos(), list, list2, this.parameters.reservation(), this.parameters.wckey());
        return (BatchScheduler.BatchJob)this.accessControl().apply(() -> this.submit$$anonfun$1(description));
    }

    public byte state(BatchScheduler.BatchJob id) {
        return BoxesRunTime.unboxToByte((Object)this.accessControl().apply(() -> this.state$$anonfun$1(id)));
    }

    public void delete(BatchScheduler.BatchJob id) {
        this.accessControl().apply((Function0 & Serializable)() -> {
            this.delete$$anonfun$1(id);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<String, String> stdOutErr(BatchScheduler.BatchJob id) {
        return (Tuple2)this.accessControl().apply(() -> this.stdOutErr$$anonfun$1(id));
    }

    private static final String $anonfun$1() {
        return "/tmp";
    }

    private final SharedStorage.JobScript buildScript$1(String jobDirectory$1, String workDirectory$1, SerializedJob serializedJob, String outputPath) {
        return SharedStorage$.MODULE$.buildScript((Function1 & Serializable)runtime -> this.installation.apply(runtime), jobDirectory$1, workDirectory$1, this.parameters.openMOLEMemory(), this.parameters.threads(), serializedJob, outputPath, this.s, this.parameters.modules(), this.parameters.debug(), this.services.newFile(), this.services.preference(), this.storageInterface, this.hierarchicalStorageInterface);
    }

    private final Option $anonfun$2() {
        return this.parameters.threads();
    }

    private final BatchScheduler.BatchJob submit$$anonfun$1(package.SLURMJobDescription description$1) {
        return package$.MODULE$.submit(this.h, description$1, this.headNode, this.systemInterpreter);
    }

    private final byte state$$anonfun$1(BatchScheduler.BatchJob id$1) {
        return GridScaleJobService$.MODULE$.translateStatus(package$.MODULE$.state(this.h, id$1, this.headNode));
    }

    private final void delete$$anonfun$1(BatchScheduler.BatchJob id$2) {
        package$.MODULE$.clean(this.h, id$2, this.headNode);
    }

    private final Tuple2 stdOutErr$$anonfun$1(BatchScheduler.BatchJob id$3) {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.stdOut(this.h, id$3, this.headNode), (Object)package$.MODULE$.stdErr(this.h, id$3, this.headNode));
    }
}

