/*
 * Decompiled with CFR 0.152.
 */
package geny;

import geny.Internal$;
import geny.Writable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Some$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public interface Readable
extends Writable {
    public <T> T readBytesThrough(Function1<InputStream, T> var1);

    public static void writeBytesTo$(Readable $this, OutputStream out) {
        $this.writeBytesTo(out);
    }

    @Override
    default public void writeBytesTo(OutputStream out) {
        this.readBytesThrough((Function1)(JProcedure1 & Serializable)_$1 -> Internal$.MODULE$.transfer((InputStream)_$1, out, Internal$.MODULE$.transfer$default$3(), Internal$.MODULE$.transfer$default$4(), Internal$.MODULE$.transfer$default$5()));
    }

    public static class ByteArrayReadable
    implements Readable {
        private final byte[] a;

        public ByteArrayReadable(byte[] a) {
            this.a = a;
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            return (T)f.apply((Object)new ByteArrayInputStream(this.a));
        }

        @Override
        public Option<String> httpContentType() {
            return Some$.MODULE$.apply((Object)"application/octet-stream");
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(this.a.length)));
        }
    }

    public static class ByteBufferReadable
    implements Readable {
        private final ByteBuffer buffer;

        public ByteBufferReadable(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            ByteBuffer bb = this.buffer.duplicate().order(this.buffer.order());
            InputStream is = new InputStream(bb){
                private final ByteBuffer bb$1;
                {
                    this.bb$1 = bb$2;
                }

                public int read() {
                    return !this.bb$1.hasRemaining() ? -1 : this.bb$1.get() & 0xFF;
                }

                public int read(byte[] bytes, int off, int len) {
                    int n;
                    if (!this.bb$1.hasRemaining()) {
                        n = -1;
                    } else {
                        int l = package$.MODULE$.min(len, this.bb$1.remaining());
                        this.bb$1.get(bytes, off, l);
                        n = l;
                    }
                    return n;
                }
            };
            return (T)f.apply((Object)is);
        }

        @Override
        public Option<String> httpContentType() {
            return Some$.MODULE$.apply((Object)"application/octet-stream");
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(this.buffer.remaining())));
        }
    }

    public static class InputStreamReadable
    implements Writable,
    Readable {
        private final InputStream i;

        public InputStreamReadable(InputStream i) {
            this.i = i;
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            return (T)f.apply((Object)this.i);
        }
    }

    public static class StringReadable
    implements Readable {
        private final String s;

        public StringReadable(String s) {
            this.s = s;
        }

        @Override
        public <T> T readBytesThrough(Function1<InputStream, T> f) {
            return (T)f.apply((Object)new ByteArrayInputStream(this.s.getBytes(StandardCharsets.UTF_8)));
        }

        @Override
        public Option<String> httpContentType() {
            return Some$.MODULE$.apply((Object)"text/plain; charset=utf-8");
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(Internal$.MODULE$.encodedLength(this.s))));
        }
    }
}

