/*
 * Decompiled with CFR 0.152.
 */
package cats.data;

import cats.Always$;
import cats.Eval;
import cats.Foldable$;
import cats.Later$;
import cats.Now$;
import cats.Show;
import cats.Show$;
import cats.UnorderedFoldable$;
import cats.compat.SortedSet$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.NonEmptyMapImpl$;
import cats.data.NonEmptySetImpl$;
import cats.data.package$;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.kernel.Order$;
import cats.kernel.Semigroup;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public class NonEmptySetOps<A> {
    private final Object value;
    private final Ordering<A> ordering;
    private final Order<A> order;

    public NonEmptySetOps(Object value) {
        this.value = value;
        this.ordering = this.toSortedSet().ordering();
        this.order = Order$.MODULE$.fromOrdering(this.ordering);
    }

    public Object value() {
        return this.value;
    }

    public SortedSet<A> toSortedSet() {
        return NonEmptySetImpl$.MODULE$.unwrap(this.value());
    }

    public Object add(A a) {
        return package$.MODULE$.NonEmptySet().create((SortedSet)this.toSortedSet().$plus(a));
    }

    public Object $plus$plus(Object as) {
        return this.union(as);
    }

    public Object $bar(Object as) {
        return this.union(as);
    }

    public SortedSet<A> $minus$minus(Object as) {
        return this.diff(as);
    }

    public SortedSet<A> $amp$tilde(Object as) {
        return this.diff(as);
    }

    public SortedSet<A> $amp(Object as) {
        return this.intersect(as);
    }

    public SortedSet<A> $minus(A a) {
        return (SortedSet)this.toSortedSet().$minus(a);
    }

    public <B> Object map(Function1<A, B> f, Order<B> B) {
        Ordering<B> bOrdering = B.toOrdering();
        return NonEmptySetImpl$.MODULE$.create((SortedSet)this.toSortedSet().map(f, bOrdering));
    }

    public NonEmptyList<A> toNonEmptyList() {
        return NonEmptyList$.MODULE$.fromListUnsafe(this.toSortedSet().toList());
    }

    public A head() {
        return (A)this.toSortedSet().head();
    }

    public SortedSet<A> tail() {
        return (SortedSet)this.toSortedSet().tail();
    }

    public A last() {
        return (A)this.toSortedSet().last();
    }

    public boolean apply(A a) {
        return this.contains(a);
    }

    public boolean contains(A a) {
        return this.toSortedSet().apply(a);
    }

    public SortedSet<A> diff(Object as) {
        return (SortedSet)this.toSortedSet().$minus$minus(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(as).toSortedSet());
    }

    public Object union(Object as) {
        return NonEmptySetImpl$.MODULE$.create((SortedSet)this.toSortedSet().$plus$plus(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(as).toSortedSet()));
    }

    public SortedSet<A> intersect(Object as) {
        NonEmptySetOps nonEmptySetOps = NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(as);
        return (SortedSet)this.toSortedSet().filter((Function1 & Serializable)a -> nonEmptySetOps.apply(a));
    }

    public boolean forall(Function1<A, Object> p) {
        return this.toSortedSet().forall(p);
    }

    public boolean exists(Function1<A, Object> f) {
        return this.toSortedSet().exists(f);
    }

    public Option<A> find(Function1<A, Object> f) {
        return this.toSortedSet().find(f);
    }

    public <B> SortedSet<B> collect(PartialFunction<A, B> pf, Order<B> B) {
        Ordering<B> ordering = B.toOrdering();
        return (SortedSet)this.toSortedSet().collect(pf, ordering);
    }

    public SortedSet<A> filter(Function1<A, Object> p) {
        return (SortedSet)this.toSortedSet().filter(p);
    }

    public SortedSet<A> filterNot(Function1<A, Object> p) {
        return this.filter((Function1 & Serializable)t -> !BoxesRunTime.unboxToBoolean((Object)p.apply(t)));
    }

    public <B> B foldLeft(B b, Function2<B, A, B> f) {
        return (B)this.toSortedSet().foldLeft(b, f);
    }

    public <B> Eval<B> foldRight(Eval<B> lb, Function2<A, Eval<B>, Eval<B>> f) {
        return Foldable$.MODULE$.apply(UnorderedFoldable$.MODULE$.catsFoldableForSortedSet()).foldRight(this.toSortedSet(), lb, f);
    }

    public A reduceLeft(Function2<A, A, A> f) {
        return (A)this.toSortedSet().reduceLeft(f);
    }

    public <B> B reduceLeftTo(Function1<A, B> f, Function2<B, A, B> g) {
        return (B)this.tail().foldLeft(f.apply(this.head()), g);
    }

    public Eval<A> reduceRight(Function2<A, Eval<A>, Eval<A>> f) {
        return this.reduceRightTo((Function1 & Serializable)x -> Predef$.MODULE$.identity(x), f);
    }

    public <B> Eval<B> reduceRightTo(Function1<A, B> f, Function2<A, Eval<B>, Eval<B>> g) {
        return Always$.MODULE$.apply(this::reduceRightTo$$anonfun$1).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Object a = tuple2._1();
                SortedSet ga = (SortedSet)tuple2._2();
                return Foldable$.MODULE$.apply(UnorderedFoldable$.MODULE$.catsFoldableForSortedSet()).reduceRightToOption(ga, f, g).flatMap((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        Object b = ((Some)option).value();
                        return (Eval)g.apply(a, Now$.MODULE$.apply(b));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Later$.MODULE$.apply(() -> NonEmptySetOps.reduceRightTo$$anonfun$2$$anonfun$1$$anonfun$1(f, a));
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <AA> AA reduce(Semigroup<AA> S) {
        return (AA)S.combineAllOption((IterableOnce<AA>)this.toSortedSet()).get();
    }

    public <B> Object concatMap(Function1<A, Object> f, Order<B> B) {
        Ordering<B> ordering = B.toOrdering();
        return NonEmptySetImpl$.MODULE$.create((SortedSet)this.toSortedSet().flatMap((Function1 & Serializable)a -> NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(f.apply(a)).toSortedSet(), ordering));
    }

    public String show(Show<A> A) {
        return new StringBuilder(8).append("NonEmpty").append(Show$.MODULE$.apply(Show$.MODULE$.catsShowForSortedSet(A)).show(this.toSortedSet())).toString();
    }

    public boolean $eq$eq$eq(Object that) {
        return Eq$.MODULE$.apply(Eq$.MODULE$.catsKernelOrderForSortedSet(this.order)).eqv(this.toSortedSet(), NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(that).toSortedSet());
    }

    public int length() {
        return this.toSortedSet().size();
    }

    public <B, C> Object zipWith(Object b, Function2<A, B, C> f, Order<C> C) {
        Ordering<C> cOrdering = C.toOrdering();
        return NonEmptySetImpl$.MODULE$.create((SortedSet)this.toSortedSet().lazyZip(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(b).toSortedSet()).map(f, BuildFrom$.MODULE$.buildFromSortedSetOps(cOrdering)));
    }

    public Object zipWithIndex() {
        return NonEmptySetImpl$.MODULE$.create(SortedSet$.MODULE$.zipWithIndex(this.toSortedSet(), this.ordering));
    }

    public <B> Object groupBy(Function1<A, B> f, Order<B> B) {
        return this.reduceLeftTo((Function1 & Serializable)a -> package$.MODULE$.NonEmptyMap().one(f.apply(a), package$.MODULE$.NonEmptySet().one(a, this.order), B), (Function2 & Serializable)(acc, a) -> {
            Object object;
            Object key = f.apply(a);
            Option option = NonEmptyMapImpl$.MODULE$.catsNonEmptyMapOps(acc).lookup(key);
            if (option instanceof Some) {
                Object nes = ((Some)option).value();
                object = NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(nes).add(a);
            } else {
                object = package$.MODULE$.NonEmptySet().one(a, this.order);
            }
            Object result = object;
            return NonEmptyMapImpl$.MODULE$.catsNonEmptyMapOps(acc).add(Tuple2$.MODULE$.apply(key, result));
        });
    }

    private final Tuple2 reduceRightTo$$anonfun$1() {
        return Tuple2$.MODULE$.apply(this.head(), this.tail());
    }

    private static final Object reduceRightTo$$anonfun$2$$anonfun$1$$anonfun$1(Function1 f$3, Object a$2) {
        return f$3.apply(a$2);
    }
}

