/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.IO;
import cats.effect.kernel.Outcome;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class CallbackStack<A>
extends AtomicReference<CallbackStack<A>> {
    private Function1<Outcome<IO, Throwable, A>, BoxedUnit> callback;

    public CallbackStack(Function1<Outcome<IO, Throwable, A>, BoxedUnit> callback) {
        this.callback = callback;
    }

    public CallbackStack<A> push(Function1<Outcome<IO, Throwable, A>, BoxedUnit> next) {
        CallbackStack<A> attempt = new CallbackStack<A>(next);
        return this.loop$1(attempt);
    }

    public void unsafeSetCallback(Function1<Outcome<IO, Throwable, A>, BoxedUnit> cb) {
        this.callback = cb;
    }

    public boolean apply(Outcome<IO, Throwable, A> oc, boolean invoked) {
        boolean invoked2;
        CallbackStack callbackStack = this;
        boolean bl = invoked;
        while (true) {
            boolean bl2;
            Function1<Outcome<IO, Throwable, A>, BoxedUnit> cb;
            if ((cb = callbackStack.callback) != null) {
                cb.apply(oc);
                bl2 = true;
            } else {
                bl2 = bl;
            }
            invoked2 = bl2;
            CallbackStack next = (CallbackStack)callbackStack.get();
            if (next == null) break;
            CallbackStack callbackStack2 = next;
            boolean bl3 = invoked2;
            callbackStack = callbackStack2;
            bl = bl3;
        }
        return invoked2;
    }

    public void clearCurrent() {
        this.callback = null;
    }

    private final CallbackStack loop$1(CallbackStack attempt$1) {
        CallbackStack cur;
        do {
            cur = (CallbackStack)this.get();
            attempt$1.lazySet(cur);
        } while (!this.compareAndSet(cur, attempt$1));
        return attempt$1;
    }
}

