/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.kernel;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.MonadError;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.IorT;
import cats.data.IorT$;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.data.WriterT;
import cats.data.WriterT$;
import cats.effect.kernel.Clock;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Outcome;
import cats.kernel.Monoid;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface GenTemporal<F, E>
extends GenConcurrent<F, E>,
Clock<F> {
    public static Applicative applicative$(GenTemporal $this) {
        return $this.applicative();
    }

    @Override
    default public Applicative<F> applicative() {
        return this;
    }

    public F sleep(FiniteDuration var1);

    public static Object delayBy$(GenTemporal $this, Object fa, FiniteDuration time) {
        return $this.delayBy(fa, time);
    }

    default public <A> F delayBy(F fa, FiniteDuration time) {
        return this.productR(this.sleep(time), fa);
    }

    public static Object andWait$(GenTemporal $this, Object fa, FiniteDuration time) {
        return $this.andWait(fa, time);
    }

    default public <A> F andWait(F fa, FiniteDuration time) {
        return this.productL(fa, this.sleep(time));
    }

    public static Object timeoutTo$(GenTemporal $this, Object fa, FiniteDuration duration, Object fallback) {
        return $this.timeoutTo(fa, duration, fallback);
    }

    default public <A> F timeoutTo(F fa, FiniteDuration duration, F fallback) {
        return this.flatMap(this.race(fa, this.sleep(duration)), (Function1 & Serializable)x$1 -> {
            Object object;
            Either either = x$1;
            if (either instanceof Left) {
                Object a = ((Left)either).value();
                object = this.pure(a);
            } else if (either instanceof Right) {
                object = fallback;
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        });
    }

    public static Object timeout$(GenTemporal $this, Object fa, FiniteDuration duration, .less.colon.less ev) {
        return $this.timeout(fa, duration, ev);
    }

    default public <A> F timeout(F fa, FiniteDuration duration, .less.colon.less<TimeoutException, E> ev) {
        return this.flatMap(this.race(fa, this.sleep(duration)), (Function1 & Serializable)x$1 -> {
            Object f;
            Either either = x$1;
            if (either instanceof Left) {
                Object a = ((Left)either).value();
                f = this.pure(a);
            } else if (either instanceof Right) {
                f = this.raiseError(ev.apply((Object)new TimeoutException(duration.toString())));
            } else {
                throw new MatchError((Object)either);
            }
            return f;
        });
    }

    public static Object timeoutAndForget$(GenTemporal $this, Object fa, FiniteDuration duration, .less.colon.less ev) {
        return $this.timeoutAndForget(fa, duration, ev);
    }

    default public <A> F timeoutAndForget(F fa, FiniteDuration duration, .less.colon.less<TimeoutException, E> ev) {
        return this.uncancelable((Function1 & Serializable)poll -> {
            GenTemporal F = this;
            return package$all$.MODULE$.toFlatMapOps(this.racePair(fa, this.sleep(duration)), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Object object;
                Tuple2 tuple22;
                Either either = x$1;
                if (either instanceof Left && (tuple22 = (Tuple2)((Left)either).value()) != null) {
                    Outcome oc = (Outcome)tuple22._1();
                    Fiber f = (Fiber)tuple22._2();
                    object = poll.apply(package$all$.MODULE$.catsSyntaxApply(f.cancel(), (Apply)F).$times$greater(oc.embedNever(F)));
                } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                    Fiber f = (Fiber)tuple2._1();
                    object = package$all$.MODULE$.catsSyntaxApply(this.start(f.cancel()), (Apply)F).$times$greater(this.raiseError(ev.apply((Object)new TimeoutException(duration.toString()))));
                } else {
                    throw new MatchError((Object)either);
                }
                return object;
            });
        });
    }

    public static interface EitherTTemporal<F, E0, E>
    extends GenTemporal<EitherT, E>,
    GenConcurrent.EitherTGenConcurrent<F, E0, E>,
    Clock.EitherTClock<F, E0> {
        @Override
        public GenTemporal<F, E> F();

        public static Clock C$(EitherTTemporal $this) {
            return $this.C();
        }

        @Override
        default public Clock<F> C() {
            return this.F();
        }

        public static MonadError delegate$(EitherTTemporal $this) {
            return $this.delegate();
        }

        @Override
        default public MonadError<EitherT, E> delegate() {
            return EitherT$.MODULE$.catsDataMonadErrorFForEitherT(this.F());
        }

        public static EitherT sleep$(EitherTTemporal $this, FiniteDuration time) {
            return $this.sleep(time);
        }

        @Override
        default public EitherT<F, E0, BoxedUnit> sleep(FiniteDuration time) {
            return EitherT$.MODULE$.liftF(this.F().sleep(time), this.F());
        }
    }

    public static interface IorTTemporal<F, L, E>
    extends GenTemporal<IorT, E>,
    GenConcurrent.IorTGenConcurrent<F, L, E>,
    Clock.IorTClock<F, L> {
        @Override
        public GenTemporal<F, E> F();

        public static Clock C$(IorTTemporal $this) {
            return $this.C();
        }

        @Override
        default public Clock<F> C() {
            return this.F();
        }

        public static MonadError delegate$(IorTTemporal $this) {
            return $this.delegate();
        }

        @Override
        default public MonadError<IorT, E> delegate() {
            return IorT$.MODULE$.catsDataMonadErrorFForIorT(this.F(), this.L());
        }

        public static IorT sleep$(IorTTemporal $this, FiniteDuration time) {
            return $this.sleep(time);
        }

        @Override
        default public IorT<F, L, BoxedUnit> sleep(FiniteDuration time) {
            return IorT$.MODULE$.liftF(this.F().sleep(time), this.F());
        }
    }

    public static interface KleisliTemporal<F, R, E>
    extends GenTemporal<Kleisli, E>,
    GenConcurrent.KleisliGenConcurrent<F, R, E>,
    Clock.KleisliClock<F, R> {
        @Override
        public GenTemporal<F, E> F();

        public static Clock C$(KleisliTemporal $this) {
            return $this.C();
        }

        @Override
        default public Clock<F> C() {
            return this.F();
        }

        public static MonadError delegate$(KleisliTemporal $this) {
            return $this.delegate();
        }

        @Override
        default public MonadError<Kleisli, E> delegate() {
            return Kleisli$.MODULE$.catsDataMonadErrorForKleisli(this.F());
        }

        public static Kleisli sleep$(KleisliTemporal $this, FiniteDuration time) {
            return $this.sleep(time);
        }

        @Override
        default public Kleisli<F, R, BoxedUnit> sleep(FiniteDuration time) {
            return Kleisli$.MODULE$.liftF(this.F().sleep(time));
        }
    }

    public static interface OptionTTemporal<F, E>
    extends GenTemporal<OptionT, E>,
    GenConcurrent.OptionTGenConcurrent<F, E>,
    Clock.OptionTClock<F> {
        @Override
        public GenTemporal<F, E> F();

        public static Clock C$(OptionTTemporal $this) {
            return $this.C();
        }

        @Override
        default public Clock<F> C() {
            return this.F();
        }

        public static MonadError delegate$(OptionTTemporal $this) {
            return $this.delegate();
        }

        @Override
        default public MonadError<OptionT, E> delegate() {
            return OptionT$.MODULE$.catsDataMonadErrorForOptionT(this.F());
        }

        public static OptionT sleep$(OptionTTemporal $this, FiniteDuration time) {
            return $this.sleep(time);
        }

        @Override
        default public OptionT<F, BoxedUnit> sleep(FiniteDuration time) {
            return OptionT$.MODULE$.liftF(this.F().sleep(time), this.F());
        }
    }

    public static interface WriterTTemporal<F, L, E>
    extends GenTemporal<WriterT, E>,
    GenConcurrent.WriterTGenConcurrent<F, L, E>,
    Clock.WriterTClock<F, L> {
        @Override
        public GenTemporal<F, E> F();

        public static Clock C$(WriterTTemporal $this) {
            return $this.C();
        }

        @Override
        default public Clock<F> C() {
            return this.F();
        }

        @Override
        public Monoid<L> L();

        public static MonadError delegate$(WriterTTemporal $this) {
            return $this.delegate();
        }

        @Override
        default public MonadError<WriterT, E> delegate() {
            return WriterT$.MODULE$.catsDataMonadErrorForWriterT(this.F(), this.L());
        }

        public static WriterT sleep$(WriterTTemporal $this, FiniteDuration time) {
            return $this.sleep(time);
        }

        @Override
        default public WriterT<F, L, BoxedUnit> sleep(FiniteDuration time) {
            return WriterT$.MODULE$.liftF(this.F().sleep(time), this.L(), this.F());
        }
    }
}

