/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Functor;
import cats.Invariant;
import cats.effect.kernel.GenConcurrent;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.std.Queue$State$;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class Queue$
implements Serializable {
    public static final Queue$State$ cats$effect$std$Queue$$$State;
    public static final Queue$ MODULE$;

    private Queue$() {
    }

    static {
        MODULE$ = new Queue$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Queue$.class);
    }

    public <F, A> Object bounded(int capacity, GenConcurrent<F, ?> F) {
        this.assertNonNegative(capacity);
        return package$all$.MODULE$.toFunctorOps((Object)F.ref(Queue$State$.MODULE$.empty()), (Functor)F).map((Function1 & Serializable)_$4 -> new Queue.BoundedQueue(capacity, _$4, F));
    }

    public <F, A> Object synchronous(GenConcurrent<F, ?> F) {
        return this.bounded(0, F);
    }

    public <F, A> Object unbounded(GenConcurrent<F, ?> F) {
        return this.bounded(Integer.MAX_VALUE, F);
    }

    public <F, A> Object dropping(int capacity, GenConcurrent<F, ?> F) {
        this.assertPositive(capacity, "Dropping");
        return package$all$.MODULE$.toFunctorOps((Object)F.ref(Queue$State$.MODULE$.empty()), (Functor)F).map((Function1 & Serializable)_$8 -> new Queue.DroppingQueue(capacity, _$8, F));
    }

    public <F, A> Object circularBuffer(int capacity, GenConcurrent<F, ?> F) {
        this.assertPositive(capacity, "CircularBuffer");
        return package$all$.MODULE$.toFunctorOps((Object)F.ref(Queue$State$.MODULE$.empty()), (Functor)F).map((Function1 & Serializable)_$10 -> new Queue.CircularBufferQueue(capacity, _$10, F));
    }

    private void assertNonNegative(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Bounded queue capacity must be non-negative, was: " + capacity);
        }
    }

    private void assertPositive(int capacity, String name) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("" + name + " queue capacity must be positive, was: " + capacity);
        }
    }

    public <F> Invariant<Queue> catsInvariantForQueue(Functor<F> evidence$1) {
        return new Invariant<Queue>(evidence$1){
            public final Functor cats$effect$std$Queue$$anon$2$$evidence$1$1;
            {
                this.cats$effect$std$Queue$$anon$2$$evidence$1$1 = evidence$1$2;
            }

            public Queue imap(Queue fa, Function1 f, Function1 g) {
                return new Queue<F, B>(fa, f, g, this){
                    private final Queue fa$1;
                    private final Function1 f$1;
                    private final Function1 g$1;
                    private final anon.2 $outer;
                    {
                        this.fa$1 = fa$4;
                        this.f$1 = f$6;
                        this.g$1 = g$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Object offer(Object b) {
                        return this.fa$1.offer(this.g$1.apply(b));
                    }

                    public Object tryOffer(Object b) {
                        return this.fa$1.tryOffer(this.g$1.apply(b));
                    }

                    public Object take() {
                        return package$all$.MODULE$.toFunctorOps((Object)this.fa$1.take(), this.$outer.cats$effect$std$Queue$$anon$2$$evidence$1$1).map(this.f$1);
                    }

                    public Object tryTake() {
                        return package$all$.MODULE$.toFunctorOps((Object)this.fa$1.tryTake(), this.$outer.cats$effect$std$Queue$$anon$2$$evidence$1$1).map((Function1 & Serializable)_$23 -> _$23.map(this.f$1));
                    }

                    public Object size() {
                        return this.fa$1.size();
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{tryTake$$anonfun$1(scala.Option )}, serializedLambda);
                    }
                };
            }
        };
    }
}

