/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative$;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Monad$;
import cats.arrow.FunctionK;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$;
import cats.effect.kernel.Ref$ApplyBuilders$;
import cats.effect.kernel.Ref$Make$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.std.Random$;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface Random<F> {
    public F betweenDouble(double var1, double var3);

    public F betweenFloat(float var1, float var2);

    public F betweenInt(int var1, int var2);

    public F betweenLong(long var1, long var3);

    public F nextAlphaNumeric();

    public F nextBoolean();

    public F nextBytes(int var1);

    public F nextDouble();

    public F nextFloat();

    public F nextGaussian();

    public F nextInt();

    public F nextIntBounded(int var1);

    public F nextLong();

    public F nextLongBounded(long var1);

    public F nextPrintableChar();

    public F nextString(int var1);

    public <A> F shuffleList(List<A> var1);

    public <A> F shuffleVector(Vector<A> var1);

    public static Random mapK$(Random $this, FunctionK f) {
        return $this.mapK(f);
    }

    default public <G> Random<G> mapK(FunctionK<F, G> f) {
        return new Random<G>(f, this){
            private final FunctionK f$1;
            private final Random $outer;
            {
                this.f$1 = f$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object betweenDouble(double minInclusive, double maxExclusive) {
                return this.f$1.apply(this.$outer.betweenDouble(minInclusive, maxExclusive));
            }

            public Object betweenFloat(float minInclusive, float maxExclusive) {
                return this.f$1.apply(this.$outer.betweenFloat(minInclusive, maxExclusive));
            }

            public Object betweenInt(int minInclusive, int maxExclusive) {
                return this.f$1.apply(this.$outer.betweenInt(minInclusive, maxExclusive));
            }

            public Object betweenLong(long minInclusive, long maxExclusive) {
                return this.f$1.apply(this.$outer.betweenLong(minInclusive, maxExclusive));
            }

            public Object nextAlphaNumeric() {
                return this.f$1.apply(this.$outer.nextAlphaNumeric());
            }

            public Object nextBoolean() {
                return this.f$1.apply(this.$outer.nextBoolean());
            }

            public Object nextBytes(int n) {
                return this.f$1.apply(this.$outer.nextBytes(n));
            }

            public Object nextDouble() {
                return this.f$1.apply(this.$outer.nextDouble());
            }

            public Object nextFloat() {
                return this.f$1.apply(this.$outer.nextFloat());
            }

            public Object nextGaussian() {
                return this.f$1.apply(this.$outer.nextGaussian());
            }

            public Object nextInt() {
                return this.f$1.apply(this.$outer.nextInt());
            }

            public Object nextIntBounded(int n) {
                return this.f$1.apply(this.$outer.nextIntBounded(n));
            }

            public Object nextLong() {
                return this.f$1.apply(this.$outer.nextLong());
            }

            public Object nextLongBounded(long n) {
                return this.f$1.apply(this.$outer.nextLongBounded(n));
            }

            public Object nextPrintableChar() {
                return this.f$1.apply(this.$outer.nextPrintableChar());
            }

            public Object nextString(int length) {
                return this.f$1.apply(this.$outer.nextString(length));
            }

            public Object shuffleList(List l) {
                return this.f$1.apply(this.$outer.shuffleList(l));
            }

            public Object shuffleVector(Vector v) {
                return this.f$1.apply(this.$outer.shuffleVector(v));
            }
        };
    }

    private static abstract class RandomCommon<F>
    implements Random<F> {
        private final Sync<F> evidence$24;

        public RandomCommon(Sync<F> evidence$24) {
            this.evidence$24 = evidence$24;
        }

        @Override
        public F betweenDouble(double minInclusive, double maxExclusive) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenDouble$$anonfun$1)), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return package$all$.MODULE$.toFunctorOps(this.nextDouble(), (Functor)this.evidence$24).map((JFunction1.mcDD.sp & Serializable)d -> {
                    double next = d * (maxExclusive - minInclusive) + minInclusive;
                    return next < maxExclusive ? next : Math.nextAfter(maxExclusive, Double.NEGATIVE_INFINITY);
                });
            });
        }

        @Override
        public F betweenFloat(float minInclusive, float maxExclusive) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenFloat$$anonfun$1)), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return package$all$.MODULE$.toFunctorOps(this.nextFloat(), (Functor)this.evidence$24).map((JFunction1.mcFF.sp & Serializable)f -> {
                    float next = f * (maxExclusive - minInclusive) + minInclusive;
                    return next < maxExclusive ? next : Math.nextAfter(maxExclusive, Double.NEGATIVE_INFINITY);
                });
            });
        }

        @Override
        public F betweenInt(int minInclusive, int maxExclusive) {
            int difference = maxExclusive - minInclusive;
            return package$all$.MODULE$.catsSyntaxApply((Object)this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenInt$$anonfun$1)), (Apply)this.evidence$24).$times$greater(package$all$.MODULE$.toFunctorOps(difference >= 0 ? package$all$.MODULE$.toFunctorOps(this.nextIntBounded(difference), (Functor)this.evidence$24).map((JFunction1.mcII.sp & Serializable)_$29 -> _$29 + minInclusive) : this.loop$1(minInclusive, maxExclusive), (Functor)this.evidence$24).map((JFunction1.mcII.sp & Serializable)out -> out));
        }

        @Override
        public F betweenLong(long minInclusive, long maxExclusive) {
            long difference = maxExclusive - minInclusive;
            return package$all$.MODULE$.catsSyntaxApply((Object)this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenLong$$anonfun$1)), (Apply)this.evidence$24).$times$greater(package$all$.MODULE$.toFunctorOps(difference >= 0L ? package$all$.MODULE$.toFunctorOps((Object)this.nextLongBounded(difference), (Functor)this.evidence$24).map((JFunction1.mcJJ.sp & Serializable)_$30 -> _$30 + minInclusive) : this.loop$2(minInclusive, maxExclusive), (Functor)this.evidence$24).map((JFunction1.mcJJ.sp & Serializable)out -> out));
        }

        @Override
        public F nextAlphaNumeric() {
            String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            return package$all$.MODULE$.toFunctorOps(this.nextIntBounded(chars.length()), (Functor)this.evidence$24).map((Function1 & Serializable)_$31 -> this.nextAlphaNumeric$$anonfun$1(chars, BoxesRunTime.unboxToInt((Object)_$31)));
        }

        @Override
        public F nextLongBounded(long n) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.require(n > 0L, (Function0<String>)((Function0 & Serializable)() -> this.nextLongBounded$$anonfun$1(n))), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                Ref.Make make = Ref$.MODULE$.apply(Ref$Make$.MODULE$.syncInstance((Sync)this.evidence$24));
                return package$all$.MODULE$.toFlatMapOps(Ref$ApplyBuilders$.MODULE$.of$extension(make, BoxesRunTime.boxToLong((long)0L)), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)offset -> {
                    Ref.Make make = Ref$.MODULE$.apply(Ref$Make$.MODULE$.syncInstance((Sync)this.evidence$24));
                    return package$all$.MODULE$.toFlatMapOps(Ref$ApplyBuilders$.MODULE$.of$extension(make, BoxesRunTime.boxToLong((long)n)), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)_n -> package$all$.MODULE$.toFlatMapOps((Object)Monad$.MODULE$.apply(this.evidence$24).whileM_(package$all$.MODULE$.toFunctorOps(_n.get(), (Functor)this.evidence$24).map((JFunction1.mcZJ.sp & Serializable)_$32 -> _$32 >= Integer.MAX_VALUE), () -> this.nextLongBounded$$anonfun$17$$anonfun$15$$anonfun$15$$anonfun$15(offset, _n)), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return package$all$.MODULE$.toFlatMapOps(offset.get(), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)finalOffset -> this.nextLongBounded$$anonfun$21$$anonfun$19$$anonfun$19$$anonfun$19$$anonfun$4((Ref)_n, BoxesRunTime.unboxToLong((Object)finalOffset)));
                    }));
                });
            });
        }

        private F require(boolean condition, Function0<String> errorMessage) {
            Object object;
            if (condition) {
                BoxedUnit boxedUnit = (BoxedUnit)package$all$.MODULE$.catsSyntaxApplicativeId(BoxedUnit.UNIT);
                object = ApplicativeIdOps$.MODULE$.pure$extension(boxedUnit, this.evidence$24);
            } else {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)package$all$.MODULE$.catsSyntaxApplicativeErrorId(new IllegalArgumentException((String)errorMessage.apply()));
                object = ApplicativeErrorIdOps$.MODULE$.raiseError$extension(illegalArgumentException, this.evidence$24);
            }
            return (F)object;
        }

        private final String betweenDouble$$anonfun$1() {
            return "Invalid bounds";
        }

        private final String betweenFloat$$anonfun$1() {
            return "Invalid bounds";
        }

        private final String betweenInt$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ Object loop$3$$anonfun$1(int minInclusive$7, int maxExclusive$6, int n) {
            Object object;
            if (n >= minInclusive$7 && n < maxExclusive$6) {
                Integer n2 = (Integer)package$all$.MODULE$.catsSyntaxApplicativeId(BoxesRunTime.boxToInteger((int)n));
                object = ApplicativeIdOps$.MODULE$.pure$extension(n2, this.evidence$24);
            } else {
                object = this.loop$1(minInclusive$7, maxExclusive$6);
            }
            return object;
        }

        private final Object loop$1(int minInclusive$6, int maxExclusive$5) {
            return package$all$.MODULE$.toFlatMapOps(this.nextInt(), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)n -> this.loop$3$$anonfun$1(minInclusive$6, maxExclusive$5, BoxesRunTime.unboxToInt((Object)n)));
        }

        private final String betweenLong$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ Object loop$5$$anonfun$1(long minInclusive$10, long maxExclusive$8, long n) {
            Object object;
            if (n >= minInclusive$10 && n < maxExclusive$8) {
                Long l = (Long)package$all$.MODULE$.catsSyntaxApplicativeId(BoxesRunTime.boxToLong((long)n));
                object = ApplicativeIdOps$.MODULE$.pure$extension(l, this.evidence$24);
            } else {
                object = this.loop$2(minInclusive$10, maxExclusive$8);
            }
            return object;
        }

        private final Object loop$2(long minInclusive$9, long maxExclusive$7) {
            return package$all$.MODULE$.toFlatMapOps(this.nextLong(), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)n -> this.loop$5$$anonfun$1(minInclusive$9, maxExclusive$7, BoxesRunTime.unboxToLong((Object)n)));
        }

        private final /* synthetic */ char nextAlphaNumeric$$anonfun$1(String chars$1, int _$31) {
            return chars$1.charAt(_$31);
        }

        private final String nextLongBounded$$anonfun$1(long n$15) {
            return "n must be positive, but was " + n$15;
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$7$$anonfun$5$$anonfun$5$$anonfun$5$$anonfun$4$$anonfun$4$$anonfun$3$$anonfun$2(Ref offset$6, long nextN$1, long n) {
            return offset$6.update((JFunction1.mcJJ.sp & Serializable)_$35 -> _$35 + (n - nextN$1));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$11$$anonfun$9$$anonfun$9$$anonfun$9$$anonfun$8$$anonfun$8$$anonfun$7(Ref offset$4, Ref _n$4, int bits$2, long nextN) {
            return package$all$.MODULE$.toFlatMapOps((bits$2 & 1) == 0 ? package$all$.MODULE$.toFlatMapOps(_n$4.get(), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)n -> this.nextLongBounded$$anonfun$7$$anonfun$5$$anonfun$5$$anonfun$5$$anonfun$4$$anonfun$4$$anonfun$3$$anonfun$2(offset$4, nextN, BoxesRunTime.unboxToLong((Object)n))) : Applicative$.MODULE$.apply(this.evidence$24).unit(), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return package$all$.MODULE$.toFunctorOps(_n$4.set(BoxesRunTime.boxToLong((long)nextN)), (Functor)this.evidence$24).map((JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$13$$anonfun$11$$anonfun$11$$anonfun$11$$anonfun$10$$anonfun$10(Ref offset$3, Ref _n$3, int bits$1, long halfn) {
            Object object;
            if ((bits$1 & 2) == 0) {
                Long l = (Long)package$all$.MODULE$.catsSyntaxApplicativeId(BoxesRunTime.boxToLong((long)halfn));
                object = ApplicativeIdOps$.MODULE$.pure$extension(l, this.evidence$24);
            } else {
                object = package$all$.MODULE$.toFunctorOps(_n$3.get(), (Functor)this.evidence$24).map((JFunction1.mcJJ.sp & Serializable)_$34 -> _$34 - halfn);
            }
            return package$all$.MODULE$.toFlatMapOps(object, (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)nextN -> this.nextLongBounded$$anonfun$11$$anonfun$9$$anonfun$9$$anonfun$9$$anonfun$8$$anonfun$8$$anonfun$7(offset$3, _n$3, bits$1, BoxesRunTime.unboxToLong((Object)nextN)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$15$$anonfun$13$$anonfun$13$$anonfun$13$$anonfun$12(Ref offset$2, Ref _n$2, int bits) {
            return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFunctorOps(_n$2.get(), (Functor)this.evidence$24).map((JFunction1.mcJJ.sp & Serializable)_$33 -> _$33 >>> 1), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)halfn -> this.nextLongBounded$$anonfun$13$$anonfun$11$$anonfun$11$$anonfun$11$$anonfun$10$$anonfun$10(offset$2, _n$2, bits, BoxesRunTime.unboxToLong((Object)halfn)));
        }

        private final Object nextLongBounded$$anonfun$17$$anonfun$15$$anonfun$15$$anonfun$15(Ref offset$1, Ref _n$1) {
            return package$all$.MODULE$.toFlatMapOps(this.nextIntBounded(2), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)bits -> this.nextLongBounded$$anonfun$15$$anonfun$13$$anonfun$13$$anonfun$13$$anonfun$12(offset$1, _n$1, BoxesRunTime.unboxToInt((Object)bits)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$18$$anonfun$16$$anonfun$16$$anonfun$16$$anonfun$1$$anonfun$1(long l) {
            return this.nextIntBounded((int)l);
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$21$$anonfun$19$$anonfun$19$$anonfun$19$$anonfun$4(Ref _n$7, long finalOffset) {
            return package$all$.MODULE$.toFunctorOps(package$all$.MODULE$.toFlatMapOps(_n$7.get(), (FlatMap)this.evidence$24).flatMap((Function1 & Serializable)l -> this.nextLongBounded$$anonfun$18$$anonfun$16$$anonfun$16$$anonfun$16$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)l))), (Functor)this.evidence$24).map((JFunction1.mcJI.sp & Serializable)n -> finalOffset + (long)n);
        }
    }

    private static abstract class ScalaRandom<F>
    extends RandomCommon<F> {
        private final F f;
        private final Sync<F> evidence$25;

        public ScalaRandom(Object f, Sync<F> evidence$25) {
            this.f = f;
            this.evidence$25 = evidence$25;
            super(evidence$25);
        }

        @Override
        public F nextBoolean() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextBoolean$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((Function1 & Serializable)out -> this.nextBoolean$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)out))));
        }

        @Override
        public F nextBytes(int n) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextBytes$$anonfun$2$$anonfun$1(n, r)), (Functor)this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        @Override
        public F nextDouble() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextDouble$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((JFunction1.mcDD.sp & Serializable)out -> out));
        }

        @Override
        public F nextFloat() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextFloat$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((JFunction1.mcFF.sp & Serializable)out -> out));
        }

        @Override
        public F nextGaussian() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextGaussian$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((JFunction1.mcDD.sp & Serializable)out -> out));
        }

        @Override
        public F nextInt() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextInt$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((JFunction1.mcII.sp & Serializable)out -> out));
        }

        @Override
        public F nextIntBounded(int n) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextIntBounded$$anonfun$2$$anonfun$1(n, r)), (Functor)this.evidence$25).map((JFunction1.mcII.sp & Serializable)out -> out));
        }

        @Override
        public F nextLong() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextLong$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((JFunction1.mcJJ.sp & Serializable)out -> out));
        }

        @Override
        public F nextPrintableChar() {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextPrintableChar$$anonfun$2$$anonfun$1(r)), (Functor)this.evidence$25).map((Function1 & Serializable)out -> this.nextPrintableChar$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToChar((Object)out))));
        }

        @Override
        public F nextString(int length) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextString$$anonfun$2$$anonfun$1(length, r)), (Functor)this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.shuffleList$$anonfun$2$$anonfun$1(l, r)), (Functor)this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return package$all$.MODULE$.toFlatMapOps((Object)this.f, (FlatMap)this.evidence$25).flatMap((Function1 & Serializable)r -> package$all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.shuffleVector$$anonfun$2$$anonfun$1(v, r)), (Functor)this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        private final boolean nextBoolean$$anonfun$2$$anonfun$1(scala.util.Random r$1) {
            return r$1.nextBoolean();
        }

        private final /* synthetic */ boolean nextBoolean$$anonfun$3$$anonfun$2(boolean out) {
            return out;
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] nextBytes$$anonfun$2$$anonfun$1(int n$20, scala.util.Random r$2) {
            void var3_3;
            byte[] bytes = new byte[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), n$20)];
            r$2.nextBytes(bytes);
            return var3_3;
        }

        private final double nextDouble$$anonfun$2$$anonfun$1(scala.util.Random r$3) {
            return r$3.nextDouble();
        }

        private final float nextFloat$$anonfun$2$$anonfun$1(scala.util.Random r$4) {
            return r$4.nextFloat();
        }

        private final double nextGaussian$$anonfun$2$$anonfun$1(scala.util.Random r$5) {
            return r$5.nextGaussian();
        }

        private final int nextInt$$anonfun$2$$anonfun$1(scala.util.Random r$6) {
            return r$6.nextInt();
        }

        private final int nextIntBounded$$anonfun$2$$anonfun$1(int n$21, scala.util.Random r$7) {
            return r$7.self().nextInt(n$21);
        }

        private final long nextLong$$anonfun$2$$anonfun$1(scala.util.Random r$8) {
            return r$8.nextLong();
        }

        private final char nextPrintableChar$$anonfun$2$$anonfun$1(scala.util.Random r$9) {
            return r$9.nextPrintableChar();
        }

        private final /* synthetic */ char nextPrintableChar$$anonfun$3$$anonfun$2(char out) {
            return out;
        }

        private final String nextString$$anonfun$2$$anonfun$1(int length$1, scala.util.Random r$10) {
            return r$10.nextString(length$1);
        }

        private final List shuffleList$$anonfun$2$$anonfun$1(List l$1, scala.util.Random r$11) {
            return (List)r$11.shuffle((IterableOnce)l$1, BuildFrom$.MODULE$.buildFromIterableOps());
        }

        private final Vector shuffleVector$$anonfun$2$$anonfun$1(Vector v$1, scala.util.Random r$12) {
            return (Vector)r$12.shuffle((IterableOnce)v$1, BuildFrom$.MODULE$.buildFromIterableOps());
        }
    }

    private static abstract class ThreadLocalRandom<F>
    extends RandomCommon<F> {
        private final Sync<F> evidence$26;

        public ThreadLocalRandom(Sync<F> evidence$26) {
            this.evidence$26 = evidence$26;
            super(evidence$26);
        }

        @Override
        public F nextBoolean() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextBoolean$$anonfun$1);
        }

        @Override
        public F nextBytes(int n) {
            return Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.nextBytes$$anonfun$1(n));
        }

        @Override
        public F nextDouble() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextDouble$$anonfun$1);
        }

        @Override
        public F nextFloat() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextFloat$$anonfun$1);
        }

        @Override
        public F nextGaussian() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextGaussian$$anonfun$1);
        }

        @Override
        public F nextInt() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextInt$$anonfun$1);
        }

        @Override
        public F nextIntBounded(int n) {
            return Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.nextIntBounded$$anonfun$1(n));
        }

        @Override
        public F nextLong() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextLong$$anonfun$1);
        }

        @Override
        public F nextPrintableChar() {
            return Sync$.MODULE$.apply(this.evidence$26).delay(this::nextPrintableChar$$anonfun$1);
        }

        @Override
        public F nextString(int length) {
            return Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.nextString$$anonfun$1(length));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.shuffleList$$anonfun$1(l));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.shuffleVector$$anonfun$1(v));
        }

        private final boolean nextBoolean$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextBoolean();
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] nextBytes$$anonfun$1(int n$23) {
            void var2_2;
            byte[] bytes = new byte[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), n$23)];
            Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextBytes(bytes);
            return var2_2;
        }

        private final double nextDouble$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextDouble();
        }

        private final float nextFloat$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextFloat();
        }

        private final double nextGaussian$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextGaussian();
        }

        private final int nextInt$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextInt();
        }

        private final int nextIntBounded$$anonfun$1(int n$24) {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().self().nextInt(n$24);
        }

        private final long nextLong$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextLong();
        }

        private final char nextPrintableChar$$anonfun$1() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextPrintableChar();
        }

        private final String nextString$$anonfun$1(int length$3) {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextString(length$3);
        }

        private final List shuffleList$$anonfun$1(List l$3) {
            return (List)Random$.MODULE$.cats$effect$std$Random$$$localRandom().shuffle((IterableOnce)l$3, BuildFrom$.MODULE$.buildFromIterableOps());
        }

        private final Vector shuffleVector$$anonfun$1(Vector v$3) {
            return (Vector)Random$.MODULE$.cats$effect$std$Random$$$localRandom().shuffle((IterableOnce)v$3, BuildFrom$.MODULE$.buildFromIterableOps());
        }
    }
}

