/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std.internal;

import cats.effect.std.internal.BankersQueue$;
import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BankersQueue<A>
implements Product,
Serializable {
    private final List front;
    private final int frontLen;
    private final List back;
    private final int backLen;

    public static <A> BankersQueue<A> apply(List<A> list, int n, List<A> list2, int n2) {
        return BankersQueue$.MODULE$.apply(list, n, list2, n2);
    }

    public static <A> BankersQueue<A> empty() {
        return BankersQueue$.MODULE$.empty();
    }

    public static BankersQueue fromProduct(Product product) {
        return BankersQueue$.MODULE$.fromProduct(product);
    }

    public static int rebalanceConstant() {
        return BankersQueue$.MODULE$.rebalanceConstant();
    }

    public static <A> BankersQueue<A> unapply(BankersQueue<A> bankersQueue) {
        return BankersQueue$.MODULE$.unapply(bankersQueue);
    }

    public BankersQueue(List<A> front, int frontLen, List<A> back, int backLen) {
        this.front = front;
        this.frontLen = frontLen;
        this.back = back;
        this.backLen = backLen;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.front()));
        n = Statics.mix((int)n, (int)this.frontLen());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.back()));
        n = Statics.mix((int)n, (int)this.backLen());
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BankersQueue)) return false;
        BankersQueue bankersQueue = (BankersQueue)object;
        if (this.frontLen() != bankersQueue.frontLen()) return false;
        if (this.backLen() != bankersQueue.backLen()) return false;
        List<A> list = this.front();
        List<A> list2 = bankersQueue.front();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<A> list3 = this.back();
        List<A> list4 = bankersQueue.back();
        if (list3 == null) {
            if (list4 == null) return true;
            return false;
        } else {
            if (!list3.equals(list4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BankersQueue;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "BankersQueue";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this._4());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "front";
                break;
            }
            case 1: {
                string = "frontLen";
                break;
            }
            case 2: {
                string = "back";
                break;
            }
            case 3: {
                string = "backLen";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public List<A> front() {
        return this.front;
    }

    public int frontLen() {
        return this.frontLen;
    }

    public List<A> back() {
        return this.back;
    }

    public int backLen() {
        return this.backLen;
    }

    public boolean nonEmpty() {
        return this.frontLen() > 0 || this.backLen() > 0;
    }

    public BankersQueue<A> pushFront(A a) {
        return super.rebalance();
    }

    public BankersQueue<A> pushBack(A a) {
        return super.rebalance();
    }

    public Tuple2<BankersQueue<A>, Option<A>> tryPopFront() {
        Tuple2 tuple2;
        if (this.frontLen() > 0) {
            BankersQueue bankersQueue = (BankersQueue)Predef$.MODULE$.ArrowAssoc(super.rebalance());
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bankersQueue, (Object)Some$.MODULE$.apply(this.front().head()));
        } else if (this.backLen() > 0) {
            BankersQueue bankersQueue = (BankersQueue)Predef$.MODULE$.ArrowAssoc(BankersQueue$.MODULE$.apply(this.front(), this.frontLen(), package$.MODULE$.Nil(), 0));
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bankersQueue, (Object)Some$.MODULE$.apply(this.back().head()));
        } else {
            BankersQueue bankersQueue = (BankersQueue)Predef$.MODULE$.ArrowAssoc((Object)this);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bankersQueue, (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public Tuple2<BankersQueue<A>, Option<A>> tryPopBack() {
        Tuple2 tuple2;
        if (this.backLen() > 0) {
            BankersQueue bankersQueue = (BankersQueue)Predef$.MODULE$.ArrowAssoc(super.rebalance());
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bankersQueue, (Object)Some$.MODULE$.apply(this.back().head()));
        } else if (this.frontLen() > 0) {
            BankersQueue bankersQueue = (BankersQueue)Predef$.MODULE$.ArrowAssoc(BankersQueue$.MODULE$.apply(package$.MODULE$.Nil(), 0, this.back(), this.backLen()));
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bankersQueue, (Object)Some$.MODULE$.apply(this.front().head()));
        } else {
            BankersQueue bankersQueue = (BankersQueue)Predef$.MODULE$.ArrowAssoc((Object)this);
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bankersQueue, (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public BankersQueue<A> reverse() {
        return BankersQueue$.MODULE$.apply(this.back(), this.backLen(), this.front(), this.frontLen());
    }

    private BankersQueue<A> rebalance() {
        BankersQueue bankersQueue;
        if (this.frontLen() > BankersQueue$.MODULE$.rebalanceConstant() * this.backLen() + 1) {
            int i = (this.frontLen() + this.backLen()) / 2;
            int j = this.frontLen() + this.backLen() - i;
            List f = this.front().take(i);
            List b = (List)this.back().$plus$plus((IterableOnce)((List)this.front().drop(i)).reverse());
            bankersQueue = BankersQueue$.MODULE$.apply(f, i, b, j);
        } else if (this.backLen() > BankersQueue$.MODULE$.rebalanceConstant() * this.frontLen() + 1) {
            int i = (this.frontLen() + this.backLen()) / 2;
            int j = this.frontLen() + this.backLen() - i;
            List f = (List)this.front().$plus$plus((IterableOnce)((List)this.back().drop(j)).reverse());
            List b = this.back().take(j);
            bankersQueue = BankersQueue$.MODULE$.apply(f, i, b, j);
        } else {
            bankersQueue = this;
        }
        return bankersQueue;
    }

    public <A> BankersQueue<A> copy(List<A> front, int frontLen, List<A> back, int backLen) {
        return new BankersQueue<A>(front, frontLen, back, backLen);
    }

    public <A> List<A> copy$default$1() {
        return this.front();
    }

    public int copy$default$2() {
        return this.frontLen();
    }

    public <A> List<A> copy$default$3() {
        return this.back();
    }

    public int copy$default$4() {
        return this.backLen();
    }

    public List<A> _1() {
        return this.front();
    }

    public int _2() {
        return this.frontLen();
    }

    public List<A> _3() {
        return this.back();
    }

    public int _4() {
        return this.backLen();
    }
}

