/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.FiberMonitor$;
import cats.effect.unsafe.FiberMonitorShared;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class FiberMonitor
extends FiberMonitorShared {
    private final WorkStealingThreadPool compute;
    private final ThreadLocal<WeakBag<IOFiber<?>>> Bags;
    private final ConcurrentLinkedQueue<WeakReference<WeakBag<IOFiber<?>>>> BagReferences;

    public static FiberMonitor apply(ExecutionContext executionContext) {
        return FiberMonitor$.MODULE$.apply(executionContext);
    }

    public FiberMonitor(WorkStealingThreadPool compute) {
        this.compute = compute;
        this.Bags = FiberMonitor$.MODULE$.Bags();
        this.BagReferences = FiberMonitor$.MODULE$.BagReferences();
    }

    public WeakBag.Handle monitorSuspended(IOFiber<?> fiber) {
        WorkerThread worker;
        Thread thread = Thread.currentThread();
        return thread instanceof WorkerThread ? ((worker = (WorkerThread)thread).isOwnedBy(this.compute) ? worker.monitor(fiber) : this.monitorFallback(fiber)) : this.monitorFallback(fiber);
    }

    public void liveFiberSnapshot(Function1<String, BoxedUnit> print) {
        if (TracingConstants.isStackTracing) {
            Option$.MODULE$.apply((Object)this.compute).fold((Function0)((JFunction0.mcV.sp & Serializable)() -> this.liveFiberSnapshot$$anonfun$1(print)), (Function1)(JProcedure1 & Serializable)compute -> {
                Tuple3<scala.collection.immutable.Set<IOFiber<?>>, Map<WorkerThread, Tuple2<Option<IOFiber<?>>, scala.collection.immutable.Set<IOFiber<?>>>>, scala.collection.immutable.Set<IOFiber<?>>> tuple3 = compute.liveFibers();
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                scala.collection.immutable.Set rawExternal = (scala.collection.immutable.Set)tuple3._1();
                Map workersMap = (Map)tuple3._2();
                scala.collection.immutable.Set rawSuspended = (scala.collection.immutable.Set)tuple3._3();
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)rawExternal, (Object)workersMap, (Object)rawSuspended);
                scala.collection.immutable.Set rawExternal2 = (scala.collection.immutable.Set)tuple32._1();
                Map workersMap2 = (Map)tuple32._2();
                scala.collection.immutable.Set rawSuspended2 = (scala.collection.immutable.Set)tuple32._3();
                scala.collection.immutable.Set<IOFiber<?>> rawForeign = this.foreignFibers();
                scala.collection.immutable.Set localAndActive = (scala.collection.immutable.Set)workersMap2.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2;
                    scala.collection.immutable.Set acc;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                            if (tuple22 == null) break block2;
                            Tuple2 tuple23 = (Tuple2)tuple22._2();
                            acc = (scala.collection.immutable.Set)tuple22._1();
                            if (tuple23 != null && (tuple2 = (Tuple2)tuple23._2()) != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Option active = (Option)tuple2._1();
                    scala.collection.immutable.Set local = (scala.collection.immutable.Set)tuple2._2();
                    return (scala.collection.immutable.Set)acc.$plus$plus((IterableOnce)local).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(active).toSet());
                });
                scala.collection.immutable.Set external = (scala.collection.immutable.Set)rawExternal2.$minus$minus((IterableOnce)localAndActive);
                scala.collection.immutable.Set suspended = (scala.collection.immutable.Set)rawSuspended2.$minus$minus((IterableOnce)localAndActive).$minus$minus((IterableOnce)external);
                scala.collection.immutable.Set foreign = (scala.collection.immutable.Set)rawForeign.$minus$minus((IterableOnce)localAndActive).$minus$minus((IterableOnce)external).$minus$minus((IterableOnce)suspended);
                Iterable workersStatuses = (Iterable)workersMap2.map((Function1 & Serializable)x$1 -> {
                    WorkerThread worker;
                    Tuple2 tuple2;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = x$1;
                            if (tuple22 == null) break block2;
                            tuple2 = (Tuple2)tuple22._2();
                            worker = (WorkerThread)tuple22._1();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Option active = (Option)tuple2._1();
                    scala.collection.immutable.Set local = (scala.collection.immutable.Set)tuple2._2();
                    Thread.State state = worker.getState();
                    Thread.State state2 = Thread.State.RUNNABLE;
                    String status = !(state != null ? !((Object)((Object)state)).equals((Object)state2) : state2 != null) ? "RUNNING" : "BLOCKED";
                    String workerString = "" + worker + " (#" + worker.index() + "): " + local.size() + " enqueued";
                    print.apply((Object)this.doubleNewline());
                    active.map((Function1 & Serializable)_$1 -> this.fiberString((IOFiber<?>)_$1, status)).foreach((Function1)(JProcedure1 & Serializable)_$2 -> print.apply(_$2));
                    this.printFibers(local, "YIELDING", print);
                    return workerString;
                });
                this.printFibers(external, "YIELDING", print);
                this.printFibers(suspended, "WAITING", print);
                this.printFibers(foreign, "ACTIVE", print);
                print.apply((Object)this.doubleNewline());
                print.apply((Object)workersStatuses.mkString(this.newline()));
                String globalStatus = "Global: enqueued " + external.size() + ", foreign " + foreign.size() + ", waiting " + suspended.size();
                print.apply((Object)this.doubleNewline());
                print.apply((Object)globalStatus);
                print.apply((Object)this.newline());
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private WeakBag.Handle monitorFallback(IOFiber<?> fiber) {
        void var3_3;
        WeakBag<IOFiber<?>> bag = this.Bags.get();
        WeakBag.Handle handle = bag.insert(fiber);
        bag.synchronizationPoint().lazySet(true);
        return var3_3;
    }

    private scala.collection.immutable.Set<IOFiber<?>> foreignFibers() {
        Set foreign = (Set)Set$.MODULE$.empty();
        this.BagReferences.iterator().forEachRemaining(bagRef -> {
            WeakBag bag = (WeakBag)bagRef.get();
            if (bag != null) {
                boolean bl = bag.synchronizationPoint().get();
                foreign.$plus$plus$eq(bag.toSet());
            }
        });
        return foreign.toSet();
    }

    private final void liveFiberSnapshot$$anonfun$1(Function1 print$1) {
        this.printFibers(this.foreignFibers(), "ACTIVE", (Function1<String, BoxedUnit>)print$1);
        print$1.apply((Object)this.newline());
    }
}

