/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;

public final class ScalQueue<A> {
    private final int mask;
    private final int numQueues;
    private final ConcurrentLinkedQueue<A>[] queues;

    public ScalQueue(int threadCount) {
        int value = threadCount - 1;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        this.mask = value | value >> 16;
        int nq = this.numQueues = this.mask + 1;
        ConcurrentLinkedQueue[] queues = new ConcurrentLinkedQueue[nq];
        for (int i = 0; i < nq; ++i) {
            queues[i] = new ConcurrentLinkedQueue();
        }
        this.queues = queues;
    }

    public void offer(A a, ThreadLocalRandom random) {
        int idx = random.nextInt(this.numQueues);
        this.queues[idx].offer(a);
    }

    public void offerAll(A[] as, ThreadLocalRandom random) {
        int nq = this.numQueues;
        for (A fiber : as) {
            int idx = random.nextInt(nq);
            this.queues[idx].offer(fiber);
        }
    }

    public A poll(ThreadLocalRandom random) {
        int nq = this.numQueues;
        int from = random.nextInt(nq);
        A a = null;
        for (int i = 0; a == null && i < nq; ++i) {
            int idx = from + i & this.mask;
            a = this.queues[idx].poll();
        }
        return a;
    }

    public void remove(A a) {
        int nq = this.numQueues;
        boolean done = false;
        for (int i = 0; !done && i < nq; ++i) {
            done = this.queues[i].remove(a);
        }
    }

    public Set<Object> snapshot() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.queues);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$1 -> _$1.toArray(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray(xs), ClassTag$.MODULE$.apply(Object.class))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty() {
        void var3_3;
        int nq = this.numQueues;
        boolean empty = true;
        for (int i = 0; empty && i < nq; ++i) {
            empty = this.queues[i].isEmpty();
        }
        return (boolean)var3_3;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public void clear() {
        int nq = this.numQueues;
        for (int i = 0; i < nq; ++i) {
            this.queues[i].clear();
        }
    }
}

