/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public final class WeakBag<A> {
    private final int MaxSizePow2;
    private final ReferenceQueue<A> queue = new ReferenceQueue();
    private int capacity = 256;
    private Entry<A>[] table = new Entry[this.capacity];
    private int index = 0;
    private final AtomicBoolean synchronizationPoint = new AtomicBoolean(true);

    public WeakBag() {
        this.MaxSizePow2 = 0x40000000;
    }

    public AtomicBoolean synchronizationPoint() {
        return this.synchronizationPoint;
    }

    public Handle insert(A a) {
        Entry<A> entry;
        WeakBag weakBag = this;
        while (true) {
            Entry oldEntry = (Entry)weakBag.queue.poll();
            int cap = weakBag.capacity;
            int idx = weakBag.index++;
            if (oldEntry != null) {
                int oldIndex = oldEntry.index();
                Entry<A> entry2 = new Entry<A>(a, oldIndex, weakBag.queue);
                weakBag.table[oldIndex] = entry2;
                entry = entry2;
                break;
            }
            if (idx < cap) {
                Entry<A> entry3 = new Entry<A>(a, idx, weakBag.queue);
                weakBag.table[idx] = entry3;
                entry = entry3;
                break;
            }
            if (cap == Integer.MAX_VALUE) {
                return () -> {};
            }
            Entry<A>[] oldTable = weakBag.table;
            int newCap = cap == weakBag.MaxSizePow2 ? Integer.MAX_VALUE : cap << 1;
            Entry[] newTable = new Entry[newCap];
            System.arraycopy(oldTable, 0, newTable, 0, idx);
            weakBag.table = newTable;
            weakBag.capacity = newCap;
        }
        return entry;
    }

    public scala.collection.immutable.Set<A> toSet() {
        Set set = (Set)Set$.MODULE$.empty();
        int sz = this.index;
        for (int i = 0; i < sz; ++i) {
            Object a = this.table[i].get();
            if (a == null) continue;
            set.$plus$eq(a);
        }
        return set.toSet();
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        int count = 0;
        int sz = this.index;
        for (int i = 0; i < sz; ++i) {
            Object a = this.table[i].get();
            if (a == null) continue;
            ++count;
        }
        return (int)var1_1;
    }

    public static final class Entry<A>
    extends WeakReference<A>
    implements Handle {
        private final int index;

        public Entry(A a, int index, ReferenceQueue<A> rq) {
            this.index = index;
            super(a, rq);
        }

        public int index() {
            return this.index;
        }

        @Override
        public void deregister() {
            boolean bl = this.enqueue();
        }
    }

    public static interface Handle {
        public void deregister();
    }
}

