/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WorkStealingThreadPool
implements ExecutionContext {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(WorkStealingThreadPool.class, "0bitmap$1");
    public long 0bitmap$1;
    private final int threadCount;
    private final String threadPrefix;
    private final String blockerThreadPrefix;
    private Function0<IORuntime> self0;
    private IORuntime self$lzy1;
    private final WorkerThread[] workerThreads;
    private final LocalQueue[] localQueues;
    private final AtomicBoolean[] parkedSignals;
    private final WeakBag[] fiberBags;
    private final AtomicBoolean workerThreadPublisher;
    private final ScalQueue<Object> externalQueue;
    private final AtomicInteger state;
    private final ConcurrentSkipListSet cachedThreads;
    private final AtomicBoolean done;
    private final AtomicInteger blockedWorkerThreadCounter;
    private final AtomicInteger blockedWorkerThreadNamingIndex;

    public WorkStealingThreadPool(int threadCount, String threadPrefix, String blockerThreadPrefix, Function0 self0) {
        int i;
        this.threadCount = threadCount;
        this.threadPrefix = threadPrefix;
        this.blockerThreadPrefix = blockerThreadPrefix;
        this.self0 = self0;
        ExecutionContext.$init$((ExecutionContext)this);
        this.workerThreads = new WorkerThread[threadCount];
        this.localQueues = new LocalQueue[threadCount];
        this.parkedSignals = new AtomicBoolean[threadCount];
        this.fiberBags = new WeakBag[threadCount];
        this.workerThreadPublisher = new AtomicBoolean(false);
        this.externalQueue = new ScalQueue(threadCount << 2);
        this.state = new AtomicInteger(threadCount << 16);
        this.cachedThreads = new ConcurrentSkipListSet<WorkerThread>(Comparator.comparingInt(_$1 -> _$1.nameIndex()));
        this.done = new AtomicBoolean(false);
        this.blockedWorkerThreadCounter = new AtomicInteger(0);
        this.blockedWorkerThreadNamingIndex = new AtomicInteger(0);
        for (i = 0; i < threadCount; ++i) {
            WorkerThread thread;
            AtomicBoolean parkedSignal;
            LocalQueue queue;
            this.localQueues()[i] = queue = new LocalQueue();
            this.parkedSignals()[i] = parkedSignal = new AtomicBoolean(false);
            int index = i;
            WeakBag fiberBag = new WeakBag();
            this.fiberBags()[i] = fiberBag;
            this.workerThreads[i] = thread = new WorkerThread(index, queue, parkedSignal, this.externalQueue, fiberBag, this);
        }
        this.workerThreadPublisher.set(true);
        for (i = 0; i < threadCount; ++i) {
            this.workerThreads[i].start();
        }
    }

    public String threadPrefix() {
        return this.threadPrefix;
    }

    public String blockerThreadPrefix() {
        return this.blockerThreadPrefix;
    }

    private IORuntime self() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    IORuntime iORuntime;
                    this.self$lzy1 = iORuntime = (IORuntime)this.self0.apply();
                    this.self0 = null;
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return iORuntime;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.self$lzy1;
    }

    public LocalQueue[] localQueues() {
        return this.localQueues;
    }

    public AtomicBoolean[] parkedSignals() {
        return this.parkedSignals;
    }

    public WeakBag<IOFiber<?>>[] fiberBags() {
        return this.fiberBags;
    }

    public ConcurrentSkipListSet<WorkerThread> cachedThreads() {
        return this.cachedThreads;
    }

    public AtomicBoolean done() {
        return this.done;
    }

    public AtomicInteger blockedWorkerThreadCounter() {
        return this.blockedWorkerThreadCounter;
    }

    public AtomicInteger blockedWorkerThreadNamingIndex() {
        return this.blockedWorkerThreadNamingIndex;
    }

    public IOFiber<?> stealFromOtherWorkerThread(int dest, ThreadLocalRandom random, WorkerThread destWorker) {
        IOFiber iOFiber;
        LocalQueue destQueue = this.localQueues()[dest];
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            IOFiber<?> res;
            int index = (from + i) % this.threadCount;
            if (index == dest || (res = this.localQueues()[index].stealInto(destQueue, destWorker)) == null) continue;
            return res;
        }
        Object element = this.externalQueue.poll(random);
        if (element instanceof IOFiber[]) {
            IOFiber[] batch = (IOFiber[])element;
            iOFiber = destQueue.enqueueBatch(batch, destWorker);
        } else if (element instanceof IOFiber) {
            IOFiber fiber = (IOFiber)element;
            if (TracingConstants.isStackTracing) {
                destWorker.active_$eq(fiber);
                this.parkedSignals()[dest].lazySet(false);
            }
            iOFiber = fiber;
        } else {
            iOFiber = null;
        }
        return iOFiber;
    }

    public boolean notifyParked(ThreadLocalRandom random) {
        if (!this.notifyShouldWakeup()) {
            return false;
        }
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            AtomicBoolean signal = this.parkedSignals()[index];
            if (!signal.getAndSet(false)) continue;
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            this.workerThreadPublisher.get();
            WorkerThread worker = this.workerThreads[index];
            LockSupport.unpark(worker);
            return true;
        }
        return false;
    }

    private boolean notifyShouldWakeup() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.SearchMask) == 0 && (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16 < this.threadCount;
    }

    public void notifyIfWorkPending(ThreadLocalRandom random) {
        for (int i = 0; i < this.threadCount; ++i) {
            if (!this.localQueues()[i].nonEmpty()) continue;
            this.notifyParked(random);
            return;
        }
        if (this.externalQueue.nonEmpty()) {
            this.notifyParked(random);
        }
    }

    public boolean transitionWorkerToSearching() {
        boolean bl;
        int st = this.state.get();
        if (2 * (st & WorkStealingThreadPoolConstants.SearchMask) >= this.threadCount) {
            bl = false;
        } else {
            this.state.getAndIncrement();
            bl = true;
        }
        return bl;
    }

    public void transitionWorkerFromSearching(ThreadLocalRandom random) {
        int prev = this.state.getAndDecrement();
        if (prev == 1) {
            this.notifyParked(random);
        }
    }

    public boolean transitionWorkerToParkedWhenSearching() {
        int prev = this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaSearching);
        return (prev & WorkStealingThreadPoolConstants.SearchMask) == 1;
    }

    public void transitionWorkerToParked() {
        this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaNotSearching);
    }

    public void replaceWorker(int index, WorkerThread newWorker) {
        this.workerThreads[index] = newWorker;
        this.workerThreadPublisher.lazySet(true);
    }

    public void rescheduleFiber(IOFiber<?> fiber) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.reschedule(fiber);
            } else {
                this.scheduleExternal(fiber);
            }
        } else {
            this.scheduleExternal(fiber);
        }
    }

    public void scheduleFiber(IOFiber<?> fiber) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.schedule(fiber);
            } else {
                this.scheduleExternal(fiber);
            }
        } else {
            this.scheduleExternal(fiber);
        }
    }

    public boolean canExecuteBlockingCode() {
        boolean bl;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            bl = worker.canExecuteBlockingCodeOn(this);
        } else {
            bl = false;
        }
        return bl;
    }

    private void scheduleExternal(IOFiber<?> fiber) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.externalQueue.offer(fiber, random);
        this.notifyParked(random);
    }

    public Tuple3<scala.collection.immutable.Set<IOFiber<?>>, Map<WorkerThread, Tuple2<Option<IOFiber<?>>, scala.collection.immutable.Set<IOFiber<?>>>>, scala.collection.immutable.Set<IOFiber<?>>> liveFibers() {
        scala.collection.immutable.Set externalFibers = (scala.collection.immutable.Set)this.externalQueue.snapshot().flatMap((Function1 & Serializable)x$1 -> {
            scala.collection.immutable.Set set;
            Object object = x$1;
            if (object instanceof IOFiber[]) {
                Object[] batch = (IOFiber[])object;
                set = Predef$.MODULE$.wrapRefArray(batch).toSet();
            } else if (object instanceof IOFiber) {
                IOFiber fiber = (IOFiber)object;
                set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IOFiber[]{fiber}));
            } else {
                set = Predef$.MODULE$.Set().empty();
            }
            return set;
        });
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Set suspended = (Set)Set$.MODULE$.empty();
        for (int i = 0; i < this.threadCount; ++i) {
            scala.collection.immutable.Set<IOFiber<?>> localFibers = this.localQueues()[i].snapshot();
            WorkerThread worker = this.workerThreads[i];
            boolean bl = this.parkedSignals()[i].get();
            Option active = Option$.MODULE$.apply(worker.active());
            WorkerThread workerThread = (WorkerThread)Predef$.MODULE$.ArrowAssoc((Object)worker);
            Option option = (Option)Predef$.MODULE$.ArrowAssoc((Object)active);
            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)workerThread, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option, localFibers)));
            suspended.$plus$plus$eq(worker.suspendedSnapshot());
        }
        return Tuple3$.MODULE$.apply((Object)externalFibers, (Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)suspended.toSet());
    }

    public void execute(Runnable runnable) {
        if (runnable instanceof IOFiber) {
            IOFiber fiber = (IOFiber)runnable;
            this.scheduleFiber(fiber);
        } else {
            IOFiber fiber = new IOFiber(runnable, this, this.self());
            this.scheduleFiber(fiber);
        }
    }

    public void reportFailure(Throwable cause) {
        cause.printStackTrace();
    }

    public void shutdown() {
        Thread.interrupted();
        if (this.done().compareAndSet(false, true)) {
            this.workerThreadPublisher.get();
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].interrupt();
            }
            Thread.interrupted();
            WorkerThread t = null;
            while ((t = this.cachedThreads().pollFirst()) != null) {
                t.interrupt();
            }
            this.externalQueue.clear();
            Thread.currentThread().interrupt();
        }
    }

    public int getWorkerThreadCount() {
        return this.threadCount;
    }

    public int getActiveThreadCount() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16;
    }

    public int getSearchingThreadCount() {
        int st = this.state.get();
        return st & WorkStealingThreadPoolConstants.SearchMask;
    }

    public int getBlockedWorkerThreadCount() {
        return this.blockedWorkerThreadCounter().get();
    }

    public long getLocalQueueFiberCount() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.localQueues());
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.size(), ClassTag$.MODULE$.apply(Long.TYPE))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getSuspendedFiberCount() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.workerThreads);
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.getSuspendedFiberCount(), ClassTag$.MODULE$.apply(Long.TYPE))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }
}

