/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.concurrent.BlockContext;
import scala.concurrent.CanAwait;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WorkerThread
extends Thread
implements BlockContext {
    private LocalQueue queue;
    private AtomicBoolean parked;
    private final ScalQueue<Object> external;
    private WeakBag<IOFiber<?>> fiberBag;
    private final WorkStealingThreadPool pool;
    private int _index;
    private ThreadLocalRandom random;
    private IOFiber<?> cedeBypass;
    private boolean blocking;
    private IOFiber<?> _active;
    private final ArrayBlockingQueue indexTransfer;
    private final int nameIndex;

    public WorkerThread(int idx, LocalQueue queue, AtomicBoolean parked, ScalQueue<Object> external, WeakBag<IOFiber<?>> fiberBag, WorkStealingThreadPool pool) {
        this.queue = queue;
        this.parked = parked;
        this.external = external;
        this.fiberBag = fiberBag;
        this.pool = pool;
        this._index = idx;
        this.blocking = false;
        this.indexTransfer = new ArrayBlockingQueue(1);
        this.nameIndex = pool.blockedWorkerThreadNamingIndex().incrementAndGet();
        this.setDaemon(true);
        String prefix = pool.threadPrefix();
        this.setName("" + prefix + "-" + this.nameIndex());
    }

    private ArrayBlockingQueue<Integer> indexTransfer() {
        return this.indexTransfer;
    }

    public int nameIndex() {
        return this.nameIndex;
    }

    public void schedule(IOFiber<?> fiber) {
        ThreadLocalRandom rnd = this.random;
        this.queue.enqueue(fiber, this.external, rnd);
        this.pool.notifyParked(rnd);
    }

    public void reschedule(IOFiber<?> fiber) {
        if (this.cedeBypass == null && this.queue.isEmpty()) {
            this.cedeBypass = fiber;
        } else {
            this.schedule(fiber);
        }
    }

    public boolean isOwnedBy(WorkStealingThreadPool threadPool) {
        return this.pool == threadPool && !this.blocking;
    }

    public boolean canExecuteBlockingCodeOn(WorkStealingThreadPool threadPool) {
        return this.pool == threadPool;
    }

    public WeakBag.Handle monitor(IOFiber<?> fiber) {
        return this.fiberBag.insert(fiber);
    }

    public int index() {
        return this._index;
    }

    public IOFiber<?> active() {
        return this._active;
    }

    public void active_$eq(IOFiber<?> fiber) {
        this._active = fiber;
    }

    public Set<IOFiber<?>> suspendedSnapshot() {
        return this.fiberBag.toSet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        WorkerThread self = this;
        ThreadLocalRandom rnd = this.random = ThreadLocalRandom.current();
        int state = 4;
        AtomicBoolean done = this.pool.done();
        block9: while (!done.get()) {
            IOFiber<?> fiber;
            IOFiber<?> iOFiber;
            if (this.blocking) {
                this.queue = null;
                this.parked = null;
                this.fiberBag = null;
                this.pool.cachedThreads().add(this);
                try {
                    Integer newIdx = this.indexTransfer().poll(60L, TimeUnit.SECONDS);
                    if (newIdx == null) {
                        if (this.pool.cachedThreads().remove(this)) {
                            this.pool.blockedWorkerThreadCounter().decrementAndGet();
                            return;
                        }
                        newIdx = this.indexTransfer().take();
                        this.init(Predef$.MODULE$.Integer2int(newIdx));
                    } else {
                        this.init(Predef$.MODULE$.Integer2int(newIdx));
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.blocking = false;
                state = 4;
            }
            int n = state & WorkStealingThreadPoolConstants.ExternalQueueTicksMask;
            switch (n) {
                case 0: {
                    Object element = this.external.poll(rnd);
                    if (element instanceof IOFiber[]) {
                        IOFiber[] batch = (IOFiber[])element;
                        this.queue.drainBatch(this.external, rnd);
                        IOFiber<?> fiber2 = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        fiber2.run();
                    } else if (element instanceof IOFiber) {
                        IOFiber fiber3 = (IOFiber)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber3;
                            this.parked.lazySet(false);
                        }
                        fiber3.run();
                    }
                    state = 4;
                    continue block9;
                }
                case 1: {
                    Object element = this.external.poll(rnd);
                    if (element instanceof IOFiber[]) {
                        IOFiber[] batch = (IOFiber[])element;
                        IOFiber<?> fiber4 = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        fiber4.run();
                        state = 4;
                        continue block9;
                    }
                    if (element instanceof IOFiber) {
                        IOFiber fiber5 = (IOFiber)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber5;
                            this.parked.lazySet(false);
                        }
                        fiber5.run();
                        state = 4;
                        continue block9;
                    }
                    if (this.pool.transitionWorkerToSearching()) {
                        state = 2;
                        continue block9;
                    }
                    if (TracingConstants.isStackTracing) {
                        this._active = null;
                    }
                    this.parked.lazySet(true);
                    this.pool.transitionWorkerToParked();
                    this.parkLoop$1(done);
                    state = 3;
                    continue block9;
                }
                case 2: {
                    IOFiber<?> fiber6 = this.pool.stealFromOtherWorkerThread(this.index(), rnd, self);
                    if (fiber6 != null) {
                        this.pool.transitionWorkerFromSearching(rnd);
                        fiber6.run();
                        state = 4;
                        continue block9;
                    }
                    if (TracingConstants.isStackTracing) {
                        this._active = null;
                    }
                    this.parked.lazySet(true);
                    if (this.pool.transitionWorkerToParkedWhenSearching()) {
                        this.pool.notifyIfWorkPending(rnd);
                    }
                    this.parkLoop$1(done);
                    state = 3;
                    continue block9;
                }
                case 3: {
                    Object element = this.external.poll(rnd);
                    if (element instanceof IOFiber[]) {
                        IOFiber[] batch = (IOFiber[])element;
                        this.pool.transitionWorkerFromSearching(rnd);
                        IOFiber<?> fiber7 = this.queue.enqueueBatch(batch, self);
                        this.pool.notifyParked(rnd);
                        fiber7.run();
                        state = 4;
                        continue block9;
                    }
                    if (element instanceof IOFiber) {
                        IOFiber fiber8 = (IOFiber)element;
                        if (TracingConstants.isStackTracing) {
                            this._active = fiber8;
                            this.parked.lazySet(false);
                        }
                        this.pool.transitionWorkerFromSearching(rnd);
                        fiber8.run();
                        state = 4;
                        continue block9;
                    }
                    state = 2;
                    continue block9;
                }
            }
            if (this.cedeBypass == null) {
                iOFiber = this.queue.dequeue(self);
            } else {
                IOFiber<?> f = this.cedeBypass;
                this.cedeBypass = null;
                iOFiber = fiber = f;
            }
            if (fiber != null) {
                fiber.run();
                ++state;
                continue;
            }
            state = 1;
        }
        return;
    }

    public <T> T blockOn(Function0<T> thunk, CanAwait permission) {
        Object object;
        ThreadLocalRandom rnd = this.random;
        this.pool.notifyParked(rnd);
        if (this.blocking) {
            object = thunk.apply();
        } else {
            Boolean bl;
            this.blocking = true;
            String prefix = this.pool.blockerThreadPrefix();
            this.setName("" + prefix + "-" + this.nameIndex());
            WorkerThread cached = this.pool.cachedThreads().pollFirst();
            if (cached != null) {
                int idx = this.index();
                this.pool.replaceWorker(idx, cached);
                bl = BoxesRunTime.boxToBoolean((boolean)cached.indexTransfer().offer(Predef$.MODULE$.int2Integer(idx)));
            } else {
                int idx = this.index();
                WorkerThread clone = new WorkerThread(idx, this.queue, this.parked, this.external, this.fiberBag, this.pool);
                this.pool.replaceWorker(idx, clone);
                this.pool.blockedWorkerThreadCounter().incrementAndGet();
                clone.start();
                bl = BoxedUnit.UNIT;
            }
            object = thunk.apply();
        }
        return (T)object;
    }

    private void init(int newIdx) {
        this._index = newIdx;
        this.queue = this.pool.localQueues()[newIdx];
        this.parked = this.pool.parkedSignals()[newIdx];
        this.fiberBag = this.pool.fiberBags()[newIdx];
        String prefix = this.pool.threadPrefix();
        this.setName("" + prefix + "-" + newIdx);
    }

    public int getSuspendedFiberCount() {
        return this.fiberBag.size();
    }

    private final void parkLoop$1(AtomicBoolean done$1) {
        boolean cont = true;
        while (cont && !done$1.get()) {
            LockSupport.park(this.pool);
            if (this.isInterrupted()) {
                this.pool.shutdown();
                continue;
            }
            cont = this.parked.get();
        }
    }
}

