/*
 * Decompiled with CFR 0.152.
 */
package cats.parse;

import java.io.Serializable;
import java.util.BitSet;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public abstract class BitSetUtilCompat {
    private final boolean isScalaJs;
    private final boolean isScalaJvm;

    public BitSetUtilCompat(boolean isScalaJs, boolean isScalaJvm) {
        this.isScalaJs = isScalaJs;
        this.isScalaJvm = isScalaJvm;
    }

    public final boolean isScalaJs() {
        return this.isScalaJs;
    }

    public final boolean isScalaJvm() {
        return this.isScalaJvm;
    }

    public final boolean isSet(BitSet b, int idx) {
        return b.get(idx & Integer.MAX_VALUE);
    }

    public BitSet bitSetFor(char[] charArray) {
        char min = charArray[0];
        BitSet bs = new BitSet(charArray[charArray.length - 1] + '\u0001' - min);
        for (int idx = 0; idx < charArray.length; ++idx) {
            bs.set(charArray[idx] - min);
        }
        return bs;
    }

    public boolean isSingleton(BitSet t) {
        return t.cardinality() == 1;
    }

    public Iterable<Object> union(List<Tuple2<Object, BitSet>> bs) {
        return this.union((Iterator<Tuple2<Object, BitSet>>)bs.iterator());
    }

    public Iterable<Object> union(Iterator<Tuple2<Object, BitSet>> bs) {
        return bs.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int m = BoxesRunTime.unboxToInt((Object)tuple2._1());
                BitSet bs = (BitSet)tuple2._2();
                return BitSetUtilCompat.toIter$1(m, bs);
            }
            throw new MatchError((Object)tuple2);
        }).toSet();
    }

    public BitSet bitSetForRange(int count) {
        BitSet bs = new BitSet(count);
        bs.flip(0, count);
        return bs;
    }

    private static final /* synthetic */ char toIter$1$$anonfun$3(int m$1, int i) {
        return (char)(m$1 + i);
    }

    private static final Iterator toIter$1(int m2, BitSet bs) {
        return package$.MODULE$.Iterator().iterate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(JFunction1.mcII.sp & Serializable)m -> bs.nextSetBit(m + 1)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 >= 0).map((Function1 & Serializable)i -> BitSetUtilCompat.toIter$1$$anonfun$3(m2, BoxesRunTime.unboxToInt((Object)i)));
    }
}

