/*
 * Decompiled with CFR 0.152.
 */
package cats.parse;

import cats.data.NonEmptyList;
import cats.kernel.Semilattice;
import cats.parse.RadixNode$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.package$;

public final class RadixNode {
    private final String matched;
    private final int bitMask;
    private final String[] prefixes;
    private final RadixNode[] children;

    public static int commonPrefixLength(String string, String string2) {
        return RadixNode$.MODULE$.commonPrefixLength(string, string2);
    }

    public static Semilattice<String> commonPrefixSemilattice() {
        return RadixNode$.MODULE$.commonPrefixSemilattice();
    }

    public static RadixNode fromSortedStrings(NonEmptyList<String> nonEmptyList) {
        return RadixNode$.MODULE$.fromSortedStrings(nonEmptyList);
    }

    public static RadixNode fromStrings(Iterable<String> iterable) {
        return RadixNode$.MODULE$.fromStrings(iterable);
    }

    public RadixNode(String matched, int bitMask, String[] prefixes, RadixNode[] children) {
        this.matched = matched;
        this.bitMask = bitMask;
        this.prefixes = prefixes;
        this.children = children;
    }

    public String toString() {
        String ps = RadixNode.list$1(this.prefixes);
        String cs = RadixNode.list$1(this.children);
        return new StringBuilder(17).append("RadixNode(").append(this.matched).append(", ").append(this.bitMask).append(", ").append(ps).append(", ").append(cs).append(")").toString();
    }

    public List<String> allStrings() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.children);
        Iterator rest = ArrayOps$.MODULE$.iterator$extension(object).flatMap((Function1 & Serializable)x$1 -> {
            RadixNode radixNode = x$1;
            if (radixNode == null) {
                return package$.MODULE$.Nil();
            }
            RadixNode c = radixNode;
            return c.allStrings();
        });
        if (this.matched == null) {
            return rest.toList();
        }
        return rest.filterNot((Function1 & Serializable)_$1 -> {
            String string = _$1;
            String string2 = this.matched;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList().$colon$colon((Object)this.matched);
    }

    public int matchAt(String str, int off) {
        String string = this.matchAtOrNull(str, off);
        if (string == null) {
            return -1;
        }
        String nonNull = string;
        return off + nonNull.length();
    }

    public final String matchAtOrNull(String str, int offset) {
        if (offset < 0 || str.length() < offset) {
            return null;
        }
        return this.matchAtOrNullLoop(str, offset);
    }

    public final String matchAtOrNullLoop(String str, int offset) {
        while (offset < str.length()) {
            char c = str.charAt(offset);
            int idx = c & this_.bitMask;
            String prefix = this_.prefixes[idx];
            if (prefix != null) {
                int plen = prefix.length();
                if (str.regionMatches(offset, prefix, 0, plen)) {
                    RadixNode radixNode = this_.children[idx];
                    int n = offset + plen;
                    RadixNode this_ = radixNode;
                    offset = n;
                    continue;
                }
                return this_.matched;
            }
            return this_.matched;
        }
        return this_.matched;
    }

    private static final String list$1(Object ary) {
        return Predef$.MODULE$.genericWrapArray(ary).mkString("[", ", ", "]");
    }
}

