/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.core;

import cats.kernel.Order;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.openmole.core.authentication.AuthenticationStore;
import org.openmole.core.buildinfo.BuildInfo$;
import org.openmole.core.compiler.Interpreter;
import org.openmole.core.dsl.package$;
import org.openmole.core.event.EventDispatcher;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.fileservice.FileServiceCache;
import org.openmole.core.fileservice.FileServiceCache$;
import org.openmole.core.market.MarketIndex;
import org.openmole.core.market.MarketIndexEntry;
import org.openmole.core.networkservice.NetworkService;
import org.openmole.core.networkservice.NetworkService$;
import org.openmole.core.outputmanager.OutputManager$;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString$;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.Preference$;
import org.openmole.core.preference.PreferenceLocation$;
import org.openmole.core.project.CompileResult;
import org.openmole.core.project.Compiled;
import org.openmole.core.project.ErrorInCode;
import org.openmole.core.project.ErrorInCode$;
import org.openmole.core.project.ErrorInCompiler;
import org.openmole.core.project.ErrorInCompiler$;
import org.openmole.core.project.Project$;
import org.openmole.core.project.ScriptFileDoesNotExists;
import org.openmole.core.project.ScriptFileDoesNotExists$;
import org.openmole.core.replication.ReplicaCatalog;
import org.openmole.core.serializer.SerializerService;
import org.openmole.core.services.Services;
import org.openmole.core.services.Services$;
import org.openmole.core.services.ServicesContainer;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.core.timeservice.TimeService;
import org.openmole.core.workflow.composition.DSL;
import org.openmole.core.workflow.composition.Puzzle;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workflow.mole.MoleServices;
import org.openmole.core.workflow.mole.MoleServices$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.TmpDirectory$;
import org.openmole.core.workspace.Workspace;
import org.openmole.gui.server.core.GUIServer;
import org.openmole.gui.server.core.GUIServer$;
import org.openmole.gui.server.core.MarkDownProcessor$;
import org.openmole.gui.server.core.ServerState;
import org.openmole.gui.server.core.ServerState$ExecutionInfo$;
import org.openmole.gui.server.ext.GUIPluginRegistry$;
import org.openmole.gui.server.ext.OMRouter;
import org.openmole.gui.server.ext.utils;
import org.openmole.gui.server.ext.utils$;
import org.openmole.gui.shared.data.EnvironmentError;
import org.openmole.gui.shared.data.EnvironmentErrorGroup;
import org.openmole.gui.shared.data.EnvironmentErrorGroup$;
import org.openmole.gui.shared.data.EnvironmentId;
import org.openmole.gui.shared.data.EnvironmentId$;
import org.openmole.gui.shared.data.ErrorData;
import org.openmole.gui.shared.data.ErrorData$;
import org.openmole.gui.shared.data.ErrorWithLocation;
import org.openmole.gui.shared.data.ErrorWithLocation$;
import org.openmole.gui.shared.data.ExecutionData;
import org.openmole.gui.shared.data.ExecutionId;
import org.openmole.gui.shared.data.ExecutionId$;
import org.openmole.gui.shared.data.ExecutionState;
import org.openmole.gui.shared.data.FileListData;
import org.openmole.gui.shared.data.FileSorting;
import org.openmole.gui.shared.data.FileSorting$;
import org.openmole.gui.shared.data.JVMInfos;
import org.openmole.gui.shared.data.JVMInfos$;
import org.openmole.gui.shared.data.MessageErrorData;
import org.openmole.gui.shared.data.MessageErrorData$;
import org.openmole.gui.shared.data.NotificationEvent;
import org.openmole.gui.shared.data.OMSettings;
import org.openmole.gui.shared.data.OMSettings$;
import org.openmole.gui.shared.data.Plugin;
import org.openmole.gui.shared.data.Plugin$;
import org.openmole.gui.shared.data.PluginExtensionData;
import org.openmole.gui.shared.data.PluginExtensionData$;
import org.openmole.gui.shared.data.Resource$;
import org.openmole.gui.shared.data.Resources;
import org.openmole.gui.shared.data.Resources$;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.gui.shared.data.SafePath$;
import org.openmole.gui.shared.data.SequenceData;
import org.openmole.gui.shared.data.SequenceData$;
import org.openmole.gui.shared.data.ServerFileSystemContext;
import org.openmole.gui.shared.data.ServerFileSystemContext$;
import org.openmole.plugin.hook.omr.OMROutputFormat$;
import org.openmole.tool.archive.ArchiveType;
import org.openmole.tool.archive.ArchiveType$;
import org.openmole.tool.archive.TarInputStream;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.cache.Lazy;
import org.openmole.tool.crypto.Cypher;
import org.openmole.tool.crypto.Cypher$;
import org.openmole.tool.logger.LoggerService;
import org.openmole.tool.outputredirection.OutputRedirection;
import org.openmole.tool.outputredirection.OutputRedirection$;
import org.openmole.tool.random.Seeder;
import org.openmole.tool.stream.StringPrintStream;
import org.openmole.tool.stream.StringPrintStream$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.stm.MaybeTxn$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public class ApiImpl {
    private final Services services;
    private final Option<GUIServer.ApplicationControl> applicationControl;
    private final ClearPreferenceLocation outputSize;
    private final ServerState serverState;

    public ApiImpl(Services services, Option<GUIServer.ApplicationControl> applicationControl) {
        this.services = services;
        this.applicationControl = applicationControl;
        this.outputSize = PreferenceLocation$.MODULE$.apply("gui", "outputsize", ApiImpl::$init$$$anonfun$1);
        this.serverState = new ServerState();
    }

    public Services services() {
        return this.services;
    }

    public ClearPreferenceLocation<Object> outputSize() {
        return this.outputSize;
    }

    public ServerState serverState() {
        return this.serverState;
    }

    public OMSettings settings() {
        utils.SafePathFileDecorator safePathFileDecorator = utils$.MODULE$.SafePathFileDecorator(utils$.MODULE$.projectsDirectory(this.services().workspace()));
        Workspace workspace = this.services().workspace();
        ServerFileSystemContext serverFileSystemContext = safePathFileDecorator.toSafePath$default$1();
        return OMSettings$.MODULE$.apply(safePathFileDecorator.toSafePath(serverFileSystemContext, workspace), org.openmole.core.buildinfo.package$.MODULE$.version().value(), org.openmole.core.buildinfo.package$.MODULE$.name(), utils$.MODULE$.formatDate(BuildInfo$.MODULE$.buildTime()), org.openmole.core.buildinfo.package$.MODULE$.development());
    }

    public void shutdown() {
        this.applicationControl.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.stop().apply$mcV$sp());
    }

    public void restart() {
        this.applicationControl.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.restart().apply$mcV$sp());
    }

    public boolean isAlive() {
        return true;
    }

    public JVMInfos jvmInfos() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long allocatedMemory = totalMemory - runtime.freeMemory();
        String javaVersion = System.getProperty("java.version");
        String jvmName = System.getProperty("java.vm.name");
        return JVMInfos$.MODULE$.apply(javaVersion, jvmName, Runtime.getRuntime().availableProcessors(), allocatedMemory, totalMemory);
    }

    public boolean isPasswordCorrect(String pass) {
        return Preference$.MODULE$.passwordIsCorrect(Cypher$.MODULE$.apply(pass), this.services().preference());
    }

    public void resetPassword() {
        Services$.MODULE$.resetPassword(this.services().authenticationStore(), this.services().preference());
    }

    public boolean createFile(SafePath safePath, String name, boolean directory) {
        File target = new File(utils$.MODULE$.SafePathDecorator(safePath).toFile(this.services().workspace()), name);
        if (directory) {
            return target.mkdirs();
        }
        return target.createNewFile();
    }

    public void deleteFiles(Seq<SafePath> safePaths) {
        Seq<Plugin> allPlugins = this.listPlugins();
        ((IterableOnceOps)safePaths.map((Function1 & Serializable)safePath -> {
            File file = utils$.MODULE$.safePathToFile(safePath, this.services().workspace());
            return Tuple2$.MODULE$.apply(safePath, (Object)file);
        })).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SafePath safePath = (SafePath)tuple2._1();
                File file = (File)tuple2._2();
                if (file.isDirectory()) {
                    org.openmole.tool.file.package$.MODULE$.FileDecorator(file).applyRecursive((Function1)(JProcedure1 & Serializable)f -> this.unplug$1(allPlugins, (File)f));
                    return;
                }
                this.unplug$1(allPlugins, file);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        utils$.MODULE$.deleteFiles(safePaths, this.services().workspace());
    }

    private Option<MessageErrorData> extractArchiveFromFiles(File from, File to) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ApiImpl.extractArchiveFromFiles$$anonfun$1(from, to);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            return None$.MODULE$;
        }
        if (try_ instanceof Failure) {
            Throwable t = ((Failure)try_).exception();
            return Some$.MODULE$.apply((Object)ErrorData$.MODULE$.apply(t));
        }
        throw new MatchError((Object)try_);
    }

    public Option<MessageErrorData> extractArchive(SafePath safePath, SafePath to) {
        return this.extractArchiveFromFiles(this.archiveFile$1(safePath), this.toFile$1(to));
    }

    public SafePath temporaryDirectory() {
        File dir = this.services().tmpDirectory().newDir("openmoleGUI", true);
        utils.SafePathFileDecorator safePathFileDecorator = utils$.MODULE$.SafePathFileDecorator(dir);
        return safePathFileDecorator.toSafePath(ServerFileSystemContext$.Absolute, this.services().workspace());
    }

    public boolean exists(SafePath safePath) {
        return utils$.MODULE$.exists(safePath, this.services().workspace());
    }

    public Seq<SafePath> copyFiles(Seq<Tuple2<SafePath, SafePath>> paths, boolean overwrite) {
        return utils$.MODULE$.copyFiles(paths, overwrite, this.services().workspace());
    }

    public FileListData listFiles(SafePath sp, FileSorting fileFilter) {
        return utils$.MODULE$.listFiles(sp, fileFilter, this.listPlugins(), this.services().workspace());
    }

    public FileSorting listFiles$default$2() {
        return FileSorting$.MODULE$.apply(FileSorting$.MODULE$.$lessinit$greater$default$1(), FileSorting$.MODULE$.$lessinit$greater$default$2(), FileSorting$.MODULE$.$lessinit$greater$default$3());
    }

    public Seq<Tuple2<SafePath, Object>> recursiveListFiles(SafePath sp, Option<String> findString) {
        return utils$.MODULE$.recursiveListFiles(sp, findString, this.services().workspace());
    }

    public boolean isEmpty(SafePath sp) {
        File f = utils$.MODULE$.safePathToFile(sp, this.services().workspace());
        return package$.MODULE$.FileDecorator(f).isDirectoryEmpty();
    }

    public void move(Seq<Tuple2<SafePath, SafePath>> moves) {
        moves.foreach((Function1 & Serializable)x$1 -> {
            SafePath safePath = (SafePath)x$1._1();
            SafePath safePath2 = (SafePath)x$1._2();
            File fromFile = utils$.MODULE$.safePathToFile(safePath, this.services().workspace());
            File toFile = utils$.MODULE$.safePathToFile(safePath2, this.services().workspace());
            toFile.getParentFile().mkdirs();
            return package$.MODULE$.FileDecorator(fromFile).move(toFile);
        });
    }

    public String mdToHtml(SafePath safePath) {
        return MarkDownProcessor$.MODULE$.apply(package$.MODULE$.FileDecorator(utils$.MODULE$.safePathToFile(safePath, this.services().workspace())).content());
    }

    public Tuple2<Object, String> saveFile(SafePath path, String fileContent, Option<String> hash, boolean overwrite) {
        File file = utils$.MODULE$.safePathToFile(path, this.services().workspace());
        if (!file.exists()) {
            package$.MODULE$.FileDecorator(file).content_$eq("");
        }
        return (Tuple2)package$.MODULE$.FileDecorator(file).withLock((Function1 & Serializable)_$3 -> {
            String string;
            if (overwrite) {
                return this.save$1(fileContent, file);
            }
            Option option = hash;
            if (option instanceof Some && (string = (String)((Some)option).value()) != null) {
                String hashOnDisk;
                String expectedHash = string;
                FileService fileService = this.services().fileService();
                String string2 = hashOnDisk = fileService.hashNoCache(file, fileService.hashNoCache$default$2(), this.services().tmpDirectory()).toString();
                String string3 = expectedHash;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return this.save$1(fileContent, file);
                }
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)hashOnDisk);
            }
            return this.save$1(fileContent, file);
        });
    }

    public long size(SafePath safePath) {
        return utils$.MODULE$.safePathToFile(safePath, this.services().workspace()).length();
    }

    public SequenceData sequence(SafePath safePath, char separator) {
        Object[] content = package$.MODULE$.FileDecorator(utils$.MODULE$.SafePathDecorator(safePath).toFile(this.services().workspace())).content().split("\n");
        Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\[[^\\]]+\\]|[+-]?[0-9][0-9]*\\.?[0-9]*([Ee][+-]?[0-9]+)?|true|false"));
        Object object = Predef$.MODULE$.refArrayOps(content);
        return (SequenceData)ArrayOps$.MODULE$.headOption$extension(object).map(arg_0 -> ApiImpl.sequence$$anonfun$1((String[])content, regex, arg_0)).getOrElse(ApiImpl::sequence$$anonfun$2);
    }

    public char sequence$default$2() {
        return ',';
    }

    public void cancelExecution(ExecutionId id) {
        this.serverState().cancel(id);
    }

    public void removeExecution(ExecutionId id) {
        this.serverState().remove(id);
    }

    public Option<ErrorData> compileScript(SafePath script) {
        StringPrintStream outputStream = StringPrintStream$.MODULE$.apply((Option)Some$.MODULE$.apply(this.services().preference().apply(this.outputSize(), ConfigurationString$.MODULE$.given_ConfigurationString_Int())));
        Object object = this.synchronousCompilation(script, outputStream);
        if (object instanceof ErrorData) {
            ErrorData e = (ErrorData)object;
            return Some$.MODULE$.apply((Object)e);
        }
        return None$.MODULE$;
    }

    public Object synchronousCompilation(SafePath scriptPath, StringPrintStream outputStream) {
        ErrorData errorData;
        block10: {
            File script = utils$.MODULE$.safePathToFile(scriptPath, this.services().workspace());
            OutputRedirection executionOutputRedirection = OutputRedirection$.MODULE$.apply((PrintStream)outputStream);
            TmpDirectory tmpDirectory = this.services().tmpDirectory();
            File executionTmpDirectory = tmpDirectory.newDir("execution", tmpDirectory.newDir$default$2());
            TmpDirectory tmpDirectory2 = TmpDirectory$.MODULE$.apply(executionTmpDirectory);
            FileServiceCache fileServiceCache = FileServiceCache$.MODULE$.apply(this.services().preference());
            Workspace workspace = Services$.MODULE$.copy$default$2(this.services());
            Preference preference = Services$.MODULE$.copy$default$3(this.services());
            Cypher cypher = Services$.MODULE$.copy$default$4(this.services());
            ThreadProvider threadProvider = Services$.MODULE$.copy$default$5(this.services());
            Seeder seeder = Services$.MODULE$.copy$default$6(this.services());
            ReplicaCatalog replicaCatalog = Services$.MODULE$.copy$default$7(this.services());
            AuthenticationStore authenticationStore = Services$.MODULE$.copy$default$9(this.services());
            SerializerService serializerService = Services$.MODULE$.copy$default$10(this.services());
            FileService fileService = Services$.MODULE$.copy$default$11(this.services());
            Lazy lazy = Services$.MODULE$.copy$default$12(this.services());
            EventDispatcher eventDispatcher = Services$.MODULE$.copy$default$13(this.services());
            NetworkService networkService = Services$.MODULE$.copy$default$15(this.services());
            LoggerService loggerService = Services$.MODULE$.copy$default$17(this.services());
            TimeService timeService = Services$.MODULE$.copy$default$18(this.services());
            ServicesContainer runServices = Services$.MODULE$.copy(this.services(), workspace, preference, cypher, threadProvider, seeder, replicaCatalog, tmpDirectory2, authenticationStore, serializerService, fileService, lazy, eventDispatcher, executionOutputRedirection, networkService, fileServiceCache, loggerService, timeService);
            try {
                CompileResult compileResult = Project$.MODULE$.compile(package$.MODULE$.FileDecorator(script).getParentFileSafe(), script, Project$.MODULE$.compile$default$3(), Project$.MODULE$.compile$default$4(), (Services)runServices);
                if (compileResult instanceof ScriptFileDoesNotExists && ScriptFileDoesNotExists$.MODULE$.unapply((ScriptFileDoesNotExists)compileResult)) {
                    errorData = ApiImpl.message$1("Script file does not exist");
                    break block10;
                }
                if (compileResult instanceof ErrorInCode) {
                    Interpreter.CompilationError compilationError;
                    ErrorInCode errorInCode = ErrorInCode$.MODULE$.unapply((ErrorInCode)compileResult);
                    Interpreter.CompilationError e = compilationError = errorInCode._1();
                    errorData = ApiImpl.error$1((Throwable)e);
                    break block10;
                }
                if (compileResult instanceof ErrorInCompiler) {
                    Throwable throwable;
                    ErrorInCompiler errorInCompiler = ErrorInCompiler$.MODULE$.unapply((ErrorInCompiler)compileResult);
                    Throwable e = throwable = errorInCompiler._1();
                    errorData = ApiImpl.error$1(e);
                    break block10;
                }
                if (compileResult instanceof Compiled) {
                    Compiled compiled = (Compiled)compileResult;
                    Some some = Some$.MODULE$.apply((Object)executionTmpDirectory);
                    Some some2 = Some$.MODULE$.apply((Object)executionOutputRedirection);
                    Some some3 = Some$.MODULE$.apply((Object)compiled.compilationContext());
                    Option option = MoleServices$.MODULE$.create$default$4();
                    MoleServices executionServices = MoleServices$.MODULE$.create(runServices.workspace().tmpDirectory(), (Option)some, (Option)some2, option, (Option)some3, runServices.preference(), runServices.seeder(), runServices.threadProvider(), runServices.eventDispatcher(), runServices.tmpDirectory(), runServices.fileService(), runServices.workspace(), runServices.outputRedirection(), runServices.loggerService(), runServices.serializerService(), runServices.networkService(), runServices.fileServiceCache(), runServices.timeService());
                    Try try_ = utils$.MODULE$.catchAll(() -> ApiImpl.synchronousCompilation$$anonfun$1(outputStream, runServices, compiled));
                    if (try_ instanceof Failure) {
                        Throwable e = ((Failure)try_).exception();
                        errorData = ApiImpl.error$1(e);
                        break block10;
                    }
                    if (try_ instanceof Success) {
                        DSL dsl = (DSL)((Success)try_).value();
                        Try try_2 = Try$.MODULE$.apply(() -> ApiImpl.synchronousCompilation$$anonfun$2(executionServices, dsl));
                        if (try_2 instanceof Success) {
                            MoleExecution ex = (MoleExecution)((Success)try_2).value();
                            errorData = ex;
                            break block10;
                        }
                        if (try_2 instanceof Failure) {
                            Throwable e = ((Failure)try_2).exception();
                            MoleServices$.MODULE$.clean(executionServices);
                            errorData = ApiImpl.error$1(e);
                            break block10;
                        }
                        throw new MatchError((Object)try_2);
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError((Object)compileResult);
            }
            catch (Throwable t) {
                errorData = ApiImpl.error$1(t);
            }
        }
        return errorData;
    }

    public ExecutionId launchScript(SafePath script, boolean validateScript) {
        Object object;
        ExecutionId execId = ExecutionId$.MODULE$.apply();
        StringPrintStream outputStream = StringPrintStream$.MODULE$.apply((Option)Some$.MODULE$.apply(this.services().preference().apply(this.outputSize(), ConfigurationString$.MODULE$.given_ConfigurationString_Int())));
        String content = package$.MODULE$.FileDecorator(utils$.MODULE$.safePathToFile(script, this.services().workspace())).content();
        this.serverState().addExecutionInfo(execId, ServerState$ExecutionInfo$.MODULE$.apply(script, content, System.currentTimeMillis(), outputStream, (Option<Object>)None$.MODULE$));
        Object object2 = this.synchronousCompilation(script, outputStream);
        if (object2 instanceof MoleExecution) {
            MoleExecution e = (MoleExecution)object2;
            object = this.processRun$1(script, execId, e, validateScript);
        } else if (object2 instanceof ErrorData) {
            ErrorData ed = (ErrorData)object2;
            object = BoxesRunTime.boxToBoolean((boolean)this.serverState().addError(execId, ExecutionState.Failed$.MODULE$.apply((Seq)scala.package$.MODULE$.Vector().empty(), ed, (Seq)scala.package$.MODULE$.Seq().empty(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$4(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$5())));
        } else {
            throw new MatchError(object2);
        }
        return execId;
    }

    public Seq<ExecutionData> executionData(int outputLines, Seq<ExecutionId> ids) {
        return this.serverState().executionData(outputLines, ids);
    }

    public void clearEnvironmentErrors(EnvironmentId environmentId) {
        this.serverState().deleteEnvironmentErrors(environmentId);
    }

    public Seq<EnvironmentErrorGroup> listEnvironmentErrors(EnvironmentId environmentId, int lines) {
        return (Seq)scala.concurrent.stm.package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> {
            Seq<EnvironmentError> environmentErrors = this.serverState().environmentErrors(environmentId);
            return ApiImpl.groupedErrors$1(lines, environmentErrors);
        }, MaybeTxn$.MODULE$.unknown());
    }

    public MarketIndex marketIndex() {
        return ApiImpl.mapToMd$1(org.openmole.core.market.package$.MODULE$.marketIndex(this.services().preference(), this.services().randomProvider(), this.services().tmpDirectory(), this.services().fileService(), this.services().networkService()));
    }

    public void getMarketEntry(MarketIndexEntry entry, SafePath path) {
        org.openmole.core.market.package$.MODULE$.downloadEntry(entry, utils$.MODULE$.safePathToFile(path, this.services().workspace()), this.services().networkService());
    }

    private Seq<Plugin> toPluginList(Seq<String> currentPlugins) {
        Seq currentPluginsSafePath = (Seq)currentPlugins.map((Function1 & Serializable)s -> SafePath$.MODULE$.apply((Iterable)Predef$.MODULE$.wrapRefArray((Object[])s.split("/")), SafePath$.MODULE$.apply$default$2()));
        return (Seq)currentPluginsSafePath.flatMap((Function1 & Serializable)csp -> {
            File file = utils$.MODULE$.safePathToFile(csp, this.services().workspace());
            String date = utils$.MODULE$.formatDate(file.lastModified());
            if (file.exists()) {
                return Some$.MODULE$.apply((Object)Plugin$.MODULE$.apply(csp, date, PluginManager$.MODULE$.bundle(file).isDefined()));
            }
            return None$.MODULE$;
        });
    }

    public Iterable<Tuple2<File, Throwable>> activatePlugins() {
        Seq plugins = (Seq)((IterableOps)((IterableOps)this.services().preference().preferenceOption(GUIServer$.MODULE$.plugins(), ConfigurationString$.MODULE$.given_ConfigurationString_Seq(ConfigurationString$.MODULE$.given_ConfigurationString_String())).getOrElse(ApiImpl::$anonfun$5)).map((Function1 & Serializable)s -> utils$.MODULE$.safePathToFile(SafePath$.MODULE$.apply((Iterable)Predef$.MODULE$.wrapRefArray((Object[])s.split("/")), SafePath$.MODULE$.apply$default$2()), this.services().workspace()))).filter((Function1 & Serializable)_$10 -> _$10.exists());
        return PluginManager$.MODULE$.tryLoad((Iterable)plugins);
    }

    private void updatePluggedList(Function1<Seq<String>, Seq<String>> set) {
        this.services().preference().updatePreference(GUIServer$.MODULE$.plugins(), (Function1 & Serializable)p -> Some$.MODULE$.apply(set.apply(p.getOrElse(ApiImpl::updatePluggedList$$anonfun$1$$anonfun$1))), ConfigurationString$.MODULE$.given_ConfigurationString_Seq(ConfigurationString$.MODULE$.given_ConfigurationString_String()), this.services().cypher());
    }

    public Seq<ErrorData> addPlugin(SafePath safePath) {
        Seq errors = utils$.MODULE$.addPlugin(safePath, this.services().workspace(), this.services().tmpDirectory());
        if (errors.isEmpty()) {
            this.updatePluggedList((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)pList -> (Seq)((SeqOps)pList.$colon$plus((Object)safePath.path().value().mkString("/"))).distinct());
        }
        return errors;
    }

    public Seq<Plugin> listPlugins() {
        Seq currentPlugins = (Seq)this.services().preference().preferenceOption(GUIServer$.MODULE$.plugins(), ConfigurationString$.MODULE$.given_ConfigurationString_Seq(ConfigurationString$.MODULE$.given_ConfigurationString_String())).getOrElse(ApiImpl::$anonfun$8);
        return this.toPluginList((Seq<String>)currentPlugins);
    }

    public void removePlugin(SafePath safePath) {
        this.updatePluggedList((Function1<Seq<String>, Seq<String>>)(Function1 & Serializable)_$11 -> (Seq)_$11.filterNot((Function1 & Serializable)_$12 -> {
            String string = _$12;
            String string2 = safePath.path().value().mkString("/");
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
        utils$.MODULE$.removePlugin(safePath, this.services().workspace());
    }

    public Iterable<OMRouter> pluginRoutes() {
        return (Iterable)((IterableOps)GUIPluginRegistry$.MODULE$.all().flatMap((Function1 & Serializable)_$13 -> _$13.router())).map((Function1 & Serializable)p -> (OMRouter)p.apply((Object)this.services()));
    }

    public PluginExtensionData getGUIPlugins() {
        return PluginExtensionData$.MODULE$.apply(GUIPluginRegistry$.MODULE$.authentications(), GUIPluginRegistry$.MODULE$.wizards(), GUIPluginRegistry$.MODULE$.analysis());
    }

    public boolean isOSGI(SafePath safePath) {
        return PluginManager$.MODULE$.isOSGI(utils$.MODULE$.safePathToFile(safePath, this.services().workspace()));
    }

    public String omrMethodName(SafePath result) {
        File omrFile = utils$.MODULE$.safePathToFile(result, this.services().workspace());
        return OMROutputFormat$.MODULE$.methodName(omrFile);
    }

    public Resources expandResources(Resources resources) {
        Seq paths = (Seq)((IterableOps)((SeqOps)resources.all().map((Function1 & Serializable)_$14 -> _$14.safePath())).distinct()).map((Function1 & Serializable)sp -> Resource$.MODULE$.apply(sp, utils$.MODULE$.SafePathDecorator(sp).toFile(this.services().workspace()).length()));
        Seq implicitResource = (Seq)resources.implicits().map((Function1 & Serializable)r -> Resource$.MODULE$.apply(r.safePath(), utils$.MODULE$.SafePathDecorator(r.safePath()).toFile(this.services().workspace()).length()));
        return Resources$.MODULE$.apply(paths, implicitResource, paths.size() + implicitResource.size());
    }

    public Seq<NotificationEvent> listNotification() {
        return this.serverState().listNotification();
    }

    public Object clearNotification(Seq<Object> ids) {
        return this.serverState().clearNotification(ids);
    }

    public void downloadHTTP(String url, SafePath path, boolean extract, boolean overwrite) {
        String string = URI.create(url).getScheme();
        Object checkedURL = string == null ? "http://" + url : url;
        NetworkService$.MODULE$.withResponse((String)checkedURL, NetworkService$.MODULE$.withResponse$default$2(), (Function1)((JProcedure1 & Serializable)arg_0 -> this.downloadHTTP$$anonfun$1(path, extract, overwrite, (String)checkedURL, arg_0)), this.services().networkService());
    }

    private static final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0xA00000));
    }

    private final void unplug$1(Seq allPlugins$1, File f) {
        if (utils$.MODULE$.isPlugged(f, allPlugins$1.toSeq(), this.services().workspace())) {
            Workspace workspace = this.services().workspace();
            ServerFileSystemContext serverFileSystemContext = utils$.MODULE$.fileToSafePath$default$2(f);
            this.removePlugin(utils$.MODULE$.fileToSafePath(f, serverFileSystemContext, workspace));
            return;
        }
    }

    private static final void extractArchiveFromFiles$$anonfun$1(File from$1, File to$1) {
        String name = from$1.getName();
        String string = name;
        String n = string;
        if (n.endsWith(".tar")) {
            ArchiveType archiveType = ArchiveType$.Tar;
            boolean bl = package$package$.MODULE$.extract$default$3(from$1);
            package$package$.MODULE$.extract(from$1, to$1, bl, archiveType);
            package$.MODULE$.FileDecorator(to$1).applyRecursive((Function1)(JProcedure1 & Serializable)f -> f.setWritable(true));
            return;
        }
        String n2 = string;
        if (n2.endsWith(".tgz") | n2.endsWith(".tar.gz")) {
            package$package$.MODULE$.extract(from$1, to$1, true, ArchiveType$.TarGZ);
            package$.MODULE$.FileDecorator(to$1).applyRecursive((Function1)(JProcedure1 & Serializable)f -> f.setWritable(true));
            return;
        }
        String n3 = string;
        if (n3.endsWith(".zip")) {
            package$package$.MODULE$.extract(from$1, to$1, true, ArchiveType$.Zip);
            return;
        }
        String n4 = string;
        if (n4.endsWith(".tar.xz") | n4.endsWith("txz")) {
            package$package$.MODULE$.extract(from$1, to$1, true, ArchiveType$.TarXZ);
            package$.MODULE$.FileDecorator(to$1).applyRecursive((Function1)(JProcedure1 & Serializable)f -> f.setWritable(true));
            return;
        }
        throw new Throwable("Unknown compression format for file " + from$1);
    }

    private final File archiveFile$1(SafePath safePath$1) {
        return utils$.MODULE$.safePathToFile(safePath$1, this.services().workspace());
    }

    private final File toFile$1(SafePath to$2) {
        return utils$.MODULE$.safePathToFile(to$2, this.services().workspace());
    }

    private final String newHash$1(File file$3) {
        FileService fileService = this.services().fileService();
        return fileService.hashNoCache(file$3, fileService.hashNoCache$default$2(), this.services().tmpDirectory()).toString();
    }

    private final Tuple2 save$1(String fileContent$2, File file$2) {
        package$.MODULE$.FileDecorator(file$2).content_$eq(fileContent$2);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.newHash$1(file$2));
    }

    private static final /* synthetic */ SequenceData sequence$$anonfun$1(String[] content$1, Regex regex$1, String h) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(h), ','));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])content$1);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object2)));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)row -> regex$1.findAllIn((CharSequence)row).toSeq(), (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(String.class), ClassTag$.MODULE$.apply(Seq.class))));
        return SequenceData$.MODULE$.apply(ArrayOps$.MODULE$.toSeq$extension(object), ArrayOps$.MODULE$.toSeq$extension(object4));
    }

    private static final SequenceData sequence$$anonfun$2() {
        return SequenceData$.MODULE$.apply(SequenceData$.MODULE$.$lessinit$greater$default$1(), SequenceData$.MODULE$.$lessinit$greater$default$2());
    }

    private static final ErrorWithLocation toErrorWithLocation$1(Interpreter.ErrorMessage em) {
        return ErrorWithLocation$.MODULE$.apply(em.rawMessage(), em.position().map((Function1 & Serializable)_$4 -> _$4.line()), em.position().map((Function1 & Serializable)_$5 -> _$5.start()), em.position().map((Function1 & Serializable)_$6 -> _$6.end()));
    }

    private static final ErrorData error$1(Throwable t) {
        MessageErrorData messageErrorData;
        Throwable throwable = t;
        if (throwable instanceof Interpreter.CompilationError) {
            Interpreter.CompilationError ce = (Interpreter.CompilationError)throwable;
            messageErrorData = ErrorData$.MODULE$.apply((Seq)ce.errorMessages().map((Function1 & Serializable)em -> ApiImpl.toErrorWithLocation$1(em)), t);
        } else {
            messageErrorData = ErrorData$.MODULE$.apply(t);
        }
        return (ErrorData)messageErrorData;
    }

    private static final MessageErrorData message$1(String message) {
        return MessageErrorData$.MODULE$.apply(message, (Option)None$.MODULE$);
    }

    private static final DSL synchronousCompilation$$anonfun$1$$anonfun$1(ServicesContainer runServices$2, Compiled compiled$2) {
        return compiled$2.eval((Seq)scala.package$.MODULE$.Seq().empty(), (Services)runServices$2);
    }

    private static final DSL synchronousCompilation$$anonfun$1(StringPrintStream outputStream$1, ServicesContainer runServices$1, Compiled compiled$1) {
        return (DSL)OutputManager$.MODULE$.withStreamOutputs((PrintStream)outputStream$1, (PrintStream)outputStream$1, () -> ApiImpl.synchronousCompilation$$anonfun$1$$anonfun$1(runServices$1, compiled$1));
    }

    private static final MoleExecution synchronousCompilation$$anonfun$2(MoleServices executionServices$1, DSL dsl$1) {
        Puzzle puzzle = package$.MODULE$.DSL().toPuzzle(dsl$1);
        return puzzle.toExecution(puzzle.toExecution$default$1(), puzzle.toExecution$default$2(), executionServices$1);
    }

    private static final MoleExecution processRun$1$$anonfun$2(MoleExecution ex$1, boolean validateScript$1) {
        return ex$1.start(validateScript$1);
    }

    private final Object processRun$1(SafePath script$1, ExecutionId execId, MoleExecution ex, boolean validateScript) {
        Vector envIds = (Vector)ex.allEnvironments().map((Function1 & Serializable)env -> {
            EnvironmentId environmentId = (EnvironmentId)Predef$.MODULE$.ArrowAssoc((Object)EnvironmentId$.MODULE$.apply(org.openmole.gui.shared.data.package$package$.MODULE$.randomId()));
            return Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)environmentId, env);
        });
        this.serverState().addRunningEnvironment(execId, (Seq<Tuple2<EnvironmentId, Environment>>)envIds);
        org.openmole.core.event.package$.MODULE$.EventDispatcherDecorator((Object)ex).listen(this.serverState().moleExecutionListener(execId, script$1), this.services().eventDispatcher());
        envIds.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                EnvironmentId envId = (EnvironmentId)tuple2._1();
                Environment env = (Environment)tuple2._2();
                return org.openmole.core.event.package$.MODULE$.EventDispatcherDecorator((Object)env).listen(this.serverState().environmentListener(envId), this.services().eventDispatcher());
            }
            throw new MatchError((Object)tuple2);
        });
        Try try_ = utils$.MODULE$.catchAll(() -> ApiImpl.processRun$1$$anonfun$2(ex, validateScript));
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return BoxesRunTime.boxToBoolean((boolean)this.serverState().addError(execId, ExecutionState.Failed$.MODULE$.apply((Seq)scala.package$.MODULE$.Vector().empty(), (ErrorData)ErrorData$.MODULE$.apply(e), (Seq)scala.package$.MODULE$.Seq().empty(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$4(), ExecutionState.Failed$.MODULE$.$lessinit$greater$default$5())));
        }
        if (try_ instanceof Success) {
            boolean inserted = this.serverState().addMoleExecution(execId, ex);
            if (!inserted) {
                ex.cancel();
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)try_);
    }

    private static final Seq groupedErrors$1(int lines$2, Seq environmentErrors$1) {
        return (Seq)((IterableOps)environmentErrors$1.groupBy((Function1 & Serializable)_$7 -> _$7.errorMessage()).toSeq().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Seq err = (Seq)tuple2._2();
                Seq dates = (Seq)((SeqOps)err.map((Function1 & Serializable)_$8 -> _$8.date())).sorted(package$.MODULE$.catsKernelOrderingForOrder((Order)package$.MODULE$.catsKernelStdOrderForLong()));
                return EnvironmentErrorGroup$.MODULE$.apply((EnvironmentError)err.head(), BoxesRunTime.unboxToLong((Object)dates.max(package$.MODULE$.catsKernelOrderingForOrder((Order)package$.MODULE$.catsKernelStdOrderForLong()))), dates.size());
            }
            throw new MatchError((Object)tuple2);
        })).takeRight(lines$2);
    }

    private static final MarketIndex mapToMd$1(MarketIndex marketIndex) {
        return marketIndex.copy((Seq)marketIndex.entries().map((Function1 & Serializable)e -> {
            Option option = e.readme().map((Function1 & Serializable)_$9 -> MarkDownProcessor$.MODULE$.apply((String)_$9));
            String string = e.copy$default$1();
            String string2 = e.copy$default$2();
            Seq seq = e.copy$default$4();
            return e.copy(string, string2, option, seq);
        }));
    }

    private static final Seq $anonfun$5() {
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static final Seq updatePluggedList$$anonfun$1$$anonfun$1() {
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static final Seq $anonfun$8() {
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static final String extractName$1(String checkedURL$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])checkedURL$2.split("/"));
        return (String)ArrayOps$.MODULE$.last$extension(object);
    }

    private static final String $anonfun$14(String checkedURL$3) {
        return ApiImpl.extractName$1(checkedURL$3);
    }

    private final /* synthetic */ void downloadHTTP$$anonfun$1(SafePath path$1, boolean extract$1, boolean overwrite$3, String checkedURL$1, CloseableHttpResponse response) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])response.getAllHeaders());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)h -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.getValue());
        }, (ClassTag)package$.MODULE$.manifestOrder2(ManifestFactory$.MODULE$.classType(String.class), ManifestFactory$.MODULE$.classType(String.class), (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(String.class), ClassTag$.MODULE$.apply(Tuple2.class)))));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && "Content-Disposition".equals(tuple2._1())) {
                String value = (String)tuple2._2();
                Object object = Predef$.MODULE$.refArrayOps((Object[])value.split(";"));
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$15 -> _$15.split("="), (ClassTag)package$.MODULE$.manifestOrder1(ManifestFactory$.MODULE$.classType(String.class), ClassTag$.MODULE$.apply(String.class).wrap())));
                return ArrayOps$.MODULE$.find$extension(object2, (Function1 & Serializable)_$16 -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])_$16);
                    String string = ((String)ArrayOps$.MODULE$.head$extension(object)).trim();
                    String string2 = "filename";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).map((Function1 & Serializable)filename -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])filename);
                    String name = ((String)ArrayOps$.MODULE$.last$extension(object)).trim();
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(name), 1)), 1);
                    }
                    return name;
                });
            }
            return None$.MODULE$;
        }, ClassTag$.MODULE$.apply(String.class)));
        String name = (String)ArrayOps$.MODULE$.headOption$extension(object3).getOrElse(() -> ApiImpl.$anonfun$14(checkedURL$1));
        InputStream is = response.getEntity().getContent();
        if (extract$1) {
            File dest = utils$.MODULE$.safePathToFile(path$1, this.services().workspace());
            try (TarInputStream tis = new TarInputStream((InputStream)new GZIPInputStream(is));){
                package$package$.MODULE$.TarInputStreamDecorator(tis).extract(dest, overwrite$3);
            }
            return;
        }
        File dest = utils$.MODULE$.safePathToFile(path$1.$div(name), this.services().workspace());
        if (!dest.exists() || overwrite$3) {
            package$.MODULE$.FileDecorator(dest).withOutputStream().apply((JProcedure1 & Serializable)os -> org.openmole.tool.stream.package$.MODULE$.copy(is, os));
            return;
        }
        throw new IOException("Destination file " + dest + " already exists and overwrite is not set");
    }
}

