/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.core;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.highlight.HighLight;
import org.openmole.core.networkservice.NetworkService;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.pluginregistry.PluginRegistry$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.Workspace;
import org.openmole.gui.server.core.GUIServer$;
import org.openmole.gui.server.ext.utils$;
import org.openmole.gui.server.jscompile.JSPack$;
import org.openmole.gui.server.jscompile.Webpack;
import org.openmole.tool.file.DirUtils$;
import org.openmole.tool.logger.JavaLogger;
import org.openmole.tool.logger.JavaLogger$Log$;
import org.openmole.tool.stream.package$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Plugins$
implements JavaLogger,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Plugins$.class.getDeclaredField("Log$lzy1"));
    private volatile Object Log$lzy1;
    public static final Plugins$ MODULE$ = new Plugins$();

    private Plugins$() {
    }

    public final JavaLogger$Log$ Log() {
        Object object = this.Log$lzy1;
        if (object instanceof JavaLogger$Log$) {
            return (JavaLogger$Log$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JavaLogger$Log$)this.Log$lzyINIT1();
    }

    private Object Log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JavaLogger$Log$ javaLogger$Log$ = null;
                    try {
                        javaLogger$Log$ = new JavaLogger$Log$((JavaLogger)this);
                        object2 = javaLogger$Log$ == null ? LazyVals.NullValue$.MODULE$ : javaLogger$Log$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return javaLogger$Log$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Plugins$.class);
    }

    public File createJsPluginDirectory(File jsPluginDirectory) {
        jsPluginDirectory.mkdirs();
        this.gatherJSIRFiles(jsPluginDirectory);
        return jsPluginDirectory;
    }

    public void gatherJSIRFiles(File dest) {
        this.bundles$1().foreach((Function1)(JProcedure1 & Serializable)b -> {
            try (JarFile jar = new JarFile(org.openmole.core.pluginmanager.package$.MODULE$.BundleDecorator(b).file());){
                CollectionConverters$.MODULE$.EnumerationHasAsScala(jar.entries()).asScala().withFilter((Function1 & Serializable)entry -> entry.getName().endsWith(".sjsir")).foreach((Function1 & Serializable)entry -> {
                    long l;
                    File destFile = org.openmole.tool.file.package$.MODULE$.FileDecorator(dest).$div(entry.getName());
                    destFile.getParentFile().mkdirs();
                    try (InputStream is = jar.getInputStream((ZipEntry)entry);){
                        l = package$.MODULE$.InputStreamDecorator(is).copy(destFile, true);
                    }
                    return l;
                });
            }
        });
    }

    public File persistentWebUI(Workspace workspace) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(workspace.persistentDir()).$div$greater("webui");
    }

    public File openmoleFile(boolean optimizedJS, Workspace workspace, TmpDirectory newFile, FileService fileService, NetworkService networkService) {
        return (File)newFile.withTmpDir((Function1 & Serializable)jsPluginDirectory -> {
            this.createJsPluginDirectory((File)jsPluginDirectory);
            File webui = this.persistentWebUI(workspace);
            File jsPluginHash = org.openmole.tool.file.package$.MODULE$.FileDecorator(workspace.persistentDir()).$div("js-plugin-hash");
            File jsFile = org.openmole.tool.file.package$.MODULE$.FileDecorator(webui).$div(utils$.MODULE$.openmoleFileName());
            org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.tool.file.package$.MODULE$.FileDecorator(jsPluginDirectory).$div("optimized_mode")).content_$eq(BoxesRunTime.boxToBoolean((boolean)optimizedJS).toString());
            if (!jsFile.exists()) {
                this.update$1(optimizedJS, newFile, networkService, (File)jsPluginDirectory, webui, jsFile);
                utils$.MODULE$.updateIfChanged(jsPluginDirectory, (Option)Some$.MODULE$.apply((Object)jsPluginHash), (Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.identity(x), fileService, newFile);
            } else {
                utils$.MODULE$.updateIfChanged(jsPluginDirectory, (Option)Some$.MODULE$.apply((Object)jsPluginHash), (Function1)(JProcedure1 & Serializable)_$2 -> this.update$1(optimizedJS, newFile, networkService, (File)jsPluginDirectory, webui, jsFile), fileService, newFile);
            }
            return org.openmole.tool.file.package$.MODULE$.FileDecorator(webui).$div(utils$.MODULE$.webpakedOpenmoleFileName());
        });
    }

    public Path expandDepsFile(File template, File to) {
        Tuple2 rules = PluginRegistry$.MODULE$.highLights().partition((Function1 & Serializable)kw -> {
            block9: {
                block3: {
                    HighLight highLight;
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            highLight = kw;
                                            if (!(highLight instanceof HighLight.TaskHighLight)) break block2;
                                            HighLight.TaskHighLight taskHighLight = HighLight.TaskHighLight$.MODULE$.unapply((HighLight.TaskHighLight)highLight);
                                            String string = taskHighLight._1();
                                            break block3;
                                        }
                                        if (!(highLight instanceof HighLight.SourceHighLight)) break block4;
                                        HighLight.SourceHighLight sourceHighLight = HighLight.SourceHighLight$.MODULE$.unapply((HighLight.SourceHighLight)highLight);
                                        String string = sourceHighLight._1();
                                        break block3;
                                    }
                                    if (!(highLight instanceof HighLight.EnvironmentHighLight)) break block5;
                                    HighLight.EnvironmentHighLight environmentHighLight = HighLight.EnvironmentHighLight$.MODULE$.unapply((HighLight.EnvironmentHighLight)highLight);
                                    String string = environmentHighLight._1();
                                    break block3;
                                }
                                if (!(highLight instanceof HighLight.HookHighLight)) break block6;
                                HighLight.HookHighLight hookHighLight = HighLight.HookHighLight$.MODULE$.unapply((HighLight.HookHighLight)highLight);
                                String string = hookHighLight._1();
                                break block3;
                            }
                            if (!(highLight instanceof HighLight.SamplingHighLight)) break block7;
                            HighLight.SamplingHighLight samplingHighLight = HighLight.SamplingHighLight$.MODULE$.unapply((HighLight.SamplingHighLight)highLight);
                            String string = samplingHighLight._1();
                            break block3;
                        }
                        if (!(highLight instanceof HighLight.DomainHighLight)) break block8;
                        HighLight.DomainHighLight domainHighLight = HighLight.DomainHighLight$.MODULE$.unapply((HighLight.DomainHighLight)highLight);
                        String string = domainHighLight._1();
                        break block3;
                    }
                    if (!(highLight instanceof HighLight.PatternHighLight)) break block9;
                    HighLight.PatternHighLight patternHighLight = HighLight.PatternHighLight$.MODULE$.unapply((HighLight.PatternHighLight)highLight);
                    String string = patternHighLight._1();
                }
                return false;
            }
            return true;
        });
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(to).content_$eq(String.valueOf(org.openmole.tool.file.package$.MODULE$.FileDecorator(template).content()).replace("##OMKeywords##", " \"" + ((IterableOnceOps)((IterableOps)rules._1()).map((Function1 & Serializable)_$3 -> _$3.name())).mkString("|") + "\" ").replace("##OMClasses##", " \"" + ((IterableOnceOps)((IterableOps)rules._2()).map((Function1 & Serializable)_$4 -> _$4.name())).mkString("|") + "\" "));
    }

    private final Seq bundles$1() {
        return (Seq)PluginManager$.MODULE$.bundles().filter((Function1 & Serializable)b -> !org.openmole.core.pluginmanager.package$.MODULE$.BundleDecorator(b).openMOLEScope().exists((Function1 & Serializable)_$1 -> {
            String string = _$1.toLowerCase();
            String string2 = "gui-provided";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
    }

    private final void update$1(boolean optimizedJS$2, TmpDirectory newFile$2, NetworkService networkService$2, File jsPluginDirectory$1, File webui$1, File jsFile$1) {
        this.Log().logger().info("Building GUI plugins ...");
        DirUtils$.MODULE$.deleteIfExists(org.openmole.tool.file.package$.MODULE$.file2Path(webui$1));
        webui$1.mkdir();
        JSPack$.MODULE$.link(jsPluginDirectory$1, jsFile$1, optimizedJS$2, newFile$2);
        this.Log().logger().info("Webpacking ...");
        File webpackConfigTemplateLocation = org.openmole.tool.file.package$.MODULE$.FileDecorator(GUIServer$.MODULE$.webpackLocation()).$div(utils$.MODULE$.webpackConfigTemplateName());
        File webpackJsonPackage = org.openmole.tool.file.package$.MODULE$.FileDecorator(GUIServer$.MODULE$.webpackLocation()).$div(utils$.MODULE$.webpackJsonPackage());
        File webpackOutput = org.openmole.tool.file.package$.MODULE$.FileDecorator(webui$1).$div(utils$.MODULE$.webpakedOpenmoleFileName());
        Path modeOpenMOLE = this.expandDepsFile(org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.tool.file.package$.MODULE$.FileDecorator(GUIServer$.MODULE$.fromWebAppLocation()).$div$greater("js")).$div(utils$.MODULE$.openmoleGrammarName()), org.openmole.tool.file.package$.MODULE$.FileDecorator(webui$1).$div(utils$.MODULE$.openmoleGrammarMode()));
        JSPack$.MODULE$.webpack(jsFile$1, webpackJsonPackage, webpackConfigTemplateLocation, webpackOutput, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Webpack.ExtraModule[]{Webpack.ExtraModule$.MODULE$.apply(org.openmole.tool.file.package$.MODULE$.path2File(modeOpenMOLE), utils$.MODULE$.aceModuleSource())})), newFile$2, networkService$2);
    }
}

